/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ddlgen.sql;

import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybMessageHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class ASMessageHandler
implements SybMessageHandler {
    public static final int DB_BASE_ERR = 11;
    public static final String SQL_STATE_OUTPUT_PARAM_IGNORED = "010P4";
    private StringBuffer _sbDDL = null;

    public ASMessageHandler() {
    }

    public ASMessageHandler(StringBuffer stringBuffer) {
        this._sbDDL = stringBuffer;
    }

    public SQLException messageHandler(SQLException sQLException) {
        boolean bl = this.handleMessage(sQLException);
        if (bl) {
            return null;
        }
        return sQLException;
    }

    public static String getSQLExceptionMessage(SQLException sQLException) {
        String string = "";
        String string2 = "";
        while (sQLException != null) {
            if (sQLException instanceof EedInfo) {
                EedInfo eedInfo = (EedInfo)sQLException;
                if (eedInfo.getSeverity() >= 11) {
                    boolean bl = true;
                    string = string + "Msg " + sQLException.getErrorCode() + ", Level " + eedInfo.getSeverity() + ", State " + eedInfo.getState() + ":\n";
                    if (eedInfo.getServerName() != null) {
                        string = string + ", Server " + eedInfo.getServerName();
                        bl = false;
                    }
                    if (eedInfo.getProcedureName() != null) {
                        string = string + (bl ? "" : ", ") + "Procedure " + eedInfo.getProcedureName();
                        bl = false;
                    }
                    string = string + (bl ? "" : ", ") + "Line " + eedInfo.getLineNumber() + ", Status " + eedInfo.getStatus() + ", TranState " + eedInfo.getTranState() + ":\n";
                }
                string = string + string2 + sQLException.getMessage();
            } else if (sQLException.getSQLState() == null) {
                string = string + string2 + sQLException.getMessage();
            } else if (!sQLException.getSQLState().equals(SQL_STATE_OUTPUT_PARAM_IGNORED)) {
                string = string + string2 + "SqlState: " + sQLException.getSQLState() + ", Error Code: " + sQLException.getErrorCode() + ", " + sQLException.getMessage();
            }
            if ((sQLException = sQLException.getNextException()) == null || string.endsWith("\n")) continue;
            string2 = "\n";
        }
        return string;
    }

    protected boolean handleMessage(SQLException sQLException) {
        boolean bl = false;
        if (this._sbDDL == null) {
            this._sbDDL = new StringBuffer();
        }
        if (sQLException.getErrorCode() == 0 && sQLException.getSQLState() == null) {
            String string = ASMessageHandler.getSQLExceptionMessage(sQLException);
            this._sbDDL.append(string).append("\n");
            bl = true;
            if (((EedInfo)sQLException).getStatus() != 0) {
                ResultSet resultSet = ((EedInfo)sQLException).getEedParams();
                try {
                    this.handleExtendedEedInfo(resultSet);
                }
                catch (SQLException sQLException2) {
                    String string2 = "Unable to display EedParams: " + sQLException2.toString() + ": sqlState = " + sQLException2.getSQLState();
                    System.out.println(string2);
                }
            }
        }
        return bl;
    }

    protected void handleExtendedEedInfo(ResultSet resultSet) throws SQLException {
        int n;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        String string = "";
        for (n = 1; n <= n2; ++n) {
            if (n > 1) {
                string = string + "\t";
            }
            string = string + resultSetMetaData.getColumnLabel(n);
        }
        while (resultSet.next()) {
            string = "";
            for (n = 1; n <= n2; ++n) {
                if (n > 1) {
                    string = string + "\t";
                }
                string = resultSet.wasNull() ? string + "NULL" : string + resultSet.getString(n);
            }
            this._sbDDL.append(string);
        }
    }
}

