/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAMultiList;
import com.sybase.asa.ASAMultiListColumnInfo;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ASABatchedMultiList
extends ASAMultiList {
    private static final byte ADDITION = 1;
    private static final byte MODIFICATION = 2;
    private static final byte DELETION = 4;
    private static final byte ALL = 7;
    private Hashtable _changes = new Hashtable();
    private boolean _allowModifications;

    public ASABatchedMultiList(boolean bl) {
        this._allowModifications = bl;
    }

    public ASABatchedMultiList(boolean bl, Vector vector, Vector vector2) {
        super(vector, vector2);
        this._allowModifications = bl;
    }

    public ASABatchedMultiList(boolean bl, Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this._allowModifications = bl;
    }

    public ASABatchedMultiList(boolean bl, Vector vector) {
        super(vector);
        this._allowModifications = bl;
    }

    public ASABatchedMultiList(boolean bl, Object[] objectArray) {
        super(objectArray);
        this._allowModifications = bl;
    }

    public ASABatchedMultiList(boolean bl, ASAMultiListColumnInfo[] aSAMultiListColumnInfoArray) {
        super(aSAMultiListColumnInfoArray);
        this._allowModifications = bl;
    }

    public void addBatchedAddition(Object object, Object object2, Vector vector) {
        if (this._markForAddition(object, object2)) {
            this.addRow(vector);
        }
    }

    public void addBatchedAddition(Object object, Object object2, Object[] objectArray) {
        if (this._markForAddition(object, object2)) {
            this.addRow(objectArray);
        }
    }

    public void addBatchedModification(Object object, Object object2, int n, Vector vector) {
        if (this._markForModification(object, object2)) {
            this.setRow(n, vector);
        }
    }

    public void addBatchedModification(Object object, Object object2, int n, Object[] objectArray) {
        if (this._markForModification(object, object2)) {
            this.setRow(n, objectArray);
        }
    }

    public void addBatchedDeletion(Object object, Object object2, int n) {
        if (this._markForDeletion(object, object2)) {
            this.removeRow(n);
        }
    }

    public boolean isBatchedAddition(Object object) {
        HashValue hashValue = (HashValue)this._changes.get(object);
        return hashValue != null && hashValue.type == 1;
    }

    public boolean isBatchedModification(Object object) {
        HashValue hashValue = (HashValue)this._changes.get(object);
        return hashValue != null && hashValue.type == 2;
    }

    public boolean isBatchedDeletion(Object object) {
        HashValue hashValue = (HashValue)this._changes.get(object);
        return hashValue != null && hashValue.type == 4;
    }

    public Enumeration getBatchedAdditions() {
        return this.getBatchedChanges(1);
    }

    public Enumeration getBatchedModifications() {
        return this.getBatchedChanges(2);
    }

    public Enumeration getBatchedDeletions() {
        return this.getBatchedChanges(4);
    }

    public Enumeration getBatchedChanges(int n) {
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this._changes.elements();
        while (enumeration.hasMoreElements()) {
            HashValue hashValue = (HashValue)enumeration.nextElement();
            if ((hashValue.type & n) == 0) continue;
            vector.add(hashValue.value);
        }
        return vector.elements();
    }

    public void clearBatchedChange(Object object) {
        this._changes.remove(object);
    }

    public void clearBatchedChanges() {
        this._changes.clear();
    }

    private boolean _markForAddition(Object object, Object object2) {
        boolean bl;
        HashValue hashValue = (HashValue)this._changes.get(object);
        if (hashValue == null) {
            this._changes.put(object, new HashValue(1, object2));
            bl = true;
        } else {
            if (hashValue.type == 1) {
                throw new IllegalStateException();
            }
            if (hashValue.type == 2) {
                bl = false;
            } else if (hashValue.type == 4) {
                if (this._allowModifications) {
                    hashValue.type = (byte)2;
                    hashValue.value = object2;
                    this._changes.put(object, hashValue);
                    bl = true;
                } else {
                    this._changes.remove(object);
                    bl = true;
                }
            } else {
                throw new IllegalStateException();
            }
        }
        return bl;
    }

    private boolean _markForModification(Object object, Object object2) {
        boolean bl;
        HashValue hashValue = (HashValue)this._changes.get(object);
        if (!this._allowModifications) {
            throw new IllegalStateException();
        }
        if (hashValue == null) {
            this._changes.put(object, new HashValue(2, object2));
            bl = true;
        } else if (hashValue.type == 1) {
            hashValue.value = object2;
            this._changes.put(object, hashValue);
            bl = true;
        } else if (hashValue.type == 2) {
            hashValue.value = object2;
            this._changes.put(object, hashValue);
            bl = true;
        } else {
            if (hashValue.type == 4) {
                throw new IllegalStateException();
            }
            throw new IllegalArgumentException();
        }
        return bl;
    }

    private boolean _markForDeletion(Object object, Object object2) {
        boolean bl;
        HashValue hashValue = (HashValue)this._changes.get(object);
        if (hashValue == null) {
            this._changes.put(object, new HashValue(4, object2));
            bl = true;
        } else if (hashValue.type == 1) {
            this._changes.remove(object);
            bl = true;
        } else if (hashValue.type == 2) {
            hashValue.type = (byte)4;
            this._changes.put(object, hashValue);
            bl = true;
        } else {
            if (hashValue.type == 4) {
                throw new IllegalStateException();
            }
            throw new IllegalArgumentException();
        }
        return bl;
    }

    private void _dumpBatchedChanges() {
    }

    private static class HashValue {
        byte type;
        Object value;

        HashValue(byte by, Object object) {
            this.type = by;
            this.value = object;
        }
    }
}

