/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASABaseGridBagPanel;
import com.sybase.asa.ASACalendarChangeEvent;
import com.sybase.asa.ASACalendarChangeListener;
import com.sybase.asa.ASAComboBox;
import com.sybase.asa.ASAMultiList;
import com.sybase.asa.ASAMultiListTableCellRenderer;
import com.sybase.asa.ASAMultiListTableHeaderRenderer;
import com.sybase.asa.ASAMultiListTableModel;
import com.sybase.asa.ASAScrollPane;
import com.sybase.asa.ASASpinBox;
import com.sybase.asa.ASASpinBoxChangeEvent;
import com.sybase.asa.ASASpinBoxChangeListener;
import com.sybase.asa.ASATextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ASACalendar
extends ASABaseGridBagPanel
implements DocumentListener,
ItemListener,
ASASpinBoxChangeListener,
ListSelectionListener,
TableColumnModelListener {
    static final int YEAR_MIN = 1;
    static final int YEAR_MAX = 3000;
    static final int ROW_COUNT = 6;
    static final int COLUMN_COUNT = 7;
    static final DateFormat DISPLAY_DATE_FORMAT = DateFormat.getDateInstance(2);
    private static final DateFormat[] PARSING_DATE_FORMATS = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getDateInstance(0)};
    private static final int PARSING_DATE_FORMAT_CNT = PARSING_DATE_FORMATS.length;
    GregorianCalendar _calendar = new GregorianCalendar();
    private Vector _calendarChangeListeners = new Vector();
    boolean _isAdjusting;
    private DateTextField _dateTextField;
    private MonthComboBox _monthComboBox;
    private YearSpinBox _yearSpinBox;
    private MonthTable _monthTable;
    private boolean _isEnabled;

    public ASACalendar() {
        this._init();
    }

    private void _init() {
        this._dateTextField = new DateTextField();
        this.add(this._dateTextField, 0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 1, 0), 0, 0);
        this._monthComboBox = new MonthComboBox();
        this.add(this._monthComboBox, 0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(1, 0, 1, 1), 0, 0);
        this._yearSpinBox = new YearSpinBox();
        this._yearSpinBox.setPreferredWidthToDigits(4);
        this.add(this._yearSpinBox, 1, 1, 1, 1, 0.0, 1.0, 17, 3, new Insets(1, 1, 1, 0), 0, 0);
        this._monthTable = new MonthTable();
        ASAScrollPane aSAScrollPane = this._monthTable.getScrollPane();
        Dimension dimension = this._monthTable.getPreferredSize();
        dimension.height = ((JComponent)this._monthTable.getTableHeader()).getPreferredSize().height + (this._monthTable.getRowHeight() + this._monthTable.getRowMargin()) * 6;
        aSAScrollPane.setPreferredSize(dimension);
        aSAScrollPane.setMinimumSize(dimension);
        aSAScrollPane.setMaximumSize(dimension);
        this.add(aSAScrollPane, 0, 2, 0, 1, 0.0, 0.0, 17, 0, new Insets(1, 0, 0, 0), 0, 0);
        this._dateTextField.getDocument().addDocumentListener(this);
        this._monthComboBox.addItemListener(this);
        this._yearSpinBox.addSpinBoxChangeListener(this);
        this._monthTable.getSelectionModel().addListSelectionListener(this);
        this._monthTable.getColumnModel().addColumnModelListener(this);
    }

    public void releaseResources() {
        this._dateTextField.getDocument().removeDocumentListener(this);
        this._monthComboBox.removeItemListener(this);
        this._yearSpinBox.removeSpinBoxChangeListener(this);
        this._monthTable.getSelectionModel().removeListSelectionListener(this);
        this._monthTable.getColumnModel().removeColumnModelListener(this);
        this._yearSpinBox.releaseResources();
        this._dateTextField = null;
        this._monthComboBox = null;
        this._yearSpinBox = null;
        this._monthTable = null;
        this._calendar = null;
        this._calendarChangeListeners = null;
    }

    public GregorianCalendar getCalendar() {
        return this._calendar;
    }

    public void setCalendar(GregorianCalendar gregorianCalendar) {
        this._calendar = gregorianCalendar;
        this._yearSpinBox.refresh();
        this._monthComboBox.refresh();
        this._monthTable.refresh();
        this._dateTextField.refresh();
        this.fireCalendarValueChanged(this._calendar);
    }

    public ASATextField getTextField() {
        return this._dateTextField;
    }

    public boolean getEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean bl) {
        this._isEnabled = bl;
        this._dateTextField.setEnabled(bl);
        this._monthComboBox.setEnabled(bl);
        this._yearSpinBox.setEnabled(bl);
        this._monthTable.setEnabled(bl);
    }

    public void addCalendarChangeListener(ASACalendarChangeListener aSACalendarChangeListener) {
        this._calendarChangeListeners.add(aSACalendarChangeListener);
    }

    public void removeCalendarChangeListener(ASACalendarChangeListener aSACalendarChangeListener) {
        this._calendarChangeListeners.remove(aSACalendarChangeListener);
    }

    protected void fireCalendarValueChanged(GregorianCalendar gregorianCalendar) {
        if (this._isAdjusting) {
            return;
        }
        ASACalendarChangeEvent aSACalendarChangeEvent = new ASACalendarChangeEvent(this, gregorianCalendar);
        int n = 0;
        int n2 = this._calendarChangeListeners.size();
        while (n < n2) {
            ((ASACalendarChangeListener)this._calendarChangeListeners.get(n)).valueChanged(aSACalendarChangeEvent);
            ++n;
        }
    }

    private void _setYear(int n) {
        if (this._calendar.get(2) == 1 && this._calendar.get(5) == 29 && !this._calendar.isLeapYear(n)) {
            this._calendar.set(n, 1, 28);
        } else {
            this._calendar.set(1, n);
        }
        this._monthTable.refresh();
        this._dateTextField.refresh();
        this.fireCalendarValueChanged(this._calendar);
    }

    private void _setMonth(int n) {
        this._calendar.roll(2, n - this._calendar.get(2));
        this._monthTable.refresh();
        this._dateTextField.refresh();
        this.fireCalendarValueChanged(this._calendar);
    }

    private void _setDayOfMonth(int n, int n2) {
        int n3 = this._monthTable.getDayOfMonthAt(n, n2);
        if (n3 != -1) {
            this._calendar.set(5, n3);
            this._dateTextField.refresh();
            this.fireCalendarValueChanged(this._calendar);
        }
    }

    private void _setDate(String string) {
        int n = 0;
        while (n < PARSING_DATE_FORMAT_CNT) {
            try {
                Date date = PARSING_DATE_FORMATS[n].parse(string);
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
                this._calendar = gregorianCalendar;
                this._yearSpinBox.refresh();
                this._monthComboBox.refresh();
                this._monthTable.refresh();
                this.fireCalendarValueChanged(this._calendar);
            }
            catch (ParseException parseException) {}
            ++n;
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._setDate(this._dateTextField.getText().trim());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._setDate(this._dateTextField.getText().trim());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this._isAdjusting) {
            return;
        }
        this._setDate(this._dateTextField.getText().trim());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this._isAdjusting || itemEvent.getStateChange() != 1) {
            return;
        }
        this._setMonth(this._monthComboBox.getSelectedIndex());
    }

    public void valueChanged(ASASpinBoxChangeEvent aSASpinBoxChangeEvent) {
        int n;
        if (this._isAdjusting || (n = aSASpinBoxChangeEvent.getNewValue()) == 0) {
            return;
        }
        this._setYear(n);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this._isAdjusting || listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this._setDayOfMonth(this._monthTable.getSelectedRow(), this._monthTable.getSelectedColumn());
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        if (this._isAdjusting || listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this._setDayOfMonth(this._monthTable.getSelectedRow(), this._monthTable.getSelectedColumn());
    }

    private final class DateTextField
    extends ASATextField {
        DateTextField() {
            this._init();
        }

        private void _init() {
            this.refresh();
        }

        void refresh() {
            ASACalendar.this._isAdjusting = true;
            this.setText(DISPLAY_DATE_FORMAT.format(ASACalendar.this._calendar.getTime()));
            ASACalendar.this._isAdjusting = false;
        }
    }

    private final class MonthComboBox
    extends ASAComboBox {
        MonthComboBox() {
            this._init();
        }

        private void _init() {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getMonths();
            String[] stringArray2 = new String[12];
            System.arraycopy(stringArray, 0, stringArray2, 0, 12);
            this.setModel(new DefaultComboBoxModel<String>(stringArray2));
            this.refresh();
        }

        void refresh() {
            ASACalendar.this._isAdjusting = true;
            this.setSelectedIndex(ASACalendar.this._calendar.get(2));
            ASACalendar.this._isAdjusting = false;
        }
    }

    private final class YearSpinBox
    extends ASASpinBox {
        YearSpinBox() {
            this._init();
        }

        private void _init() {
            this.setMinimum(1);
            this.setMaximum(3000);
            this.refresh();
        }

        void refresh() {
            ASACalendar.this._isAdjusting = true;
            this.setValue(ASACalendar.this._calendar.get(1));
            ASACalendar.this._isAdjusting = false;
        }
    }

    private final class MonthTable
    extends ASAMultiList {
        private GregorianCalendar _workDate = new GregorianCalendar();
        private int _firstDayOfWeek;
        private ASAMultiListTableModel _tableModel;
        private ASAMultiListTableCellRenderer _cellRenderer;
        private int _firstDayOfMonthOffset;
        private int _lastDayOfMonth;

        MonthTable() {
            this._firstDayOfWeek = ASACalendar.this._calendar.getFirstDayOfWeek();
            this._init();
        }

        private void _init() {
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols();
            String[] stringArray = dateFormatSymbols.getShortWeekdays();
            String[] stringArray2 = dateFormatSymbols.getWeekdays();
            Object[] objectArray = new String[7];
            String[] stringArray3 = new String[7];
            System.arraycopy(stringArray, this._firstDayOfWeek, objectArray, 0, 7 - this._firstDayOfWeek + 1);
            System.arraycopy(stringArray, 1, objectArray, 7 - this._firstDayOfWeek + 1, this._firstDayOfWeek - 1);
            System.arraycopy(stringArray2, this._firstDayOfWeek, stringArray3, 0, 7 - this._firstDayOfWeek + 1);
            System.arraycopy(stringArray2, 1, stringArray3, 7 - this._firstDayOfWeek + 1, this._firstDayOfWeek - 1);
            this._tableModel = new ASAMultiListTableModel(objectArray, 6);
            this.setModel(this._tableModel);
            this.setColumnToolTips(stringArray3);
            this.setSelectionMode(0);
            this.setSorting(false);
            this.setCellSelectionEnabled(true);
            this.setShowGrid(false);
            this.setAutoResizeMode(4);
            this.setAutoColumnWidths(false);
            this._cellRenderer = (ASAMultiListTableCellRenderer)this.getDefaultRenderer(this.getColumnClass(0));
            this._cellRenderer.setHorizontalAlignment(0);
            this._setColumnWidths();
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTableHeader.setResizingAllowed(false);
            jTableHeader.setDefaultRenderer(new ASAMultiListTableHeaderRenderer(this, 0));
            this.refresh();
        }

        private void _setColumnWidths() {
            int n;
            FontMetrics fontMetrics = ((Component)this).getFontMetrics(this._cellRenderer.getFont());
            int n2 = 0;
            TableColumnModel tableColumnModel = this.getColumnModel();
            int n3 = 0;
            while (n3 < 7) {
                n = fontMetrics.stringWidth(this.getColumnName(n3));
                n2 = Math.max(n2, n);
                ++n3;
            }
            n3 = 1;
            while (n3 <= 31) {
                n = fontMetrics.stringWidth(String.valueOf(n3));
                n2 = Math.max(n2, n);
                ++n3;
            }
            n2 += (tableColumnModel.getColumnMargin() + this.getIntercellSpacing().width) * 2 + 8;
            n3 = 0;
            while (n3 < 7) {
                this.setColumnWidth(n3, n2);
                ++n3;
            }
        }

        void refresh() {
            ASACalendar.this._isAdjusting = true;
            this._workDate.set(ASACalendar.this._calendar.get(1), ASACalendar.this._calendar.get(2), 1);
            this._firstDayOfMonthOffset = (this._workDate.get(7) + 7 - this._firstDayOfWeek) % 7;
            this._lastDayOfMonth = ASACalendar.this._calendar.getActualMaximum(5);
            this._tableModel.fireTableChanged(new TableModelEvent(this._tableModel));
            int n = ASACalendar.this._calendar.get(5);
            int n2 = this.getRowForDayOfMonth(n);
            int n3 = this.getColumnForDayOfMonth(n);
            this.setRowSelectionInterval(n2, n2);
            this.setColumnSelectionInterval(n3, n3);
            ASACalendar.this._isAdjusting = false;
        }

        int getDayOfMonthAt(int n, int n2) {
            int n3;
            if (n >= 0 && n2 >= 0 && (n3 = n * 7 + n2 - this._firstDayOfMonthOffset + 1) > 0 && n3 <= this._lastDayOfMonth) {
                return n3;
            }
            return -1;
        }

        int getRowForDayOfMonth(int n) {
            return (n + this._firstDayOfMonthOffset - 1) / 7;
        }

        int getColumnForDayOfMonth(int n) {
            return n + this._firstDayOfMonthOffset - 1 - this.getRowForDayOfMonth(n) * 7;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Object getValueAt(int n, int n2) {
            int n3 = this.getDayOfMonthAt(n, n2);
            if (n3 != -1) {
                return String.valueOf(n3);
            }
            return null;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseEvent(mouseEvent);
        }

        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 506) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n >= 0 && n2 >= 0 && this.getValueAt(n, n2) == null) {
                    mouseEvent.consume();
                    return;
                }
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                int n = this.getSelectedRow();
                int n2 = this.getSelectedColumn();
                switch (keyEvent.getKeyCode()) {
                    case 37: {
                        this._handleArrowKeyPressed(keyEvent, n, --n2);
                        break;
                    }
                    case 39: {
                        this._handleArrowKeyPressed(keyEvent, n, ++n2);
                        break;
                    }
                    case 38: {
                        this._handleArrowKeyPressed(keyEvent, --n, n2);
                        break;
                    }
                    case 40: {
                        this._handleArrowKeyPressed(keyEvent, ++n, n2);
                        break;
                    }
                    case 36: {
                        this._handleHomeOrEndKeyPressed(keyEvent, n, true);
                        break;
                    }
                    case 35: {
                        this._handleHomeOrEndKeyPressed(keyEvent, n, false);
                        break;
                    }
                    case 33: {
                        this._handlePageUpOrPageDownKeyPressed(keyEvent, n2, true);
                        break;
                    }
                    case 34: {
                        this._handlePageUpOrPageDownKeyPressed(keyEvent, n2, false);
                        break;
                    }
                    case 9: {
                        this._handleTabOrShiftTabKeyPressed(keyEvent, n, n2);
                        break;
                    }
                    default: {
                        super.processKeyEvent(keyEvent);
                    }
                }
                return;
            }
            super.processKeyEvent(keyEvent);
        }

        private void _handleArrowKeyPressed(KeyEvent keyEvent, int n, int n2) {
            if (n >= 0 && n < 6 && n2 >= 0 && n2 < 7 && this.getValueAt(n, n2) == null) {
                keyEvent.consume();
            } else {
                super.processKeyEvent(keyEvent);
            }
        }

        private void _handleHomeOrEndKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 7;
                n2 = 1;
            } else {
                n4 = 6;
                n3 = -1;
                n2 = -1;
            }
            int n5 = n4;
            while (n5 != n3) {
                if (this.getValueAt(n, n5) != null) {
                    this.setRowSelectionInterval(n, n);
                    this.setColumnSelectionInterval(n5, n5);
                    keyEvent.consume();
                    return;
                }
                n5 += n2;
            }
            keyEvent.consume();
        }

        private void _handlePageUpOrPageDownKeyPressed(KeyEvent keyEvent, int n, boolean bl) {
            int n2;
            int n3;
            int n4;
            if (bl) {
                n4 = 0;
                n3 = 6;
                n2 = 1;
            } else {
                n4 = 5;
                n3 = -1;
                n2 = -1;
            }
            int n5 = n4;
            while (n5 != n3) {
                if (this.getValueAt(n5, n) != null) {
                    this.setRowSelectionInterval(n5, n5);
                    this.setColumnSelectionInterval(n, n);
                    keyEvent.consume();
                    return;
                }
                n5 += n2;
            }
            keyEvent.consume();
        }

        private void _handleTabOrShiftTabKeyPressed(KeyEvent keyEvent, int n, int n2) {
            int n3;
            int n4 = keyEvent.getModifiers();
            if (n4 == 0) {
                int n5 = this.getDayOfMonthAt(n, n2);
                n3 = n5 == -1 || n5 == this._lastDayOfMonth ? 1 : n5 + 1;
            } else if (n4 == 1) {
                int n6 = this.getDayOfMonthAt(n, n2);
                n3 = n6 == -1 || n6 == 1 ? this._lastDayOfMonth : n6 - 1;
            } else {
                super.processKeyEvent(keyEvent);
                return;
            }
            int n7 = this.getRowForDayOfMonth(n3);
            int n8 = this.getColumnForDayOfMonth(n3);
            this.setRowSelectionInterval(n7, n7);
            this.setColumnSelectionInterval(n8, n8);
            keyEvent.consume();
        }
    }
}

