/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASACheckedData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import javax.accessibility.AccessibleContext;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class ASACheckedDataTableCellRenderer
extends JPanel
implements TableCellRenderer {
    private static final Color FOREGROUND_COLOR = UIManager.getColor("Table.foreground");
    private static final Color BACKGROUND_COLOR = UIManager.getColor("Table.background");
    private static final Color SELECTION_FOREGROUND_COLOR = UIManager.getColor("Table.selectionForeground");
    private static final Color SELECTION_BACKGROUND_COLOR = UIManager.getColor("Table.selectionBackground");
    private static final Color FOCUS_CELL_FOREGROUND_COLOR = UIManager.getColor("Table.focusCellForeground");
    private static final Color INACTIVE_FOREGROUND_COLOR = UIManager.getColor("TextField.inactiveForeground");
    private static final Border FOCUS_BORDER = UIManager.getBorder("Table.focusCellHighlightBorder");
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    protected JCheckBox checkBox = new JCheckBox();
    protected JLabel label = new JLabel();

    public ASACheckedDataTableCellRenderer() {
        this.setForeground(FOREGROUND_COLOR);
        this.setBackground(BACKGROUND_COLOR);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        this.checkBox.setForeground(FOREGROUND_COLOR);
        this.checkBox.setBackground(BACKGROUND_COLOR);
        this.checkBox.setOpaque(true);
        this.add((Component)this.checkBox, "West");
        this.label.setOpaque(true);
        this.add((Component)this.label, "Center");
    }

    public AccessibleContext getAccessibleContext() {
        return this.label.getAccessibleContext();
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        boolean bl3 = jTable.isEnabled();
        if (object != null && object instanceof ASACheckedData) {
            ASACheckedData aSACheckedData = (ASACheckedData)object;
            this.checkBox.setEnabled(bl3 && aSACheckedData.isEnabled);
            this.checkBox.setSelected(aSACheckedData.isChecked);
            this.label.setText(aSACheckedData.toString());
        }
        if (bl) {
            if (jTable.isFocusOwner()) {
                this.label.setBackground(SELECTION_BACKGROUND_COLOR);
            } else {
                this.label.setBackground(SystemColor.control);
            }
        } else {
            this.label.setBackground(BACKGROUND_COLOR);
        }
        if (!bl3) {
            this.label.setForeground(INACTIVE_FOREGROUND_COLOR);
        } else if (bl && jTable.isFocusOwner()) {
            this.label.setForeground(SELECTION_FOREGROUND_COLOR);
        } else if (bl2) {
            this.label.setForeground(FOCUS_CELL_FOREGROUND_COLOR);
        } else {
            this.label.setForeground(FOREGROUND_COLOR);
        }
        this.setBorder(bl2 ? FOCUS_BORDER : NO_FOCUS_BORDER);
        return this;
    }
}

