/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASATextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class ASAIntegerTextField
extends ASATextField {
    Toolkit _toolkit = Toolkit.getDefaultToolkit();

    public ASAIntegerTextField() {
        this._init();
    }

    public ASAIntegerTextField(String string) {
        super(string);
        this._init();
    }

    public ASAIntegerTextField(int n) {
        super(n);
        this._init();
    }

    public ASAIntegerTextField(String string, int n) {
        super(string, n);
        this._init();
    }

    private void _init() {
        this.setDocument(new IntegerDocument());
        this.setHorizontalAlignment(4);
    }

    public int getValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setValue(int n) {
        this.setText(String.valueOf(n));
    }

    public void setPreferredWidthToDigits(int n) {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        try {
            int n2 = (int)(Math.pow(10.0, n) - 1.0);
            int n3 = fontMetrics.stringWidth(String.valueOf(n2));
            this.setPreferredWidth(n3, true);
            this.setMinimumSize(new Dimension(n3, this.getMinimumSize().height));
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
    }

    private final class IntegerDocument
    extends PlainDocument {
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            int n3 = 0;
            int n4 = cArray2.length;
            while (n3 < n4) {
                if (Character.isDigit(cArray[n3])) {
                    cArray2[n2++] = cArray[n3];
                } else {
                    ASAIntegerTextField.this._toolkit.beep();
                }
                ++n3;
            }
            super.insertString(n, new String(cArray2, 0, n2), attributeSet);
        }

        IntegerDocument() {
        }
    }
}

