/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASATextField;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.text.DecimalFormatSymbols;

public class ASAMaskedTextField
extends ASATextField
implements FocusListener,
ClipboardOwner {
    private static final String STR_EMPTY = "";
    private static final String STR_DEFAULT_INPUT_MASK = "*";
    private String _inputMaskString = "*";
    private char _promptChar = (char)95;
    private boolean _convertToUpperCase;
    private boolean _convertToLowerCase;
    private boolean _beepOnInvalidInput = true;
    private Toolkit _toolkit = this.getToolkit();
    private Clipboard _clipboard = this._toolkit.getSystemClipboard();
    private MaskedText _maskedText;

    public ASAMaskedTextField() {
        this._init();
    }

    public ASAMaskedTextField(String string) {
        this._inputMaskString = string;
        this._init();
    }

    public ASAMaskedTextField(String string, char c) {
        this._inputMaskString = string;
        this._promptChar = c;
        this._init();
    }

    private void _init() {
        this._setupMaskedText();
        this.addFocusListener(this);
    }

    public void releaseResources() {
        this.removeFocusListener(this);
        this._inputMaskString = null;
        this._toolkit = null;
        this._clipboard = null;
        this._maskedText = null;
    }

    public String getInputMask() {
        return this._inputMaskString;
    }

    public void setInputMask(String string) {
        this._inputMaskString = string;
        this._setupMaskedText();
    }

    public char getPromptChar() {
        return this._promptChar;
    }

    public void setPromptChar(char c) {
        this._promptChar = c;
        this._setupMaskedText();
    }

    public boolean getConvertToUpperCase() {
        return this._convertToUpperCase;
    }

    public void setConvertToUpperCase(boolean bl) {
        this._convertToUpperCase = bl;
    }

    public boolean getConvertToLowerCase() {
        return this._convertToLowerCase;
    }

    public void setConvertToLowerCase(boolean bl) {
        this._convertToLowerCase = bl;
    }

    public boolean getBeepOnInvalidInput() {
        return this._beepOnInvalidInput;
    }

    public void setBeepOnInvalidInput(boolean bl) {
        this._beepOnInvalidInput = bl;
    }

    public boolean isEmpty() {
        return this._maskedText.getText(false).trim().length() == 0;
    }

    public boolean isPartiallySpecified() {
        return this._maskedText.getText(false).trim().length() != 0 && this._maskedText.toString().indexOf(this._promptChar) != -1;
    }

    public boolean isFullySpecified() {
        return this._maskedText.toString().indexOf(this._promptChar) == -1;
    }

    public void setPreferredWidthToFit() {
        FontMetrics fontMetrics = ((Component)this).getFontMetrics(this.getFont());
        int n = this._maskedText.getWidestStringWidth(fontMetrics);
        this.setPreferredWidth(n, true);
    }

    public String getText() {
        return this._maskedText.getText(true);
    }

    public String getText(boolean bl) {
        return this._maskedText.getText(bl);
    }

    public void setText(String string) {
        this._maskedText.resetChars();
        this._maskedText.setChars(string);
        super.setText(this._maskedText.toString());
    }

    public void cut() {
        int n = this.getSelectionStart();
        int n2 = this.getSelectionEnd();
        this.copy();
        this._maskedText.resetChars(n, n2);
        super.setText(this._maskedText.toString());
        this.setCaretPosition(n);
    }

    public void copy() {
        StringSelection stringSelection = new StringSelection(this._maskedText.getText(true, this.getSelectionStart(), this.getSelectionEnd()));
        this._clipboard.setContents(stringSelection, this);
    }

    public void paste() {
        Transferable transferable = this._clipboard.getContents(this);
        int n = this.getSelectionStart();
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                int n2 = this._maskedText.setChars(string, n);
                super.setText(this._maskedText.toString());
                this.setCaretPosition(n2);
            }
            catch (Exception exception) {}
        }
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        if (!this.isEditable()) {
            super.processKeyEvent(keyEvent);
            return;
        }
        block0 : switch (keyEvent.getID()) {
            case 401: {
                if (keyEvent.getModifiers() != 0) {
                    super.processKeyEvent(keyEvent);
                    return;
                }
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        int n = this.getSelectionStart();
                        int n2 = this.getSelectionEnd();
                        if (n < n2) {
                            this._maskedText.resetChars(n, n2);
                            super.setText(this._maskedText.toString());
                            this.setCaretPosition(n);
                        } else if (n > this._maskedText.getFirstPlaceholderIndex()) {
                            n = this._maskedText.getPreviousPlaceholderIndex(n);
                            this._maskedText.resetChar(n);
                            super.setText(this._maskedText.toString());
                            this.setCaretPosition(n);
                        }
                        keyEvent.consume();
                        break block0;
                    }
                    case 127: {
                        int n = this.getSelectionStart();
                        int n3 = this.getSelectionEnd();
                        if (n < n3) {
                            this._maskedText.resetChars(n, n3);
                            super.setText(this._maskedText.toString());
                            this.setCaretPosition(n);
                        } else if (n <= this._maskedText.getLastPlaceholderIndex()) {
                            if (this._maskedText.isLiteral(n)) {
                                n = this._maskedText.getNextPlaceholderIndex(n);
                            }
                            this._maskedText.resetChar(n);
                            super.setText(this._maskedText.toString());
                            if (n < this._maskedText.getLastPlaceholderIndex()) {
                                this.setCaretPosition(this._maskedText.getNextPlaceholderIndex(n));
                            } else {
                                this.setCaretPosition(this._maskedText.getLastPlaceholderIndex() + 1);
                            }
                        }
                        keyEvent.consume();
                        break block0;
                    }
                }
                super.processKeyEvent(keyEvent);
                break;
            }
            case 400: {
                char c = keyEvent.getKeyChar();
                if (c == '\b') {
                    keyEvent.consume();
                    return;
                }
                if (Character.isISOControl(c)) {
                    super.processKeyEvent(keyEvent);
                    return;
                }
                int n = this.getSelectionStart();
                if (n > this._maskedText.getLastPlaceholderIndex()) {
                    this._handleInvalidInput();
                    keyEvent.consume();
                    return;
                }
                if (this._maskedText.isLiteral(n)) {
                    n = this._maskedText.getNextPlaceholderIndex(n);
                }
                if (this._maskedText.setChar(this._convertChar(c), n)) {
                    int n4 = this.getSelectionEnd();
                    if (n < n4) {
                        this._maskedText.resetChars(n + 1, n4);
                    }
                    super.setText(this._maskedText.toString());
                    if (n < this._maskedText.getLastPlaceholderIndex()) {
                        this.setCaretPosition(this._maskedText.getNextPlaceholderIndex(n));
                    } else {
                        this.setCaretPosition(this._maskedText.getLastPlaceholderIndex() + 1);
                    }
                } else {
                    this._handleInvalidInput();
                }
                keyEvent.consume();
                break;
            }
            case 402: {
                super.processKeyEvent(keyEvent);
                break;
            }
        }
    }

    private void _setupMaskedText() {
        this._maskedText = new MaskedText(this._inputMaskString, this._promptChar);
    }

    private char _convertChar(char c) {
        if (this._convertToUpperCase) {
            return Character.toUpperCase(c);
        }
        if (this._convertToLowerCase) {
            return Character.toLowerCase(c);
        }
        return c;
    }

    private void _handleInvalidInput() {
        if (this._beepOnInvalidInput) {
            this._toolkit.beep();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        super.setText(this._maskedText.toString());
        this.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this._maskedText.getText(false).trim().length() == 0) {
            super.setText(STR_EMPTY);
        } else {
            super.setText(this._maskedText.toString());
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    private static class MaskedText {
        private char[] _text;
        private MaskChar[] _mask;
        private int _length;
        private char _promptChar;
        private int _placeholderCount;
        private int _firstPlaceholderIndex;
        private int _lastPlaceholderIndex;

        MaskedText(String string, char c) {
            int n;
            if (string == null || (n = string.length()) == 0 || n == 1 && string.charAt(0) == '\\' || string.charAt(n - 1) == '\\' && string.charAt(n - 2) == '\\') {
                throw new IllegalArgumentException();
            }
            MaskChar[] maskCharArray = new MaskChar[n];
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = -1;
            int n6 = 0;
            while (n6 < n) {
                char c2 = string.charAt(n6);
                switch (c2) {
                    case '#': 
                    case '*': 
                    case '?': 
                    case 'L': 
                    case 'M': 
                    case 'U': {
                        if (n3 == 0) {
                            n4 = n6;
                        }
                        n5 = n6;
                        ++n3;
                        maskCharArray[n2] = new MaskChar(c2, true);
                        break;
                    }
                    case ',': {
                        maskCharArray[n2] = new MaskChar(decimalFormatSymbols.getGroupingSeparator(), false);
                        break;
                    }
                    case '.': {
                        maskCharArray[n2] = new MaskChar(decimalFormatSymbols.getDecimalSeparator(), false);
                        break;
                    }
                    case '\\': {
                        maskCharArray[n2] = new MaskChar(string.charAt(++n6), false);
                        break;
                    }
                    default: {
                        maskCharArray[n2] = new MaskChar(c2, false);
                    }
                }
                ++n2;
                ++n6;
            }
            if (n3 == 0) {
                throw new IllegalArgumentException();
            }
            this._length = n2;
            this._mask = new MaskChar[n2];
            System.arraycopy(maskCharArray, 0, this._mask, 0, n2);
            this._promptChar = c;
            this._placeholderCount = n3;
            this._firstPlaceholderIndex = n4;
            this._lastPlaceholderIndex = n5;
            this._text = new char[n2];
            n6 = 0;
            while (n6 < n2) {
                MaskChar maskChar = this._mask[n6];
                this._text[n6] = maskChar.isPlaceholder ? this._promptChar : maskChar.charValue;
                ++n6;
            }
        }

        public int getWidestStringWidth(FontMetrics fontMetrics) {
            int n = fontMetrics.charWidth(this._promptChar);
            int n2 = fontMetrics.charWidth('0');
            int n3 = fontMetrics.charWidth('W');
            int n4 = fontMetrics.charWidth('W');
            int n5 = fontMetrics.charWidth('w');
            int n6 = fontMetrics.charWidth('W');
            int n7 = fontMetrics.charWidth('W');
            int n8 = 0;
            int n9 = 0;
            while (n9 < this._length) {
                MaskChar maskChar = this._mask[n9];
                char c = maskChar.charValue;
                if (maskChar.isPlaceholder) {
                    switch (c) {
                        case '#': {
                            n8 += Math.max(n, n2);
                            break;
                        }
                        case '?': {
                            n8 += Math.max(n, n3);
                            break;
                        }
                        case 'U': {
                            n8 += Math.max(n, n4);
                            break;
                        }
                        case 'L': {
                            n8 += Math.max(n, n5);
                            break;
                        }
                        case 'M': {
                            n8 += Math.max(n, n6);
                            break;
                        }
                        case '*': {
                            n8 += Math.max(n, n7);
                            break;
                        }
                    }
                } else {
                    n8 += fontMetrics.charWidth(c);
                }
                ++n9;
            }
            return n8;
        }

        public String toString() {
            return new String(this._text);
        }

        String getText(boolean bl) {
            return this.getText(bl, 0, this._length);
        }

        String getText(boolean bl, int n, int n2) {
            char[] cArray = new char[bl ? this._length : this._placeholderCount];
            int n3 = 0;
            int n4 = n;
            while (n4 < n2) {
                MaskChar maskChar = this._mask[n4];
                char c = this._text[n4];
                if (maskChar.isPlaceholder) {
                    cArray[n3++] = c == this._promptChar ? (char)' ' : c;
                } else if (bl) {
                    cArray[n3++] = c;
                }
                ++n4;
            }
            return new String(cArray, 0, n3);
        }

        boolean isPlaceholder(int n) {
            return this._mask[n].isPlaceholder;
        }

        boolean isLiteral(int n) {
            return !this._mask[n].isPlaceholder;
        }

        int length() {
            return this._length;
        }

        int getFirstPlaceholderIndex() {
            return this._firstPlaceholderIndex;
        }

        int getLastPlaceholderIndex() {
            return this._lastPlaceholderIndex;
        }

        int getPreviousPlaceholderIndex(int n) {
            int n2 = n - 1;
            while (n2 >= 0) {
                if (this._mask[n2].isPlaceholder) {
                    return n2;
                }
                --n2;
            }
            return this._firstPlaceholderIndex;
        }

        int getNextPlaceholderIndex(int n) {
            int n2 = n + 1;
            while (n2 < this._length) {
                if (this._mask[n2].isPlaceholder) {
                    return n2;
                }
                ++n2;
            }
            return this._lastPlaceholderIndex;
        }

        void resetChar(int n) {
            if (this._mask[n].isPlaceholder) {
                this._text[n] = this._promptChar;
            }
        }

        void resetChars(int n, int n2) {
            int n3 = n;
            while (n3 < n2) {
                this.resetChar(n3);
                ++n3;
            }
        }

        void resetChars() {
            this.resetChars(0, this._length - 1);
        }

        boolean setChar(char c, int n) {
            boolean bl = false;
            if (this._mask[n].isPlaceholder) {
                switch (this._mask[n].charValue) {
                    case '#': {
                        if (!Character.isDigit(c)) break;
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                    case '?': {
                        if (!Character.isLetterOrDigit(c)) break;
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                    case 'U': {
                        if (!Character.isUpperCase(c)) break;
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                    case 'L': {
                        if (!Character.isLowerCase(c)) break;
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                    case 'M': {
                        if (!Character.isLetter(c)) break;
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                    case '*': {
                        this._text[n] = c;
                        bl = true;
                        break;
                    }
                }
            }
            return bl;
        }

        int setChars(String string, int n) {
            boolean bl = false;
            if (n > this._lastPlaceholderIndex) {
                return n;
            }
            int n2 = this._mask[n].isPlaceholder ? n : this.getNextPlaceholderIndex(n);
            int n3 = 0;
            int n4 = Math.min(string.length(), this._length);
            while (n3 < n4) {
                if (this.setChar(string.charAt(n3), n2)) {
                    bl = true;
                    if (n2 == this._lastPlaceholderIndex) {
                        return n2 + 1;
                    }
                    n2 = this.getNextPlaceholderIndex(n2);
                }
                ++n3;
            }
            return bl ? n2 : n;
        }

        int setChars(String string) {
            return this.setChars(string, 0);
        }

        private static class MaskChar {
            char charValue;
            boolean isPlaceholder;

            MaskChar(char c, boolean bl) {
                this.charValue = c;
                this.isPlaceholder = bl;
            }
        }
    }
}

