/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAMultiColumnLabelTableCellRenderer;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ASAMultiColumnLabel
extends JTable {
    private static final String STR_EMPTY = "";
    private ASAMultiColumnLabelTableCellRenderer _renderer = new ASAMultiColumnLabelTableCellRenderer();
    private boolean _useDefaultRenderer = true;
    private boolean _calculateColumnWidths = true;
    private int _rowCount;
    private int _columnCount;
    private TableColumnModel _tableColumnModel;
    private int[] _extraIntercolumnSpacing;
    private int _extraIntercolumnSpacingCount;

    public ASAMultiColumnLabel() {
        this._init();
    }

    public ASAMultiColumnLabel(Vector vector) {
        this.setDataVector(vector);
        this._init();
    }

    public ASAMultiColumnLabel(Object[][] objectArray) {
        this.setDataVector(objectArray);
        this._init();
    }

    private void _init() {
        this.setForeground(SystemColor.controlText);
        this.setBackground(SystemColor.control);
        this.setSelectionForeground(this.getForeground());
        this.setSelectionBackground(this.getBackground());
        this.setShowGrid(false);
        this.setFocusable(false);
    }

    public boolean getUseDefaultRenderer() {
        return this._useDefaultRenderer;
    }

    public void setUseDefaultRenderer(boolean bl) {
        this._useDefaultRenderer = bl;
        if (bl) {
            this._useDefaultRenderer();
        }
    }

    public boolean getCalculateColumnWidths() {
        return this._calculateColumnWidths;
    }

    public void setCalculateColumnWidths(boolean bl) {
        this._calculateColumnWidths = bl;
        if (bl) {
            this._calculateColumnWidths();
        }
    }

    public int[] getExtraIntercolumnSpacing() {
        return this._extraIntercolumnSpacing;
    }

    public void setExtraIntercolumnSpacing(int[] nArray) {
        this._extraIntercolumnSpacing = nArray;
        if (nArray != null) {
            this._extraIntercolumnSpacingCount = nArray.length;
            this._calculateColumnWidths();
        }
    }

    public void setDataVector(Vector vector) {
        this._rowCount = vector == null ? 0 : vector.size();
        this._columnCount = this._rowCount == 0 ? 0 : ((Vector)vector.get(0)).size();
        ((DefaultTableModel)this.getModel()).setDataVector(vector, this._createEmptyColumnNamesVector());
        this._tableColumnModel = this.getColumnModel();
        if (this._useDefaultRenderer) {
            this._useDefaultRenderer();
        }
        if (this._calculateColumnWidths) {
            this._calculateColumnWidths();
        }
    }

    public void setDataVector(Object[][] objectArray) {
        this._rowCount = objectArray == null ? 0 : objectArray.length;
        this._columnCount = this._rowCount == 0 ? 0 : objectArray[0].length;
        ((DefaultTableModel)this.getModel()).setDataVector(objectArray, this._createEmptyColumnNamesArray());
        this._tableColumnModel = this.getColumnModel();
        if (this._useDefaultRenderer) {
            this._useDefaultRenderer();
        }
        if (this._calculateColumnWidths) {
            this._calculateColumnWidths();
        }
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    private Vector _createEmptyColumnNamesVector() {
        Vector<String> vector = new Vector<String>(this._columnCount);
        int n = 0;
        while (n < this._columnCount) {
            vector.add(STR_EMPTY);
            ++n;
        }
        return vector;
    }

    private String[] _createEmptyColumnNamesArray() {
        String[] stringArray = new String[this._columnCount];
        int n = 0;
        while (n < this._columnCount) {
            stringArray[n] = STR_EMPTY;
            ++n;
        }
        return stringArray;
    }

    private void _useDefaultRenderer() {
        int n = 0;
        while (n < this._columnCount) {
            this._tableColumnModel.getColumn(n).setCellRenderer(this._renderer);
            ++n;
        }
    }

    private void _calculateColumnWidths() {
        int n = 0;
        int n2 = 0;
        while (n2 < this._columnCount) {
            int n3 = 0;
            int n4 = 0;
            while (n4 < this._rowCount) {
                Object object = this.getValueAt(n4, n2);
                if (object != null) {
                    int n5 = this._renderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)n4, (int)n2).getPreferredSize().width;
                    n3 = Math.max(n3, n5);
                }
                ++n4;
            }
            if (this._extraIntercolumnSpacing != null && n2 < this._extraIntercolumnSpacingCount) {
                n3 += this._extraIntercolumnSpacing[n2];
                n += this._extraIntercolumnSpacing[n2];
            }
            TableColumn tableColumn = this._tableColumnModel.getColumn(n2);
            tableColumn.setPreferredWidth(n3 += 5);
            tableColumn.setMinWidth(n3);
            tableColumn.setMaxWidth(n3);
            ++n2;
        }
        Dimension dimension = this.getPreferredSize();
        dimension.width += this.getIntercellSpacing().width * this._columnCount;
        dimension.width += n;
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
    }
}

