/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.asa.ASAIconTextData;
import com.sybase.asa.ASAIconTextDataTableCellRenderer;
import com.sybase.asa.ASAMultiListColumnInfo;
import com.sybase.asa.ASAMultiListTableCellRenderer;
import com.sybase.asa.ASAMultiListTableHeaderRenderer;
import com.sybase.asa.ASAMultiListTableModel;
import com.sybase.asa.ASAScrollPane;
import com.sybase.asa.ASASortingTableModel;
import com.sybase.asa.ASAUserData;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ASAMultiList
extends JTable
implements ComponentListener,
ActionListener {
    protected static final String STR_EMPTY = "";
    protected static final String STR_COMMA = ",";
    protected static final String STR_BORDER = "TableHeader.cellBorder";
    protected static final String[] DEFAULT_COLUMN_NAMES = new String[]{" "};
    protected static Set FORWARD_TRAVERSAL_KEYSTROKES = new TreeSet();
    protected static Set BACKWARD_TRAVERSAL_KEYSTROKES;
    private boolean _autoKeySelectionEnabled;
    private Timer _timer;
    private StringBuffer _typedSoFar;
    private boolean _ascendingSortOrder = true;
    private int _sortedColumnNumber = -1;
    protected ASASortingTableModel tableModel;
    protected TableColumnModel tableColumnModel;
    protected int columnCount;
    protected ASAScrollPane scrollPane;
    private boolean _autoColumnWidths = true;
    private int[] _columnWidths;
    private String[] _columnToolTips;
    protected Object _defaultEscapeKeyBinding;
    protected Object _defaultEnterKeyBinding;
    private static /* synthetic */ Class class$java$lang$Object;
    private static /* synthetic */ Class class$java$lang$Number;

    public ASAMultiList() {
        this.setModel(new ASAMultiListTableModel(DEFAULT_COLUMN_NAMES, 0));
        this._init();
    }

    public ASAMultiList(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.setModel(new ASAMultiListTableModel(vector, vector2));
        this._init();
    }

    public ASAMultiList(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.setModel(new ASAMultiListTableModel(objectArray, objectArray2));
        this._init();
    }

    public ASAMultiList(Vector vector) {
        this.setModel(new ASAMultiListTableModel(vector, 0));
        this._init();
    }

    public ASAMultiList(Object[] objectArray) {
        this.setModel(new ASAMultiListTableModel(objectArray, 0));
        this._init();
    }

    public ASAMultiList(ASAMultiListColumnInfo[] aSAMultiListColumnInfoArray) {
        int n = aSAMultiListColumnInfoArray.length;
        Object[] objectArray = new String[n];
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = aSAMultiListColumnInfoArray[n2].name;
            stringArray[n2] = aSAMultiListColumnInfoArray[n2].toolTip;
            ++n2;
        }
        this.setModel(new ASAMultiListTableModel(objectArray, 0));
        this.setColumnToolTips(stringArray);
        this._init();
    }

    private void _init() {
        this.scrollPane = new ASAScrollPane(this);
        this.setShowGrid(false);
        this.setAutoResizeMode(0);
        this.scrollPane.getViewport().setBackground(this.getBackground());
        this.getTableHeader().setReorderingAllowed(false);
        InputMap inputMap = this.getInputMap(1);
        this._defaultEscapeKeyBinding = inputMap.get(KeyStroke.getKeyStroke(27, 0));
        this._defaultEnterKeyBinding = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "none");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "none");
        ((Container)this).setFocusTraversalKeys(0, FORWARD_TRAVERSAL_KEYSTROKES);
        ((Container)this).setFocusTraversalKeys(1, BACKWARD_TRAVERSAL_KEYSTROKES);
        this.addComponentListener(this);
        this._autoKeySelectionEnabled = true;
        this._timer = new Timer(1000, this);
        this._typedSoFar = new StringBuffer();
        this._timer.start();
    }

    public void releaseResources() {
        if (this._timer.isRunning()) {
            this._timer.stop();
        }
        this._timer.removeActionListener(this);
        this.tableModel.releaseResources();
        this._timer = null;
        this._typedSoFar = null;
        this.tableModel = null;
        this.tableColumnModel = null;
        this.scrollPane = null;
    }

    private static String[] _parseStringList(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        try {
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = stringTokenizer.nextToken().trim();
                ++n2;
            }
        }
        catch (Exception exception) {
            stringArray = null;
        }
        return stringArray;
    }

    public void setModel(ASAMultiListTableModel aSAMultiListTableModel) {
        this.setModel(new ASASortingTableModel(this, aSAMultiListTableModel));
    }

    protected void setModel(ASASortingTableModel aSASortingTableModel) {
        if (this.tableModel != null) {
            this.clear();
        }
        super.setModel(aSASortingTableModel);
        this.tableModel = aSASortingTableModel;
        this.tableColumnModel = this.getColumnModel();
        this.columnCount = this.tableColumnModel.getColumnCount();
        this._columnWidths = new int[this.columnCount];
        Class clazz = class$java$lang$Object;
        if (clazz == null) {
            clazz = class$java$lang$Object = ASAMultiList.class$("java.lang.Object");
        }
        this.setDefaultRenderer(clazz, new ASAMultiListTableCellRenderer());
        Class clazz2 = class$java$lang$Number;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Number = ASAMultiList.class$("java.lang.Number");
        }
        this.setDefaultRenderer(clazz2, new ASAMultiListTableCellRenderer());
        JTableHeader jTableHeader = this.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.setDefaultRenderer(new ASAMultiListTableHeaderRenderer(this));
        }
    }

    public boolean isAutoKeySelectionEnabled() {
        return this._autoKeySelectionEnabled;
    }

    public void setAutoKeySelectionEnabled(boolean bl) {
        this._autoKeySelectionEnabled = bl;
        if (bl && !this._timer.isRunning()) {
            this._timer.restart();
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
    }

    public boolean isSorting() {
        if (this.tableModel == null) {
            return false;
        }
        return this.tableModel.isSorting();
    }

    public void setSorting(boolean bl) {
        JTableHeader jTableHeader = this.getTableHeader();
        this.tableModel.setSorting(bl);
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public boolean isAscendingSortOrder() {
        return this._ascendingSortOrder;
    }

    public void setAscendingSortOrder(boolean bl) {
        JTableHeader jTableHeader = this.getTableHeader();
        this._ascendingSortOrder = bl;
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public int getSortedColumnNumber() {
        return this.isSorting() ? this._sortedColumnNumber : -1;
    }

    public void setSortedColumnNumber(int n) {
        JTableHeader jTableHeader = this.getTableHeader();
        this._sortedColumnNumber = n;
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    public boolean getAutoColumnWidths() {
        return this._autoColumnWidths;
    }

    public void setAutoColumnWidths(boolean bl) {
        this._autoColumnWidths = bl;
    }

    public boolean getColumnHasIconTextData(int n) {
        return this.tableColumnModel.getColumn(n).getCellRenderer() instanceof ASAIconTextDataTableCellRenderer;
    }

    public void setColumnHasIconTextData(int n, boolean bl) {
        this.tableColumnModel.getColumn(n).setCellRenderer(bl ? new ASAIconTextDataTableCellRenderer() : new ASAMultiListTableCellRenderer());
    }

    public ASAScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void restoreDefaultEscapeAndEnterKeyBindings() {
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(27, 0), this._defaultEscapeKeyBinding);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), this._defaultEnterKeyBinding);
    }

    public void setColumnHeadings(Vector vector) {
        this.setModel(new ASAMultiListTableModel(vector, 0));
    }

    public void setColumnHeadings(Object[] objectArray) {
        this.setModel(new ASAMultiListTableModel(objectArray, 0));
    }

    public String getColumnToolTip(int n) {
        String string;
        if (this._columnToolTips != null && (string = this._columnToolTips[n]) != null && string.length() > 0) {
            return string;
        }
        return this.tableModel != null ? this.tableModel.getColumnName(n) : null;
    }

    public void setColumnToolTips(String[] stringArray) {
        this._columnToolTips = stringArray;
    }

    public void setColumnWidths(String string) {
        String[] stringArray = ASAMultiList._parseStringList(string, STR_COMMA);
        int n = 0;
        while (n < this.columnCount) {
            int n2 = Integer.valueOf(stringArray[n]);
            this.tableColumnModel.getColumn(n).setPreferredWidth(n2);
            this._columnWidths[n] = n2;
            ++n;
        }
    }

    public void setColumnWidths(int[] nArray) {
        int n = 0;
        while (n < this.columnCount) {
            int n2 = nArray[n];
            this.tableColumnModel.getColumn(n).setPreferredWidth(n2);
            this._columnWidths[n] = n2;
            ++n;
        }
    }

    public void setColumnWidth(int n, int n2) {
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setPreferredWidth(n2);
        this._columnWidths[n] = n2;
    }

    public void setColumnWidthToFit(int n) {
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n2 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n2 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        int n3 = 0;
        int n4 = this.getRowCount();
        while (n3 < n4) {
            int n5 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)n3, (int)n), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            n2 = Math.max(n2, n5);
            ++n3;
        }
        this.setColumnWidth(n, n2 += this.getIntercellSpacing().width);
    }

    public void setColumnWidthToFit(int n, String[] stringArray) {
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n2 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n2 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        int n3 = 0;
        int n4 = stringArray.length;
        while (n3 < n4) {
            int n5 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)stringArray[n3], (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            n2 = Math.max(n2, n5);
            ++n3;
        }
        this.setColumnWidth(n, n2 += this.getIntercellSpacing().width);
    }

    public void setColumnWidthToFit(int n, int n2) {
        String string;
        JTableHeader jTableHeader;
        TableColumn tableColumn = this.tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
        int n3 = 0;
        if (tableCellRenderer == null && (jTableHeader = this.getTableHeader()) != null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        if (tableCellRenderer2 == null) {
            tableCellRenderer2 = tableCellRenderer;
        }
        if (tableCellRenderer != null) {
            n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        }
        try {
            string = new Integer((int)Math.pow(10.0, n2 - 1)).toString();
        }
        catch (ArithmeticException arithmeticException) {
            return;
        }
        int n4 = tableCellRenderer2.getTableCellRendererComponent((JTable)this, (Object)string, (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
        int n5 = Math.max(n3, n4);
        this.setColumnWidth(n, n5 += this.getIntercellSpacing().width);
    }

    public void calculateColumnWidths() {
        int n;
        JViewport jViewport;
        if (!this._autoColumnWidths || this.scrollPane == null || (jViewport = this.scrollPane.getViewport()) == null || (n = jViewport.getWidth()) == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.columnCount) {
            int n5 = this._columnWidths[n4];
            if (n5 != 0) {
                ++n2;
                n3 += n5;
            }
            ++n4;
        }
        if (n2 == this.columnCount) {
            return;
        }
        int n6 = n - n3;
        if (n6 < 0) {
            return;
        }
        int n7 = n6 / (this.columnCount - n2);
        if (n7 < 75) {
            return;
        }
        n4 = 0;
        while (n4 < this.columnCount) {
            if (this._columnWidths[n4] <= 0) {
                this.tableColumnModel.getColumn(n4).setPreferredWidth(n7);
            }
            ++n4;
        }
    }

    public void setInitialColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.tableModel.getColumnCount();
        int n2 = this.getPreferredScrollableViewportSize().height;
        int n3 = n2 / this.getRowHeight();
        int n4 = this.getRowCount();
        int n5 = Math.min(n4, n3);
        if (n5 < 10 && n4 >= 10) {
            n5 = 10;
        }
        int n6 = 0;
        while (n6 < n) {
            Object object;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(n6);
            int n7 = 0;
            JTableHeader jTableHeader = this.getTableHeader();
            if (jTableHeader != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
                object = tableColumn.getHeaderValue();
                if (object != null) {
                    n7 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
                }
            }
            int n8 = 0;
            while (n8 < n5) {
                tableCellRenderer = this.getCellRenderer(n8, n6);
                object = this.tableModel.getValueAt(n8, n6);
                if (object == null && n8 >= (n5 = Math.min(this.getRowCount(), 10))) break;
                int n9 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)object, (boolean)false, (boolean)false, (int)n8, (int)n6).getPreferredSize().width;
                n7 = Math.max(n7, n9);
                ++n8;
            }
            tableColumn.setPreferredWidth(n7 + 2);
            ++n6;
        }
        this.sizeColumnsToFit(-1);
    }

    public void selectRow(int n) {
        this.setRowSelectionInterval(n, n);
    }

    public void selectRows(int n, int n2) {
        this.setRowSelectionInterval(n, n2);
    }

    public void selectRows(int[] nArray) {
        this.clearSelection();
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int n3 = nArray[n];
            this.addRowSelectionInterval(n3, n3);
            ++n;
        }
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public Icon getIconAt(int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            return null;
        }
        if (object instanceof Icon) {
            return (Icon)object;
        }
        if (object instanceof ASAIconTextData) {
            return ((ASAIconTextData)object).icon;
        }
        return null;
    }

    public void setIconAt(Icon icon, int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            this.tableModel.setValueAt(icon, n, n2);
        } else if (object instanceof ASAIconTextData) {
            ((ASAIconTextData)object).icon = icon;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else {
            this.tableModel.setValueAt(icon, n, n2);
        }
    }

    public String getStringAt(int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            return new String();
        }
        if (object instanceof String) {
            return (String)object;
        }
        return object.toString();
    }

    public void setStringAt(String string, int n, int n2) {
        Object object = this.tableModel.getValueAt(n, n2);
        if (object == null) {
            this.tableModel.setValueAt(string, n, n2);
        } else if (object instanceof ASAIconTextData) {
            ((ASAIconTextData)object).text = string;
            this.tableModel.fireTableCellUpdated(n, n2);
        } else {
            this.tableModel.setValueAt(string, n, n2);
        }
    }

    public Object getUserDataAt(int n, int n2) {
        ASAUserData aSAUserData = (ASAUserData)this.tableModel.getValueAt(n, n2);
        return aSAUserData.getUserData();
    }

    public void setUserDataAt(Object object, int n, int n2) {
        ASAUserData aSAUserData = (ASAUserData)this.tableModel.getValueAt(n, n2);
        aSAUserData.setUserData(object);
        this.tableModel.fireTableCellUpdated(n, n2);
    }

    public Vector getRow(int n) {
        Vector<Object> vector = new Vector<Object>(this.columnCount);
        int n2 = 0;
        while (n2 < this.columnCount) {
            vector.add(this.getValueAt(n, n2));
            ++n2;
        }
        return vector;
    }

    public Vector getRowAsStringData(int n) {
        Vector<String> vector = new Vector<String>(this.columnCount);
        int n2 = 0;
        while (n2 < this.columnCount) {
            vector.add(this.getStringAt(n, n2));
            ++n2;
        }
        return vector;
    }

    public Object[] getRowAsArray(int n) {
        Object[] objectArray = new Object[this.columnCount];
        int n2 = 0;
        while (n2 < this.columnCount) {
            objectArray[n2] = this.getValueAt(n, n2);
            ++n2;
        }
        return objectArray;
    }

    public Object getRowAsStringDataArray(int n) {
        Object[] objectArray = new Object[this.columnCount];
        int n2 = 0;
        while (n2 < this.columnCount) {
            objectArray[n2] = this.getStringAt(n, n2);
            ++n2;
        }
        return objectArray;
    }

    public Vector getDataVector() {
        return this.tableModel.getDataVector();
    }

    public void setRow(int n, Vector vector) {
        int n2 = 0;
        while (n2 < this.columnCount) {
            this.tableModel.setValueAt(vector.get(n2), n, n2);
            ++n2;
        }
    }

    public void setRow(int n, Object[] objectArray) {
        int n2 = 0;
        while (n2 < this.columnCount) {
            this.tableModel.setValueAt(objectArray[n2], n, n2);
            ++n2;
        }
    }

    public int findRow(String string) {
        return this.findRow(string, 0, this.getRowCount(), false, false);
    }

    public int findRow(String string, int n) {
        return this.findRow(string, n, this.getRowCount(), false, false);
    }

    public int findRow(String string, int n, int n2, boolean bl, boolean bl2) {
        int n3 = string.length();
        int n4 = n;
        while (n4 < n2) {
            String string2 = this.getStringAt(n4, 0);
            if (string2 != null) {
                int n5;
                int n6 = n5 = bl2 ? n3 : Math.max(n3, string2.length());
                if (string2.regionMatches(bl, 0, string, 0, n5)) {
                    return n4;
                }
            }
            ++n4;
        }
        return -1;
    }

    public int findRow(String[] stringArray) {
        return this.findRow(stringArray, 0);
    }

    public int findRow(String[] stringArray, int n) {
        int n2 = stringArray.length;
        int n3 = n;
        int n4 = this.getRowCount();
        while (n3 < n4) {
            int n5 = 0;
            while (n5 < n2) {
                if (!this.getStringAt(n3, n5).equals(stringArray[n5])) break;
                ++n5;
            }
            if (n5 == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public void sort() {
        this.tableModel.sortByColumn(0, true);
    }

    public void sort(int n) {
        this.tableModel.sortByColumn(n, true);
    }

    public void sort(boolean bl) {
        this.tableModel.sortByColumn(0, bl);
    }

    public void sort(int n, boolean bl) {
        this.tableModel.sortByColumn(n, bl);
    }

    public void moveRow(int n, int n2, int n3) {
        this.tableModel.moveRow(n, n2, n3);
        this.clearSelection();
    }

    public void addRow(Vector vector) {
        this.tableModel.addRow(vector);
        this.clearSelection();
    }

    public void addRow(Object[] objectArray) {
        this.tableModel.addRow(objectArray);
        this.clearSelection();
    }

    public void addRowWithIcon(Icon icon, Vector vector) {
        Vector vector2 = (Vector)vector.clone();
        vector2.set(0, new ASAIconTextData(icon, (String)vector.firstElement()));
        this.tableModel.addRow(vector2);
        this.clearSelection();
    }

    public void insertRow(int n, Vector vector) {
        this.tableModel.insertRow(n, vector);
        this.clearSelection();
    }

    public void insertRow(int n, Object[] objectArray) {
        this.tableModel.insertRow(n, objectArray);
        this.clearSelection();
    }

    public void insertRowWithIcon(int n, Icon icon, Vector vector) {
        Vector vector2 = (Vector)vector.clone();
        vector2.set(0, new ASAIconTextData(icon, (String)vector.firstElement()));
        this.tableModel.insertRow(n, vector2);
        this.clearSelection();
    }

    public void removeRow(int n) {
        this.tableModel.removeRow(n);
    }

    public void clear() {
        this.tableModel.clear();
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().addListSelectionListener(listSelectionListener);
    }

    public void removeListSelectionListener(ListSelectionListener listSelectionListener) {
        this.getSelectionModel().removeListSelectionListener(listSelectionListener);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        JTableHeader jTableHeader = this.getTableHeader();
        if (bl && this._autoKeySelectionEnabled && !this._timer.isRunning()) {
            this._timer.restart();
            this._typedSoFar.setLength(0);
        } else if (!bl && this._timer.isRunning()) {
            this._timer.stop();
        }
        if (jTableHeader != null) {
            jTableHeader.columnMarginChanged(new ChangeEvent(this));
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2;
        char c;
        int n3 = keyEvent.getKeyCode();
        int n4 = this.getRowCount();
        if (this._timer.isRunning() && n3 == 0 && n == 0 && (c = keyEvent.getKeyChar()) != '\uffff' && ((n2 = keyEvent.getModifiers()) == 0 || n2 == 1) && n4 > 0) {
            String string;
            this._timer.stop();
            this._typedSoFar.append(c);
            int n5 = this.isSelectionEmpty() ? 0 : this.getMaxSelectionIndex();
            int n6 = this._typedSoFar.length();
            if (n6 == 1 || this._typedSoFar.charAt(n6 - 2) == c) {
                ++n5;
                string = String.valueOf(c);
            } else {
                string = this._typedSoFar.toString();
            }
            int n7 = this.findRow(string, n5, n4, true, true);
            if (n7 != -1 || (n7 = this.findRow(string, 0, n5, true, true)) != -1) {
                this.setRowSelectionInterval(n7, n7);
                this.scrollRectToVisible(this.getCellRect(n7, 0, true));
            }
            this._timer.restart();
        }
        if (n3 == 9 && n4 == 0) {
            return true;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.calculateColumnWidths();
        this.removeComponentListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._timer) {
            this._typedSoFar.setLength(0);
        }
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        JViewport jViewport;
        super.tableChanged(tableModelEvent);
        if (this._autoColumnWidths && this.scrollPane != null && (jViewport = this.scrollPane.getViewport()) != null && jViewport.getWidth() > 0 && tableModelEvent.getType() != 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public final void run() {
                    ASAMultiList.this.calculateColumnWidths();
                }
            });
        }
    }

    static {
        FORWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 0));
        BACKWARD_TRAVERSAL_KEYSTROKES = new TreeSet();
        BACKWARD_TRAVERSAL_KEYSTROKES.add(KeyStroke.getKeyStroke(9, 1));
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

