/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.util.Dbg;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.border.Border;

public class ASAToolBarToggleButton
extends JToggleButton
implements ItemListener,
MouseListener {
    private boolean _pressed;
    private static Border COMP_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private static Border EMPTY_BORDER = BorderFactory.createCompoundBorder(COMP_BORDER, COMP_BORDER);
    private static Border BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), COMP_BORDER);
    private static Border PRESSED_BUTTON_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), COMP_BORDER);
    private static Color SELECTED_AND_NOT_OVER_BACKGROUND_COLOR = ASAToolBarToggleButton.averageColor(SystemColor.control, SystemColor.controlLtHighlight);
    protected static final boolean _isXP = System.getProperty("os.name").equals("Windows XP");
    protected boolean _entered;
    protected static final int ARC_DIAMETER = 8;
    protected static Color _enteredColor = ASAToolBarToggleButton.averageColor(SystemColor.control, SystemColor.controlLtHighlight);
    protected static Color _borderColor = ASAToolBarToggleButton.averageColor(SystemColor.control, SystemColor.controlShadow);
    protected static Color _pressedBorderColor = SystemColor.controlShadow;
    protected static Color _pressedColor = ASAToolBarToggleButton.averageColor(SystemColor.controlLtHighlight, SystemColor.controlShadow);
    protected static Color _selectedBorderColor = ASAToolBarToggleButton.averageColor(SystemColor.textHighlight, SystemColor.textInactiveText);
    protected static Color _selectedColor = SystemColor.controlLtHighlight;

    public ASAToolBarToggleButton() {
        this.init();
    }

    public ASAToolBarToggleButton(Icon icon) {
        super(icon);
        this.init();
    }

    protected static Color averageColor(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    private void init() {
        this.setAlignmentY(0.5f);
        if (_isXP) {
            super.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        } else {
            super.setBorder(EMPTY_BORDER);
        }
        this.addMouseListener(this);
        this.setFocusable(false);
        if (!_isXP) {
            this.getModel().addItemListener(this);
        }
        if (_isXP) {
            super.setBorderPainted(false);
            this.setContentAreaFilled(false);
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (_isXP) {
            Color color;
            Color color2;
            int n = this.getHeight();
            int n2 = this.getWidth();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            boolean bl = this.getModel().isSelected();
            if (bl) {
                if (this._pressed) {
                    color2 = _pressedBorderColor;
                    color = _pressedColor;
                } else {
                    color2 = _selectedBorderColor;
                    color = _selectedColor;
                }
            } else if (this._entered) {
                if (this._pressed) {
                    color2 = _pressedBorderColor;
                    color = _pressedColor;
                } else {
                    color2 = _borderColor;
                    color = SystemColor.control;
                }
            } else {
                color2 = SystemColor.control;
                color = SystemColor.control;
            }
            graphics2D.setColor(color);
            graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
            graphics2D.setColor(color2);
            graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, n2 - 1, n - 1, 8.0, 8.0));
            if (this._entered && !this._pressed) {
                Color color3 = bl ? SystemColor.control : color2;
                Color color4 = ASAToolBarToggleButton.averageColor(color, color3);
                graphics2D.setColor(color3);
                int n3 = 4;
                graphics2D.draw(new Line2D.Double(n2 - 2, n3, n2 - 2, n - n3));
                graphics2D.draw(new Line2D.Double(n3, n - 2, n2 - n3, n2 - 2));
                graphics2D.setColor(color4);
                graphics2D.draw(new Line2D.Double(n2 - 3, n3, n2 - 3, n - n3));
                graphics2D.draw(new Line2D.Double(n3, n - 3, n2 - n3, n2 - 3));
            }
            super.paintComponent(graphics);
        } else {
            super.paintComponent(graphics);
        }
    }

    public void setBorder(Border border) {
        if (!_isXP) {
            super.setBorder(border);
        }
    }

    public void releaseResources() {
        this.removeMouseListener(this);
        if (!_isXP) {
            this.getModel().removeItemListener(this);
        }
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (!_isXP) {
            if (bl) {
                this.setBackground(SELECTED_AND_NOT_OVER_BACKGROUND_COLOR);
            } else {
                this.setBackground(SystemColor.control);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            this.setBackground(SystemColor.control);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            if (false && this.dbgEnabled()) {
                Dbg.printlnEx((String)"entered");
            }
            this._entered = true;
            if (_isXP) {
                this.repaint();
            } else if (this._pressed) {
                this.setBorder(PRESSED_BUTTON_BORDER);
                this.setBackground(SystemColor.control);
            } else if (this.isSelected()) {
                this.setBackground(SystemColor.control);
            } else {
                this.setBorder(BUTTON_BORDER);
                this.setBackground(SystemColor.control);
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (this._entered) {
            if (false && this.dbgEnabled()) {
                Dbg.printlnEx((String)"exited");
            }
            this._entered = false;
            if (_isXP) {
                this.repaint();
            } else {
                this.setBorder(EMPTY_BORDER);
                if (this.isSelected()) {
                    this.setBackground(SELECTED_AND_NOT_OVER_BACKGROUND_COLOR);
                } else {
                    this.setBackground(SystemColor.control);
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            if (false && this.dbgEnabled()) {
                Dbg.printlnEx((String)"MousePressed");
            }
            this._pressed = true;
            if (_isXP) {
                this.repaint();
            } else {
                this.setBorder(PRESSED_BUTTON_BORDER);
                this.setBackground(SystemColor.control);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this._pressed) {
            this._pressed = false;
            if (_isXP) {
                this.repaint();
            } else {
                if (this.getBorder() == PRESSED_BUTTON_BORDER) {
                    if (this.isSelected()) {
                        this.setBackground(SystemColor.control);
                    } else {
                        this.setBorder(BUTTON_BORDER);
                        this.setBackground(SystemColor.control);
                    }
                } else {
                    this.setBorder(EMPTY_BORDER);
                    this.setBackground(SystemColor.control);
                }
                Container container = this.getParent();
                while (container != null) {
                    if (!container.isVisible()) {
                        this.setBorder(EMPTY_BORDER);
                        this.setBackground(SystemColor.control);
                        return;
                    }
                    container = container instanceof Container ? container.getParent() : null;
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    protected boolean dbgEnabled() {
        return false && Dbg.isMessageTypeEnabled((String)"com.sybase.asa.ASAToolBarToggleButton");
    }
}

