/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa;

import com.sybase.central.SCDialogSupport;
import com.sybase.central.SCProfile;
import com.sybase.util.Platform;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ASAUtils {
    private static final String STR_EMPTY = "";
    private static final String STR_OS_DOT_NAME = "os.name";
    private static final String STR_OS_DOT_VERSION = "os.version";
    private static final String STR_WINDOWS = "Windows";
    private static final String STR_WINDOWS_95 = "Windows 95";
    private static final String STR_WINDOWS_98 = "Windows 98";
    private static final String STR_WINDOWS_ME = "Windows Me";
    private static final String STR_WINDOWS_NT = "Windows NT";
    private static final String STR_WINDOWS_2000 = "Windows 2000";
    private static final String STR_WINDOWS_XP = "Windows XP";
    private static final String STR_5_DOT_1 = "5.1";
    private static final String STR_5_DOT_2 = "5.2";
    private static final String STR_SOLARIS = "Solaris";
    private static final String STR_SUNOS = "SunOS";
    private static final String STR_LINUX = "Linux";
    private static final String STR_Y = "Y";
    private static final String STR_N = "N";
    private static final String STR_COMMA = ",";
    private static final String STR_COMMA_SPACE = ", ";
    private static final String STR_SPACE_DASH_SPACE = " - ";
    private static final String STR_SPACE_OPEN_PAREN = " (";
    private static final String STR_CLOSE_PAREN_SPACE_DASH_SPACE = ") - ";
    private static final Integer INT_ZERO = new Integer(0);
    private static final String REGEXP_NON_NEGATIVE_INT = "[0-9]+";
    private static final String REGEXP_PROFILE_STRING = "\"([^\"]+|(\"\"))*\"";
    private static final int BUFFER_SIZE = 1024;

    public static String getOSName() {
        return System.getProperty(STR_OS_DOT_NAME);
    }

    public static String getOSVersion() {
        return System.getProperty(STR_OS_DOT_VERSION);
    }

    public static boolean isWindows() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS) != -1;
    }

    public static boolean isWindowsFake32() {
        return ASAUtils.isWindows95() || ASAUtils.isWindows98() || ASAUtils.isWindowsMe();
    }

    public static boolean isWindowsReal32() {
        return ASAUtils.isWindows() && !ASAUtils.isWindowsFake32();
    }

    public static boolean isWindows95() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_95) != -1;
    }

    public static boolean isWindows98() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_98) != -1;
    }

    public static boolean isWindowsMe() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_ME) != -1;
    }

    public static boolean isWindowsNT() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_NT) != -1;
    }

    public static boolean isWindows2000() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_2000) != -1;
    }

    public static boolean isWindowsXP() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_XP) != -1 && ASAUtils.getOSVersion().indexOf(STR_5_DOT_1) != -1;
    }

    public static boolean isWindows2003() {
        return ASAUtils.getOSName().indexOf(STR_WINDOWS_XP) != -1 && ASAUtils.getOSVersion().indexOf(STR_5_DOT_2) != -1;
    }

    public static boolean isUnix() {
        return ASAUtils.isSolaris() || ASAUtils.isLinux();
    }

    public static boolean isSolaris() {
        String osName = ASAUtils.getOSName();
        return osName.indexOf(STR_SOLARIS) != -1 || osName.indexOf(STR_SUNOS) != -1;
    }

    public static boolean isLinux() {
        return ASAUtils.getOSName().indexOf(STR_LINUX) != -1;
    }

    public static boolean isExistingFile(String pathName) {
        File file = new File(pathName);
        return file.exists() && file.isFile();
    }

    public static boolean isExistingDirectory(String pathName) {
        if (pathName.length() == 0) {
            return true;
        }
        File file = new File(pathName);
        return file.exists() && file.isDirectory();
    }

    public static String getDirectoryFromPath(String pathName) {
        File file = new File(pathName);
        String directoryName = file.getParent();
        return directoryName == null ? STR_EMPTY : directoryName;
    }

    public static String getExistingDirectoryFromPath(String pathName) {
        if (pathName.length() == 0) {
            return pathName;
        }
        File file = new File(pathName);
        while (file != null) {
            if (file.exists() && file.isDirectory()) {
                return file.getPath();
            }
            file = file.getParentFile();
        }
        return STR_EMPTY;
    }

    public static String getFileFromPath(String pathName) {
        File file = new File(pathName);
        String fileName = file.getName();
        return fileName == null ? STR_EMPTY : fileName;
    }

    public static String getFileWithoutExtensionFromPath(String pathName) {
        int index;
        String fileName = ASAUtils.getFileFromPath(pathName);
        int len = fileName.length();
        if (len > 0 && (index = fileName.lastIndexOf(46)) > 0) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getFileExtensionFromPath(String pathName) {
        int index;
        String fileName = ASAUtils.getFileFromPath(pathName);
        int len = fileName.length();
        if (len > 0 && (index = fileName.lastIndexOf(46)) > 0 && index < len - 1) {
            return fileName.substring(index + 1);
        }
        return STR_EMPTY;
    }

    public static String getCanonicalPath(String pathName) {
        File file = new File(pathName);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static String buildFullPathName(String directoryName, String fileName) {
        if (directoryName == null) {
            return fileName;
        }
        if (fileName == null) {
            return directoryName;
        }
        int len = directoryName.length();
        if (len > 0 && directoryName.charAt(len - 1) != File.separatorChar) {
            return String.valueOf(directoryName) + File.separatorChar + fileName;
        }
        return String.valueOf(directoryName) + fileName;
    }

    public static boolean createDirectory(String pathName) {
        File file = new File(pathName);
        return file.mkdirs();
    }

    public static boolean deleteFile(String pathName) {
        File file = new File(pathName);
        return file.delete();
    }

    public static String quote(String text, char quoteChar, char escapeChar, boolean addEnclosingQuotes, boolean doubleUpQuotes) {
        if (!addEnclosingQuotes && (text == null || text.indexOf(quoteChar) == -1 && text.indexOf(escapeChar) == -1)) {
            return text;
        }
        boolean doubleUpEscapes = escapeChar != '\u0000';
        int len = text != null ? text.length() : 0;
        char[] buf = new char[len * 2 + 2];
        int n = 0;
        if (addEnclosingQuotes) {
            buf[n++] = quoteChar;
        }
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            buf[n++] = c;
            if (doubleUpQuotes && c == quoteChar) {
                buf[n++] = quoteChar;
            }
            if (doubleUpEscapes && c == escapeChar) {
                buf[n++] = escapeChar;
            }
            ++i;
        }
        if (addEnclosingQuotes) {
            buf[n++] = quoteChar;
        }
        return new String(buf, 0, n);
    }

    public static String unquote(String text, char quoteChar, char escapeChar, boolean removeEnclosingQuotes, boolean singleDownQuotes) {
        int endIndex;
        int startIndex;
        if (text == null || text.length() <= 1 || text.indexOf(quoteChar) == -1 && text.indexOf(escapeChar) == -1) {
            return text;
        }
        boolean singleDownEscapes = escapeChar != '\u0000';
        int len = text.length();
        if (removeEnclosingQuotes && text.indexOf(quoteChar) == 0 && text.lastIndexOf(quoteChar) == len - 1) {
            startIndex = 1;
            endIndex = len - 1;
        } else {
            startIndex = 0;
            endIndex = len;
        }
        char[] buf = new char[endIndex - startIndex];
        int n = 0;
        int i = startIndex;
        while (i < endIndex) {
            char c = text.charAt(i);
            if (singleDownQuotes && c == quoteChar && i < endIndex - 1 && text.charAt(i + 1) == quoteChar) {
                buf[n++] = quoteChar;
                ++i;
            } else if (singleDownEscapes && c == escapeChar && i < endIndex - 1 && text.charAt(i + 1) == escapeChar) {
                buf[n++] = escapeChar;
                ++i;
            } else {
                buf[n++] = c;
            }
            ++i;
        }
        return new String(buf, 0, n);
    }

    public static String buildIntegerList(int[] items, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int n = items.length;
        while (i < n) {
            int item = items[i];
            if (buffer.length() > 0) {
                buffer.append(delimiter);
            }
            buffer.append(String.valueOf(item));
            ++i;
        }
        return buffer.toString();
    }

    public static String buildProfileIntegerList(int[] items) {
        return ASAUtils.buildIntegerList(items, STR_COMMA);
    }

    public static String buildSQLIntegerList(int[] items) {
        return ASAUtils.buildIntegerList(items, STR_COMMA_SPACE);
    }

    public static int[] parseIntegerList(String text, String regexp) {
        ArrayList<Integer> items = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            Integer value;
            String item = matcher.group();
            try {
                value = Integer.valueOf(item);
            }
            catch (NumberFormatException e) {
                value = 0;
            }
            items.add(value);
        }
        int n = items.size();
        int[] values = new int[n];
        int i = 0;
        while (i < n) {
            values[i] = (Integer)items.get(i);
            ++i;
        }
        return values;
    }

    public static int[] parseProfileIntegerList(String text) {
        return ASAUtils.parseIntegerList(text, REGEXP_NON_NEGATIVE_INT);
    }

    public static String buildStringList(String[] items, String delimiter, char quoteChar, char escapeChar, boolean addEnclosingQuotes, boolean doubleUpQuotes) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int n = items.length;
        while (i < n) {
            String item = items[i];
            if (item != null && item.length() != 0) {
                if (buffer.length() > 0) {
                    buffer.append(delimiter);
                }
                buffer.append(ASAUtils.quote(item, quoteChar, escapeChar, addEnclosingQuotes, doubleUpQuotes));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String buildStringList(Collection items, String delimiter, char quoteChar, char escapeChar, boolean addEnclosingQuotes, boolean doubleUpQuotes) {
        return ASAUtils.buildStringList(items.toArray(new String[items.size()]), delimiter, quoteChar, escapeChar, addEnclosingQuotes, doubleUpQuotes);
    }

    public static String buildProfileStringList(String[] items) {
        return ASAUtils.buildStringList(items, STR_COMMA, '\"', '\u0000', true, true);
    }

    public static String buildSQLIdentifierList(String[] items) {
        return ASAUtils.buildStringList(items, STR_COMMA_SPACE, '\"', '\\', true, true);
    }

    public static String buildSQLStringList(String[] items) {
        return ASAUtils.buildStringList(items, STR_COMMA_SPACE, '\'', '\\', true, true);
    }

    public static String buildSQLKeywordList(String[] items) {
        return ASAUtils.buildStringList(items, STR_COMMA_SPACE, '\u0000', '\u0000', false, false);
    }

    public static String buildDisplayStringList(String[] items) {
        return ASAUtils.buildStringList(items, STR_COMMA_SPACE, '\u0000', '\u0000', false, false);
    }

    public static String buildProfileStringList(Collection items) {
        return ASAUtils.buildProfileStringList(items.toArray(new String[items.size()]));
    }

    public static String buildSQLIdentifierList(Collection items) {
        return ASAUtils.buildSQLIdentifierList(items.toArray(new String[items.size()]));
    }

    public static String buildSQLStringList(Collection items) {
        return ASAUtils.buildSQLStringList(items.toArray(new String[items.size()]));
    }

    public static String buildSQLKeywordList(Collection items) {
        return ASAUtils.buildSQLKeywordList(items.toArray(new String[items.size()]));
    }

    public static String buildDisplayStringList(Collection items) {
        return ASAUtils.buildDisplayStringList(items.toArray(new String[items.size()]));
    }

    public static String buildNameWithOwner(String name, String owner) {
        int len = name.length() + owner.length() + 3;
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(name);
        buffer.append(STR_SPACE_OPEN_PAREN);
        buffer.append(owner);
        buffer.append(')');
        return buffer.toString();
    }

    public static String buildNameWithNameWithOwner(String name1, String name2, String owner) {
        int len = name1.length() + name2.length() + owner.length() + 6;
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(name1);
        buffer.append(STR_SPACE_DASH_SPACE);
        buffer.append(name2);
        buffer.append(STR_SPACE_OPEN_PAREN);
        buffer.append(owner);
        buffer.append(')').toString();
        return buffer.toString();
    }

    public static String buildNameWithUser(String name, String user) {
        int len = name.length() + user.length() + 3;
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(name);
        buffer.append(STR_SPACE_DASH_SPACE);
        buffer.append(user);
        return buffer.toString();
    }

    public static String buildNameWithOwnerWithUser(String name, String owner, String user) {
        int len = name.length() + owner.length() + user.length() + 6;
        StringBuffer buffer = new StringBuffer(len);
        buffer.append(name);
        buffer.append(STR_SPACE_OPEN_PAREN);
        buffer.append(owner);
        buffer.append(STR_CLOSE_PAREN_SPACE_DASH_SPACE);
        buffer.append(user);
        return buffer.toString();
    }

    public static String compressWhitespace(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return text;
        }
        StringTokenizer tokenizer = new StringTokenizer(text);
        StringBuffer buffer = new StringBuffer(len);
        while (tokenizer.hasMoreTokens()) {
            buffer.append(tokenizer.nextToken()).append(' ');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public static String removeCarriageReturns(String text) {
        int len;
        if (text == null || (len = text.length()) == 0) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            if (text.charAt(i) != '\r') {
                buffer.append(text.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String buildHexString(byte[] bytes) {
        int len = bytes.length;
        StringBuffer buffer = new StringBuffer(len * 4 + 2);
        buffer.append('\'');
        int i = 0;
        while (i < len) {
            int b = bytes[i];
            if (b < 0) {
                b += 256;
            }
            int hi = b >>> 4;
            int lo = b & 0xF;
            buffer.append("\\x");
            if (hi < 10) {
                buffer.append((char)(48 + hi));
            } else {
                buffer.append((char)(97 + hi - 10));
            }
            if (lo < 10) {
                buffer.append((char)(48 + lo));
            } else {
                buffer.append((char)(97 + lo - 10));
            }
            ++i;
        }
        buffer.append('\'');
        return buffer.toString();
    }

    public static String buildScript(String[] stmts) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int n = stmts.length;
        while (i < n) {
            String stmt = stmts[i];
            if (stmt != null && stmt.length() > 0) {
                buffer.append(stmt);
                buffer.append(";\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String buildScript(ArrayList stmts) {
        return ASAUtils.buildScript(stmts.toArray(new String[stmts.size()]));
    }

    public static boolean isValid24HourTime(String text) {
        try {
            return text.length() == 4 && Integer.parseInt(text.substring(0, 2)) <= 23 && Integer.parseInt(text.substring(2)) <= 59;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean equals(String s1, String s2) {
        return ASAUtils.equals(s1, s2, true);
    }

    public static boolean equals(String s1, String s2, boolean caseSensitive) {
        if (s1 == null || s1.length() == 0) {
            return s2 == null || s2.length() == 0;
        }
        return caseSensitive ? s1.equals(s2) : s1.equalsIgnoreCase(s2);
    }

    public static boolean equals(int[] a1, int[] a2) {
        if (a1 == null || a1.length == 0) {
            return a2 == null || a2.length == 0;
        }
        return Arrays.equals(a1, a2);
    }

    public static boolean equals(Collection c1, Collection c2) {
        if (c1 == null || c1.size() == 0) {
            return c2 == null || c2.size() == 0;
        }
        return c1.equals(c2);
    }

    public static boolean equals(Date d1, Date d2) {
        return d1 == null ? d2 == null : d1.equals(d2);
    }

    public static boolean equals(Time t1, Time t2) {
        return t1 == null ? t2 == null : t1.equals(t2);
    }

    public static boolean equals(Timestamp s1, Timestamp s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static boolean getBooleanPreference(SCProfile profile, String keyName, boolean defaultValue) {
        String value = profile.readString(keyName);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase(STR_Y)) {
            return true;
        }
        if (value.equalsIgnoreCase(STR_N)) {
            return false;
        }
        return defaultValue;
    }

    public static void setBooleanPreference(SCProfile profile, String keyName, boolean value) {
        profile.writeString(keyName, value ? STR_Y : STR_N);
    }

    public static Image loadImage(String fileName) {
        byte[] image;
        block6: {
            InputStream resource;
            block5: {
                resource = UIManager.getLookAndFeel().getClass().getResourceAsStream(fileName);
                if (resource != null) break block5;
                return null;
            }
            try {
                int n;
                BufferedInputStream in = new BufferedInputStream(resource);
                ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
                byte[] buffer = new byte[1024];
                while ((n = in.read(buffer)) > 0) {
                    out.write(buffer, 0, n);
                }
                in.close();
                out.flush();
                image = out.toByteArray();
                if (image != null && image.length != 0) break block6;
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return Toolkit.getDefaultToolkit().createImage(image);
    }

    public static boolean closeOnSuccess(SCDialogSupport dialogSupport, boolean success) {
        if (success && Platform.isMacOS()) {
            final JButton button = dialogSupport.getStandardButtonById(2);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    button.doClick();
                }
            });
            return false;
        }
        return success;
    }
}

