/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.util;

import com.sybase.asa.util.ServiceException;
import java.text.Collator;
import java.util.Vector;

public class Service
implements Comparable {
    public static final int DISPLAY_INDEX = 0;
    public static final int SERVICE_INDEX = 1;
    public static final int UNKNOWN_SERVICE = 0;
    public static final int SERVER_SERVICE = 2;
    public static final int CLIENT_SERVICE = 3;
    public static final int ENGINE_SERVICE = 4;
    public static final int REMOTE_SERVICE = 5;
    public static final int REP_SERVICE = 6;
    public static final int OPEN_SERVICE = 7;
    public static final int SAMPLE_SERVICE = 8;
    public static final int ML_SERVICE = 9;
    public static final int IQ_SERVICE = 10;
    public static final int DBMLSYNC_SERVICE = 11;
    public static final int AUTOMATIC = 2;
    public static final int MANUAL = 3;
    public static final int DISABLED = 4;
    public static final int STOPPED = 1;
    public static final int START_PENDING = 2;
    public static final int STOP_PENDING = 3;
    public static final int RUNNING = 4;
    public static final int CONTINUE_PENDING = 5;
    public static final int PAUSE_PENDING = 6;
    public static final int PAUSED = 7;
    public static final int ERROR_PATH_NOT_FOUND = 3;
    public static final int ERROR_SERVICE_NOT_ACTIVE = 1062;
    public static final int ERROR_SERVICE_DOES_NOT_EXIST = 1060;
    public static final int ERROR_INVALID_NAME = 123;
    public static final int ERROR_INVALID_HANDLE = 6;
    public static final int ERROR_INVALID_PARAMETER = 87;
    public static final int ERROR_INVALID_SERVICE_ACCOUNT = 1057;
    public static final int ERROR_CIRCULAR_DEPENDENCY = 1059;
    public static final int ERROR_SERVICE_EXISTS = 1073;
    public static final int ERROR_ACCESS_DENIED = 5;
    public static final int ERROR_SERVICE_DATABASE_LOCKED = 1055;
    public static final int ERROR_SERVICE_ALREADY_RUNNING = 1056;
    public static final int ERROR_INVALID_SERVICE_CONTROL = 1052;
    public static final int ERROR_SERVICE_DISABLED = 1058;
    public static final int ERROR_SERVICE_MARKED_FOR_DELETE = 1072;
    public static final int ERROR_SERVICE_LOGON_FAILED = 1069;
    public static final int ERROR_SERVICE_REQUEST_TIMEOUT = 1053;
    public static final int ERROR_SERVICE_DEPENDENCY_FAIL = 1068;
    public static final int ERROR_NO_SUCH_USER = 1317;
    public static final int ERROR_EXCEPTION_IN_SERVICE = 1064;
    public static final Collator COLLATOR = Collator.getInstance();
    private String _name;
    private int _startup;
    private int _type;
    private int _status;
    private String _path;
    private String _parameters;
    private boolean _interact;
    private String _account;
    private String _password;
    private String _group;
    private boolean _isDeletePending;
    private Vector _depGroups;
    private Vector _depServices;

    public Service() {
    }

    public Service(String string) {
        this._name = string;
    }

    public void setName(String string) {
        this._name = string;
    }

    public void setServiceType(int n) {
        this._type = n;
    }

    public void setServiceStartup(int n) {
        this._startup = n;
    }

    public void setStatus(int n) {
        this._status = n;
    }

    public void setPath(String string) {
        this._path = string;
    }

    public void setParameters(String string) {
        this._parameters = string;
    }

    public void setPassword(String string) {
        this._password = string;
    }

    public void setAccount(String string) {
        this._account = string;
    }

    public void setInteract(boolean bl) {
        this._interact = bl;
    }

    public void setLoadOrderGroup(String string) {
        this._group = string;
    }

    public void setDepGroups(Vector vector) {
        if (this._depGroups != null) {
            this._depGroups.removeAllElements();
        }
        this._depGroups = new Vector();
        this._depGroups = (Vector)vector.clone();
    }

    public void setDepServices(Vector vector) {
        if (this._depServices != null) {
            this._depServices.removeAllElements();
        }
        this._depServices = new Vector();
        this._depServices = (Vector)vector.clone();
    }

    public String getName() {
        return this._name;
    }

    public int getServiceStatus() {
        return this._status;
    }

    public int getServiceStartup() {
        return this._startup;
    }

    public int getServiceType() {
        return this._type;
    }

    public boolean isPauseSupported() {
        return this._type == 6;
    }

    public String getPath() {
        return this._path;
    }

    public String getParameters() {
        return this._parameters;
    }

    public boolean getInteract() {
        return this._interact;
    }

    public String getAccount() {
        return this._account;
    }

    public String getPassword() {
        return this._password;
    }

    public String getLoadOrderGroup() {
        return this._group;
    }

    public void setDeletePending(boolean bl) {
        this._isDeletePending = bl;
    }

    public boolean isDeletePending() {
        return this._isDeletePending;
    }

    public Vector getDepGroups() {
        return this._depGroups;
    }

    public Vector getDepServices() {
        return this._depServices;
    }

    public void getAllInfo() {
        Vector[] vectorArray = new Vector[2];
        this.setPath(this.getPath(this._name, this._type));
        this.setParameters(this.getParameters(this._name, this._type));
        this.setAccount(this.getAccount(this._name, this._type));
        this.setInteract(this.getInteract(this._name, this._type));
        vectorArray = this.getDependencies(this._name, this._type);
        this.setLoadOrderGroup(this.getLoadOrderGroup(this._name, this._type));
        this._depGroups = vectorArray[0];
        this._depServices = vectorArray[1];
    }

    public void setAllInfo() throws ServiceException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        String[] stringArray = new String[2];
        int n = 0;
        while (n < this._depServices.size()) {
            stringArray = (String[])this._depServices.elementAt(n);
            vector.addElement(stringArray[1]);
            ++n;
        }
        n = 0;
        while (n < this._depGroups.size()) {
            stringArray = (String[])this._depGroups.elementAt(n);
            vector2.addElement(stringArray[0]);
            ++n;
        }
        boolean bl = this.changeServiceConfig(this._name, this._type, this.getServiceStartup(), this.getPath(), this.getLoadOrderGroup(), vector, vector2, this.getAccount(), this.getPassword(), this.getInteract(), this.getParameters());
        if (!bl) {
            throw new ServiceException(-4);
        }
    }

    public void install() throws ServiceException {
        int n = this.installService(this._name, this._type, this.getServiceStartup(), this.getPath(), this.getParameters(), this.getInteract(), this.getAccount(), this.getPassword());
        if (n != 0) {
            throw new ServiceException(n);
        }
    }

    public void remove() throws ServiceException {
        int n = this.removeSAService(this._name, this._type);
        if (n != 0 && n != -1) {
            throw new ServiceException(n);
        }
        if (n == -1) {
            throw new ServiceException(-1);
        }
    }

    public int startService() {
        return this.startSAService(this._name, this._type);
    }

    public int pauseService() {
        return this.pauseSAService(this._name, this._type);
    }

    public int stopService() {
        int n = this.stopSAService(this._name, this._type);
        return n;
    }

    private native int removeSAService(String var1, int var2);

    private native int startSAService(String var1, int var2);

    private native int pauseSAService(String var1, int var2);

    private native int stopSAService(String var1, int var2);

    private native int installService(String var1, int var2, int var3, String var4, String var5, boolean var6, String var7, String var8);

    private native String getPath(String var1, int var2);

    private native String getParameters(String var1, int var2);

    private native String getAccount(String var1, int var2);

    private native boolean getInteract(String var1, int var2);

    private native Vector[] getDependencies(String var1, int var2);

    private native String getLoadOrderGroup(String var1, int var2);

    private native boolean changeServiceConfig(String var1, int var2, int var3, String var4, String var5, Vector var6, Vector var7, String var8, String var9, boolean var10, String var11);

    public int compareTo(Object object) {
        if (object == this) {
            return 0;
        }
        if (!(object instanceof Service)) {
            return -1;
        }
        return COLLATOR.compare(this._name, ((Service)object).getName());
    }
}

