/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.common.IntegerTextField;
import com.sybase.asa.logon.ASAConnectAssistant;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.ASADatabaseSource;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.EventQueuePumper;
import com.sybase.util.FileUtil;
import com.sybase.util.MRUComboBox;
import com.sybase.util.Platform;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EmptyStackException;
import java.util.Stack;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

class ASAAssistantModel {
    private static final String IGNORESQLCONNECT = "ignoresqlconnect=yes";
    private static final String IGNORECACHE = "ignorecache=yes";
    private static final int PING_TIMEOUT = 10000;
    private static final String LINKS = "LINKS";
    private static final String TCP = "TCPIP";
    private static final String SELECT_PROP_SQL = "SELECT PROPERTY( 'ServerName' ), PROPERTY( 'MachineName' ), PROPERTY( 'ProductName' ), PROPERTY( 'ProductVersion' ), DB_NAME()";
    private ASAConnectAssistant _view;
    private ASADatabaseSource _dbSrc;
    private ConnType _connType = null;
    private LogonResourcesBase _res;
    private ConnState _state = ConnState.START;
    private Stack<ConnStateInfo> _prevStates;
    private boolean _testConnDone;
    private boolean _handlingBack = false;
    private String _lastDBN;
    private Exception _lastEx = null;
    private boolean _haveBadLogin = false;
    private String _dbName = null;
    private String _srvName = null;
    private String _dbHost = null;
    private String _dbProd = null;
    private String _dbVer = null;
    private String _links = null;

    ASAAssistantModel(ASAConnectAssistant aSAConnectAssistant, ASADatabaseSource aSADatabaseSource, LogonResourcesBase logonResourcesBase) {
        this._view = aSAConnectAssistant;
        this._dbSrc = aSADatabaseSource;
        this._res = logonResourcesBase;
        this._prevStates = new Stack();
        this._testConnDone = false;
    }

    void resetModel() {
        this._prevStates.clear();
        this._connType = null;
        this.setStateStart();
    }

    void handleNext(Object object) {
        this._dbSrc.enableToggleButton(false);
        this.saveState();
        if (this._state == null) {
            this._lastEx = null;
            this.setStateConnError();
            this._dbSrc.enableToggleButton(true);
            return;
        }
        switch (this._state) {
            case START: {
                this.handleStartTransition();
                break;
            }
            case IS_RUNNING: {
                this.handleIsRunningTransition(object);
                break;
            }
            case CONN_LOCATION: {
                this.handleConnLocationTransition(object);
                break;
            }
            case CONN_METHOD: {
                this.handleConnMethodTransition();
                break;
            }
            case DB_CONN_LOCAL: {
                this.handleDBLocalTransition();
                break;
            }
            case DB_CONN_REMOTE: {
                this.handleDBRemoteTransition();
                break;
            }
            case DB_CONN_AUTO: {
                this.handleDBAutoTransition();
                break;
            }
            case TCP_INFO_LOCAL: {
                this.handleTCPLocalTransition();
                break;
            }
            case TCP_INFO_REMOTE: {
                this.handleTCPRemoteTransition();
                break;
            }
            case ENC_INFO_NEEDED: {
                this.handleEncryptionTransition();
                break;
            }
            case DB_FILE_NEEDED: {
                this.handleDBFileTransition();
                break;
            }
            default: {
                this._lastEx = null;
                this.setStateConnError();
            }
        }
        this._dbSrc.enableToggleButton(true);
    }

    void handleBack() {
        this._dbSrc.enableToggleButton(false);
        this._handlingBack = true;
        ConnStateInfo connStateInfo = null;
        try {
            connStateInfo = this._prevStates.pop();
        }
        catch (EmptyStackException emptyStackException) {
            this._handlingBack = false;
            this._dbSrc.enableToggleButton(true);
            return;
        }
        if (connStateInfo == null) {
            this._handlingBack = false;
            this._dbSrc.enableToggleButton(true);
            return;
        }
        this._dbSrc.setInitialConnectionInfo(connStateInfo._connInfo);
        this._dbSrc.setInitialValues();
        switch (connStateInfo._caState) {
            case START: {
                this.setStateStart();
                break;
            }
            case IS_RUNNING: {
                this.setStateIsRunning();
                break;
            }
            case CONN_LOCATION: {
                this.setStateConnLocation();
                break;
            }
            case CONN_METHOD: {
                this.setStateConnMethod();
                break;
            }
            case DB_CONN_LOCAL: {
                this.setStateDBLocal();
                break;
            }
            case DB_CONN_REMOTE: {
                this.setStateDBRemote();
                break;
            }
            case DB_CONN_AUTO: {
                this.setStateDBAuto();
                break;
            }
            case TCP_INFO_LOCAL: {
                this.setStateTCPLocal();
                break;
            }
            case TCP_INFO_REMOTE: {
                this.setStateTCPRemote();
                break;
            }
            case ENC_INFO_NEEDED: {
                this.setStateEncryption();
                break;
            }
            case DB_FILE_NEEDED: {
                this._lastDBN = connStateInfo._misc;
                this.setStateDBFile();
                break;
            }
            case CONN_SUCCESSFUL: {
                this.setStateConnSuccess();
                break;
            }
            case ERR_UNKNOWN: {
                this._lastEx = null;
                this.setStateConnError();
                break;
            }
        }
        this._handlingBack = false;
        this._dbSrc.enableToggleButton(true);
    }

    private void saveState() {
        ASAConnectionInfo aSAConnectionInfo = (ASAConnectionInfo)this._dbSrc.getConnectionInfo();
        ConnState connState = this._state;
        ConnStateInfo connStateInfo = connState == ConnState.DB_FILE_NEEDED ? new ConnStateInfo(aSAConnectionInfo, connState, this._lastDBN) : new ConnStateInfo(aSAConnectionInfo, connState);
        this._prevStates.push(connStateInfo);
    }

    private void showWarningMsg(String string) {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._view);
        SybOptionPane.showMessageDialog((Component)window, (Object)string, (String)this._res.get("CA_DIALOG_TITLE"), (int)2);
    }

    private void showInfoMsg(String string) {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._view);
        SybOptionPane.showMessageDialog((Component)window, (Object)string, (String)this._res.get("CA_DIALOG_TITLE"), (int)1);
    }

    private int testConnection(ASAConnectionInfo aSAConnectionInfo) {
        Integer n;
        block6: {
            n = null;
            this._testConnDone = false;
            EventQueuePumper.Condition condition = new EventQueuePumper.Condition(){

                public boolean keepGoing() {
                    return !ASAAssistantModel.this._testConnDone;
                }
            };
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                }
            };
            ConnTester connTester = new ConnTester(aSAConnectionInfo);
            connTester.execute();
            while (!this._testConnDone) {
                EventQueuePumper.pump((EventQueuePumper.Condition)condition);
                if (this._testConnDone) break;
                SwingUtilities.invokeLater(runnable);
                try {
                    this.wait(100L);
                }
                catch (Exception exception) {}
            }
            try {
                n = (Integer)connTester.get();
            }
            catch (Exception exception) {
                if (!(exception instanceof RuntimeException)) break block6;
                throw (RuntimeException)exception;
            }
        }
        if (n == null) {
            return -300;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportBadConnection(ASAConnectionInfo aSAConnectionInfo) {
        File file = null;
        String string = "";
        if (this._lastEx != null) {
            string = this._lastEx.getLocalizedMessage();
            this._lastEx = null;
        }
        if (aSAConnectionInfo == null) {
            this.showInfoMsg(this._res.get("CA_CONN_ERR_DETAILS_MSG") + "\n\n" + string);
            return;
        }
        try {
            file = FileUtil.createSecureTempFile((String)"connassist", null);
            aSAConnectionInfo.otherParms = aSAConnectionInfo.otherParms + ";LOG=" + file.getAbsolutePath();
        }
        catch (IOException iOException) {
            this.showInfoMsg(this._res.get("CA_CONN_ERR_DETAILS_MSG") + "\n\n" + string);
            return;
        }
        this.testConnection(aSAConnectionInfo);
        StringBuilder stringBuilder = new StringBuilder(256);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).isEmpty()) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string2);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._view);
        DetailsErrorDialog.showDialog((Component)window, (String)this._res.get("CA_DIALOG_TITLE"), (Icon)UIManager.getIcon("OptionPane.informationIcon"), (String)(this._res.get("CA_CONN_ERR_DETAILS_MSG") + "\n\n" + string), (String)stringBuilder.toString(), null);
    }

    boolean isLocalConn() {
        return ConnType.LOCAL == this._connType;
    }

    boolean inFinishedState() {
        return ConnState.CONN_SUCCESSFUL == this._state || ConnState.ERR_UNKNOWN == this._state;
    }

    boolean inStartState() {
        return ConnState.START == this._state;
    }

    private void handleStartTransition() {
        this._dbSrc.resetControls();
        this.setStateIsRunning();
    }

    private void handleIsRunningTransition(Object object) {
        boolean bl = object == ASAConnectAssistant.YES;
        this._dbSrc.setDSNEnabled(false);
        this._dbSrc.setAdvancedTableEnabled(false);
        if (bl) {
            this.setStateConnLocation();
        } else {
            this._connType = ConnType.AUTO;
            this.setStateConnMethod();
        }
    }

    private void handleConnLocationTransition(Object object) {
        boolean bl = object == ASAConnectAssistant.LOCAL;
        this._connType = bl ? ConnType.LOCAL : ConnType.REMOTE;
        this.setStateConnMethod();
    }

    private void handleConnMethodTransition() {
        if (!this._dbSrc.validateConnMethodFields()) {
            this._prevStates.pop();
            if (Platform.isWindows() && !Platform.isWindows9x()) {
                this.showWarningMsg(this._res.get("CA_CONN_WIN_REQ_INFO_NEEDED"));
            } else {
                this.showWarningMsg(this._res.get("CA_CONN_OTHER_REQ_INFO_NEEDED"));
            }
            JTextField jTextField = this._dbSrc.getUseridField();
            if (jTextField != null) {
                jTextField.requestFocus();
            }
            return;
        }
        switch (this._connType) {
            case LOCAL: {
                this.setStateDBLocal();
                break;
            }
            case REMOTE: {
                this.setStateDBRemote();
                break;
            }
            case AUTO: {
                this.setStateDBAuto();
                break;
            }
            default: {
                this._lastEx = null;
                this.setStateConnError();
            }
        }
    }

    private void handleDBLocalTransition() {
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        aSAConnectionInfo2.autoStart = false;
        aSAConnectionInfo2.otherParms = IGNORESQLCONNECT;
        aSAConnectionInfo2.generatedParms = "";
        int n = this.testConnection(aSAConnectionInfo2);
        if (n == -100) {
            aSAConnectionInfo2.autoStart = true;
            aSAConnectionInfo2.generatedParms = "LINKS=TCPIP(" + "LocalOnly" + "=yes)";
            aSAConnectionInfo2.otherParms = "ignorecache=yes;ignoresqlconnect=yes";
            n = this.testConnection(aSAConnectionInfo2);
            if (n == -100 || n == -832) {
                this.handleNoConnStringsWorked();
                return;
            }
        }
        this._links = aSAConnectionInfo2.generatedParms;
        if (n == 0) {
            aSAConnectionInfo2.otherParms = aSAConnectionInfo2.otherParms.startsWith(IGNORECACHE) ? IGNORECACHE : "";
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = "";
            aSAConnectionInfo2.autoStart = true;
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateDBLocal();
                }
            }
        }
    }

    private void handleDBRemoteTransition() {
        if (!this._dbSrc.validateServerNameField()) {
            this._prevStates.pop();
            this.showWarningMsg(this._res.get("CA_DB_REMOTE_REQ_INFO_NEEDED"));
            MRUComboBox mRUComboBox = this._dbSrc.getServerNameField();
            if (mRUComboBox != null) {
                mRUComboBox.requestFocus();
            }
            return;
        }
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        aSAConnectionInfo2.autoStart = false;
        aSAConnectionInfo2.otherParms = IGNORESQLCONNECT;
        aSAConnectionInfo2.generatedParms = "";
        int n = this.testConnection(aSAConnectionInfo2);
        if (n == -100) {
            aSAConnectionInfo2.autoStart = true;
            aSAConnectionInfo2.generatedParms = "LINKS=TCPIP";
            aSAConnectionInfo2.otherParms = "ignorecache=yes;ignoresqlconnect=yes";
            n = this.testConnection(aSAConnectionInfo2);
            if (n == -100) {
                this.handleNoConnStringsWorked();
                return;
            }
        }
        this._links = aSAConnectionInfo2.generatedParms;
        if (n == 0) {
            aSAConnectionInfo2.otherParms = aSAConnectionInfo2.otherParms.startsWith(IGNORECACHE) ? IGNORECACHE : "";
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = "";
            aSAConnectionInfo2.autoStart = true;
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateDBRemote();
                }
            }
        }
    }

    private void handleDBAutoTransition() {
        if (!this._dbSrc.validateDBFileField()) {
            this._prevStates.pop();
            this.showWarningMsg(this._res.get("CA_DB_AUTO_REQ_INFO_NEEDED"));
            MRUComboBox mRUComboBox = this._dbSrc.getDatabaseFileField();
            if (mRUComboBox != null) {
                mRUComboBox.requestFocus();
            }
            return;
        }
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        aSAConnectionInfo2.databaseFile = aSAConnectionInfo.databaseFile;
        aSAConnectionInfo2.databaseKey = aSAConnectionInfo.databaseKey;
        aSAConnectionInfo2.otherParms = IGNORESQLCONNECT;
        this._links = "";
        int n = this.testConnection(aSAConnectionInfo2);
        if (n == 0) {
            aSAConnectionInfo2.otherParms = "";
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -83: {
                    this.showInfoMsg(this._res.get("CA_DB_FILE_NOT_EXIST"));
                    this._prevStates.pop();
                    this.setStateDBAuto();
                    break;
                }
                case -84: {
                    this.showInfoMsg(this._res.get("CA_DB_FILE_CORRUPT_MSG"));
                    this._prevStates.pop();
                    this.setStateDBAuto();
                    break;
                }
                case -840: {
                    this.showInfoMsg(this._res.get("CA_AUTO_START_ENC_DB_MSG"));
                    this._prevStates.pop();
                    this.setStateDBAuto();
                    break;
                }
                case -1005: {
                    this.showInfoMsg(this._res.get("CA_AUTO_START_WRONG_VER_MSG"));
                    this._prevStates.pop();
                    this.setStateDBAuto();
                    break;
                }
                default: {
                    this.setStateConnError();
                }
            }
        }
    }

    private void handleTCPLocalTransition() {
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LINKS);
        stringBuilder.append("=");
        stringBuilder.append(TCP);
        stringBuilder.append("(");
        stringBuilder.append("Host");
        stringBuilder.append("=localhost");
        IntegerTextField integerTextField = this._dbSrc.getPortField();
        if (integerTextField.getText() != null && integerTextField.getText().length() > 0) {
            stringBuilder.append(";");
            stringBuilder.append("PORT");
            stringBuilder.append("=");
            stringBuilder.append(integerTextField.getText());
        }
        stringBuilder.append(";");
        stringBuilder.append("DOBROAD");
        stringBuilder.append("=direct)");
        aSAConnectionInfo2.generatedParms = stringBuilder.toString();
        aSAConnectionInfo2.otherParms = "ignorecache=yes;ignoresqlconnect=yes";
        int n = this.testConnection(aSAConnectionInfo2);
        if (n == -100) {
            this.handleNoConnStringsWorked();
            return;
        }
        this._links = aSAConnectionInfo2.generatedParms;
        if (n == 0) {
            aSAConnectionInfo2.otherParms = IGNORECACHE;
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = "";
            stringBuilder = new StringBuilder();
            stringBuilder.append("LINKS=tcpip(host=localhost");
            if (integerTextField.getText() != null && integerTextField.getText().length() > 0) {
                stringBuilder.append(";port=");
                stringBuilder.append(integerTextField.getText());
            }
            stringBuilder.append(")");
            aSAConnectionInfo2.generatedParms = stringBuilder.toString();
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateTCPLocal();
                }
            }
        }
    }

    private void handleTCPRemoteTransition() {
        String string;
        if (!this._dbSrc.validateHostField()) {
            this._prevStates.pop();
            this.showWarningMsg(this._res.get("CA_TCP_REMOTE_REQ_INFO_NEEDED"));
            JTextField jTextField = this._dbSrc.getHostField();
            if (jTextField != null) {
                jTextField.requestFocus();
            }
            return;
        }
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this._dbSrc.getHostField().getText();
        String string3 = this._dbSrc.getPortField().getText(false);
        String string4 = null;
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(this._dbSrc.getNetOtherField().getText());
        while (connectionStringTokenizer.hasMoreTokens()) {
            String string5 = connectionStringTokenizer.nextToken();
            int n = string5.indexOf("=");
            String string6 = n != -1 ? string5.substring(0, n) : "";
            if (!"CPORT".equalsIgnoreCase(string6)) {
                if (!"ClientPort".equalsIgnoreCase(string6)) continue;
            }
            string4 = string5;
            break;
        }
        stringBuilder.append(LINKS);
        stringBuilder.append("=");
        stringBuilder.append(TCP);
        stringBuilder.append("(");
        stringBuilder.append("Host");
        stringBuilder.append("=");
        stringBuilder.append(string2);
        if (string4 != null && string4.length() > 0 || string3 != null && string3.length() > 0) {
            if (string3 != null && string3.length() > 0) {
                stringBuilder.append(";");
                stringBuilder.append("PORT");
                stringBuilder.append("=");
                stringBuilder.append(string3);
            }
            if (string4 != null && string4.length() > 0) {
                stringBuilder.append(";");
                stringBuilder.append(string4);
            }
            string = stringBuilder.toString();
            stringBuilder.append(";");
            stringBuilder.append("DOBROAD");
            stringBuilder.append("=none)");
        } else {
            string = stringBuilder.toString();
            stringBuilder.append(";");
            stringBuilder.append("DOBROAD");
            stringBuilder.append("=direct)");
        }
        aSAConnectionInfo2.generatedParms = stringBuilder.toString();
        aSAConnectionInfo2.otherParms = "ignorecache=yes;ignoresqlconnect=yes";
        int n = this.testConnection(aSAConnectionInfo2);
        if (n == -100) {
            this.handleNoConnStringsWorked();
            return;
        }
        this._links = aSAConnectionInfo2.generatedParms;
        if (n == 0) {
            aSAConnectionInfo2.otherParms = IGNORECACHE;
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = "";
            aSAConnectionInfo2.generatedParms = string + ")";
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateTCPRemote();
                }
            }
        }
    }

    private void handleEncryptionTransition() {
        int n;
        if (!this._dbSrc.validateEncComboBox()) {
            this._prevStates.pop();
            this.showWarningMsg(this._res.get("CA_ENC_REQ_INFO_NEEDED"));
            SybComboBox sybComboBox = this._dbSrc.getEncTypeCombo();
            if (sybComboBox != null) {
                sybComboBox.requestFocus();
            }
            return;
        }
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        String string = this._dbSrc.getEncString();
        aSAConnectionInfo2.otherParms = string != null && string.length() > 0 ? string + ";" + IGNORECACHE + ";" + IGNORESQLCONNECT : "ignorecache=yes;ignoresqlconnect=yes";
        if (this._links != null && this._links.length() > 0) {
            aSAConnectionInfo2.generatedParms = this._links;
        }
        if ((n = this.testConnection(aSAConnectionInfo2)) == -100) {
            this.setStateConnError();
            return;
        }
        if (n == 0) {
            aSAConnectionInfo2.otherParms = string != null && string.length() > 0 ? string + ";" + IGNORECACHE : IGNORECACHE;
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = string != null && string.length() > 0 ? string : "";
            if (this._links != null && this._links.length() > 0) {
                int n2 = this._links.indexOf("DOBROAD");
                int n3 = -1;
                if (n2 != -1) {
                    n3 = this._links.indexOf(";", n2);
                    n3 = n3 == -1 ? this._links.indexOf(")", n2) : ++n3;
                }
                aSAConnectionInfo2.generatedParms = n2 != -1 && n3 != -1 ? this._links.substring(0, n2) + this._links.substring(n3) : this._links;
            }
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.showInfoMsg(this._res.get("CA_INFO_ENC_INCORRECT"));
                    this._prevStates.pop();
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateEncryption();
                }
            }
        }
    }

    private void handleDBFileTransition() {
        int n;
        ASAConnectionInfo aSAConnectionInfo = this._prevStates.peek()._connInfo;
        ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo();
        aSAConnectionInfo2.setClassLoader(this._dbSrc.getClassLoader());
        aSAConnectionInfo2.userid = aSAConnectionInfo.userid;
        aSAConnectionInfo2.password = aSAConnectionInfo.password;
        aSAConnectionInfo2.serverName = aSAConnectionInfo.serverName;
        aSAConnectionInfo2.databaseName = aSAConnectionInfo.databaseName;
        aSAConnectionInfo2.databaseFile = aSAConnectionInfo.databaseFile;
        aSAConnectionInfo2.otherParms = "ignorecache=yes;ignoresqlconnect=yes";
        if (this._links != null && this._links.length() > 0) {
            aSAConnectionInfo2.generatedParms = this._links;
        }
        if ((n = this.testConnection(aSAConnectionInfo2)) == -100) {
            this.setStateConnError();
            return;
        }
        if (n == 0) {
            aSAConnectionInfo2.otherParms = IGNORECACHE;
            n = this.testConnection(aSAConnectionInfo2);
            if (n != 0) {
                this.showInfoMsg(this._res.get("CA_INFO_SQLCONNECT_SET"));
            }
            aSAConnectionInfo2.otherParms = "";
            if (this._links != null && this._links.length() > 0) {
                int n2 = this._links.indexOf("DOBROAD");
                int n3 = -1;
                if (n2 != -1) {
                    n3 = this._links.indexOf(";", n2);
                    n3 = n3 == -1 ? this._links.indexOf(")", n2) : ++n3;
                }
                aSAConnectionInfo2.generatedParms = n2 != -1 && n3 != -1 ? this._links.substring(0, n2) + this._links.substring(n3) : this._links;
            }
            this._dbSrc.setInitialConnectionInfo(aSAConnectionInfo2);
            this._dbSrc.setInitialValues();
            this.setStateConnSuccess();
        } else {
            switch (n) {
                case -103: {
                    this.setStateInvalidLogon();
                    break;
                }
                case -1145: 
                case -829: {
                    this.setStateEncryption();
                    break;
                }
                case -83: {
                    if (this._dbSrc.validateDBFileField()) {
                        this.showInfoMsg(this._res.get("CA_DB_FILE_NOT_EXIST"));
                    }
                    this._prevStates.pop();
                    this.setStateDBFile();
                    break;
                }
                case -84: {
                    this.showInfoMsg(this._res.get("CA_DB_FILE_CORRUPT_MSG"));
                    this._prevStates.pop();
                    this.setStateDBFile();
                    break;
                }
                default: {
                    this.reportBadConnection(aSAConnectionInfo2);
                    this._prevStates.pop();
                    this.setStateDBFile();
                }
            }
        }
    }

    private void setStateStart() {
        this._state = ConnState.START;
        this._view.setBackEnabled(false);
        this._view.setNextEnabled(true);
        this._view.setState(this._state);
    }

    private void setStateIsRunning() {
        this._state = ConnState.IS_RUNNING;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
    }

    boolean isAutoStarting() {
        return this._connType != null && this._connType == ConnType.AUTO;
    }

    boolean isRemote() {
        return this._connType != null && this._connType == ConnType.REMOTE;
    }

    private void setStateConnLocation() {
        this._state = ConnState.CONN_LOCATION;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
    }

    private void setStateConnMethod() {
        this._state = ConnState.CONN_METHOD;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(0);
        JTextField jTextField = this._dbSrc.getUseridField();
        if (jTextField != null) {
            jTextField.requestFocus();
        }
    }

    private void setStateDBLocal() {
        this._state = ConnState.DB_CONN_LOCAL;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(1);
        MRUComboBox mRUComboBox = this._dbSrc.getServerNameField();
        if (mRUComboBox != null) {
            mRUComboBox.requestFocus();
        }
    }

    private void setStateDBRemote() {
        this._state = ConnState.DB_CONN_REMOTE;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(1);
        MRUComboBox mRUComboBox = this._dbSrc.getServerNameField();
        if (mRUComboBox != null) {
            mRUComboBox.requestFocus();
        }
    }

    private void setStateDBAuto() {
        this._state = ConnState.DB_CONN_AUTO;
        this._view.setState(this._state);
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(1);
        MRUComboBox mRUComboBox = this._dbSrc.getDatabaseFileField();
        if (mRUComboBox != null) {
            mRUComboBox.requestFocus();
        }
    }

    private void setStateTCPLocal() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(2);
        this._dbSrc.selectTCPCheck();
        if (this._dbSrc.getPortField() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ASAAssistantModel.this._dbSrc.getPortField().requestFocusInWindow();
                }
            });
        }
        this._state = ConnState.TCP_INFO_LOCAL;
        this._view.setState(this._state);
    }

    private void setStateTCPRemote() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(2);
        this._dbSrc.selectTCPCheck();
        if (this._dbSrc.getHostField() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ASAAssistantModel.this._dbSrc.getHostField().requestFocusInWindow();
                }
            });
        }
        this._state = ConnState.TCP_INFO_REMOTE;
        this._view.setState(this._state);
    }

    private void setStateEncryption() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        this._dbSrc.selectTab(2);
        SybComboBox sybComboBox = this._dbSrc.getEncTypeCombo();
        if (sybComboBox != null) {
            sybComboBox.requestFocus();
        }
        this._state = ConnState.ENC_INFO_NEEDED;
        this._view.setState(this._state);
    }

    String getLastDBN() {
        return this._lastDBN;
    }

    private void setStateDBFile() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._haveBadLogin = false;
        MRUComboBox mRUComboBox = this._dbSrc.getDatabaseNameField();
        this._dbSrc.selectTab(1);
        if (mRUComboBox != null) {
            if (!this._handlingBack) {
                this._lastDBN = mRUComboBox.getStringValue();
            }
            mRUComboBox.requestFocus();
        }
        if (this._lastDBN == null) {
            this._lastDBN = "";
        }
        this._state = ConnState.DB_FILE_NEEDED;
        this._view.setState(this._state);
    }

    private void setStateConnSuccess() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(false);
        this._dbSrc.setNextDefault(false);
        this._dbSrc.setDSNEnabled(true);
        this._dbSrc.setAdvancedTableEnabled(true);
        this._haveBadLogin = false;
        if (this._dbName == null) {
            this._dbName = "";
        }
        if (this._srvName == null) {
            this._srvName = "";
        }
        if (this._dbHost == null) {
            this._dbHost = "";
        }
        if (this._dbProd == null) {
            this._dbProd = "";
        }
        if (this._dbVer == null) {
            this._dbVer = "";
        }
        this._state = ConnState.CONN_SUCCESSFUL;
        this._view.setState(this._state);
    }

    String getConnectionSuccessfulMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_BEGIN"));
        stringBuilder.append("<br><table border=0 cellpadding=0>");
        if (!this._dbName.isEmpty()) {
            stringBuilder.append("<tr><td><b>");
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_DATABASE"));
            stringBuilder.append("</b></td><td width=5px></td><td>");
            stringBuilder.append(this._dbName);
            stringBuilder.append("</td></tr>");
        }
        if (!this._srvName.isEmpty()) {
            stringBuilder.append("<tr><td><b>");
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_SERVER"));
            stringBuilder.append("</b></td><td width=5px></td><td>");
            stringBuilder.append(this._srvName);
            stringBuilder.append("</td></tr>");
        }
        if (!this._dbProd.isEmpty()) {
            stringBuilder.append("<tr><td><b>");
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_PRODUCT"));
            stringBuilder.append("</b></td><td width=5px></td><td>");
            stringBuilder.append(this._dbProd);
            if (!this._dbVer.isEmpty()) {
                stringBuilder.append(' ');
                stringBuilder.append(this._dbVer);
            }
            stringBuilder.append("</td></tr>");
        }
        if (!this._dbHost.isEmpty()) {
            stringBuilder.append("<tr><td><b>");
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_HOST"));
            stringBuilder.append("</b></td><td width=5px></td><td>");
            stringBuilder.append(this._dbHost);
            stringBuilder.append("</td></tr>");
        }
        stringBuilder.append("</table><br>");
        if (Platform.isWindows()) {
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_END_WIN"));
        } else {
            stringBuilder.append(this._res.get("CA_CONN_SUCCESSFUL_MSG_END_OTHER"));
        }
        return stringBuilder.toString();
    }

    private void setStateConnError() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(false);
        this._dbSrc.setNextDefault(false);
        this._haveBadLogin = false;
        this._state = ConnState.ERR_UNKNOWN;
        this._view.setState(this._state);
    }

    String getConnectionErrorMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._lastEx != null) {
            stringBuilder.append(this._res.getFormatted("CA_ERR_UNKNOWN_HEADER", this._lastEx.getLocalizedMessage()));
        } else {
            stringBuilder.append(this._res.get("CA_ERR_UNKNOWN_HEADER_NO_EXPLANATION"));
        }
        switch (this._connType) {
            case LOCAL: {
                stringBuilder.append(this._res.get("CA_ERR_UNKNOWN_LOCAL_MSG"));
                break;
            }
            case REMOTE: {
                stringBuilder.append(this._res.get("CA_ERR_UNKNOWN_REMOTE_MSG"));
                break;
            }
            case AUTO: {
                stringBuilder.append(this._res.get("CA_ERR_UNKNOWN_MSG"));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled connection type");
            }
        }
        return stringBuilder.toString();
    }

    private void setStateInvalidLogon() {
        this._view.setBackEnabled(true);
        this._view.setNextEnabled(true);
        this._dbSrc.setNextDefault(true);
        this._dbSrc.selectTab(0);
        if (this._haveBadLogin) {
            this._prevStates.pop();
        }
        this._haveBadLogin = true;
        JTextField jTextField = this._dbSrc.getUseridField();
        if (jTextField != null) {
            jTextField.requestFocus();
        }
        this._view.setState(ConnState.INVALID_UID_PWD);
    }

    private void handleNoConnStringsWorked() {
        Object object;
        Object object2;
        if (this._state == ConnState.DB_CONN_LOCAL && !this._dbSrc.validateServerNameField()) {
            this._prevStates.pop();
            this.showInfoMsg(this._res.get("CA_INFO_ENTER_SERVER"));
            this.setStateDBLocal();
            return;
        }
        if (this._state == ConnState.DB_CONN_LOCAL) {
            this.setStateTCPLocal();
            return;
        }
        if (this._state == ConnState.DB_CONN_REMOTE) {
            this.setStateTCPRemote();
            return;
        }
        if (this._state == ConnState.TCP_INFO_REMOTE) {
            object2 = this._dbSrc.getHostField();
            object = ((JTextComponent)object2).getText();
            if (object == null || ((String)object).length() < 1) {
                this._prevStates.pop();
                this.showInfoMsg(this._res.get("CA_INFO_NO_HOST_FOUND"));
                this.setStateTCPRemote();
                return;
            }
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                boolean bl = inetAddress.isReachable(10000);
                if (!bl) {
                    this._prevStates.pop();
                    this.showInfoMsg(this._res.get("CA_INFO_NO_HOST_FOUND"));
                    this.setStateTCPRemote();
                    return;
                }
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                this._prevStates.pop();
                this.showInfoMsg(this._res.get("CA_INFO_NO_HOST_FOUND"));
                this.setStateTCPRemote();
                return;
            }
        }
        if (this._state == ConnState.TCP_INFO_LOCAL || this._state == ConnState.TCP_INFO_REMOTE) {
            JTextField jTextField;
            object2 = (ASAConnectionInfo)this._dbSrc.getConnectionInfo();
            object = new ASAConnectionInfo();
            ((AbstractConnectionInfo)object).setClassLoader(this._dbSrc.getClassLoader());
            ((ASAConnectionInfo)object).userid = ((ASAConnectionInfo)object2).userid;
            ((ASAConnectionInfo)object).password = ((ASAConnectionInfo)object2).password;
            ((ASAConnectionInfo)object).serverName = ((ASAConnectionInfo)object2).serverName;
            ((ASAConnectionInfo)object).databaseName = ((ASAConnectionInfo)object2).databaseName;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(LINKS);
            stringBuilder.append("=");
            stringBuilder.append(TCP);
            stringBuilder.append("(");
            stringBuilder.append("Host");
            stringBuilder.append("=");
            if (this._state == ConnState.TCP_INFO_LOCAL) {
                stringBuilder.append("localhost;");
            } else {
                jTextField = this._dbSrc.getHostField();
                stringBuilder.append(jTextField.getText());
                stringBuilder.append(";");
            }
            jTextField = this._dbSrc.getPortField();
            if (jTextField.getText() != null && jTextField.getText().length() > 0) {
                stringBuilder.append("PORT");
                stringBuilder.append("=");
                stringBuilder.append(jTextField.getText());
                stringBuilder.append(";");
            }
            jTextField = this._dbSrc.getNetOtherField();
            ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(jTextField.getText());
            while (connectionStringTokenizer.hasMoreTokens()) {
                String string = connectionStringTokenizer.nextToken();
                int n = string.indexOf("=");
                String string2 = n != -1 ? string.substring(0, n) : "";
                if (!"CPORT".equalsIgnoreCase(string2)) {
                    if (!"ClientPort".equalsIgnoreCase(string2)) continue;
                }
                stringBuilder.append(string);
                break;
            }
            stringBuilder.append(";");
            stringBuilder.append("VERIFY");
            stringBuilder.append("=no;");
            stringBuilder.append("DOBROAD");
            stringBuilder.append("=none)");
            ((ASAConnectionInfo)object).generatedParms = stringBuilder.toString();
            ((ASAConnectionInfo)object).otherParms = "ignorecache=yes;ignoresqlconnect=yes";
            int n = this.testConnection((ASAConnectionInfo)object);
            if (n == 0 || n == -83 || n == -1145 || n == -103 || n == -140 || n == -205 || n == -206 || n == -245 || n == -246 || n == -102 || n == -816 || n == -82 || n == -77 || n == -75 || n == -76 || n == -840 || n == -1074 || n == -1003) {
                this._prevStates.pop();
                if (this._state == ConnState.TCP_INFO_LOCAL) {
                    this.setStateTCPLocal();
                } else {
                    this.setStateTCPRemote();
                }
                this._dbSrc.selectTab(1);
                MRUComboBox mRUComboBox = this._dbSrc.getServerNameField();
                if (mRUComboBox != null) {
                    mRUComboBox.requestFocus();
                }
                this.showInfoMsg(this._res.get("CA_INFO_SERVER_NAME_WRONG"));
                return;
            }
        }
        this.setStateConnError();
    }

    class ConnTester
    extends SwingWorker<Integer, Void> {
        private ASAConnectionInfo _info;

        ConnTester(ASAConnectionInfo aSAConnectionInfo) {
            this._info = aSAConnectionInfo;
            ASAAssistantModel.this._view.setBackEnabled(false);
            ASAAssistantModel.this._view.setNextEnabled(false);
            ASAAssistantModel.this._view.setBarVisible(true);
            ASAAssistantModel.this._dbSrc.enableSourceComboBox(false);
            ASAAssistantModel.this._dbSrc.setCursorBusy();
        }

        @Override
        public Integer doInBackground() {
            Connection connection = null;
            int n = 0;
            try {
                connection = JDBCDrivers.connect(this._info);
                if (connection != null) {
                    n = 0;
                    try {
                        Statement statement = connection.createStatement();
                        ResultSet resultSet = statement.executeQuery(ASAAssistantModel.SELECT_PROP_SQL);
                        boolean bl = resultSet.next();
                        if (bl) {
                            ASAAssistantModel.this._srvName = resultSet.getString(1);
                            ASAAssistantModel.this._dbHost = resultSet.getString(2);
                            ASAAssistantModel.this._dbProd = resultSet.getString(3);
                            ASAAssistantModel.this._dbVer = resultSet.getString(4);
                            ASAAssistantModel.this._dbName = resultSet.getString(5);
                        } else {
                            ASAAssistantModel.this._srvName = "";
                            ASAAssistantModel.this._dbHost = "";
                            ASAAssistantModel.this._dbProd = "";
                            ASAAssistantModel.this._dbVer = "";
                            ASAAssistantModel.this._dbName = "";
                        }
                        resultSet.close();
                        connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            catch (SQLException sQLException) {
                ASAAssistantModel.this._lastEx = sQLException;
                n = sQLException.getErrorCode();
            }
            catch (ClassNotFoundException classNotFoundException) {
                ASAAssistantModel.this._lastEx = classNotFoundException;
                n = -810;
            }
            return n;
        }

        @Override
        protected void done() {
            ASAAssistantModel.this._view.setBarVisible(false);
            ASAAssistantModel.this._dbSrc.enableSourceComboBox(true);
            ASAAssistantModel.this._dbSrc.setCursorNormal();
            ASAAssistantModel.this._testConnDone = true;
        }
    }

    static class ConnStateInfo {
        ASAConnectionInfo _connInfo;
        ConnState _caState;
        String _misc;

        ConnStateInfo(ASAConnectionInfo aSAConnectionInfo, ConnState connState) {
            this._connInfo = aSAConnectionInfo;
            this._caState = connState;
            this._misc = null;
        }

        ConnStateInfo(ASAConnectionInfo aSAConnectionInfo, ConnState connState, String string) {
            this._connInfo = aSAConnectionInfo;
            this._caState = connState;
            this._misc = string;
        }
    }

    static enum ConnState {
        START,
        IS_RUNNING,
        CONN_LOCATION,
        CONN_METHOD,
        DB_CONN_LOCAL,
        DB_CONN_REMOTE,
        DB_CONN_AUTO,
        TCP_INFO_LOCAL,
        TCP_INFO_REMOTE,
        ENC_INFO_NEEDED,
        DB_FILE_NEEDED,
        CONN_SUCCESSFUL,
        ERR_UNKNOWN,
        INVALID_UID_PWD;

    }

    static enum ConnType {
        LOCAL,
        REMOTE,
        AUTO;

    }
}

