/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.CmdSeqException;
import com.sybase.asa.logon.CommException;
import com.sybase.asa.logon.EngineStartException;
import com.sybase.util.Platform;
import com.sybase.util.win32.Registry;
import java.io.File;
import java.util.Vector;

public class ASAConnect {
    private static boolean _loadDBLIB = true;
    private static boolean _installed = false;
    private static String _DBLibName = "dblib11";
    private static File _file = null;

    public static void disableDBLIBLoading() {
        _loadDBLIB = false;
    }

    public static void install() {
        File file;
        if (_installed) {
            return;
        }
        if (!_loadDBLIB) {
            _installed = true;
            return;
        }
        String string = System.getProperty("asa.dblib_directory");
        if (!(string == null || (file = new File(string)).exists() && file.isDirectory())) {
            string = null;
        }
        if (string == null) {
            string = ASAConnect.guessDBLibDirectory();
        }
        try {
            String string2 = ASAConnect.getLibraryName();
            if (string == null) {
                System.loadLibrary(string2);
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                if (!string.endsWith(File.separator)) {
                    stringBuffer.append(File.separator);
                }
                stringBuffer.append(System.mapLibraryName(string2));
                System.load(stringBuffer.toString());
            }
            _installed = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            _installed = false;
            throw unsatisfiedLinkError;
        }
    }

    static String guessDBLibDirectory() {
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (Platform.isWindows()) {
            File file;
            String string2 = System.getProperty("asa.location");
            if (string2 == null && Registry.isInstalled()) {
                string2 = Registry.getValue((int)0, (String)"SOFTWARE\\Sybase\\SQL Anywhere\\11.0", (String)"Location");
            }
            if (string2 != null && string2.length() != 0 && (file = new File(string2)).exists() && file.isDirectory()) {
                stringBuffer.append(string2);
                if (!string2.endsWith(File.separator)) {
                    stringBuffer.append(File.separator);
                }
                if (Platform.is64BitWindows()) {
                    stringBuffer.append("bin64\\");
                } else {
                    stringBuffer.append("bin32\\");
                }
                file = new File(stringBuffer.toString());
                if (!file.exists() || !file.isDirectory()) {
                    stringBuffer = null;
                }
            }
        }
        string = stringBuffer == null || stringBuffer.length() == 0 ? null : stringBuffer.toString();
        return string;
    }

    private static String getLibraryName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (Platform.isWindows()) {
            stringBuffer.append(_DBLibName);
        } else {
            stringBuffer.append(_DBLibName);
            stringBuffer.append("_r");
        }
        return stringBuffer.toString();
    }

    public static boolean isInstalled() {
        if (!_installed) {
            ASAConnect.install();
        }
        return _installed;
    }

    public static native boolean findServers(Vector var0, Vector var1, Vector var2);

    public static native boolean shutdownEngine(String var0);

    public static native boolean stopDatabase(String var0);

    public static native boolean startEngine(String var0, String var1, boolean[] var2) throws CommException, CmdSeqException, EngineStartException;

    public static native String getCanonicalConnectionString(String var0);

    static native String getProperty(int var0);

    private static boolean dbgEnabled() {
        return false;
    }
}

