/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ASAAssistantModel;
import com.sybase.asa.logon.ASADatabaseSource;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.SybTitledPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

class ASAConnectAssistant
extends JPanel
implements ActionListener {
    static final Object YES = 1;
    static final Object NO = 2;
    static final Object LOCAL = 3;
    static final Object REMOTE = 4;
    private LogonResourcesBase _res = LogonResourcesBase.getBundle();
    private ASAAssistantModel _model;
    private SybTitledPanel _panel;
    private JPanel _contentPane;
    private CardLayout _cardLayout;
    private JPanel _cardPanel;
    private BaseCard[] _cards;
    private Color _background;
    private SybButton _back;
    private SybButton _next;
    private static final String NO_PROGRESS_BAR = "0";
    private static final String PROGRESS_BAR = "1";
    private JProgressBar _bar;
    private JPanel _progressBarPanel;
    private CardLayout _progressBarPanelLayout;

    ASAConnectAssistant(ASADatabaseSource aSADatabaseSource) {
        this._model = new ASAAssistantModel(this, aSADatabaseSource, this._res);
        this.createUI();
    }

    private void createUI() {
        this._background = this.calculateBackgroundColor(10);
        this._contentPane = new JPanel();
        this._contentPane.setLayout(new GridBagLayout());
        this._cardLayout = new CardLayout();
        this._cardPanel = new JPanel(this._cardLayout);
        this._cards = new BaseCard[]{new WelcomeCard(), new IsRunningCard(), new ConnLocationCard(), new ConnMethodCard(), new DBConnLocalCard(), new DBConnRemoteCard(), new DBConnAutoCard(), new TCPInfoLocalCard(), new TCPInfoRemoteCard(), new EncInfoNeededCard(), new DBFileNeededCard(), new ConnSuccessfulCard(), new ErrUnknownCard(), new InvalidUserIDPasswordCard()};
        for (int i = 0; i < this._cards.length; ++i) {
            this._cardPanel.add((Component)this._cards[i], this._cards[i].getID());
        }
        this._contentPane.add((Component)this._cardPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._bar = new JProgressBar();
        this._bar.setIndeterminate(true);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this._background);
        this._progressBarPanelLayout = new CardLayout();
        this._progressBarPanel = new JPanel(this._progressBarPanelLayout);
        this._progressBarPanel.add((Component)jPanel, NO_PROGRESS_BAR);
        this._progressBarPanel.add((Component)this._bar, PROGRESS_BAR);
        this._contentPane.add((Component)this._progressBarPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 20, 2, new Insets(10, 20, 10, 20), 0, 0));
        this._back = new SybButton(this._res.get("Back"));
        this._next = new SybButton(this._res.get("Next"));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._back, this._next});
        this._next.addActionListener((ActionListener)this);
        this._back.addActionListener((ActionListener)this);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBackground(this._background);
        jPanel2.add((Component)this._back);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add((Component)this._next);
        this._contentPane.add((Component)jPanel2, new GridBagConstraints(0, 99, 1, 1, 1.0, 0.0, 20, 2, new Insets(10, 0, 0, 0), 0, 0));
        Color color = this.calculateBackgroundColor(3);
        this._contentPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, color), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this._contentPane.setBackground(this._background);
        this._panel = new SybTitledPanel((JComponent)this._contentPane, this._res.get("CA_DIALOG_TITLE"));
        this.setLayout(new BorderLayout());
        this.add((Component)this._panel, "Center");
    }

    private Color calculateBackgroundColor(int n) {
        int n2 = SystemColor.window.getRGB();
        int n3 = (n2 & 0xFF0000) >>> 16;
        int n4 = (n2 & 0xFF00) >>> 8;
        int n5 = n2 & 0xFF;
        n2 = SystemColor.textHighlight.getRGB();
        int n6 = (n2 & 0xFF0000) >>> 16;
        int n7 = (n2 & 0xFF00) >>> 8;
        int n8 = n2 & 0xFF;
        int n9 = (n6 - n3) / n;
        n3 = n9 > 0 ? Math.min(255, n3 + n9) : Math.max(0, n3 + n9);
        n9 = (n7 - n4) / n;
        n4 = n9 > 0 ? Math.min(255, n4 + n9) : Math.max(0, n4 + n9);
        n9 = (n8 - n5) / n;
        n5 = n9 > 0 ? Math.min(255, n5 + n9) : Math.max(0, n5 + n9);
        Color color = new Color(n3, n4, n5);
        return color;
    }

    SybTitledPanel getTitledPanel() {
        return this._panel;
    }

    void resetAssistant() {
        this._model.resetModel();
    }

    void showAssistant() {
        this.setVisible(true);
    }

    void hideAssistant() {
        this.setVisible(false);
    }

    SybButton getNextButton() {
        return this._next;
    }

    void setState(ASAAssistantModel.ConnState connState) {
        String string = connState.toString();
        this._cardLayout.show(this._cardPanel, string);
        for (int i = 0; i < this._cards.length; ++i) {
            if (!this._cards[i].getID().equals(string)) continue;
            this._cards[i].initializeComponents();
            break;
        }
    }

    private BaseCard getSelectedCard() {
        BaseCard baseCard = null;
        for (int i = 0; i < this._cards.length; ++i) {
            if (!this._cards[i].isVisible()) continue;
            baseCard = this._cards[i];
            break;
        }
        return baseCard;
    }

    void setNextEnabled(boolean bl) {
        this._next.setEnabled(bl);
    }

    void setBackEnabled(boolean bl) {
        this._back.setEnabled(bl);
    }

    void setBarVisible(boolean bl) {
        if (bl) {
            this._progressBarPanelLayout.show(this._progressBarPanel, PROGRESS_BAR);
        } else {
            this._progressBarPanelLayout.show(this._progressBarPanel, NO_PROGRESS_BAR);
        }
    }

    boolean isLocalConn() {
        return this._model.isLocalConn();
    }

    boolean isAssistantDone() {
        return this._model.inFinishedState();
    }

    boolean isAssistantStarted() {
        return !this._model.inStartState();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        Object object2 = null;
        BaseCard baseCard = this.getSelectedCard();
        object2 = baseCard.getValue();
        object = actionEvent.getSource();
        if (object == this._next) {
            this._model.handleNext(object2);
        } else if (object == this._back) {
            this._model.handleBack();
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    class InvalidUserIDPasswordCard
    extends BaseCard {
        InvalidUserIDPasswordCard() {
            super(ASAAssistantModel.ConnState.INVALID_UID_PWD, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_INVALID_UID_PWD_MSG"));
        }
    }

    class ErrUnknownCard
    extends BaseCard {
        ErrUnknownCard() {
            super(ASAAssistantModel.ConnState.ERR_UNKNOWN, 1);
        }

        @Override
        void initializeComponents() {
            this._html.setText(ASAConnectAssistant.this._model.getConnectionErrorMessage());
        }
    }

    class ConnSuccessfulCard
    extends BaseCard {
        ConnSuccessfulCard() {
            super(ASAAssistantModel.ConnState.CONN_SUCCESSFUL, 1);
        }

        @Override
        void initializeComponents() {
            this._html.setText(ASAConnectAssistant.this._model.getConnectionSuccessfulMessage());
            this._html.invalidate();
        }
    }

    class DBFileNeededCard
    extends BaseCard {
        DBFileNeededCard() {
            super(ASAAssistantModel.ConnState.DB_FILE_NEEDED, 1);
        }

        @Override
        void initializeComponents() {
            String string;
            String string2 = ASAConnectAssistant.this._model.getLastDBN();
            if (ASAConnectAssistant.this._model.isRemote()) {
                LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
                ASAConnectAssistant.this._res;
                string = logonResourcesBase.getFormatted("CA_DB_FILE_NEEDED_REMOTE_MSG", string2);
            } else {
                LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
                ASAConnectAssistant.this._res;
                string = logonResourcesBase.getFormatted("CA_DB_FILE_NEEDED_LOCAL_MSG", string2);
            }
            this._html.setText(string);
        }
    }

    class EncInfoNeededCard
    extends BaseCard {
        EncInfoNeededCard() {
            super(ASAAssistantModel.ConnState.ENC_INFO_NEEDED, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_ENC_INFO_NEEDED_MSG"));
        }
    }

    class TCPInfoRemoteCard
    extends BaseCard {
        TCPInfoRemoteCard() {
            super(ASAAssistantModel.ConnState.TCP_INFO_REMOTE, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_TCP_INFO_REMOTE_MSG"));
        }
    }

    class TCPInfoLocalCard
    extends BaseCard {
        TCPInfoLocalCard() {
            super(ASAAssistantModel.ConnState.TCP_INFO_LOCAL, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_TCP_INFO_LOCAL_MSG"));
        }
    }

    class DBConnAutoCard
    extends BaseCard {
        DBConnAutoCard() {
            super(ASAAssistantModel.ConnState.DB_CONN_AUTO, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_DB_CONN_AUTO_MSG"));
        }
    }

    class DBConnRemoteCard
    extends BaseCard {
        DBConnRemoteCard() {
            super(ASAAssistantModel.ConnState.DB_CONN_REMOTE, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_DB_CONN_REMOTE_MSG"));
        }
    }

    class DBConnLocalCard
    extends BaseCard {
        DBConnLocalCard() {
            super(ASAAssistantModel.ConnState.DB_CONN_LOCAL, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_DB_CONN_LOCAL_MSG"));
        }
    }

    class ConnMethodCard
    extends BaseCard {
        ConnMethodCard() {
            super(ASAAssistantModel.ConnState.CONN_METHOD, 1);
            if (Platform.isWindows() && !Platform.isWindows9x()) {
                LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
                ASAConnectAssistant.this._res;
                this._html.setText(logonResourcesBase.get("CA_CONN_METHOD_MSG_WIN"));
            } else {
                LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
                ASAConnectAssistant.this._res;
                this._html.setText(logonResourcesBase.get("CA_CONN_METHOD_MSG_OTHER"));
            }
        }
    }

    class ConnLocationCard
    extends BaseCard {
        ConnLocationCard() {
            super(ASAAssistantModel.ConnState.CONN_LOCATION, 3);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_LOCAL_REMOTE_QUESTION"));
            LogonResourcesBase logonResourcesBase2 = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._rb1.setText(logonResourcesBase2.get("CA_CONN_LOCAL_TEXT"));
            LogonResourcesBase logonResourcesBase3 = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._rb2.setText(logonResourcesBase3.get("CA_CONN_REMOTE_TEXT"));
        }

        @Override
        void initializeComponents() {
            if (ASAConnectAssistant.this._model.isAutoStarting()) {
                this._rb2.setSelected(true);
            } else {
                this._rb1.setSelected(true);
            }
        }

        @Override
        Object getValue() {
            return this._rb1.isSelected() ? LOCAL : REMOTE;
        }
    }

    class IsRunningCard
    extends BaseCard {
        IsRunningCard() {
            super(ASAAssistantModel.ConnState.IS_RUNNING, 3);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_DB_RUNNING_QUESTION"));
            LogonResourcesBase logonResourcesBase2 = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._rb1.setText(logonResourcesBase2.get("Yes"));
            LogonResourcesBase logonResourcesBase3 = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._rb2.setText(logonResourcesBase3.get("No"));
        }

        @Override
        void initializeComponents() {
            if (ASAConnectAssistant.this._model.isAutoStarting()) {
                this._rb2.setSelected(true);
            } else {
                this._rb1.setSelected(true);
            }
        }

        @Override
        Object getValue() {
            return this._rb1.isSelected() ? YES : NO;
        }
    }

    class WelcomeCard
    extends BaseCard {
        WelcomeCard() {
            super(ASAAssistantModel.ConnState.START, 1);
            LogonResourcesBase logonResourcesBase = ASAConnectAssistant.this._res;
            ASAConnectAssistant.this._res;
            this._html.setText(logonResourcesBase.get("CA_WELCOME_MSG"));
        }
    }

    abstract class BaseCard
    extends JPanel {
        static final int HTML_TEXT = 1;
        static final int RADIO_BUTTONS = 2;
        private String _id;
        protected JTextPane _html;
        protected JScrollPane _scroll;
        protected SybRadioButton _rb1;
        protected SybRadioButton _rb2;

        BaseCard(ASAAssistantModel.ConnState connState, int n) {
            super(new GridBagLayout());
            this._html = null;
            this._scroll = null;
            this._rb1 = null;
            this._rb2 = null;
            int n2 = 0;
            this._id = connState.toString();
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            if (n == 1) {
                this.add((Component)this.createHTMLComponent(), new GridBagConstraints(0, n2++, 1, 1, 1.0, 1.0, 19, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else if ((n & 1) != 0) {
                this.add((Component)this.createHTMLComponent(), new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 19, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
            if ((n & 2) != 0) {
                this.createRadioButtons();
                this.add((Component)this._rb1, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 19, 2, new Insets(10, 20, 0, 0), 0, 0));
                this.add((Component)this._rb2, new GridBagConstraints(0, n2++, 1, 1, 1.0, 0.0, 19, 2, new Insets(0, 20, 0, 0), 0, 0));
            }
            if (n != 1) {
                this.add(Box.createVerticalGlue(), new GridBagConstraints(0, n2++, 1, 1, 0.0, 1.0, 19, 3, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.setBackground(ASAConnectAssistant.this._background);
        }

        String getID() {
            return this._id;
        }

        void initializeComponents() {
        }

        Object getValue() {
            return null;
        }

        private void createRadioButtons() {
            this._rb1 = new SybRadioButton();
            this._rb1.setOpaque(false);
            this._rb2 = new SybRadioButton();
            this._rb2.setOpaque(false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._rb1);
            buttonGroup.add((AbstractButton)this._rb2);
            this._rb1.setSelected(true);
        }

        private JComponent createHTMLComponent() {
            StyleSheet styleSheet;
            SybLabel sybLabel = new SybLabel("dummy");
            this._html = new JTextPane(){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    Dimension dimension = super.getPreferredScrollableViewportSize();
                    if (dimension.width > 300) {
                        dimension.width = 300;
                    }
                    if (dimension.height > 400) {
                        dimension.height = 400;
                    }
                    return dimension;
                }

                @Override
                public void setText(String string) {
                    super.setText(string);
                    this.setCaretPosition(0);
                }
            };
            this._html.setContentType("text/html");
            this._html.setEnabled(false);
            this._html.setEditable(false);
            this._html.setDisabledTextColor(sybLabel.getForeground());
            this._html.setBorder(BorderFactory.createEmptyBorder());
            Document document = this._html.getDocument();
            if (document instanceof HTMLDocument && (styleSheet = ((HTMLDocument)document).getStyleSheet()) != null) {
                Font font = sybLabel.getFont();
                int n = font.getSize();
                styleSheet.addRule("body { font : " + n + "pt " + font.getFamily() + "; }");
                styleSheet.addRule("body { background-color:rgb(" + ASAConnectAssistant.this._background.getRed() + "," + ASAConnectAssistant.this._background.getGreen() + "," + ASAConnectAssistant.this._background.getBlue() + ") };");
                styleSheet.addRule("dt { font-weight:bold };");
                styleSheet.addRule("dd { margin-bottom:" + n + "pt };");
                styleSheet.addRule("dd p { margin-bottom:" + Integer.toString(n / 2) + "pt };");
                styleSheet.addRule("div.heading { font-weight:bold };");
            }
            this._scroll = new JScrollPane(this._html);
            this._scroll.setBorder(BorderFactory.createEmptyBorder());
            this._html.setBorder(BorderFactory.createEmptyBorder());
            return this._scroll;
        }
    }
}

