/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ASAConnect;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.ODBCDataSource;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.Platform;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public final class ASAConnectionInfo
extends AbstractConnectionInfo {
    private static final boolean DEFAULT_AUTOSTART = true;
    private static final boolean DEFAULT_AUTOSTOP = true;
    static final char DELIMITER = ';';
    private static final String CP_USERID = "userid";
    private static final String CP_UID = "UID";
    private static final String CP_PWD = "PWD";
    private static final String CP_PASSWORD = "password";
    private static final String CP_CON = "CON";
    private static final String CP_CONNECTION_NAME = "connectionname";
    private static final String CP_DATASOURCE_NAME = "datasourcename";
    private static final String CP_DSN = "DSN";
    private static final String CP_FILEDSN = "FILEDSN";
    private static final String CP_FILE_DATASOURCE_NAME = "filedatasourcename";
    private static final String CP_SERVER_NAME = "ServerName";
    private static final String CP_ENG = "ENG";
    private static final String CP_DBN = "DBN";
    private static final String CP_DATABASE_NAME = "databasename";
    private static final String CP_DBF = "DBF";
    private static final String CP_DATABASE_FILE = "databasefile";
    private static final String CP_START = "START";
    private static final String CP_START_LINE = "startline";
    private static final String CP_ASTART = "ASTART";
    private static final String CP_AUTOSTART = "autostart";
    private static final String CP_ASTOP = "ASTOP";
    private static final String CP_AUTOSTOP = "autostop";
    private static final String CP_DBKEY = "DBKEY";
    private static final String CP_DATABASE_KEY = "databasekey";
    private static final String CP_INT = "INT";
    private static final String CP_INTEGRATED = "integrated";
    private static final String CP_NEW_PWD = "newpwd";
    private static final String CP_KERBEROS = "KRB";
    private static final String CP_KRB = "kerberos";
    private static final String SER_HOST = "<HOST>=";
    private static final String SER_PORT = "<PORT>=";
    public static final int UNKNOWN_PORT = -1;
    public String userid = null;
    public String password = null;
    public String connectionName = null;
    public String dsn = null;
    public String fdsn = null;
    public String serverName = null;
    public String host = null;
    public int port = -1;
    public String startLine = null;
    public String databaseName = null;
    public String databaseFile = null;
    public boolean autoStart = true;
    public boolean autoStop = true;
    public String otherParms = null;
    public String databaseKey = null;
    public boolean useIntegratedLogin = false;
    public String kerberos = null;
    String newPassword = null;
    public String generatedParms = null;

    public ASAConnectionInfo() {
    }

    public ASAConnectionInfo(ASAConnectionInfo aSAConnectionInfo) {
        aSAConnectionInfo.copy(this);
    }

    public ASAConnectionInfo(String string) {
        this.deserialize(string);
    }

    @Override
    public String serialize() {
        final ArrayList arrayList = new ArrayList();
        final ArrayList arrayList2 = new ArrayList();
        this.enumerateDataValues(new DataValueCallback(){

            @Override
            public void addParm(String string, String string2) {
                arrayList.add(string);
                if (string.equals(ASAConnectionInfo.CP_PWD) || string.equals(ASAConnectionInfo.CP_DBKEY)) {
                    arrayList2.add(ASAConnectionInfo.this.encryptPassword(string2));
                } else {
                    arrayList2.add(string2);
                }
            }
        });
        String[] stringArray = arrayList.toArray(new String[0]);
        String[] stringArray2 = arrayList2.toArray(new String[0]);
        String string = this.defaultSerializer(stringArray, stringArray2);
        return string;
    }

    @Override
    public void deserialize(String string) {
        String[] stringArray = this.defaultDeserializer(string);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; i += 2) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                if (string2.equals(CP_PWD) || string2.equals(CP_DBKEY)) {
                    string3 = this.decryptPassword(string3);
                }
                this.setConnectionInfoDataFromNameValue(string2, string3);
            }
        }
    }

    @Override
    public void setUserName(String string) {
        this.userid = string;
    }

    @Override
    public String getUserName() {
        return this.userid;
    }

    @Override
    public void setPassword(String string) {
        this.password = string;
    }

    public void setNewPassword(String string) {
        this.newPassword = string;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getDatabaseType() {
        return 0;
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(false);
    }

    private String getConnectionString(final boolean bl) {
        final StringBuffer stringBuffer = new StringBuffer(128);
        this.enumerateDataValues(new DataValueCallback(){

            @Override
            public void addParm(String string, String string2) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(string);
                stringBuffer.append("=");
                if (bl && (string.equals(ASAConnectionInfo.CP_PWD) || string.equals(ASAConnectionInfo.CP_DBKEY))) {
                    stringBuffer.append("***");
                } else {
                    stringBuffer.append(string2);
                }
            }
        });
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getConnectionString(true));
        if (this.host != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(SER_HOST);
            stringBuffer.append(this.host);
        }
        if (this.port != -1) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(SER_PORT);
            stringBuffer.append(this.port);
        }
        return stringBuffer.toString();
    }

    public void merge(ASAConnectionInfo aSAConnectionInfo) {
        if (aSAConnectionInfo.userid != null) {
            this.userid = aSAConnectionInfo.userid;
        }
        if (aSAConnectionInfo.password != null) {
            this.password = aSAConnectionInfo.password;
        }
        if (aSAConnectionInfo.connectionName != null) {
            this.connectionName = aSAConnectionInfo.connectionName;
        }
        if (aSAConnectionInfo.dsn != null) {
            this.dsn = aSAConnectionInfo.dsn;
        }
        if (aSAConnectionInfo.fdsn != null) {
            this.fdsn = aSAConnectionInfo.fdsn;
        }
        if (aSAConnectionInfo.serverName != null) {
            this.serverName = aSAConnectionInfo.serverName;
        }
        if (aSAConnectionInfo.host != null) {
            this.host = aSAConnectionInfo.host;
        }
        if (aSAConnectionInfo.port != -1) {
            this.port = aSAConnectionInfo.port;
        }
        if (aSAConnectionInfo.startLine != null) {
            this.startLine = aSAConnectionInfo.startLine;
        }
        if (aSAConnectionInfo.databaseName != null) {
            this.databaseName = aSAConnectionInfo.databaseName;
        }
        if (aSAConnectionInfo.databaseFile != null) {
            this.databaseFile = aSAConnectionInfo.databaseFile;
        }
        if (!aSAConnectionInfo.autoStart) {
            this.autoStart = aSAConnectionInfo.autoStart;
        }
        if (!aSAConnectionInfo.autoStop) {
            this.autoStop = aSAConnectionInfo.autoStop;
        }
        if (aSAConnectionInfo.otherParms != null) {
            this.otherParms = aSAConnectionInfo.otherParms;
        }
        if (aSAConnectionInfo.databaseKey != null) {
            this.databaseKey = aSAConnectionInfo.databaseKey;
        }
        if (aSAConnectionInfo.useIntegratedLogin) {
            this.useIntegratedLogin = aSAConnectionInfo.useIntegratedLogin;
        }
        if (aSAConnectionInfo.kerberos != null) {
            this.kerberos = aSAConnectionInfo.kerberos;
        }
        if (aSAConnectionInfo.generatedParms != null) {
            this.generatedParms = aSAConnectionInfo.generatedParms;
        }
    }

    @Override
    public Object clone() {
        ASAConnectionInfo aSAConnectionInfo = new ASAConnectionInfo();
        this.copy(aSAConnectionInfo);
        return aSAConnectionInfo;
    }

    public void copy(ASAConnectionInfo aSAConnectionInfo) {
        aSAConnectionInfo.userid = this.userid;
        aSAConnectionInfo.password = this.password;
        aSAConnectionInfo.connectionName = this.connectionName;
        aSAConnectionInfo.dsn = this.dsn;
        aSAConnectionInfo.fdsn = this.fdsn;
        aSAConnectionInfo.serverName = this.serverName;
        aSAConnectionInfo.host = this.host;
        aSAConnectionInfo.port = this.port;
        aSAConnectionInfo.startLine = this.startLine;
        aSAConnectionInfo.databaseName = this.databaseName;
        aSAConnectionInfo.databaseFile = this.databaseFile;
        aSAConnectionInfo.autoStart = this.autoStart;
        aSAConnectionInfo.autoStop = this.autoStop;
        aSAConnectionInfo.otherParms = this.otherParms;
        aSAConnectionInfo.databaseKey = this.databaseKey;
        aSAConnectionInfo.useIntegratedLogin = this.useIntegratedLogin;
        aSAConnectionInfo.kerberos = this.kerberos;
        aSAConnectionInfo.generatedParms = this.generatedParms;
        aSAConnectionInfo.newPassword = this.newPassword;
        aSAConnectionInfo._classLoader = this._classLoader;
    }

    @Override
    public boolean canAttemptConnection() {
        boolean bl = this.dsn != null && this.dsn.length() != 0 || this.fdsn != null && this.fdsn.length() != 0;
        boolean bl2 = this.useIntegratedLogin || this.kerberos != null || bl || this.userid != null && this.userid.length() != 0;
        return bl2;
    }

    @Override
    public String getURL() {
        String string = null;
        final StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("jdbc:odbc:");
        if (this.dsn != null) {
            stringBuffer.append("dsn=");
            stringBuffer.append(this.dsn.trim());
        } else if (this.fdsn != null) {
            stringBuffer.append("filedsn=");
            stringBuffer.append(this.fdsn.trim());
        } else {
            String string2 = System.getProperty("sybase.asa.logon.odbcdriver");
            if (string2 == null || string2.length() == 0) {
                stringBuffer.append("driver=SQL Anywhere ");
                stringBuffer.append(Integer.toString(11));
            } else {
                stringBuffer.append("driver=");
                stringBuffer.append(string2);
            }
        }
        if (this.host != null && this.port != -1 && this.generatedParms == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Links=tcpip{IP=");
            stringBuilder.append(this.host);
            stringBuilder.append(";Port=");
            stringBuilder.append(Integer.toString(this.port));
            stringBuilder.append(";verify=no;dobroadcast=no};Eng=unused");
            this.generatedParms = stringBuilder.toString();
        }
        this.enumerateDataValues(new DataValueCallback(){

            @Override
            public void addParm(String string, String string2) {
                if (!string.equals(ASAConnectionInfo.CP_DSN) && !string.equals(ASAConnectionInfo.CP_FILEDSN)) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(';');
                    }
                    stringBuffer.append(string);
                    stringBuffer.append("=");
                    stringBuffer.append(string2);
                }
            }
        });
        if (this.newPassword != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append("NEWPWD=");
            stringBuffer.append(this.newPassword);
        }
        if (this.connectionName == null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append("CON=''");
        }
        string = stringBuffer.toString();
        return string;
    }

    public Properties getConnectionPropertiesForDriver() {
        Properties properties = this.getConnectionPropertiesForODBC();
        return properties;
    }

    private Properties getConnectionPropertiesForODBC() {
        Properties properties = new Properties();
        properties.put("ASAUseIsolationOnOpen", "0");
        return properties;
    }

    private void enumerateDataValues(DataValueCallback dataValueCallback) {
        int n;
        String string;
        ConnectionStringTokenizer connectionStringTokenizer;
        if (this.dsn != null) {
            dataValueCallback.addParm(CP_DSN, this.dsn);
        }
        if (this.fdsn != null) {
            dataValueCallback.addParm(CP_FILEDSN, this.fdsn);
        }
        if (this.userid != null) {
            dataValueCallback.addParm(CP_UID, this.userid);
        }
        if (this.password != null) {
            dataValueCallback.addParm(CP_PWD, this.password);
        }
        if (this.connectionName != null) {
            dataValueCallback.addParm(CP_CON, this.connectionName);
        }
        if (this.serverName != null) {
            dataValueCallback.addParm(CP_ENG, this.serverName);
        }
        if (this.startLine != null) {
            dataValueCallback.addParm(CP_START, this.startLine);
        }
        if (this.databaseName != null) {
            dataValueCallback.addParm(CP_DBN, this.databaseName);
        }
        if (this.databaseFile != null) {
            dataValueCallback.addParm(CP_DBF, this.databaseFile);
        }
        if (!this.autoStart) {
            dataValueCallback.addParm(CP_ASTART, this.autoStart ? "Yes" : "No");
        }
        if (!this.autoStop) {
            dataValueCallback.addParm(CP_ASTOP, this.autoStop ? "Yes" : "No");
        }
        if (this.databaseKey != null) {
            dataValueCallback.addParm(CP_DBKEY, this.databaseKey);
        }
        if (this.useIntegratedLogin) {
            dataValueCallback.addParm(CP_INT, "Yes");
        }
        if (this.kerberos != null && !this.kerberos.isEmpty()) {
            dataValueCallback.addParm(CP_KRB, this.kerberos);
        }
        if (this.otherParms != null && this.otherParms.length() > 0) {
            connectionStringTokenizer = new ConnectionStringTokenizer(this.otherParms);
            while (connectionStringTokenizer.hasMoreTokens()) {
                string = connectionStringTokenizer.nextToken();
                if (string.startsWith("<ASE>") || (n = string.indexOf("=")) == -1) continue;
                dataValueCallback.addParm(string.substring(0, n), string.substring(n + 1));
            }
        }
        if (this.generatedParms != null) {
            connectionStringTokenizer = new ConnectionStringTokenizer(this.generatedParms);
            while (connectionStringTokenizer.hasMoreTokens()) {
                string = connectionStringTokenizer.nextToken();
                n = string.indexOf("=");
                if (n == -1) continue;
                dataValueCallback.addParm(string.substring(0, n), string.substring(n + 1));
            }
        }
    }

    @Override
    public void mergeConnectionString(String string) {
        block7: {
            block6: {
                int n = string.indexOf(",");
                if (string.indexOf(";") != -1 || n == -1) break block6;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    this.userid = string2;
                }
                if (!stringTokenizer.hasMoreElements()) break block7;
                string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    this.password = string2;
                }
                if (!stringTokenizer.hasMoreElements()) break block7;
                string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    if (string2.regionMatches(true, string2.length() - 3, ".db", 0, 3)) {
                        this.databaseFile = string2;
                    } else {
                        this.serverName = string2;
                    }
                }
                if (!stringTokenizer.hasMoreElements() || (string2 = stringTokenizer.nextToken()).length() <= 0) break block7;
                this.connectionName = string2;
                break block7;
            }
            ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
            while (connectionStringTokenizer.hasMoreTokens()) {
                String string3 = connectionStringTokenizer.nextToken();
                this.setConnectionInfoDataFromToken(string3);
            }
        }
    }

    private void setConnectionInfoDataFromToken(String string) {
        String string2;
        int n = string.indexOf("=");
        if (n == -1) {
            n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n) + '=' + string.substring(n + 1);
            } else {
                return;
            }
        }
        String string3 = (string2 = string.substring(0, n).trim()).equalsIgnoreCase(CP_PWD) || string2.equalsIgnoreCase(CP_PASSWORD) || string2.equalsIgnoreCase(CP_DBKEY) || string2.equalsIgnoreCase(CP_DATABASE_KEY) ? string.substring(n + 1) : string.substring(n + 1).trim();
        this.setConnectionInfoDataFromNameValue(string2, string3);
    }

    private void setConnectionInfoDataFromNameValue(String string, String string2) {
        StringBuffer stringBuffer = null;
        if (string.equalsIgnoreCase(CP_DSN) || string.equalsIgnoreCase(CP_DATASOURCE_NAME)) {
            this.dsn = string2;
        } else if (string.equalsIgnoreCase(CP_FILEDSN) || string.equalsIgnoreCase(CP_FILE_DATASOURCE_NAME)) {
            this.fdsn = string2;
        } else if (string.equalsIgnoreCase(CP_ASTOP) || string.equalsIgnoreCase(CP_AUTOSTOP)) {
            this.autoStop = this.stringToBoolean(string2);
        } else if (string.equalsIgnoreCase(CP_ASTART) || string.equalsIgnoreCase(CP_AUTOSTART)) {
            this.autoStart = this.stringToBoolean(string2);
        } else if (string.equalsIgnoreCase(CP_ENG) || string.equalsIgnoreCase(CP_SERVER_NAME)) {
            this.serverName = string2;
        } else if (string.equalsIgnoreCase(CP_START) || string.equalsIgnoreCase(CP_START_LINE)) {
            this.startLine = string2;
        } else if (string.equalsIgnoreCase(CP_DBN) || string.equalsIgnoreCase(CP_DATABASE_NAME)) {
            this.databaseName = string2;
        } else if (string.equalsIgnoreCase(CP_DBF) || string.equalsIgnoreCase(CP_DATABASE_FILE)) {
            this.databaseFile = string2;
        } else if (string.equalsIgnoreCase(CP_DBKEY) || string.equalsIgnoreCase(CP_DATABASE_KEY)) {
            this.databaseKey = string2;
        } else if (string.equalsIgnoreCase(CP_CON) || string.equalsIgnoreCase(CP_CONNECTION_NAME)) {
            this.connectionName = string2;
        } else if (string.equalsIgnoreCase(CP_UID) || string.equalsIgnoreCase(CP_USERID)) {
            this.userid = string2;
        } else if (string.equalsIgnoreCase(CP_PWD) || string.equalsIgnoreCase(CP_PASSWORD)) {
            this.password = string2;
        } else if (string.equalsIgnoreCase(CP_NEW_PWD)) {
            this.newPassword = string2;
        } else if (string.equalsIgnoreCase(CP_INT) || string.equalsIgnoreCase(CP_INTEGRATED)) {
            this.useIntegratedLogin = this.stringToBoolean(string2);
        } else if (string.equalsIgnoreCase(CP_KRB) || string.equalsIgnoreCase(CP_KERBEROS)) {
            this.kerberos = string2;
        } else {
            stringBuffer = this.otherParms == null ? new StringBuffer() : new StringBuffer(this.otherParms);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(";");
            }
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(string2);
        }
        if (stringBuffer != null) {
            this.otherParms = stringBuffer.toString();
        }
    }

    private boolean stringToBoolean(String string) {
        return string.equals("1") || string.equalsIgnoreCase("Yes");
    }

    public void saveAsDSN(int n, String string) {
        ASAConnectionInfo aSAConnectionInfo;
        if (!Platform.isWindows()) {
            return;
        }
        String string2 = "SQL Anywhere " + Integer.toString(11);
        String string3 = "dbodbc" + Integer.toString(11) + ".dll";
        String string4 = ASAConnect.guessDBLibDirectory();
        File file = string4 == null ? new File(string3) : new File(string4 + string3);
        final Properties properties = new Properties();
        if (this.dsn != null || this.fdsn != null) {
            String string5 = ASAConnect.getCanonicalConnectionString(this.getConnectionString());
            aSAConnectionInfo = new ASAConnectionInfo(string5);
            aSAConnectionInfo.password = this.password;
        } else {
            aSAConnectionInfo = this;
        }
        aSAConnectionInfo.enumerateDataValues(new DataValueCallback(){

            @Override
            public void addParm(String string, String string2) {
                if (!string.equals(ASAConnectionInfo.CP_DSN) && !string.equals(ASAConnectionInfo.CP_FILEDSN)) {
                    int n = string2.length();
                    if (n >= 2) {
                        char c = string2.charAt(0);
                        char c2 = string2.charAt(n - 1);
                        if (c == '\'' && c2 == '\'') {
                            string2 = string2.substring(1, n - 1);
                        }
                    }
                    properties.setProperty(string, string2);
                }
            }
        });
        ODBCUtils.createDSN(n, string, string2, file, properties);
    }

    public void loadFromDSN(ODBCDataSource.Type type, String string) {
        Properties properties;
        ODBCDataSource oDBCDataSource = ODBCDataSource.getDataSource(type, string);
        if (oDBCDataSource != null && (properties = oDBCDataSource.getProperties()) != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement().toString();
                String string3 = properties.getProperty(string2);
                this.setConnectionInfoDataFromNameValue(string2, string3);
            }
        }
    }

    static String getSelfAuthenticationSQL() {
        String string = ASAConnect.isInstalled() ? ASAConnect.getProperty(-99) : null;
        if (string == null || string.isEmpty()) {
            string = "Company=Sybase;Application=DBTools;Signature=000fa55157edb8e14d818eb4fe3db41447146f1571g2a1b5949cab32c7760419117ca3ce88770fecfd7";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SET TEMPORARY OPTION Connection_authentication='");
        stringBuilder.append(string);
        stringBuilder.append('\'');
        return stringBuilder.toString();
    }

    private static interface DataValueCallback {
        public void addParm(String var1, String var2);
    }
}

