/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.common.ChangePasswordDialog;
import com.sybase.asa.common.IntegerTextField;
import com.sybase.asa.logon.ASAAdvancedPage;
import com.sybase.asa.logon.ASAConnect;
import com.sybase.asa.logon.ASAConnectAssistant;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.ASANetworkPage;
import com.sybase.asa.logon.BrowseDSNDialog;
import com.sybase.asa.logon.CEProxyPortDialog;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.EngineStartException;
import com.sybase.asa.logon.FindServerDialog;
import com.sybase.asa.logon.GenerateODBCDataSourceDialog;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.LogonSourceHost;
import com.sybase.asa.logon.NoServerAddressException;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.asa.logon.Preferences;
import com.sybase.asa.logon.PropertyMetaData;
import com.sybase.asa.logon.Tool;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.ClipboardManager;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.FileUtil;
import com.sybase.util.FontHelper;
import com.sybase.util.MRUComboBox;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.SybTitledPanelCloseEvent;
import com.sybase.util.SybTitledPanelCloseListener;
import com.sybase.util.UIUtils;
import com.sybase.util.win32.Registry;
import com.sybase.util.win32.Win32Util;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImageFilter;
import java.awt.image.FilteredImageSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class ASADatabaseSource
implements LogonSource,
ActionListener,
ItemListener,
SybTitledPanelCloseListener,
ComponentListener {
    private static final String SAVE_PREFIX = "ASADatabaseSource";
    private static final String SAVE_DSN = "DSN";
    private static final String SAVE_FDSN = "FDSN";
    private static final String SAVE_SERVER_NAME = "serverName";
    private static final String SAVE_START_LINE = "startLine";
    private static final String SAVE_DATABASE_NAME = "databaseName";
    private static final String SAVE_DATABASE_FILE = "databaseFile";
    private static final String SAVE_LAST_DBF_FOLDER = "lastDBFFolder";
    private static final String SAVE_LAST_FDSN_FOLDER = "lastFDSNFolder";
    private static final String SAVE_CA_TOGGLE_STATUS = "caToggleStatus";
    private static final String DELETE_KEY_COMMAND = "deleteKey";
    private static final String INSERT_KEY_COMMAND = "insertKey";
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private JTabbedPane _tabbedPane = null;
    private JPanel _identificationPanel = null;
    private JPanel _databasePanel = null;
    private ASANetworkPage _networkPanel = null;
    private ASAAdvancedPage _advancedPanel = null;
    private SybButton _toggleAssistButton = null;
    private ASAConnectAssistant _assistant = null;
    private ImageIcon _collapseIcon = null;
    private ImageIcon _expandIcon = null;
    private SybRadioButton _supplyUIDandPWD = null;
    private SybRadioButton _useIntegratedLogin = null;
    private SybLabel _useridLabel = null;
    private JTextField _userid = null;
    private SybLabel _passwordLabel = null;
    private JTextField _password = null;
    private SybRadioButton _noProfile = null;
    private SybRadioButton _dsnProfile = null;
    private SybRadioButton _fdsnProfile = null;
    private MRUComboBox _dsn = null;
    private MRUComboBox _fdsn = null;
    private SybButton _browseDSN = null;
    private SybButton _openODBCAdmin = null;
    private SybButton _browseFDSN = null;
    private static final int NO_PROFILE = 0;
    private static final int DSN_PROFILE = 1;
    private static final int FDSN_PROFILE = 2;
    private boolean _osSupportsIntegratedLogins = false;
    private static boolean _selectIntegratedLogins = false;
    private MRUComboBox _serverName = null;
    private MRUComboBox _startLine = null;
    private MRUComboBox _databaseName = null;
    private MRUComboBox _databaseFile = null;
    private SybButton _findServer = null;
    private SybButton _browseDatabaseFile = null;
    private SybLabel _databaseKeyLabel = null;
    private JPasswordField _databaseKey = null;
    private SybCheckBox _autoStart = null;
    private SybCheckBox _autoStop = null;
    private DocumentListener _databaseFileDocumentListener = null;
    private ClassLoader _classLoader = null;
    private boolean _simplified = false;
    private boolean _showConnectionName = false;
    protected String _helpJARLocation = null;
    protected String _helpPrefix;
    protected String _helpSuffix;
    protected HelpViewer _helpViewer = null;
    protected LogonResourcesBase _res = LogonResourcesBase.getBundle();
    private JPanel _panel = null;
    private ASAConnectionInfo _initialConnectionInfo = null;
    private Exception _initialException = null;
    private LogonSourceHost _host = null;
    private UnsatisfiedLinkError _dblibInitializationError = null;
    private Object[] _tools = null;
    private boolean _showCA = true;
    private boolean _attemptingConnection = true;
    private JPanel _contentPanel;
    private static final int TEST_CONNECTION_TOOL_ID = 1;
    private static final int CE_PROXY_PORT_TOOL_ID = 2;
    private static final int COPY_CONNECTION_STRING_TOOL_ID = 3;
    private static final int GENERATE_ODBC_DSN_TOOL_ID = 4;

    public ASADatabaseSource() {
        this(0);
    }

    public ASADatabaseSource(int n) {
        this._simplified = (n & 1) != 0;
        this._showConnectionName = (n & 2) != 0;
        String string = System.getProperty("os.name");
        this._osSupportsIntegratedLogins = string.indexOf("Windows") != -1 && string.indexOf("Windows 95") == -1 && string.indexOf("Windows 98") == -1 && string.indexOf("Windows Me") == -1;
    }

    @Override
    public void setLogonSourceHost(LogonSourceHost logonSourceHost) {
        this._host = logonSourceHost;
    }

    @Override
    public void notifyLogonSourceSelected(boolean bl) {
        if (this._dblibInitializationError != null) {
            DetailsErrorDialog.showDialog((Component)this.getParentWindow(), (String)this._res.get("Connect"), (String)this._res.get("CouldNotLoadDBLIB"), (String)this._dblibInitializationError.getLocalizedMessage(), null);
            this._dblibInitializationError = null;
        }
        this._host.enableOKButton(true);
        if (bl && this._assistant != null) {
            this.showAssistant(this._showCA);
        }
    }

    @Override
    public void notifyConnectOK() {
        Preferences.save(SAVE_PREFIX, SAVE_DSN, this._dsn.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_FDSN, this._fdsn.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_SERVER_NAME, this._serverName.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_START_LINE, this._startLine.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_DATABASE_NAME, this._databaseName.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_DATABASE_FILE, this._databaseFile.getMRUList());
        if (this._assistant != null) {
            Preferences.save(SAVE_PREFIX, SAVE_CA_TOGGLE_STATUS, Boolean.toString(this._assistant.isVisible()));
        }
    }

    @Override
    public void notifyCancelClicked() {
        boolean bl = this._assistant == null ? false : this._assistant.isVisible();
        Preferences.save(SAVE_PREFIX, SAVE_CA_TOGGLE_STATUS, Boolean.toString(bl));
        Preferences.makePermanent();
    }

    @Override
    public void setInitialConnectionInfo(AbstractConnectionInfo abstractConnectionInfo) {
        if (abstractConnectionInfo instanceof ASAConnectionInfo) {
            this._initialConnectionInfo = (ASAConnectionInfo)abstractConnectionInfo;
        }
    }

    @Override
    public void destroy() {
        this.destroyGUI();
        this._res = null;
        this._initialConnectionInfo = null;
        this._helpViewer = null;
        this._host = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel.getPreferredSize();
    }

    @Override
    public JPanel getPanel(int n) {
        if (this._panel == null) {
            this._simplified = (n & 1) != 0;
            this._showConnectionName = (n & 2) != 0;
            this.createGUI();
        }
        return this._panel;
    }

    @Override
    public String getHelpContextId() {
        String string;
        if (this._tabbedPane == null) {
            string = "HELP_ASA_DB_SRC_PAGE_1";
        } else {
            switch (this._tabbedPane.getSelectedIndex()) {
                default: {
                    string = "HELP_ASA_DB_SRC_PAGE_1";
                    break;
                }
                case 1: {
                    string = "HELP_ASA_DB_SRC_PAGE_2";
                    break;
                }
                case 2: {
                    string = "HELP_ASA_DB_SRC_NETWORK_PAGE";
                    break;
                }
                case 3: {
                    string = "HELP_ASA_DB_SRC_PAGE_3";
                }
            }
        }
        return string;
    }

    private void buildConnectionString(ConnectionStringBuilder connectionStringBuilder) {
        PropertyMetaData[] propertyMetaDataArray;
        String string;
        String string2;
        if (this._dsnProfile.isSelected()) {
            string2 = this._dsn.getStringValue();
            if (string2 != null && string2.length() != 0) {
                connectionStringBuilder.addParm(SAVE_DSN, string2);
            }
        } else if (this._fdsnProfile.isSelected() && (string2 = this._fdsn.getStringValue()) != null && string2.length() != 0) {
            connectionStringBuilder.addParm("FileDSN", string2);
        }
        if (this._userid.getText().trim().length() != 0) {
            connectionStringBuilder.addParm("UID", this._userid.getText().trim());
        }
        if (this._password.getText().length() != 0) {
            connectionStringBuilder.addParm("PWD", this._password.getText());
        }
        if (!this._autoStart.isSelected()) {
            connectionStringBuilder.addParm("AUTOSTART", "No");
        }
        if (!this._autoStop.isSelected()) {
            connectionStringBuilder.addParm("ASTOP", "No");
        }
        if ((string2 = this._serverName.getStringValue()) != null && string2.length() != 0 && string2.indexOf(":") == -1) {
            connectionStringBuilder.addParm("ENG", string2);
        }
        if ((string2 = this._startLine.getStringValue()) != null && string2.length() != 0) {
            connectionStringBuilder.addParm("START", string2);
        }
        this._networkPanel.commitPartialEdits();
        String string3 = this._networkPanel.getConnectionString();
        if (string3 != null && string3.length() != 0) {
            connectionStringBuilder.addParm("LINKS", string3);
        }
        if ((string = this._networkPanel.getEncryptionString(false)) != null && string.length() > 0) {
            connectionStringBuilder.addParm("ENC", string);
        }
        if ((string2 = this._databaseName.getStringValue()) != null && string2.length() > 0) {
            connectionStringBuilder.addParm("DBN", string2);
        }
        if ((string2 = this._databaseFile.getStringValue()) != null && string2.length() != 0) {
            connectionStringBuilder.addParm("DBF", string2);
        }
        this._advancedPanel.commitPartialEdits();
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray = this._advancedPanel.getPropertyMetaData()) {
            if ("(other)".equals(propertyMetaData.getName())) {
                StringTokenizer stringTokenizer = new StringTokenizer(propertyMetaData.getValue(), ";");
                while (stringTokenizer.hasMoreTokens()) {
                    String string4;
                    String string5 = stringTokenizer.nextToken();
                    int n = string5.indexOf("=");
                    if (n == -1 || (string4 = string5.substring(0, n).trim()).length() == 0) continue;
                    String string6 = string5.substring(n + 1).trim();
                    connectionStringBuilder.addParm(string4, string6);
                }
                continue;
            }
            string2 = propertyMetaData.getValue();
            if (string2 == null || string2.length() == 0) continue;
            connectionStringBuilder.addParm(propertyMetaData.getName(), string2);
        }
    }

    @Override
    public void setInitialFocus() {
        if (this._initialException != null) {
            this.displayError(this._initialException);
            this._initialException = null;
        } else {
            this._userid.requestFocus();
        }
    }

    private void createGUI() {
        Serializable serializable;
        try {
            ASAConnect.install();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this._dblibInitializationError = unsatisfiedLinkError;
        }
        this._panel = new JPanel(new GridBagLayout());
        this._tabbedPane = new JTabbedPane();
        this._identificationPanel = this.createIdentificationPanel();
        this._databasePanel = this.createDatabasePanel();
        this._networkPanel = new ASANetworkPage(this._res.get("Network"));
        this._advancedPanel = new ASAAdvancedPage(this._res.get("Advanced"), this._showConnectionName);
        this._tabbedPane.addTab(this._identificationPanel.getName(), this._identificationPanel);
        this._tabbedPane.addTab(this._databasePanel.getName(), this._databasePanel);
        this._tabbedPane.addTab(this._networkPanel.getName(), this._networkPanel);
        this._tabbedPane.addTab(this._advancedPanel.getName(), this._advancedPanel);
        if (this._simplified) {
            this._panel.add((Component)this._tabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.createToggleAssistantButton();
            serializable = new JPanel();
            SpringLayout springLayout = new SpringLayout();
            serializable.setLayout(springLayout);
            serializable.add(this._tabbedPane);
            serializable.add((Component)this._toggleAssistButton);
            serializable.setComponentZOrder((Component)this._toggleAssistButton, 0);
            serializable.setComponentZOrder(this._tabbedPane, 1);
            SpringLayout.Constraints constraints = springLayout.getConstraints(this._tabbedPane);
            SpringLayout.Constraints constraints2 = springLayout.getConstraints((Component)this._toggleAssistButton);
            SpringLayout.Constraints constraints3 = springLayout.getConstraints((Component)serializable);
            Dimension dimension = this._toggleAssistButton.getPreferredSize();
            Rectangle rectangle = this._tabbedPane.getUI().getTabBounds(this._tabbedPane, 0);
            int n = dimension.height - rectangle.height + 1;
            constraints.setX(Spring.constant(0));
            constraints.setY(Spring.constant(n));
            constraints2.setX(Spring.sum(Spring.constant(-1 * dimension.width), constraints.getConstraint("East")));
            constraints2.setY(Spring.constant(0));
            constraints3.setConstraint("East", constraints.getConstraint("East"));
            constraints3.setConstraint("South", constraints.getConstraint("South"));
            this._assistant = new ASAConnectAssistant(this);
            this._assistant.getTitledPanel().addCloseListener((SybTitledPanelCloseListener)this);
            String string = Preferences.load(SAVE_PREFIX, SAVE_CA_TOGGLE_STATUS);
            this._showCA = string != null ? Boolean.parseBoolean(string) : true;
            if (!this._showCA) {
                this._assistant.setVisible(false);
            }
            if (this._showCA) {
                this._panel.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this._toggleAssistButton.setIcon((Icon)this._expandIcon);
                this._panel.add((Component)serializable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            }
            this._panel.add((Component)this._assistant, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 0, 0), 0, 0));
            this._contentPanel = serializable;
        }
        serializable = KeyStroke.getKeyStroke(10, 0);
        this._userid.getKeymap().removeKeyStrokeBinding((KeyStroke)serializable);
        this._password.getKeymap().removeKeyStrokeBinding((KeyStroke)serializable);
        this._panel.addComponentListener(this);
        this.setInitialValues();
        this.enableControls();
    }

    private void createToggleAssistantButton() {
        Image image = UIUtils.getExplorerBarGroupCollapseButton().getImage();
        Image image2 = UIUtils.getExplorerBarGroupExpandButton().getImage();
        double d = image.getWidth(null) / 2;
        double d2 = image.getHeight(null) / 2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(270.0), d, d2);
        BufferedImageFilter bufferedImageFilter = new BufferedImageFilter(new AffineTransformOp(affineTransform, 1));
        this._collapseIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), bufferedImageFilter)));
        this._expandIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image2.getSource(), bufferedImageFilter)));
        this._toggleAssistButton = new SybButton((Icon)this._collapseIcon);
        this._toggleAssistButton.setToolTipText(this._res.get("CA_BUTTON_TOOLTIP"));
        this._toggleAssistButton.getAccessibleContext().setAccessibleDescription(this._res.get("CA_BUTTON_TOOLTIP"));
        this._toggleAssistButton.addActionListener((ActionListener)this);
        int n = this._toggleAssistButton.getPreferredSize().height;
        this._toggleAssistButton.setPreferredSize(new Dimension(n + 6, n));
    }

    private JPanel createIdentificationPanel() {
        ButtonGroup buttonGroup;
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName(this._res.get("Identification"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        ImageIcon imageIcon = new ImageIcon(LogonImages.getIdentification());
        SybLabel sybLabel = new SybLabel(this._res.get("The following values are used to identify yourself to the database"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        if (this._osSupportsIntegratedLogins) {
            this._supplyUIDandPWD = new SybRadioButton(this._res.get("SupplyUIDAndPWD"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            jPanel2.add((Component)this._supplyUIDandPWD, gridBagConstraints);
        }
        this._useridLabel = new SybLabel(this._res.get("User:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, this._osSupportsIntegratedLogins ? 32 : 16, 0, 5);
        jPanel2.add((Component)this._useridLabel, gridBagConstraints);
        this._userid = new JTextField(10);
        new FontHelper((JTextComponent)this._userid);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._userid, gridBagConstraints);
        this._useridLabel.setLabelFor((Component)this._userid);
        this._passwordLabel = new SybLabel(this._res.get("Password:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, this._osSupportsIntegratedLogins ? 32 : 16, 0, 5);
        jPanel2.add((Component)this._passwordLabel, gridBagConstraints);
        this._password = new JPasswordField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel2.add((Component)this._password, gridBagConstraints);
        this._passwordLabel.setLabelFor((Component)this._password);
        if (this._osSupportsIntegratedLogins) {
            this._useIntegratedLogin = new SybRadioButton(this._res.get("UseIntegratedLogin"));
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 5, 0, 5);
            jPanel2.add((Component)this._useIntegratedLogin, gridBagConstraints);
            buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._supplyUIDandPWD);
            buttonGroup.add((AbstractButton)this._useIntegratedLogin);
            if (_selectIntegratedLogins) {
                this._useIntegratedLogin.setSelected(true);
            } else {
                this._supplyUIDandPWD.setSelected(true);
            }
            this._useIntegratedLogin.addItemListener((ItemListener)this);
            this._supplyUIDandPWD.addItemListener((ItemListener)this);
        }
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)new JSeparator(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(8, 0, 8, 0), 0, 0));
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        imageIcon = new ImageIcon(LogonImages.getProfile());
        sybLabel = new SybLabel(this._res.get("You can use default connection values stored in a profile."));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._noProfile = new SybRadioButton(this._res.get("None"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        jPanel2.add((Component)this._noProfile, gridBagConstraints);
        this._dsnProfile = new SybRadioButton(this._res.get("ODBC Data Source Name"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        jPanel2.add((Component)this._dsnProfile, gridBagConstraints);
        String string = Preferences.load(SAVE_PREFIX, SAVE_DSN);
        if (string != null && string.length() != 0) {
            string = this.removeBogusDataSources(string);
        }
        this._dsn = new MRUComboBox(string);
        new FontHelper((JComboBox)this._dsn);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._dsn, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        jPanel2.add((Component)this._dsn, gridBagConstraints);
        this._browseDSN = new SybButton(this._res.get("&Browse..."));
        this._browseDSN.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel2.add((Component)this._browseDSN, gridBagConstraints);
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            this._openODBCAdmin = new SybButton(Win32Util.getODBCAdministratorIcon());
            this._openODBCAdmin.setMargin(new Insets(2, 2, 2, 2));
            this._openODBCAdmin.setToolTipText(this._res.get("ODBCAdminToolTip"));
            this._openODBCAdmin.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel2.add((Component)this._openODBCAdmin, gridBagConstraints);
        }
        this._fdsnProfile = new SybRadioButton(this._res.get("FDSN_PROFILE"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel2.add((Component)this._fdsnProfile, gridBagConstraints);
        string = Preferences.load(SAVE_PREFIX, SAVE_FDSN);
        if (string != null && string.length() != 0) {
            string = this.removeBogusDataSourceFiles(string);
        }
        this._fdsn = new MRUComboBox(string);
        new FontHelper((JComboBox)this._fdsn);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._fdsn, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        jPanel2.add((Component)this._fdsn, gridBagConstraints);
        this._browseFDSN = new SybButton(this._res.get("&Browse..."));
        this._browseFDSN.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel2.add((Component)this._browseFDSN, gridBagConstraints);
        buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._noProfile);
        buttonGroup.add((AbstractButton)this._dsnProfile);
        buttonGroup.add((AbstractButton)this._fdsnProfile);
        if (this._initialConnectionInfo == null) {
            this._noProfile.setSelected(true);
        } else if (this._initialConnectionInfo.dsn != null && this._initialConnectionInfo.dsn.length() > 0) {
            this._dsnProfile.setSelected(true);
        } else if (this._initialConnectionInfo.fdsn != null && this._initialConnectionInfo.fdsn.length() > 0) {
            this._fdsnProfile.setSelected(true);
        } else {
            this._noProfile.setSelected(true);
        }
        this._noProfile.addItemListener((ItemListener)this);
        this._dsnProfile.addItemListener((ItemListener)this);
        this._fdsnProfile.addItemListener((ItemListener)this);
        jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 21, 3, new Insets(0, 0, 0, 0), 0, 0));
        if (!Registry.isInstalled()) {
            this._browseDSN.setEnabled(false);
        }
        Dimension dimension = jPanel.getPreferredSize();
        Dimension dimension2 = jPanel.getMaximumSize();
        dimension2.height = dimension.height;
        jPanel.setMaximumSize(dimension2);
        return jPanel;
    }

    private String removeBogusDataSourceFiles(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Registry.isInstalled()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                if (!file.exists() && file.getParent() != null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(file);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String removeBogusDataSources(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Registry.isInstalled()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!ODBCUtils.isValidDSN(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    protected Image getProductImage() {
        return LogonImages.getAsa32();
    }

    private JPanel createDatabasePanel() {
        boolean bl;
        int n = 0;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setName(this._res.get("Database"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        ImageIcon imageIcon = new ImageIcon(this.getProductImage());
        SybLabel sybLabel = new SybLabel(this._res.get("The following information identifies the database server"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Server name:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._serverName = new MRUComboBox(Preferences.load(SAVE_PREFIX, SAVE_SERVER_NAME));
        new FontHelper((JComboBox)this._serverName);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._serverName, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel2.add((Component)this._serverName, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._serverName);
        this._findServer = new SybButton(this._res.get("Find..."));
        this._findServer.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)this._findServer, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Start line:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._startLine = new MRUComboBox(Preferences.load(SAVE_PREFIX, SAVE_START_LINE));
        new FontHelper((JComboBox)this._startLine);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._startLine, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)this._startLine, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._startLine);
        jPanel.add(jPanel2);
        jPanel.add(new JSeparator());
        jPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        n = 0;
        imageIcon = new ImageIcon(LogonImages.getDatabase32x32());
        sybLabel = new SybLabel(this._res.get("The following information identifies the database"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Database name:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._databaseName = new MRUComboBox(Preferences.load(SAVE_PREFIX, SAVE_DATABASE_NAME));
        new FontHelper((JComboBox)this._databaseName);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._databaseName, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)this._databaseName, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._databaseName);
        sybLabel = new SybLabel(this._res.get("Database file:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._databaseFile = new MRUComboBox(Preferences.load(SAVE_PREFIX, SAVE_DATABASE_FILE));
        new FontHelper((JComboBox)this._databaseFile);
        ASADatabaseSource.setMRUComboBoxPreferredWidth(this._databaseFile, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel2.add((Component)this._databaseFile, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._databaseFile);
        this._browseDatabaseFile = new SybButton(this._res.get("&Browse..."));
        this._browseDatabaseFile.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)this._browseDatabaseFile, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Database key:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 32, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._databaseKey = new JPasswordField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)this._databaseKey, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._databaseKey);
        this._databaseKeyLabel = sybLabel;
        JTextField jTextField = (JTextField)this._databaseFile.getEditor().getEditorComponent();
        this._databaseFileDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                ASADatabaseSource.this.enableDatabaseKeyField();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ASADatabaseSource.this.enableDatabaseKeyField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ASADatabaseSource.this.enableDatabaseKeyField();
            }
        };
        jTextField.getDocument().addDocumentListener(this._databaseFileDocumentListener);
        this._autoStart = new SybCheckBox(this._res.get("Start database automatically"));
        this._autoStart.setSelected(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 0);
        jPanel2.add((Component)this._autoStart, gridBagConstraints);
        this._autoStop = new SybCheckBox(this._res.get("Stop database after last disconnect"));
        this._autoStop.setSelected(true);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 0);
        jPanel2.add((Component)this._autoStop, gridBagConstraints);
        jPanel.add(jPanel2);
        try {
            bl = ASAConnect.isInstalled();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        this._findServer.setEnabled(bl);
        return jPanel;
    }

    private static void setMRUComboBoxPreferredWidth(MRUComboBox mRUComboBox, int n) {
        Dimension dimension = mRUComboBox.getPreferredSize();
        FontMetrics fontMetrics = mRUComboBox.getFontMetrics(mRUComboBox.getFont());
        int n2 = fontMetrics.charWidth('m');
        int n3 = n2 * n;
        if (dimension.width > n3) {
            dimension.width = n3;
            mRUComboBox.setPreferredSize(dimension);
        }
    }

    private void enableControls() {
        if (this._osSupportsIntegratedLogins) {
            boolean bl = this._supplyUIDandPWD.isSelected();
            this._useridLabel.setEnabled(bl);
            this._userid.setEnabled(bl);
            this._passwordLabel.setEnabled(bl);
            this._password.setEnabled(bl);
        }
        boolean bl = this._dsnProfile.isSelected();
        boolean bl2 = this._fdsnProfile.isSelected();
        this._dsn.setEnabled(bl);
        this._browseDSN.setEnabled(bl && Registry.isInstalled());
        if (this._openODBCAdmin != null) {
            this._openODBCAdmin.setEnabled(bl);
        }
        this._fdsn.setEnabled(bl2);
        this._browseFDSN.setEnabled(bl2);
        this.enableDatabaseKeyField();
    }

    private void enableDatabaseKeyField() {
        String string;
        Object object;
        boolean bl = false;
        if (this._databaseFile != null && (object = this._databaseFile.getEditor().getItem()) != null && (string = object.toString()) != null && string.length() > 0) {
            bl = true;
        }
        this._databaseKeyLabel.setEnabled(bl);
        this._databaseKey.setEnabled(bl);
    }

    void setInitialValues() {
        this.resetControls();
        if (this._initialConnectionInfo != null) {
            this.setInitialValues(this._initialConnectionInfo);
        }
    }

    private void setInitialValues(ASAConnectionInfo aSAConnectionInfo) {
        if (aSAConnectionInfo.userid != null) {
            this._userid.setText(aSAConnectionInfo.userid);
        }
        if (aSAConnectionInfo.password != null) {
            this._password.setText(aSAConnectionInfo.password);
        }
        if (aSAConnectionInfo.dsn != null) {
            this._dsnProfile.setSelected(true);
            this._dsn.setSelectedItem((Object)aSAConnectionInfo.dsn);
            this._networkPanel.toggleAllCheckboxes(false);
        }
        if (aSAConnectionInfo.fdsn != null) {
            this._fdsnProfile.setSelected(true);
            this._fdsn.setSelectedItem((Object)aSAConnectionInfo.fdsn);
            this._networkPanel.toggleAllCheckboxes(false);
        }
        if (aSAConnectionInfo.serverName != null) {
            this._serverName.setSelectedItem((Object)aSAConnectionInfo.serverName);
        } else if (aSAConnectionInfo.host != null && aSAConnectionInfo.port != -1) {
            this._serverName.setSelectedItem((Object)(aSAConnectionInfo.host + ":" + Integer.toString(aSAConnectionInfo.port)));
        }
        if (aSAConnectionInfo.startLine != null) {
            this._startLine.setSelectedItem((Object)aSAConnectionInfo.startLine);
        }
        if (aSAConnectionInfo.databaseName != null) {
            this._databaseName.setSelectedItem((Object)aSAConnectionInfo.databaseName);
        }
        if (aSAConnectionInfo.databaseFile != null) {
            this._databaseFile.setSelectedItem((Object)aSAConnectionInfo.databaseFile);
        }
        if (aSAConnectionInfo.databaseKey != null) {
            this._databaseKey.setText(aSAConnectionInfo.databaseKey);
        }
        this._autoStart.setSelected(aSAConnectionInfo.autoStart);
        this._autoStop.setSelected(aSAConnectionInfo.autoStop);
        if (this._showConnectionName && aSAConnectionInfo.connectionName != null) {
            this._advancedPanel.setInitialValue("CON", aSAConnectionInfo.connectionName);
        }
        if (this._osSupportsIntegratedLogins) {
            if (aSAConnectionInfo.useIntegratedLogin) {
                this._useIntegratedLogin.setSelected(true);
            } else {
                this._supplyUIDandPWD.setSelected(true);
            }
        }
        if (aSAConnectionInfo.otherParms != null || aSAConnectionInfo.generatedParms != null) {
            ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(aSAConnectionInfo.otherParms + ";" + aSAConnectionInfo.generatedParms);
            while (connectionStringTokenizer.hasMoreTokens()) {
                String string;
                String string2 = connectionStringTokenizer.nextToken();
                int n = string2.indexOf("=");
                String string3 = n != -1 ? string2.substring(0, n) : "";
                if (string3.equalsIgnoreCase("LINKS") || string3.equalsIgnoreCase("CommLinks")) {
                    string = string2.substring(string2.indexOf(61) + 1);
                    if (string == null || string.length() <= 0) continue;
                    this._networkPanel.setInitialValues(string);
                    continue;
                }
                if (string3.equalsIgnoreCase("ENC") || string3.equalsIgnoreCase("Encryption")) {
                    string = string2.substring(string2.indexOf(61) + 1);
                    if (string == null || string.length() <= 0) continue;
                    this._networkPanel.setEncryptionValues(string);
                    continue;
                }
                String[] stringArray = string2.split("=");
                if (stringArray.length <= 1) continue;
                this._advancedPanel.setInitialValue(stringArray[0], stringArray[1]);
            }
        }
    }

    void resetControls() {
        if (this._supplyUIDandPWD != null) {
            this._supplyUIDandPWD.setSelected(true);
        }
        this._userid.setText("");
        this._password.setText("");
        this._noProfile.setSelected(true);
        this._dsn.setSelectedItem(null);
        this._fdsn.setSelectedItem(null);
        this._serverName.setSelectedItem(null);
        this._startLine.setSelectedItem(null);
        this._databaseName.setSelectedItem(null);
        this._databaseFile.setSelectedItem(null);
        this._autoStop.setSelected(true);
        this._autoStart.setSelected(true);
        this._advancedPanel.resetProps();
        this._networkPanel.resetProps();
    }

    private boolean stringToBoolean(String string) {
        return string.equals("1") || string.equalsIgnoreCase("Yes");
    }

    private void destroyGUI() {
        if (this._panel != null) {
            this._tabbedPane = null;
            this._identificationPanel = null;
            this._databasePanel = null;
            this._networkPanel.destroyUI();
            this._networkPanel = null;
            this._advancedPanel.destroyUI();
            this._advancedPanel = null;
            this._userid = null;
            this._useridLabel = null;
            this._password = null;
            this._passwordLabel = null;
            if (this._osSupportsIntegratedLogins) {
                if (this._supplyUIDandPWD != null) {
                    this._supplyUIDandPWD.removeItemListener((ItemListener)this);
                    this._supplyUIDandPWD = null;
                }
                if (this._useIntegratedLogin != null) {
                    this._useIntegratedLogin.removeItemListener((ItemListener)this);
                    this._useIntegratedLogin = null;
                }
            }
            this._dsn = null;
            this._fdsn = null;
            this._serverName = null;
            this._startLine = null;
            this._databaseName = null;
            if (this._databaseFileDocumentListener != null) {
                JTextField jTextField = (JTextField)this._databaseFile.getEditor().getEditorComponent();
                jTextField.getDocument().removeDocumentListener(this._databaseFileDocumentListener);
                this._databaseFileDocumentListener = null;
            }
            this._databaseFile = null;
            this._databaseKeyLabel = null;
            this._databaseKey = null;
            this._autoStart = null;
            this._autoStop = null;
            this._noProfile.removeItemListener((ItemListener)this);
            this._noProfile = null;
            this._dsnProfile.removeItemListener((ItemListener)this);
            this._dsnProfile = null;
            this._fdsnProfile.removeItemListener((ItemListener)this);
            this._fdsnProfile = null;
            this._browseDSN.removeActionListener((ActionListener)this);
            this._browseDSN = null;
            if (this._openODBCAdmin != null) {
                this._openODBCAdmin.removeActionListener((ActionListener)this);
                this._openODBCAdmin = null;
            }
            this._browseFDSN.removeActionListener((ActionListener)this);
            this._browseFDSN = null;
            if (this._findServer != null) {
                this._findServer.removeActionListener((ActionListener)this);
                this._findServer = null;
            }
            if (this._browseDatabaseFile != null) {
                this._browseDatabaseFile.removeActionListener((ActionListener)this);
                this._browseDatabaseFile = null;
            }
            if (this._toggleAssistButton != null) {
                this._toggleAssistButton.removeActionListener((ActionListener)this);
                this._toggleAssistButton = null;
            }
            this._collapseIcon = null;
            this._expandIcon = null;
            this._assistant = null;
            this._panel.removeComponentListener(this);
            DialogUtils.removeComponents((Container)this._panel);
            this._panel = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._findServer) {
            this.handleFindServer();
        } else if (object == this._browseDSN) {
            this.handleBrowseDSN();
        } else if (object == this._browseFDSN) {
            this.handleBrowseFDSN();
        } else if (object == this._openODBCAdmin) {
            this.handleOpenODBCAdmin();
        } else if (object == this._browseDatabaseFile) {
            this.handleBrowseDBF();
        } else if (object == this._toggleAssistButton) {
            this.showAssistant(!this._assistant.isVisible());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._supplyUIDandPWD || object == this._useIntegratedLogin) {
            _selectIntegratedLogins = this._useIntegratedLogin.isSelected();
            this.enableControls();
        } else if (object == this._noProfile) {
            this._networkPanel.selectDefaultOptions();
            this.enableControls();
        } else if (object == this._dsnProfile || object == this._fdsnProfile) {
            JRadioButton jRadioButton = (JRadioButton)object;
            if (jRadioButton.isSelected()) {
                this._networkPanel.toggleAllCheckboxes(false);
                this._serverName.setSelectedItem((Object)"");
                this._startLine.setSelectedItem((Object)"");
                this._databaseName.setSelectedItem((Object)"");
                this._databaseFile.setSelectedItem((Object)"");
            }
            this.enableControls();
        }
    }

    private void handleOpenODBCAdmin() {
        ODBCUtils.openODBCAdministrator(this.getParentWindow());
    }

    private void handleFindServer() {
        boolean bl = this._assistant != null && this._assistant.isVisible() && this._assistant.isLocalConn();
        Window window = this.getParentWindow();
        FindServerDialog findServerDialog = window instanceof Dialog ? new FindServerDialog((Dialog)window, bl) : new FindServerDialog((Frame)window, bl);
        if (findServerDialog.create()) {
            this._serverName.setSelectedItem((Object)findServerDialog.getServerName());
            String string = findServerDialog.getHost();
            String string2 = null;
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null || !string2.equals(string)) {
                this._networkPanel.toggleTCPCheckBox(true);
            }
        }
    }

    private void handleBrowseDSN() {
        String[] stringArray;
        String string = this._dsn.getStringValue();
        Window window = this.getParentWindow();
        BrowseDSNDialog browseDSNDialog = window instanceof Frame ? new BrowseDSNDialog((Frame)window) : new BrowseDSNDialog((Dialog)window);
        if (browseDSNDialog.create(string, stringArray = this.getODBCDriverNamePrefixes())) {
            this._dsn.setSelectedItem((Object)browseDSNDialog.getDSN());
        }
    }

    protected String[] getODBCDriverNamePrefixes() {
        return new String[]{"Adaptive Server Anywhere ", "SQL Anywhere "};
    }

    private void handleBrowseFDSN() {
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        String string = Preferences.load(SAVE_PREFIX, SAVE_LAST_FDSN_FOLDER);
        if (string == null && (string = ODBCUtils.getDefaultFileDSNFolder()) == null) {
            string = System.getProperty("user.dir");
        }
        File file = new File(string);
        String string2 = this._fdsn.getStringValue();
        File file2 = string2 != null ? new File(string2) : null;
        sybFileChooser.setTitle(this._res.get("ODBC Data Source File"));
        if (sybFileChooser.showDialog(this.getParentWindow(), file, file2)) {
            File file3 = sybFileChooser.getSelectedFile();
            this._fdsn.setSelectedItem((Object)file3.toString());
            Preferences.save(SAVE_PREFIX, SAVE_LAST_FDSN_FOLDER, file3.getParent());
        }
    }

    private void handleBrowseDBF() {
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        String string = Preferences.load(SAVE_PREFIX, SAVE_LAST_DBF_FOLDER);
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        File file = new File(string);
        sybFileChooser.setTitle(this._res.get("Database File"));
        Object object = this._databaseFile.getSelectedItem();
        File file2 = object != null ? new File(object.toString()) : null;
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[1];
        sybFileFilterArray[0] = new SybFileFilter("db", this._res.get("Database Files (*.db)"));
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        if (sybFileChooser.showDialog(this.getParentWindow(), file, file2)) {
            File file3 = sybFileChooser.getSelectedFile();
            this._databaseFile.setSelectedItem((Object)file3.toString());
            Preferences.save(SAVE_PREFIX, SAVE_LAST_DBF_FOLDER, file3.getParent());
        }
    }

    private void showAssistant(boolean bl) {
        this._showCA = bl;
        if (bl && this._assistant.isVisible() || !bl && !this._assistant.isVisible()) {
            return;
        }
        GridBagLayout gridBagLayout = (GridBagLayout)this._panel.getLayout();
        GridBagConstraints gridBagConstraints = gridBagLayout.getConstraints(this._contentPanel);
        if (bl) {
            this._assistant.resetAssistant();
            this._assistant.showAssistant();
            this._toggleAssistButton.setIcon((Icon)this._collapseIcon);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 3;
        } else {
            this._assistant.hideAssistant();
            this.setDSNEnabled(true);
            this.setAdvancedTableEnabled(true);
            this._toggleAssistButton.setIcon((Icon)this._expandIcon);
            this.setNextDefault(false);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 1;
        }
        gridBagLayout.setConstraints(this._contentPanel, gridBagConstraints);
        this._panel.doLayout();
        Window window = this.getParentWindow();
        if (window != null) {
            window.pack();
        }
    }

    void setNextDefault(boolean bl) {
        if (bl) {
            this._host.setDefaultButton((JButton)this._assistant.getNextButton());
        } else {
            this._host.resetDefaultButton();
        }
    }

    void enableSourceComboBox(boolean bl) {
        this._host.enableSourceComboBox(bl);
    }

    protected Window getParentWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._panel);
        return window;
    }

    @Override
    public AbstractConnectionInfo getConnectionInfo() {
        String string;
        String string2 = null;
        if (this._panel == null) {
            ASAConnectionInfo aSAConnectionInfo = new ASAConnectionInfo(this._initialConnectionInfo);
            return aSAConnectionInfo;
        }
        ASAConnectionInfo aSAConnectionInfo = new ASAConnectionInfo();
        aSAConnectionInfo.setClassLoader(this._classLoader);
        boolean bl = aSAConnectionInfo.useIntegratedLogin = this._useIntegratedLogin != null && this._useIntegratedLogin.isSelected();
        if (aSAConnectionInfo.useIntegratedLogin) {
            aSAConnectionInfo.userid = null;
            aSAConnectionInfo.password = null;
        } else {
            string = this._userid.getText().trim();
            aSAConnectionInfo.userid = string.length() > 0 ? string : null;
            string = this._password.getText();
            aSAConnectionInfo.password = string.length() > 0 ? string : null;
        }
        aSAConnectionInfo.fdsn = null;
        aSAConnectionInfo.dsn = null;
        if (this._dsnProfile.isSelected()) {
            string = this._dsn.getStringValue();
            if (string != null && string.length() != 0) {
                aSAConnectionInfo.dsn = string;
            }
        } else if (this._fdsnProfile.isSelected() && (string = this._fdsn.getStringValue()) != null && string.length() != 0) {
            aSAConnectionInfo.fdsn = string;
        }
        aSAConnectionInfo.autoStart = this._autoStart.isSelected();
        aSAConnectionInfo.autoStop = this._autoStop.isSelected();
        string = this._serverName.getStringValue();
        if (string != null && string.length() != 0) {
            aSAConnectionInfo.serverName = string;
        } else {
            if (this._attemptingConnection && this._networkPanel.hostEntered() && this._networkPanel.portEntered()) {
                aSAConnectionInfo.serverName = "unspecified";
                this._networkPanel.addNoVerifyParms();
            } else {
                aSAConnectionInfo.serverName = null;
            }
            aSAConnectionInfo.host = null;
            aSAConnectionInfo.port = -1;
        }
        this._networkPanel.commitPartialEdits();
        string2 = this._networkPanel.getLinksString();
        String string3 = this._networkPanel.getEncryptionString(true);
        aSAConnectionInfo.startLine = null;
        string = this._startLine.getStringValue();
        if (string != null && string.length() != 0) {
            aSAConnectionInfo.startLine = string;
        }
        aSAConnectionInfo.databaseName = null;
        string = this._databaseName.getStringValue();
        if (string != null && string.length() != 0) {
            aSAConnectionInfo.databaseName = string;
        }
        aSAConnectionInfo.databaseFile = null;
        string = this._databaseFile.getStringValue();
        if (string != null && string.length() != 0) {
            aSAConnectionInfo.databaseFile = string;
        }
        aSAConnectionInfo.databaseKey = (string = new String(this._databaseKey.getPassword())).length() != 0 ? string : null;
        this._advancedPanel.commitPartialEdits();
        PropertyMetaData[] propertyMetaDataArray = this._advancedPanel.getPropertyMetaData();
        if (this._showConnectionName) {
            for (PropertyMetaData propertyMetaData : propertyMetaDataArray) {
                if (!"CON".equals(propertyMetaData.getName())) continue;
                string = propertyMetaData.getValue();
                if (string.length() != 0) {
                    aSAConnectionInfo.connectionName = string;
                    break;
                }
                aSAConnectionInfo.connectionName = null;
                break;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray) {
            if ("CON".equals(propertyMetaData.getName())) continue;
            if ("(other)".equals(propertyMetaData.getName())) {
                string = propertyMetaData.getValue();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(';');
                }
                stringBuilder.append(string);
                continue;
            }
            string = propertyMetaData.getValue();
            if (string == null || string.length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(propertyMetaData.getName() + "=" + string);
        }
        aSAConnectionInfo.otherParms = stringBuilder.length() > 0 ? stringBuilder.toString() + ";" + string3 : string3;
        aSAConnectionInfo.generatedParms = string2;
        return aSAConnectionInfo;
    }

    @Override
    public Connection connect(ArrayList<SQLWarning> arrayList, AbstractConnectionInfo abstractConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        ASAConnectionInfo aSAConnectionInfo = abstractConnectionInfo instanceof ASAConnectionInfo ? (ASAConnectionInfo)abstractConnectionInfo : null;
        if (this._panel == null) {
            ASAConnectionInfo aSAConnectionInfo2 = new ASAConnectionInfo(this._initialConnectionInfo);
            if (aSAConnectionInfo != null) {
                aSAConnectionInfo2.merge(aSAConnectionInfo);
            }
            if (classLoader != null) {
                aSAConnectionInfo2.setClassLoader(classLoader);
            }
            try {
                connection = JDBCDrivers.connect(aSAConnectionInfo2);
            }
            catch (Exception exception) {
                this._initialException = exception;
            }
        } else {
            connection = this.connectFromUI(arrayList, aSAConnectionInfo, classLoader);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection connectFromUI(ArrayList<SQLWarning> arrayList, ASAConnectionInfo aSAConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        ASAConnectionInfo aSAConnectionInfo2 = (ASAConnectionInfo)this.getConnectionInfo();
        if (classLoader != null) {
            aSAConnectionInfo2.setClassLoader(classLoader);
        }
        if (aSAConnectionInfo != null) {
            aSAConnectionInfo2.merge(aSAConnectionInfo);
        }
        try {
            try {
                connection = JDBCDrivers.connect(aSAConnectionInfo2);
            }
            catch (SQLException sQLException) {
                if (aSAConnectionInfo2.newPassword == null && this.isSAPasswordExpiredError(sQLException)) {
                    String[] stringArray;
                    while ((stringArray = this.promptForNewPassword(aSAConnectionInfo2.getUserName()))[0] != null) {
                        aSAConnectionInfo2.setPassword(stringArray[0]);
                        aSAConnectionInfo2.setNewPassword(stringArray[1]);
                        try {
                            connection = JDBCDrivers.connect(aSAConnectionInfo2);
                        }
                        catch (SQLException sQLException2) {
                            this.reportConnectionFailure(sQLException2);
                        }
                        finally {
                            aSAConnectionInfo2.setNewPassword(null);
                        }
                    }
                    throw sQLException;
                }
                throw sQLException;
            }
            if (arrayList != null) {
                for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    arrayList.add(sQLWarning);
                }
                connection.clearWarnings();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.displayError(classNotFoundException);
        }
        catch (SQLException sQLException) {
            this.displayError(sQLException);
        }
        return connection;
    }

    private boolean isSAPasswordExpiredError(SQLException sQLException) {
        return sQLException.getMessage().indexOf("[SQL Anywhere]") != -1 && sQLException.getErrorCode() == -1152;
    }

    private String[] promptForNewPassword(String string) {
        ChangePasswordDialog changePasswordDialog;
        String string2 = null;
        String string3 = null;
        String string4 = this._res.get("ERR_YOUR_PASSWORD_EXPIRED");
        Window window = this.getParentWindow();
        if (window instanceof JFrame) {
            String string5 = ((JFrame)window).getTitle();
            changePasswordDialog = new ChangePasswordDialog((JFrame)window, string5, 0, string4, string);
        } else {
            String string6 = ((JDialog)window).getTitle();
            changePasswordDialog = new ChangePasswordDialog((JDialog)window, string6, 0, string4, string);
        }
        if (changePasswordDialog.open()) {
            string2 = new String(changePasswordDialog.getOldPassword());
            string3 = changePasswordDialog.getNewPassword();
        }
        return new String[]{string2, string3};
    }

    @Override
    public void reportConnectionFailure(Exception exception) {
        this.displayError(exception);
    }

    private void displayError(Exception exception) {
        if (exception instanceof ClassNotFoundException) {
            this.handleDriverNotFound(exception);
        } else if (exception instanceof SQLException) {
            this.handleSQLException((SQLException)exception);
        } else if (exception instanceof NoServerAddressException) {
            this.handleNoServerAddressException((NoServerAddressException)exception);
        } else if (exception instanceof EngineStartException) {
            this.handleEngineStartException((EngineStartException)exception);
        } else {
            this.handleGenericException(exception);
        }
    }

    private void handleGenericException(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayConnectionError(exception.getLocalizedMessage(), null, stringBuffer.toString());
    }

    private void handleEngineStartException(EngineStartException engineStartException) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this._autoStart != null && !this._autoStart.isSelected()) {
            string2 = this._res.get("ErrServerNotFound");
            string = (this._dsnProfile.isSelected() || this._fdsnProfile.isSelected()) && this._serverName.getSelectedItem() != null && this._serverName.getSelectedItem().toString().length() == 0 ? this._res.get("ErrServerNotFoundODBCRemedy") : this._res.get("ErrServerNotFoundRemedy");
            this._tabbedPane.setSelectedComponent(this._databasePanel);
            this._serverName.requestFocus();
        } else {
            string2 = this._res.get("Could not start the database engine");
            string = this._res.get("CouldNotStartDatabaseEngineRemedy");
            this._tabbedPane.setSelectedComponent(this._databasePanel);
            if (this._databaseName.getSelectedItem() != null && this._databaseName.getSelectedItem().toString().length() != 0) {
                this._databaseName.requestFocus();
            } else {
                this._databaseFile.requestFocus();
            }
        }
        this.displayConnectionError(engineStartException, string2, string, stringBuffer.toString());
    }

    private void handleNoServerAddressException(NoServerAddressException noServerAddressException) {
        boolean bl;
        String string = null;
        String string2 = noServerAddressException.getLocalizedMessage();
        boolean bl2 = this._dsnProfile.isSelected() && this._dsn.getSelectedItem() != null && this._dsn.getSelectedItem().toString().trim().length() != 0;
        boolean bl3 = bl = this._fdsnProfile.isSelected() && this._fdsn.getSelectedItem() != null && this._fdsn.getSelectedItem().toString().trim().length() != 0;
        if (!bl2 && !bl) {
            string = this._res.get("ErrMustGiveDSNOrFDSN");
            this.displayConnectionError(string2, string, "");
            this._tabbedPane.setSelectedComponent(this._identificationPanel);
            if (this._dsnProfile.isSelected()) {
                this._dsn.requestFocus();
            } else if (this._fdsnProfile.isSelected()) {
                this._fdsn.requestFocus();
            } else {
                this._dsnProfile.setSelected(true);
                this.enableControls();
                this._dsn.requestFocus();
            }
            return;
        }
        string = this._dsnProfile.isSelected() || this._fdsnProfile.isSelected() ? this._res.get("NoServerAddressODBCRemedy") : this._res.get("NoServerAddressRemedy");
        StringBuffer stringBuffer = new StringBuffer();
        this.displayConnectionError(string2, string, stringBuffer.toString());
        this._tabbedPane.setSelectedComponent(this._databasePanel);
        this._serverName.requestFocus();
    }

    private void handleSQLException(SQLException sQLException) {
        String string;
        String string2;
        StringBuffer stringBuffer;
        JComponent jComponent;
        JPanel jPanel;
        block30: {
            String string3;
            SQLException sQLException2;
            String string4;
            block29: {
                jPanel = null;
                jComponent = null;
                stringBuffer = new StringBuffer();
                string4 = System.getProperty("line.separator");
                sQLException2 = sQLException.getNextException();
                int n = sQLException2 != null ? sQLException2.getErrorCode() : 0;
                string3 = sQLException.getSQLState();
                if (string3 == null || !string3.equals("JZ00L") || sQLException2 == null) break block29;
                switch (n) {
                    case 911: {
                        this._tabbedPane.setSelectedComponent(this._databasePanel);
                        this._databaseName.requestFocus();
                        string2 = sQLException2.getLocalizedMessage();
                        string = null;
                        break;
                    }
                    case 4001: {
                        this._tabbedPane.setSelectedComponent(this._databasePanel);
                        this._databaseFile.requestFocus();
                        string2 = sQLException2.getLocalizedMessage();
                        string = this._res.get("CouldNotStartDatabaseRemedy");
                        break;
                    }
                    case 4002: {
                        this._tabbedPane.setSelectedComponent(this._identificationPanel);
                        this._userid.requestFocus();
                        string2 = sQLException2.getLocalizedMessage();
                        string = null;
                        break;
                    }
                    case 6004: {
                        string2 = sQLException2.getLocalizedMessage();
                        string = this._res.get("RequestStartStopDenied");
                        if (this._databaseName.getSelectedItem() != null && this._databaseName.getSelectedItem().toString().length() != 0) {
                            this._tabbedPane.setSelectedComponent(this._databasePanel);
                            this._databaseName.requestFocus();
                            break;
                        }
                        break block30;
                    }
                    default: {
                        string2 = sQLException2.getLocalizedMessage();
                        string = null;
                        break;
                    }
                }
                break block30;
            }
            if (string3 != null && string3.equals("JZ004")) {
                string2 = this._res.get("You must give a user name.");
                string = null;
                this._tabbedPane.setSelectedComponent(this._identificationPanel);
                this._userid.requestFocus();
            } else if (string3 != null && string3.equals("JZ006")) {
                string2 = this._res.get("Connection refused.");
                string = this._res.get("ErrServerNotFoundRemedy");
                this._tabbedPane.setSelectedComponent(this._databasePanel);
                this._serverName.requestFocus();
            } else if (sQLException.getMessage().indexOf("[SQL Anywhere]") != -1) {
                switch (sQLException.getErrorCode()) {
                    case -100: {
                        string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                        string = this._res.get("ErrServerNotFoundRemedy");
                        this._tabbedPane.setSelectedComponent(this._databasePanel);
                        this._serverName.requestFocusInWindow();
                        break;
                    }
                    case -1074: {
                        jPanel = this._identificationPanel;
                        string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                        if (this._useIntegratedLogin.isSelected()) {
                            string = null;
                            break;
                        }
                        string = this._res.get("You must give a user name.");
                        jComponent = this._userid;
                        break;
                    }
                    case -103: {
                        string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                        string = null;
                        this._tabbedPane.setSelectedComponent(this._identificationPanel);
                        this._userid.requestFocusInWindow();
                        break;
                    }
                    case -205: {
                        string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                        string = this._res.get("IntegrateLoginsNotAllowedRemedy");
                        this._tabbedPane.setSelectedComponent(this._identificationPanel);
                        this._dsn.requestFocusInWindow();
                        break;
                    }
                    default: {
                        string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                        string = null;
                        break;
                    }
                }
            } else if (sQLException.getMessage().indexOf("[Microsoft][ODBC Driver Manager]") != -1 && string3.equals("IM002")) {
                this._tabbedPane.setSelectedComponent(this._identificationPanel);
                if (this._noProfile.isSelected()) {
                    this._dsnProfile.setSelected(true);
                    this.enableControls();
                    this._dsn.requestFocusInWindow();
                } else if (this._fdsnProfile.isSelected()) {
                    this._fdsn.requestFocusInWindow();
                } else {
                    this._dsn.requestFocusInWindow();
                }
                string2 = this._res.get("UnknownODBCDataSource");
                string = this._res.get("UnknownODBCDataSourceRemedy");
            } else {
                string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                string = null;
                sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    stringBuffer.append(ODBCUtils.stripODBCHeader(sQLException2.getLocalizedMessage()));
                    stringBuffer.append(string4);
                }
            }
        }
        this.displayConnectionError(sQLException, string2, string, stringBuffer.toString());
        if (jPanel != null) {
            this._tabbedPane.setSelectedComponent(jPanel);
        }
        if (jComponent != null) {
            jComponent.requestFocus();
        }
    }

    private void handleDriverNotFound(Exception exception) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this._res.get("Missing JDBC driver"));
        stringBuffer.append(string);
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append(this._res.get("Classpath"));
        stringBuffer.append(string);
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        this.displayConnectionError(this._res.get("The JDBC driver could not be loaded."), null, stringBuffer.toString());
    }

    private void displayConnectionError(Exception exception, String string, String string2, String string3) {
        String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string4);
        if (exception instanceof SQLException) {
            stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(((SQLException)exception).getErrorCode())));
            stringBuffer.append(string4);
            stringBuffer.append(this._res.getFormatted("\tSQL state={0}", ((SQLException)exception).getSQLState()));
            stringBuffer.append(string4);
            SQLException sQLException = ((SQLException)exception).getNextException();
            if (sQLException != null) {
                stringBuffer.append(sQLException.getLocalizedMessage());
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(sQLException.getErrorCode())));
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tSQL state={0}", sQLException.getSQLState()));
                stringBuffer.append(string4);
            }
        }
        this.displayConnectionError(string, string2, stringBuffer.toString());
    }

    private void displayConnectionError(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        final String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this._res.get("Could not connect to the database"));
        stringBuffer2.append(string4);
        stringBuffer2.append(string4);
        stringBuffer2.append(string);
        if (string2 != null) {
            stringBuffer2.append(string4);
            stringBuffer2.append(string4);
            stringBuffer2.append(string2);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this._res.get("Connection parameters:"));
        stringBuffer.append(string4);
        stringBuffer.append(this._res.getFormatted("\tUser={0}", this._userid.getText()));
        stringBuffer.append(string4);
        stringBuffer.append(this._res.getFormatted("\tPassword={0}", "***"));
        stringBuffer.append(string4);
        this.buildConnectionString(new ConnectionStringBuilder(){

            @Override
            public void addParm(String string, String string2) {
                if (string.equalsIgnoreCase("UID") || string.equalsIgnoreCase("PWD")) {
                    return;
                }
                LogonResourcesBase cfr_ignored_0 = ASADatabaseSource.this._res;
                stringBuffer.append(ASADatabaseSource.this._res.getFormatted("\t{0}={1}", string, string2));
                stringBuffer.append(string4);
            }
        });
        Window window = this.getParentWindow();
        String string5 = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
        DetailsErrorDialog.showDialog((Component)window, (String)string5, (String)stringBuffer2.toString(), (String)stringBuffer.toString(), null);
    }

    @Override
    public String getDisplayName() {
        return this._res.get("ADAPTIVE_SERVER_ANYWHERE");
    }

    @Override
    public Icon getIcon() {
        return ASAComponentsImageLoader.getImageIcon((String)"asa", (int)1001);
    }

    @Override
    public boolean hasHelp() {
        return this._helpJARLocation != null;
    }

    @Override
    public void showHelp() {
        if (this._helpViewer == null) {
            try {
                this._helpViewer = FactoryHelp.getHelpViewer((String)this._helpJARLocation, (String)this._helpPrefix, (String)this._helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                Window window = this.getParentWindow();
                String string = window instanceof Dialog ? ((Dialog)window).getTitle() : ((Frame)window).getTitle();
                SybOptionPane.showMessageDialog((Component)window, (Object)this._res.get("Help could not be displayed."), (String)string, (int)1);
            }
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage(this.getHelpContextId(), this.getParentWindow());
        }
    }

    @Override
    public void setHelpFolder(String string, String string2, String string3) {
        this._helpJARLocation = string;
        this._helpPrefix = string2;
        this._helpSuffix = string3;
    }

    @Override
    public Object[] getTools() {
        if (this._tools == null) {
            if (Platform.isWindows() && Registry.isInstalled() && CEProxyPortDialog.areProxyPortsSupported()) {
                Object[] objectArray = new Object[4];
                objectArray[0] = new Tool(1, this._res.get("TestConnection"));
                objectArray[1] = new Tool(2, this._res.get("CreateCEProxyPort"));
                objectArray[2] = new Tool(3, this._res.get("CopyConnectionString"));
                objectArray[3] = new Tool(4, this._res.get("SaveAsODBCDSN"));
                this._tools = objectArray;
            } else if (Platform.isWindows()) {
                Object[] objectArray = new Object[3];
                objectArray[0] = new Tool(1, this._res.get("TestConnection"));
                objectArray[1] = new Tool(3, this._res.get("CopyConnectionString"));
                objectArray[2] = new Tool(4, this._res.get("SaveAsODBCDSN"));
                this._tools = objectArray;
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = new Tool(1, this._res.get("TestConnection"));
                objectArray[1] = new Tool(3, this._res.get("CopyConnectionString"));
                this._tools = objectArray;
            }
        }
        return this._tools;
    }

    @Override
    public void notifyToolClicked(int n) {
        int n2 = ((Tool)this._tools[n]).getID();
        if (n2 == 1) {
            this.handleTestConnectionTool();
        } else if (n2 == 2) {
            CEProxyPortDialog.create(this.getParentWindow());
        } else if (n2 == 3) {
            this.handleCopyConnectionStringTool();
        } else if (n2 == 4) {
            this.handleGenerateODBCDSNTool();
        }
    }

    private void handleGenerateODBCDSNTool() {
        if (!this.validate()) {
            return;
        }
        this._attemptingConnection = false;
        Window window = this.getParentWindow();
        GenerateODBCDataSourceDialog generateODBCDataSourceDialog = null;
        AbstractConnectionInfo abstractConnectionInfo = this.getConnectionInfo();
        this._attemptingConnection = true;
        if (!(abstractConnectionInfo instanceof ASAConnectionInfo)) {
            return;
        }
        if (window instanceof Dialog) {
            generateODBCDataSourceDialog = new GenerateODBCDataSourceDialog((Dialog)window, (ASAConnectionInfo)abstractConnectionInfo);
        } else if (window instanceof Frame) {
            generateODBCDataSourceDialog = new GenerateODBCDataSourceDialog((Frame)window, (ASAConnectionInfo)abstractConnectionInfo);
        }
        if (generateODBCDataSourceDialog != null) {
            generateODBCDataSourceDialog.create();
        }
    }

    private void handleCopyConnectionStringTool() {
        if (!this.validate()) {
            return;
        }
        this._attemptingConnection = false;
        ASAConnectionInfo aSAConnectionInfo = (ASAConnectionInfo)this.getConnectionInfo();
        this._attemptingConnection = true;
        if (aSAConnectionInfo.password != null && aSAConnectionInfo.password.length() > 0) {
            aSAConnectionInfo.password = "***";
        }
        String string = aSAConnectionInfo.getConnectionString();
        StringSelection stringSelection = new StringSelection("\"" + string + "\"");
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        boolean bl = ClipboardManager.setContents((Clipboard)clipboard, (Transferable)stringSelection, null);
        if (!bl) {
            Window window = this.getParentWindow();
            String string2 = "";
            string2 = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
            SybOptionPane.showMessageDialog((Component)window, (Object)this._res.get("CouldNotCopyConnectionString"), (String)string2, (int)0);
        }
    }

    private void handleTestConnectionTool() {
        if (!this.validate()) {
            return;
        }
        ASAConnectionInfo aSAConnectionInfo = (ASAConnectionInfo)this.getConnectionInfo();
        Window window = this.getParentWindow();
        ASADatabaseSource.testConnection(window, aSAConnectionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testConnection(Window window, ASAConnectionInfo aSAConnectionInfo) {
        block11: {
            File file = null;
            Connection connection = null;
            LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
            try {
                file = FileUtil.createSecureTempFile((String)"testcon", null);
                String string = file.getAbsolutePath();
                aSAConnectionInfo.otherParms = aSAConnectionInfo.otherParms + ";LOG=" + string;
                try {
                    connection = JDBCDrivers.connect(aSAConnectionInfo);
                    if (connection == null) break block11;
                    ASADatabaseSource.reportTestConnection(window, file, UIManager.getIcon("OptionPane.informationIcon"), logonResourcesBase.get("ConnectionSucceeded"));
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                    }
                }
                catch (SQLException sQLException) {
                    ASADatabaseSource.reportFailedConnection(window, file, sQLException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ASADatabaseSource.reportFailedConnection(window, file, classNotFoundException);
                }
            }
            catch (IOException iOException) {
                SybOptionPane.showMessageDialog((Component)window, (Object)logonResourcesBase.getFormatted("CouldNotTestConnection", iOException.getLocalizedMessage()), (String)logonResourcesBase.get("TestConnection"), (int)0);
            }
            finally {
                boolean bl;
                if (file == null || !(bl = file.delete())) {
                    // empty if block
                }
            }
        }
    }

    private static void reportFailedConnection(Window window, File file, Exception exception) {
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        ASADatabaseSource.reportTestConnection(window, file, UIManager.getIcon("OptionPane.errorIcon"), logonResourcesBase.get("ConnectionFailed") + "\n" + exception.getLocalizedMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reportTestConnection(Window window, File file, Icon icon, String string) {
        BufferedReader bufferedReader = null;
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        StringBuffer stringBuffer = new StringBuffer(256);
        try {
            if (Platform.isWindows() && Win32Util.isInstalled()) {
                String string2 = Win32Util.getCharsetNameForCodePage((int)Win32Util.getANSICodePage());
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string2));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            if (bufferedReader == null) {
                bufferedReader = new BufferedReader(new FileReader(file));
            }
            while (true) {
                String string3;
                if ((string3 = bufferedReader.readLine()) == null) {
                }
                if ((string3 = string3.trim()).length() == 0) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string3);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        DetailsErrorDialog.showDialog((Component)window, (String)logonResourcesBase.get("TestConnectionWindowTitle"), (Icon)icon, (String)string, (String)stringBuffer.toString(), null);
    }

    @Override
    public boolean validate() {
        int n;
        String string;
        Window window;
        boolean bl = true;
        if (this._assistant != null && this._assistant.isVisible() && this._assistant.isAssistantStarted() && !this._assistant.isAssistantDone()) {
            window = this.getParentWindow();
            string = "";
            string = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
            n = SybOptionPane.showConfirmDialog((Component)window, (Object)this._res.get("ERR_ASSISTANT_NOT_DONE"), (String)string, (int)0);
            if (n == 1) {
                return false;
            }
        }
        if (this._networkPanel.getLinksString() == null && !this._dsnProfile.isSelected() && !this._fdsnProfile.isSelected()) {
            window = this.getParentWindow();
            string = "";
            string = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
            SybOptionPane.showMessageDialog((Component)window, (Object)this._res.get("NoNetworkOptionsGiven"), (String)string, (int)0);
            bl = false;
        }
        if (bl && this.containsForeignCharacters(this.getConnectionInfo().toString())) {
            window = this.getParentWindow();
            string = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
            n = SybOptionPane.showConfirmDialog((Component)window, (Object)this._res.get("ERR_BAD_CHARS_PRESENT"), (String)string, (int)0);
            bl = n != 0;
        }
        return bl;
    }

    boolean containsForeignCharacters(String string) {
        boolean bl = false;
        Charset charset = Charset.defaultCharset();
        CharsetEncoder charsetEncoder = charset.newEncoder();
        try {
            charsetEncoder.encode(CharBuffer.wrap(string));
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            bl = true;
        }
        return bl;
    }

    void selectTab(int n) {
        if (n < -1 || n >= this._tabbedPane.getTabCount()) {
            return;
        }
        this._tabbedPane.setSelectedIndex(n);
    }

    void enableToggleButton(boolean bl) {
        this._toggleAssistButton.setEnabled(bl);
    }

    void setDSNEnabled(boolean bl) {
        this._noProfile.setEnabled(bl);
        this._dsnProfile.setEnabled(bl);
        this._fdsnProfile.setEnabled(bl);
    }

    void setAdvancedTableEnabled(boolean bl) {
        this._advancedPanel.enableTable(bl);
    }

    boolean validateConnMethodFields() {
        boolean bl = false;
        if (this._osSupportsIntegratedLogins) {
            bl = this._useIntegratedLogin.isSelected();
        }
        if (!bl) {
            String string = this._userid.getText();
            bl = string != null && string.length() > 0;
        }
        return bl;
    }

    boolean validateServerNameField() {
        boolean bl;
        String string = this._serverName.getStringValue();
        boolean bl2 = bl = string != null && string.length() > 0;
        if (bl && this.containsForeignCharacters(string)) {
            Window window = this.getParentWindow();
            String string2 = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
            int n = SybOptionPane.showConfirmDialog((Component)window, (Object)this._res.get("ERR_BAD_CHARS_PRESENT"), (String)string2, (int)0);
            bl = n == 1;
        }
        return bl;
    }

    boolean validateDBFileField() {
        String string = this._databaseFile.getStringValue();
        return string != null && string.length() > 0;
    }

    boolean validateHostField() {
        String string = this.getHostField().getText();
        return string != null && string.length() > 0;
    }

    boolean validateEncComboBox() {
        String string = this.getEncTypeCombo().getSelectedItem().toString();
        return !"".equals(string);
    }

    void selectTCPCheck() {
        this._networkPanel.toggleAllCheckboxes(false);
        this._networkPanel.toggleTCPCheckBox(true);
    }

    void setCursorBusy() {
        this._panel.setCursor(Cursor.getPredefinedCursor(3));
    }

    void setCursorNormal() {
        this._panel.setCursor(Cursor.getDefaultCursor());
    }

    JTextField getUseridField() {
        return this._userid;
    }

    MRUComboBox getServerNameField() {
        return this._serverName;
    }

    MRUComboBox getDatabaseNameField() {
        return this._databaseName;
    }

    MRUComboBox getDatabaseFileField() {
        return this._databaseFile;
    }

    JTextField getHostField() {
        return this._networkPanel.getHostField();
    }

    IntegerTextField getPortField() {
        return this._networkPanel.getPortField();
    }

    JTextField getNetOtherField() {
        return this._networkPanel.getOtherPropField();
    }

    SybComboBox getEncTypeCombo() {
        return this._networkPanel.getEncTypeCombo();
    }

    String getEncString() {
        return this._networkPanel.getEncryptionString(true);
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public void closeRequested(SybTitledPanelCloseEvent sybTitledPanelCloseEvent) {
        this.showAssistant(false);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (componentEvent.getSource() == this._panel && this._assistant != null && this._assistant.isVisible()) {
            this.showAssistant(false);
            this._showCA = true;
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    static interface ConnectionStringBuilder {
        public void addParm(String var1, String var2);
    }
}

