/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ConnectionPropertyTableCellEditor;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.PropertyMetaData;
import com.sybase.asa.logon.PropertyTable;
import com.sybase.asa.logon.PropertyTableModel;
import com.sybase.util.FontHelper;
import com.sybase.util.KeySelectionHelper;
import com.sybase.util.SybLabel;
import com.sybase.util.SybTextArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;

public abstract class AdvancedPageBase
extends JPanel
implements ListSelectionListener,
ComponentListener {
    private static final int VERT_SPACING = 8;
    private PropertyTable _table;
    private KeySelectionHelper _ksh;
    private JPanel _descrPanel;
    private SybLabel _descrLabel;
    private SybTextArea _descrText;

    public AdvancedPageBase(String string) {
        this.setName(string);
    }

    public void init() {
        this.createTable();
        this.createUI();
    }

    public abstract PropertyMetaData[] getPropertyMetaData();

    private void createUI() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this._descrPanel = new JPanel(new GridBagLayout());
        this._descrPanel.setBorder(BorderFactory.createEtchedBorder());
        this._descrLabel = new SybLabel(){

            public void invalidate() {
            }

            public void validate() {
            }

            public void revalidate() {
            }

            public void firePropertyChange(String string, Object object, Object object2) {
            }
        };
        this._descrLabel.setText(" ");
        Font font = this._descrLabel.getFont();
        this._descrLabel.setFont(font.deriveFont(1));
        this._descrText = new SybTextArea(" \n \n \n ", 4, 30);
        this._descrText.setTabMovesFocus(false);
        this._descrText.setEnabled(false);
        this._descrText.setEditable(false);
        this._descrText.setLineWrap(true);
        this._descrText.setWrapStyleWord(true);
        this._descrText.setFont(font);
        this._descrText.setDisabledTextColor(this._descrLabel.getForeground());
        this._descrText.setBackground(this._descrLabel.getBackground());
        this._descrText.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane((Component)this._descrText);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setOpaque(false);
        Dimension dimension = new Dimension(this._descrText.getPreferredSize().width, this._descrText.getPreferredSize().height + 2);
        jScrollPane.setPreferredSize(dimension);
        JScrollPane jScrollPane2 = new JScrollPane(this._table);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(125);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(240);
        Dimension dimension2 = jScrollPane2.getPreferredSize();
        dimension2.height = this._table.getRowHeight() * 8;
        jScrollPane2.setPreferredSize(dimension2);
        this._descrPanel.add((Component)this._descrLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 21, 2, new Insets(5, 5, 5, 5), 0, 0));
        this._descrPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)jScrollPane2, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 21, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._descrPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add(Box.createVerticalStrut(this._descrPanel.getPreferredSize().height), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this._table.getRowCount() > 0) {
            this._table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.addComponentListener(this);
    }

    private void createTable() {
        PropertyMetaData[] propertyMetaDataArray = this.getPropertyMetaData();
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        String[] stringArray = new String[2];
        stringArray[0] = logonResourcesBase.get("NAME");
        stringArray[1] = logonResourcesBase.get("VALUE");
        String[] stringArray2 = stringArray;
        PropertyTableModel propertyTableModel = new PropertyTableModel(propertyMetaDataArray, stringArray2);
        this._table = new PropertyTable();
        this._ksh = new KeySelectionHelper((JComponent)this._table);
        this._table.setRowSorter(new TableRowSorter<PropertyTableModel>(propertyTableModel));
        this._table.setModel(propertyTableModel);
        this._table.setInitialColumnWidths();
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setRowHeight(this._table.getRowHeight() + 2);
        this._table.setDefaultEditor(Object.class, new ConnectionPropertyTableCellEditor(this._table));
        this._table.setDefaultRenderer(Object.class, FontHelper.getTableCellRenderer());
    }

    public void destroyUI() {
        this.removeComponentListener(this);
        this._table = null;
        this._ksh.destroy();
        this._ksh = null;
        this._descrLabel = null;
        this._descrText = null;
        this._descrPanel = null;
    }

    /*
     * WARNING - void declaration
     */
    void setInitialValue(String string, String string2) {
        if (string == null || "".equals(string) || string2 == null) {
            return;
        }
        PropertyMetaData[] propertyMetaDataArray = this.getPropertyMetaData();
        PropertyMetaData propertyMetaData = null;
        for (PropertyMetaData propertyMetaData2 : propertyMetaDataArray) {
            if (string.equalsIgnoreCase(propertyMetaData2.getName()) || string.equalsIgnoreCase(propertyMetaData2.getLongName())) {
                try {
                    propertyMetaData2.setValue(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
            if (!"(other)".equalsIgnoreCase(propertyMetaData2.getName())) continue;
            propertyMetaData = propertyMetaData2;
        }
        if (propertyMetaData != null) {
            String string3 = propertyMetaData.getValue();
            if (string3 == null || "".equals(string3)) {
                String string4 = string + "=" + string2;
            } else {
                String string5 = string3 + ";" + string + "=" + string2;
            }
            try {
                void var5_9;
                propertyMetaData.setValue((String)var5_9);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    void resetProps() {
        this.commitPartialEdits();
        for (int i = 0; i < this._table.getRowCount(); ++i) {
            this._table.setValueAt("", i, 1);
        }
    }

    void commitPartialEdits() {
        if (this._table.isEditing()) {
            ((AbstractCellEditor)((Object)this._table.getCellEditor())).stopCellEditing();
        }
    }

    void enableTable(boolean bl) {
        this._table.setEnabled(bl);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PropertyMetaData[] propertyMetaDataArray;
        int n = this._table.getSelectedRow();
        if (n < 0) {
            return;
        }
        n = this._table.convertRowIndexToModel(n);
        String string = this._table.getModel().getValueAt(n, 0).toString();
        String string2 = "";
        String string3 = "";
        if (string == null || "".equals(string)) {
            this._descrLabel.setText("");
            this._descrText.setText("");
            return;
        }
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray = this.getPropertyMetaData()) {
            if (!propertyMetaData.getName().equalsIgnoreCase(string) && !propertyMetaData.getLongName().equalsIgnoreCase(string)) continue;
            string = propertyMetaData.getName();
            string2 = propertyMetaData.getDescription();
            string3 = propertyMetaData.getLongName();
            break;
        }
        if ("(other)".equalsIgnoreCase(string)) {
            this._descrLabel.setText(string);
        } else {
            this._descrLabel.setText(string3 + " [" + string + "]");
        }
        this._descrText.setText(string2);
        this._descrText.setCaretPosition(0);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.commitPartialEdits();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }
}

