/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.DSItem;
import com.sybase.asa.logon.DSTableModel;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.Preferences;
import com.sybase.util.DialogUtils;
import com.sybase.util.JREUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.win32.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BrowseDSNDialog
extends JDialog
implements ActionListener {
    private static final String SAVE_PREFIX = "BrowseDSNDialog";
    private static final String SAVE_SHOW_ALL = "ShowAll";
    private static final String ESCAPE_ACTION = "Escape";
    private boolean _retcode;
    private String _dsn;
    private LogonResourcesBase _res = null;
    private JTable _table = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybCheckBox _showAllCheckBox = null;
    private boolean _showAll;
    private String[] _driverNamePrefix = null;
    private Pattern _regexpPattern = null;

    public BrowseDSNDialog(Dialog dialog) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public BrowseDSNDialog(Frame frame) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    public boolean create(String string) {
        return this.create(string, (String[])null);
    }

    public boolean create(String string, String[] stringArray) {
        this._retcode = false;
        this._driverNamePrefix = stringArray;
        this.init(string);
        return this._retcode;
    }

    public boolean create(String string, String string2) {
        this._retcode = false;
        this._regexpPattern = Pattern.compile(string2, 2);
        this.init(string);
        return this._retcode;
    }

    private void init(String string) {
        this.createUI(string);
        this.loadPreferences();
        this.setVisible(true);
        this.savePreferences();
        this.destroyUI();
    }

    public String getDSN() {
        return this._dsn;
    }

    private void createUI(String string) {
        this._res = LogonResourcesBase.getBundle();
        this._table = new JTable();
        this._table.setShowGrid(false);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setAutoResizeMode(0);
        this._table.setSelectionMode(0);
        this._table.setPreferredScrollableViewportSize(new Dimension(460, 200));
        this.fillTable(string);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(KeyStroke.getKeyStroke(9, 0));
        this._table.setFocusTraversalKeys(0, treeSet);
        treeSet = new TreeSet();
        treeSet.add(KeyStroke.getKeyStroke(9, 1));
        this._table.setFocusTraversalKeys(1, treeSet);
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    BrowseDSNDialog.this.handleOK();
                }
            }
        });
        this._table.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowseDSNDialog.this.handleOK();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this._table.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowseDSNDialog.this.handleCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
        if (this._driverNamePrefix != null || this._regexpPattern != null) {
            this._showAllCheckBox = new SybCheckBox(this._res.get("ShowAllDataSources"));
            this._showAllCheckBox.setSelected(this._showAll);
            this._showAllCheckBox.addActionListener((ActionListener)this);
        }
        this._ok = new SybButton(this._res.get("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(this._res.get("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_ACTION, KeyStroke.getKeyStroke(27, 0, false), 2);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        if (this._showAllCheckBox != null) {
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this._showAllCheckBox, gridBagConstraints);
        }
        Component component = Box.createHorizontalGlue();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 5);
        jPanel.add((Component)this._ok, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this._cancel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.setTitle(this._res.get("Data Source Names"));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void destroyUI() {
        this._table = null;
        if (this._showAllCheckBox != null) {
            this._showAllCheckBox.removeActionListener((ActionListener)this);
            this._showAllCheckBox = null;
        }
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener((ActionListener)this);
        this._ok.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        this._ok = null;
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this._cancel = null;
        this._driverNamePrefix = null;
        DialogUtils.removeComponents((Container)this);
        this.dispose();
    }

    private void fillTable(String string) {
        Vector<DSItem> vector = new Vector<DSItem>();
        this.fillDataSourceListFromRegistry(0, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", vector);
        this.fillDataSourceListFromRegistry(1, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", vector);
        Object[] objectArray = vector.toArray();
        Arrays.sort(objectArray);
        this._table.setModel(new DSTableModel(objectArray));
        if (vector.size() > 0) {
            int n;
            if (string == null || string.length() == 0) {
                n = 0;
            } else {
                for (n = 0; n < objectArray.length; ++n) {
                    if (!objectArray[n].toString().equals(string)) continue;
                    this._table.setRowSelectionInterval(n, n);
                    break;
                }
                if (n == objectArray.length) {
                    n = 0;
                }
            }
            this._table.setRowSelectionInterval(n, n);
            Rectangle rectangle = this._table.getCellRect(n, 0, true);
            this._table.scrollRectToVisible(rectangle);
        }
        BrowseDSNDialog.setInitialColumnWidths(this._table);
    }

    public static void setInitialColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = JREUtils.getTableCellRenderer((JTable)jTable, (int)i).getTableCellRendererComponent((JTable)jTable, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            Class<?> clazz = jTable.getColumnClass(i);
            for (int j = 0; j < n2; ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Object object = jTable.getValueAt(j, i);
                if (object == null && j >= (n2 = Math.min(jTable.getRowCount(), 10))) break;
                int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
            tableColumn.setPreferredWidth(n3 += 2);
        }
        jTable.sizeColumnsToFit(-1);
    }

    private void fillDataSourceListFromRegistry(int n, String string, Vector<DSItem> vector) {
        Vector vector2 = Registry.enumerateValues((int)n, (String)string);
        if (vector2 != null) {
            int n2 = vector2.size();
            for (int i = 0; i < n2; ++i) {
                String string2 = vector2.elementAt(i).toString();
                String string3 = Registry.getValue((int)n, (String)string, (String)string2);
                if (string3 == null || string3.length() == 0 || !this.shouldShow(string3)) continue;
                vector.addElement(new DSItem(string2, string3));
            }
        }
    }

    private boolean shouldShow(String string) {
        boolean bl = this._showAll;
        if (!bl) {
            if (this._regexpPattern != null) {
                if (this._regexpPattern.matcher(string).matches()) {
                    bl = true;
                }
            } else if (this._driverNamePrefix == null) {
                bl = true;
            } else {
                for (int i = 0; i < this._driverNamePrefix.length && !(bl = string.startsWith(this._driverNamePrefix[i])); ++i) {
                }
            }
        }
        return bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_ACTION)) {
            this.handleCancel();
        } else if (this._showAllCheckBox != null && object == this._showAllCheckBox) {
            this._showAll = this._showAllCheckBox.isSelected();
            int n = this._table.getSelectedRow();
            String string = n != -1 ? this._table.getValueAt(n, 0).toString() : null;
            this.fillTable(string);
            this._table.requestFocus();
        }
    }

    private void handleOK() {
        this.setVisible(false);
        int n = this._table.getSelectedRow();
        if (n != -1) {
            this._dsn = this._table.getValueAt(n, 0).toString();
            this._retcode = true;
        } else {
            this._retcode = false;
        }
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }

    private void savePreferences() {
        Preferences.save(SAVE_PREFIX, SAVE_SHOW_ALL, this._showAll ? "1" : "0");
    }

    private void loadPreferences() {
        this._showAll = true;
        String string = Preferences.load(SAVE_PREFIX, SAVE_SHOW_ALL);
        if (string != null && string.length() != 0 && string.equalsIgnoreCase("0")) {
            this._showAll = false;
        }
    }
}

