/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.MyTableModel;
import com.sybase.asa.logon.TableItem;
import com.sybase.asa.logon.ValueEditorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.JREUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.win32.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CEProxyPortDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String PROXY_PORT_KEY = "SOFTWARE\\Microsoft\\Windows CE Services\\ProxyPorts";
    private static final String ESCAPE_ACTION = "Escape";
    private LogonResourcesBase _res = null;
    private JTable _table = null;
    private SybButton _new = null;
    private SybButton _edit = null;
    private SybButton _delete = null;
    private SybButton _ok = null;

    public static boolean areProxyPortsSupported() {
        int n;
        boolean bl = false;
        if (Registry.isInstalled() && (n = Registry.getDWORDValue((int)0, (String)"SOFTWARE\\Microsoft\\Windows CE Services", (String)"MajorVersion")) > 0) {
            bl = true;
        }
        return bl;
    }

    public static void create(JFrame jFrame) {
        CEProxyPortDialog cEProxyPortDialog = new CEProxyPortDialog(jFrame);
        cEProxyPortDialog.openDialog(jFrame);
        cEProxyPortDialog = null;
    }

    public static void create(JDialog jDialog) {
        CEProxyPortDialog cEProxyPortDialog = new CEProxyPortDialog(jDialog);
        cEProxyPortDialog.openDialog(jDialog);
        cEProxyPortDialog = null;
    }

    public static void create(Window window) {
        if (window instanceof JFrame) {
            CEProxyPortDialog.create((JFrame)window);
        } else if (window instanceof JDialog) {
            CEProxyPortDialog.create((JDialog)window);
        } else {
            throw new IllegalArgumentException("parent must be a JFrame or JDialog");
        }
    }

    private CEProxyPortDialog(JFrame jFrame) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    private CEProxyPortDialog(JDialog jDialog) {
        super((Window)jDialog, Dialog.ModalityType.DOCUMENT_MODAL);
    }

    private void openDialog(Window window) {
        this.createUI(window);
        this.setVisible(true);
        this.destroyUI();
    }

    private void createUI(Window window) {
        this._res = LogonResourcesBase.getBundle();
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(this._res.get("CE_PROXY_EXPLANATION "));
        this._table = new JTable();
        this._table.setShowGrid(false);
        this._table.getTableHeader().setReorderingAllowed(false);
        this._table.setAutoResizeMode(0);
        this._table.setSelectionMode(0);
        this._table.setPreferredScrollableViewportSize(new Dimension(460, 200));
        this.fillTable();
        this.selectTableRow(0);
        this._table.getSelectionModel().addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this._table);
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(KeyStroke.getKeyStroke(9, 0));
        this._table.setFocusTraversalKeys(0, treeSet);
        treeSet = new TreeSet();
        treeSet.add(KeyStroke.getKeyStroke(9, 1));
        this._table.setFocusTraversalKeys(1, treeSet);
        this._table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    CEProxyPortDialog.this.handleOK();
                }
            }
        });
        this._table.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CEProxyPortDialog.this.handleOK();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this._new = new SybButton(this._res.get("CE_PROXY_NEW"));
        this._new.addActionListener((ActionListener)this);
        this._edit = new SybButton(this._res.get("CE_PROXY_EDIT"));
        this._edit.addActionListener((ActionListener)this);
        this._delete = new SybButton(this._res.get("CE_PROXY_DELETE"));
        this._delete.addActionListener((ActionListener)this);
        this._ok = new SybButton(this._res.get("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)sybMultiLineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this._new, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this._edit, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this._delete, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.left = 0;
        jPanel.add((Component)this._ok, gridBagConstraints);
        this.enableButtons();
        this.getContentPane().add(jPanel);
        this.setTitle(this._res.get("CE_PROXY_PORTS_TITLE "));
        this.pack();
        this.setLocationRelativeTo(window);
    }

    private void destroyUI() {
        this._table.getSelectionModel().removeListSelectionListener(this);
        this._table = null;
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener((ActionListener)this);
        this._ok.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
        this._ok = null;
        this._new.removeActionListener((ActionListener)this);
        this._new = null;
        this._edit.removeActionListener((ActionListener)this);
        this._edit = null;
        this._delete.removeActionListener((ActionListener)this);
        this._delete = null;
        DialogUtils.removeComponents((Container)this);
        this.dispose();
    }

    private void fillTable() {
        ArrayList<TableItem> arrayList = new ArrayList<TableItem>();
        Vector vector = Registry.enumerateValues((int)0, (String)PROXY_PORT_KEY);
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string = vector.elementAt(i).toString();
                int n2 = Registry.getDWORDValue((int)0, (String)PROXY_PORT_KEY, (String)string);
                if (n2 == 0) continue;
                arrayList.add(new TableItem(n2, string));
            }
        }
        Object[] objectArray = new TableItem[arrayList.size()];
        arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        this._table.setModel(new MyTableModel((TableItem[])objectArray));
        this.setInitialColumnWidths(this._table);
    }

    private void selectTableRow(int n) {
        if (this._table.getRowCount() > 0) {
            this._table.setRowSelectionInterval(n, n);
            Rectangle rectangle = this._table.getCellRect(0, 0, true);
            this._table.scrollRectToVisible(rectangle);
        }
    }

    private void setInitialColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getColumnCount();
        int n2 = jTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n3 = JREUtils.getTableCellRenderer((JTable)jTable, (int)i).getTableCellRendererComponent(null, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            Class<?> clazz = jTable.getColumnClass(i);
            for (int j = 0; j < n2; ++j) {
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(j, i);
                Object object = jTable.getValueAt(j, i);
                if (object == null && j >= (n2 = Math.min(jTable.getRowCount(), 10))) break;
                int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
            tableColumn.setPreferredWidth(n3 += 2);
        }
        jTable.sizeColumnsToFit(-1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private void enableButtons() {
        int n = this._table.getSelectedRow();
        boolean bl = n != -1;
        this._edit.setEnabled(bl);
        this._delete.setEnabled(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._new) {
            this.handleNew();
        } else if (object == this._edit) {
            this.handleEdit();
        } else if (object == this._delete) {
            this.handleDelete();
        }
    }

    private void handleNew() {
        ValueEditorDialog valueEditorDialog = new ValueEditorDialog(this, this._res.get("NEW_PROXY_PORT_TITLE"));
        if (valueEditorDialog.create(null, "SQL Anywhere", true, 2638)) {
            String string = valueEditorDialog.getNewName();
            int n = valueEditorDialog.getNewPort();
            Registry.setDWORDValue((int)0, (String)PROXY_PORT_KEY, (String)string, (int)n);
            this.fillTable();
            int n2 = ((MyTableModel)this._table.getModel()).getRowFromPort(n);
            if (n2 != -1) {
                this.selectTableRow(n2);
            }
            this._table.requestFocusInWindow();
        }
    }

    private void handleEdit() {
        MyTableModel myTableModel = (MyTableModel)this._table.getModel();
        int n = this._table.getSelectedRow();
        TableItem tableItem = myTableModel.getItemFromRow(n);
        ValueEditorDialog valueEditorDialog = new ValueEditorDialog(this, this._res.get("EDIT_PROXY_PORT_TITLE"));
        if (valueEditorDialog.create(null, tableItem.getName(), false, tableItem.getPort())) {
            int n2 = valueEditorDialog.getNewPort();
            Registry.setDWORDValue((int)0, (String)PROXY_PORT_KEY, (String)tableItem.getName(), (int)n2);
            this.fillTable();
            n = myTableModel.getRowFromPort(n2);
            if (n != -1) {
                this.selectTableRow(n);
            }
            this._table.requestFocusInWindow();
        }
    }

    private void handleDelete() {
        int n = this._table.getSelectedRow();
        int n2 = SybOptionPane.showConfirmDialog((Component)this, (Object)this._res.get("DELETE_PROXY_PORT_TEXT"), (String)this._res.get("DELETE_PROXY_PORT_TITLE"), (int)0);
        if (n2 == 0) {
            MyTableModel myTableModel = (MyTableModel)this._table.getModel();
            TableItem tableItem = myTableModel.getItemFromRow(n);
            Registry.deleteValue((int)0, (String)PROXY_PORT_KEY, (String)tableItem.getName());
            this.fillTable();
            if (this._table.getRowCount() > 0) {
                if (n > 0) {
                    --n;
                }
                this.selectTableRow(n);
            }
        }
        this._table.requestFocusInWindow();
    }

    private void handleOK() {
        this.setVisible(false);
    }
}

