/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.Preferences;
import com.sybase.asa.logon.PropertyMetaData;
import com.sybase.asa.logon.PropertyTableModel;
import com.sybase.util.FontHelper;
import com.sybase.util.NumericTextField;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;

class ConnectionPropertyTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final String ACTN_CANCEL_EDITING = "0";
    private static final String SAVE_LAST_FOLDER_USED = "lastFolderUsed";
    private static final String SAVE_PREFIX = "ConnectionPropertyTableCellEditor";
    private JTable _table;
    private PropertyMetaData _data;
    private SybComboBox _comboBox;
    private JTextField _textField;
    private JPasswordField _passwordField;
    private FilePropEditorComponent _fileField;
    private NumericTextField _numericTextField;

    ConnectionPropertyTableCellEditor(JTable jTable) {
        this._table = jTable;
        this._comboBox = new SybComboBox();
        Component component = this._comboBox.getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            new FontHelper((JTextComponent)component);
        }
        this._textField = new JTextField();
        new FontHelper((JTextComponent)this._textField);
        this._numericTextField = new NumericTextField();
        this._passwordField = new JPasswordField();
        this._textField.setHorizontalAlignment(2);
        this._comboBox.setEditable(false);
        this._fileField = new FilePropEditorComponent();
        this._comboBox.setBorder(BorderFactory.createLineBorder(this._comboBox.getForeground()));
        this._textField.setBorder(BorderFactory.createLineBorder(this._textField.getForeground()));
        this._textField.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._passwordField.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._comboBox.registerKeyboardAction((ActionListener)this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
        this._fileField._editor.registerKeyboardAction(this, ACTN_CANCEL_EDITING, KeyStroke.getKeyStroke(27, 0), 0);
    }

    @Override
    public Object getCellEditorValue() {
        switch (this._data.getType()) {
            case BOOLEAN: {
                return this._comboBox.getSelectedItem();
            }
            case ENUM: {
                if (this._data.isEnumAllowsEdits()) {
                    return this._comboBox.getEditor().getItem();
                }
                return this._comboBox.getSelectedItem();
            }
            case FILE: {
                return this._fileField._editor.getText().trim();
            }
            case PASSWORD: {
                return new String(this._passwordField.getPassword());
            }
            case INTEGER: {
                return this._numericTextField.getText();
            }
        }
        return this._textField.getText().trim();
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        PropertyTableModel propertyTableModel = (PropertyTableModel)this._table.getModel();
        this._textField.setText("");
        this._passwordField.setText("");
        this._comboBox.removeAllItems();
        this._fileField._editor.setText("");
        if (object == null) {
            object = "";
        }
        if (n >= 0) {
            n = this._table.convertRowIndexToModel(n);
            try {
                this._data = propertyTableModel.getMetaDataForRow(n);
            }
            catch (Exception exception) {
                this._data = null;
            }
        } else {
            this._data = null;
        }
        if (this._data == null) {
            this._textField.setText(object.toString());
            return this._textField;
        }
        switch (this._data.getType()) {
            case BOOLEAN: {
                this._comboBox.addItem((Object)"");
                this._comboBox.addItem((Object)"YES");
                this._comboBox.addItem((Object)"NO");
                this._comboBox.setSelectedItem(object);
                this._comboBox.setEditable(false);
                return this._comboBox;
            }
            case ENUM: {
                String[] stringArray = this._data.getEnumValues();
                if (stringArray == null) {
                    this._textField.setText(object.toString());
                    return this._textField;
                }
                this._comboBox.addItem((Object)"");
                for (String string : stringArray) {
                    this._comboBox.addItem((Object)string);
                }
                this._comboBox.setSelectedItem(object);
                if (this._data.isEnumAllowsEdits()) {
                    this._comboBox.setEditable(true);
                } else {
                    this._comboBox.setEditable(false);
                }
                return this._comboBox;
            }
            case FILE: {
                this._fileField._editor.setText(object.toString());
                return this._fileField;
            }
            case PASSWORD: {
                this._passwordField.setText(object.toString());
                return this._passwordField;
            }
            case INTEGER: {
                this._numericTextField.setAllowUnit(this._data.getHasUnits());
                this._numericTextField.setText("");
                this._numericTextField.setText(object.toString());
                return this._numericTextField;
            }
        }
        this._textField.setText(object.toString());
        return this._textField;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if ((object == this._textField || object == this._comboBox || object == this._fileField._editor) && actionEvent.getActionCommand().equals(ACTN_CANCEL_EDITING)) {
            this.cancelCellEditing();
        }
    }

    class FilePropEditorComponent
    extends JPanel
    implements ActionListener {
        JTextField _editor = new JTextField();
        SybButton _button;

        FilePropEditorComponent() {
            this._editor.setHorizontalAlignment(2);
            new FontHelper((JTextComponent)this._editor);
            this._button = new SybButton("...");
            this._button.setFocusable(false);
            this._button.setMargin(new Insets(2, 2, 2, 2));
            if (Platform.isMacOS()) {
                FontMetrics fontMetrics = this._button.getFontMetrics(this._button.getFont());
                int n = fontMetrics.stringWidth(this._button.getText());
                this._button.setPreferredSize(new Dimension(n + 8, this._button.getPreferredSize().height));
            }
            this._editor.setBorder(BorderFactory.createLineBorder(this._editor.getForeground()));
            this.setLayout(new BorderLayout());
            this.add((Component)this._editor, "Center");
            this.add((Component)this._button, "East");
            this._button.addActionListener((ActionListener)this);
        }

        @Override
        public void requestFocus() {
            this._editor.requestFocus();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._button) {
                this.browseForFile();
            }
        }

        private void browseForFile() {
            LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
            SybFileChooser sybFileChooser = new SybFileChooser(17);
            String string = Preferences.load(ConnectionPropertyTableCellEditor.SAVE_PREFIX, ConnectionPropertyTableCellEditor.SAVE_LAST_FOLDER_USED);
            if (string == null) {
                string = System.getProperty("user.dir");
            }
            File file = new File(string);
            String string2 = this._editor.getText();
            File file2 = string2 != null && !string2.isEmpty() ? new File(string2) : null;
            sybFileChooser.setTitle(logonResourcesBase.get("Browse Files"));
            if (sybFileChooser.showDialog(SwingUtilities.getWindowAncestor(ConnectionPropertyTableCellEditor.this._table), file, file2)) {
                File file3 = sybFileChooser.getSelectedFile();
                this._editor.setText(file3.toString());
                Preferences.save(ConnectionPropertyTableCellEditor.SAVE_PREFIX, ConnectionPropertyTableCellEditor.SAVE_LAST_FOLDER_USED, file3.getParent());
            }
        }
    }
}

