/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ASAConnect;
import com.sybase.asa.logon.ASAHostInformation;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.util.DialogUtils;
import com.sybase.util.KeySelectionHelper;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.ImageObserver;
import java.net.InetAddress;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;

class FindServerDialog
extends JDialog
implements ActionListener {
    private static final String ESCAPE_ACTION = "Escape";
    private static final String LOCALHOST = "localhost";
    private static final String LOOPBACK = "127.0.0.1";
    private static Rectangle _bounds = null;
    private boolean _retcode;
    private String _host;
    private int _port;
    private String _serverName;
    private boolean _onlyShowLocal;
    private LogonResourcesBase _res = null;
    private JTable _serverList = null;
    private KeySelectionHelper _keySelectionHelper = null;
    private SybCheckBox _localOnlyCheck = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;

    FindServerDialog(Frame frame) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._onlyShowLocal = false;
    }

    FindServerDialog(Dialog dialog) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this._onlyShowLocal = false;
    }

    FindServerDialog(Frame frame, boolean bl) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._onlyShowLocal = bl;
    }

    FindServerDialog(Dialog dialog, boolean bl) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this._onlyShowLocal = bl;
    }

    boolean create() {
        this._retcode = false;
        this.createUI();
        this.setVisible(true);
        this.destroyUI();
        return this._retcode;
    }

    int getPort() {
        return this._port;
    }

    String getHost() {
        return this._host;
    }

    String getServerName() {
        return this._serverName;
    }

    private void createUI() {
        this._res = LogonResourcesBase.getBundle();
        MyTableModel myTableModel = new MyTableModel();
        this._serverList = new JTable(myTableModel);
        this._keySelectionHelper = new KeySelectionHelper((JComponent)this._serverList);
        TableRowSorter<MyTableModel> tableRowSorter = new TableRowSorter<MyTableModel>(myTableModel);
        tableRowSorter.setRowFilter(new MyRowFilter());
        this._serverList.setRowSorter(tableRowSorter);
        this._serverList.getTableHeader().setReorderingAllowed(false);
        this._serverList.setShowVerticalLines(false);
        this._serverList.setShowHorizontalLines(false);
        this._serverList.setPreferredScrollableViewportSize(new Dimension(450, (this._serverList.getRowHeight() + this._serverList.getRowMargin()) * 8));
        this._serverList.setDefaultRenderer(Object.class, new CellRenderer());
        this._serverList.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this._serverList);
        InputMap inputMap = this._serverList.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "null");
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "null");
        TreeSet<KeyStroke> treeSet = new TreeSet<KeyStroke>();
        treeSet.add(KeyStroke.getKeyStroke(9, 0));
        this._serverList.setFocusTraversalKeys(0, treeSet);
        treeSet = new TreeSet();
        treeSet.add(KeyStroke.getKeyStroke(9, 1));
        this._serverList.setFocusTraversalKeys(1, treeSet);
        this._serverList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FindServerDialog.this.handleOK();
                }
            }
        });
        this._localOnlyCheck = new SybCheckBox(this._res.get("ONLY_SHOW_LOCAL_SERVERS"), this._onlyShowLocal);
        this._localOnlyCheck.addActionListener((ActionListener)this);
        this.fillServerList(myTableModel);
        this._ok = new SybButton(this._res.get("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(this._res.get("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_ACTION, KeyStroke.getKeyStroke(27, 0, false), 2);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this._localOnlyCheck, gridBagConstraints);
        Component component = Box.createHorizontalGlue();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 5);
        jPanel.add((Component)this._ok, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this._cancel, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.setTitle(this._res.get("Find Servers"));
        this.pack();
        this.setMinimumSize(this.getPreferredSize());
        if (_bounds != null) {
            this.setBounds(_bounds);
            UIUtils.ensureWindowIsVisible((Window)this);
        } else {
            this.setLocationRelativeTo(this.getParent());
        }
        this._serverList.requestFocus();
    }

    private void destroyUI() {
        _bounds = this.getBounds();
        this._keySelectionHelper.destroy();
        this._keySelectionHelper = null;
        this._serverList = null;
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._localOnlyCheck.removeActionListener((ActionListener)this);
        this._localOnlyCheck = null;
        this.getRootPane().setDefaultButton(null);
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        DialogUtils.removeComponents((Container)this);
    }

    private void fillServerList(MyTableModel myTableModel) {
        FindingServersDlg findingServersDlg = new FindingServersDlg((JDialog)this.getParent());
        Vector vector = findingServersDlg.hosts;
        Vector vector2 = findingServersDlg.names;
        Vector vector3 = findingServersDlg.ports;
        int n = vector.size();
        Object[] objectArray = new ASAHostInformation[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new ASAHostInformation(vector2.elementAt(i).toString(), vector.elementAt(i).toString(), (Integer)vector3.elementAt(i));
        }
        myTableModel.setDataArray(objectArray);
        this.applyFilter();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_ACTION)) {
            this.handleCancel();
        } else if (object == this._localOnlyCheck) {
            this.applyFilter();
        }
    }

    private void handleOK() {
        this.setVisible(false);
        int n = this._serverList.getSelectedRow();
        if (n != -1) {
            MyTableModel myTableModel = (MyTableModel)this._serverList.getModel();
            n = this._serverList.convertRowIndexToModel(n);
            ASAHostInformation aSAHostInformation = myTableModel.getRowObject(n);
            this._host = aSAHostInformation.addr;
            this._port = aSAHostInformation.port;
            this._serverName = aSAHostInformation.name;
            this._retcode = true;
        } else {
            this._retcode = false;
        }
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }

    private void applyFilter() {
        String string = null;
        String string2 = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string = inetAddress.getHostName();
            string2 = inetAddress.getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = LOCALHOST;
        }
        if (string2 == null) {
            string2 = LOOPBACK;
        }
        boolean bl = this._localOnlyCheck.isSelected();
        MyTableModel myTableModel = (MyTableModel)this._serverList.getModel();
        int n = myTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            ASAHostInformation aSAHostInformation = myTableModel.getRowObject(i);
            aSAHostInformation.isVisible = bl ? string.equalsIgnoreCase(aSAHostInformation.addr) || LOCALHOST.equalsIgnoreCase(aSAHostInformation.addr) || string2.equalsIgnoreCase(aSAHostInformation.addr) || LOOPBACK.equalsIgnoreCase(aSAHostInformation.addr) || string2.equals(aSAHostInformation.getDottedIP()) : true;
        }
        myTableModel.fireTableDataChanged();
    }

    static class FindingServersDlg
    extends JDialog
    implements Runnable,
    ActionListener {
        Vector hosts = new Vector();
        Vector names = new Vector();
        Vector ports = new Vector();
        private boolean _done;
        private SybButton _cancel;
        private SybLabel _label;

        FindingServersDlg(Dialog dialog) {
            super(dialog, true);
            this.createGUI();
            this.setLocationRelativeTo(dialog);
            this._done = false;
            Thread thread = new Thread(this);
            thread.start();
            if (!this._done) {
                this.setVisible(true);
            }
            this.destroyGUI();
        }

        private void createGUI() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
            ImageIcon imageIcon = new ImageIcon(LogonImages.getFindServer());
            this._label = new SybLabel(logonResourcesBase.get("Looking for servers..."));
            this._label.setIcon((Icon)imageIcon);
            this._label.setIconTextGap(10);
            imageIcon.setImageObserver((ImageObserver)this._label);
            jPanel.add((Component)this._label);
            jPanel.add(Box.createVerticalStrut(5));
            JPanel jPanel2 = new JPanel();
            this._cancel = new SybButton(logonResourcesBase.get("Cancel"));
            jPanel2.add((Component)this._cancel);
            jPanel2.setAlignmentX(0.0f);
            jPanel.add(jPanel2);
            this._cancel.addActionListener((ActionListener)this);
            this.setTitle(logonResourcesBase.get("Find Servers"));
            this.getContentPane().add(jPanel);
            this.pack();
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._cancel) {
                this.setVisible(false);
            }
        }

        private void destroyGUI() {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
            DialogUtils.removeComponents((Container)this);
        }

        @Override
        public void run() {
            try {
                ASAConnect.findServers(this.names, this.hosts, this.ports);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
            this._done = true;
            this.setVisible(false);
        }
    }

    static class MyRowFilter
    extends RowFilter<MyTableModel, Integer> {
        MyRowFilter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends MyTableModel, ? extends Integer> entry) {
            MyTableModel myTableModel = entry.getModel();
            int n = entry.getIdentifier();
            ASAHostInformation aSAHostInformation = myTableModel.getRowObject(n);
            return aSAHostInformation.isVisible;
        }
    }

    static class MyTableModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private Object[] _data;

        MyTableModel() {
            LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
            this._data = new ASAHostInformation[0];
            String[] stringArray = new String[3];
            stringArray[0] = logonResourcesBase.get("Name");
            stringArray[1] = logonResourcesBase.get("Address");
            stringArray[2] = logonResourcesBase.get("Port");
            this._columnNames = stringArray;
        }

        void setDataArray(Object[] objectArray) {
            this._data = objectArray;
            this.fireTableDataChanged();
        }

        ASAHostInformation getRowObject(int n) {
            return (ASAHostInformation)this._data[n];
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._data.length;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string;
            ASAHostInformation aSAHostInformation = (ASAHostInformation)this._data[n];
            switch (n2) {
                case 0: {
                    string = aSAHostInformation.name;
                    break;
                }
                case 1: {
                    string = aSAHostInformation.addr;
                    break;
                }
                case 2: {
                    string = Integer.toString(aSAHostInformation.port);
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    static class CellRenderer
    extends DefaultTableCellRenderer {
        private static final ImageIcon _serverIcon = new ImageIcon(LogonImages.getHost());

        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setIcon(_serverIcon);
            } else {
                this.setIcon(null);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

