/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.util.DialogUtils;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class GenerateODBCDataSourceDialog
extends JDialog
implements ActionListener,
DocumentListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private boolean _showTypeControls;
    private ASAConnectionInfo _info;
    private SybButton _ok;
    private SybButton _cancel;
    private SybLabel _dsnLabel;
    private JTextField _dsnField;
    private SybLabel _dsTypeLabel;
    private SybRadioButton _userDsType;
    private SybRadioButton _sysDsType;
    private SybCheckBox _saveUidAndPwd;
    private SybMultiLineLabel _saveWarningLabel;
    private JPanel _panel;

    GenerateODBCDataSourceDialog(Dialog dialog, ASAConnectionInfo aSAConnectionInfo) {
        super((Window)dialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this._info = aSAConnectionInfo;
        this._showTypeControls = Platform.isWindows();
    }

    GenerateODBCDataSourceDialog(Frame frame, ASAConnectionInfo aSAConnectionInfo) {
        super((Window)frame, Dialog.ModalityType.DOCUMENT_MODAL);
        this._info = aSAConnectionInfo;
        this._showTypeControls = Platform.isWindows();
    }

    void create() {
        this.createUI();
        this.setVisible(true);
        this.destroyUI();
    }

    private void createUI() {
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        this._ok = Platform.isVista() ? new SybButton(logonResourcesBase.get("SAVE_AS_DS_SAVE_BUTTON"), (Icon)ASAComponentsImageLoader.getImageIcon((String)"vistashield", (int)1001)) : new SybButton(logonResourcesBase.get("SAVE_AS_DS_SAVE_BUTTON"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._ok.setEnabled(false);
        this._cancel = new SybButton(logonResourcesBase.get("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0), 1);
        this._dsnLabel = new SybLabel(logonResourcesBase.get("GENERATE_DS_DSN"));
        this._dsnField = new JTextField();
        this._dsnField.setHorizontalAlignment(2);
        this._dsnLabel.setLabelFor((Component)this._dsnField);
        this._dsnField.getDocument().addDocumentListener(this);
        if (this._showTypeControls) {
            this._dsTypeLabel = new SybLabel(logonResourcesBase.get("GENERATE_DS_SELECT_TYPE"));
            this._userDsType = new SybRadioButton(logonResourcesBase.get("GENERATE_DS_USER_TYPE"), true);
            this._sysDsType = new SybRadioButton(logonResourcesBase.get("GENERATE_DS_SYSTEM_TYPE"), false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this._userDsType);
            buttonGroup.add((AbstractButton)this._sysDsType);
        }
        this._saveUidAndPwd = new SybCheckBox(logonResourcesBase.get("GENERATE_DS_SAVE_CRED"), false);
        this._saveWarningLabel = new SybMultiLineLabel(logonResourcesBase.get("SAVE_AS_DS_SAVE_CRED_WARNING"), 100);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        this._panel = new JPanel(new GridBagLayout());
        this._panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._panel.add((Component)this._dsnLabel, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
        this._panel.add((Component)this._dsnField, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 15, 0), 0, 0));
        if (this._showTypeControls) {
            this._panel.add((Component)this._dsTypeLabel, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 5, 0), 0, 0));
            this._panel.add((Component)this._userDsType, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 0, 0), 0, 0));
            this._panel.add((Component)this._sysDsType, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 15, 0), 0, 0));
        }
        this._panel.add((Component)this._saveUidAndPwd, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        this._panel.add((Component)this._saveWarningLabel, new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 21, 2, new Insets(0, 20, 20, 0), 0, 0));
        this._panel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 21, 2, new Insets(8, 0, 0, 0), 0, 0));
        this._panel.add((Component)this._ok, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 5), 0, 0));
        this._panel.add((Component)this._cancel, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.getContentPane().add(this._panel);
        this.setTitle(logonResourcesBase.get("SAVE_AS_DS_TITLE"));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void destroyUI() {
        this.getRootPane().setDefaultButton(null);
        this._ok.removeActionListener((ActionListener)this);
        this._ok = null;
        this._cancel.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._dsnLabel = null;
        this._dsnField = null;
        this._dsTypeLabel = null;
        this._userDsType = null;
        this._sysDsType = null;
        this._saveUidAndPwd = null;
        this._saveWarningLabel = null;
        DialogUtils.removeComponents((Container)this._panel);
        this._panel = null;
    }

    private void handleOK() {
        int n;
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        String string = this._dsnField.getText();
        if (string == null || string.isEmpty()) {
            SybOptionPane.showMessageDialog((Component)this, (Object)logonResourcesBase.get("GENERATE_DS_NO_NAME_ERR"), (String)this.getTitle(), (int)0);
            return;
        }
        if (ODBCUtils.isValidDSN(string)) {
            n = SybOptionPane.showConfirmDialog((Component)this, (Object)logonResourcesBase.get("GENERATE_DS_DSN_EXISTS"), (String)this.getTitle(), (int)1);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.setVisible(false);
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        if (!this._saveUidAndPwd.isSelected()) {
            this._info.userid = null;
            this._info.password = null;
        }
        n = 0;
        if (this._showTypeControls && this._sysDsType.isSelected()) {
            n = 1;
        }
        this._info.saveAsDSN(n, string);
        this.setVisible(false);
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private void handleDocumentChange() {
        String string = this._dsnField.getText();
        if (string != null && !string.isEmpty()) {
            this._ok.setEnabled(true);
        } else {
            this._ok.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.handleCancel();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._dsnField.getDocument()) {
            this.handleDocumentChange();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._dsnField.getDocument()) {
            this.handleDocumentChange();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (documentEvent.getDocument() == this._dsnField.getDocument()) {
            this.handleDocumentChange();
        }
    }
}

