/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.Dbg;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.logon.AbstractConnectionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public final class GenericConnectionInfo
extends AbstractConnectionInfo {
    public static final String PID_USERNAME = "UID";
    public static final String PID_PASSWORD = "PWD";
    public static final String PID_DSN = "DSN";
    public static final String PID_FILEDSN = "FILEDSN";
    public static final String PID_DRIVER = "DRIVER";
    private static String[] SupportedParameters = new String[]{"UID", "PWD", "DSN", "FILEDSN", "DRIVER"};
    protected Properties _props;

    public GenericConnectionInfo() {
        this.resetFields();
    }

    public GenericConnectionInfo(GenericConnectionInfo genericConnectionInfo) {
        this.resetFields();
        if (genericConnectionInfo != null) {
            this.merge(genericConnectionInfo);
        }
    }

    @Override
    public int getDatabaseType() {
        return 99;
    }

    public void setParameter(String string, String string2) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (string2 != null) {
            this._props.setProperty(string, string2);
        } else {
            this._props.remove(string);
        }
    }

    public String getParameter(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return this._props.getProperty(string);
    }

    private String findPropertyNameIgnoreCase(String string) {
        String string2 = null;
        Enumeration<?> enumeration = this._props.propertyNames();
        while (enumeration.hasMoreElements() && !(string2 = (String)enumeration.nextElement()).equalsIgnoreCase(string)) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public String getUserName() {
        return this._props.getProperty(PID_USERNAME);
    }

    @Override
    public void setUserName(String string) {
        if (string == null) {
            this._props.remove(PID_USERNAME);
        } else {
            this._props.setProperty(PID_USERNAME, string);
        }
    }

    @Override
    public String getPassword() {
        return this._props.getProperty(PID_PASSWORD);
    }

    @Override
    public void setPassword(String string) {
        if (string == null) {
            this._props.remove(PID_PASSWORD);
        } else {
            this._props.setProperty(PID_PASSWORD, string);
        }
    }

    Enumeration getParameterNames() {
        return this._props.propertyNames();
    }

    @Override
    public Object clone() {
        GenericConnectionInfo genericConnectionInfo = new GenericConnectionInfo(this);
        return genericConnectionInfo;
    }

    @Override
    public boolean canAttemptConnection() {
        String string = this.getParameter(PID_DSN);
        String string2 = this.getParameter(PID_FILEDSN);
        boolean bl = string != null && string.length() > 0 || string2 != null && string2.length() > 0;
        return bl;
    }

    @Override
    public String getURL() {
        String string;
        String string2;
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder(128);
        String string4 = this.getParameter(PID_DSN);
        String string5 = this.getParameter(PID_FILEDSN);
        stringBuilder.append("jdbc:ianywhere:");
        if (string4 != null) {
            stringBuilder.append("dsn=");
            stringBuilder.append(string4.trim());
        } else if (string5 != null) {
            stringBuilder.append("filedsn=");
            stringBuilder.append(string5.trim());
        } else {
            string2 = this.findPropertyNameIgnoreCase(PID_DRIVER);
            if (string2 != null && (string = this._props.getProperty(string2)) != null) {
                stringBuilder.append(string2);
                stringBuilder.append('=');
                stringBuilder.append(string);
            }
        }
        Enumeration<?> enumeration = this._props.propertyNames();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.equalsIgnoreCase(PID_DRIVER) || string2.equalsIgnoreCase(PID_DSN) || string2.equalsIgnoreCase(PID_FILEDSN)) continue;
            string = this._props.getProperty(string2);
            stringBuilder.append(';');
            stringBuilder.append(string2);
            stringBuilder.append('=');
            stringBuilder.append(string);
        }
        string3 = stringBuilder.toString();
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        Connection connection;
        block21: {
            connection = null;
            String string = this.getURL();
            try {
                int n;
                Properties properties = new Properties();
                String string2 = "\u00e3\u00fc\u00dd\u00db\u0084\u00e6\u00e3\u00e9";
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < string2.length(); ++n) {
                    stringBuffer.append((char)(string2.charAt(n) ^ 0xAA));
                }
                properties.setProperty("licfile", stringBuffer.toString());
                String string3 = "\u00ee\u00cb\u00c6\u00cf\u00ef\u00cb\u00d8\u00c4\u00c2\u00cb\u00d8\u00ce\u00de\u00e6\u00c3\u00dc\u00cf\u00d9\u00ec\u00c5\u00d8\u00cf\u00dc\u00cf";
                stringBuffer = new StringBuffer();
                for (n = 0; n < string3.length(); ++n) {
                    stringBuffer.append((char)(string3.charAt(n) ^ 0xAA));
                }
                properties.setProperty("licpwd", stringBuffer.toString());
                Driver driver = JDBCDrivers.loadIAnywhereJDBCODBCDriver(this._classLoader);
                connection = driver.connect(string, properties);
                try {
                    connection.setAutoCommit(false);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    String string4;
                    DatabaseMetaData databaseMetaData;
                    String string5;
                    if (!Dbg.shouldSendAuthenticationString() || (string5 = (databaseMetaData = connection.getMetaData()).getDatabaseProductName()).indexOf("SQL Anywhere") == -1 || (string4 = ASAConnectionInfo.getSelfAuthenticationSQL()) == null || string4.isEmpty()) break block21;
                    Statement statement = connection.createStatement();
                    try {
                        statement.execute(string4);
                    }
                    catch (SQLException sQLException) {
                    }
                    finally {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (ClassNotFoundException classNotFoundException) {
                SQLException sQLException = new SQLException("The iAnywhere JDBC Driver could not be loaded.");
                sQLException.initCause(classNotFoundException);
                throw sQLException;
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        return connection;
    }

    @Override
    public String getConnectionString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < SupportedParameters.length; ++i) {
            String string = this._props.getProperty(SupportedParameters[i]);
            if (string == null || string.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(SupportedParameters[i]);
            stringBuffer.append('=');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public void mergeConnectionString(String string) {
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String string2 = connectionStringTokenizer.nextToken();
            this.setConnectionInfoDataFromToken(string2);
        }
    }

    private void setConnectionInfoDataFromToken(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n) + '=' + string.substring(n + 1);
            } else {
                return;
            }
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.setConnectionInfoDataFromNameValue(string2, string3);
    }

    private void setConnectionInfoDataFromNameValue(String string, String string2) {
        if (string.equalsIgnoreCase(PID_USERNAME) || string.equalsIgnoreCase("UserID")) {
            this._props.setProperty(PID_USERNAME, string2);
        } else if (string.equalsIgnoreCase(PID_PASSWORD) || string.equalsIgnoreCase("Password")) {
            this._props.setProperty(PID_PASSWORD, string2);
        } else if (string.equalsIgnoreCase(PID_DSN) || string.equalsIgnoreCase("DataSourceName")) {
            this._props.setProperty(PID_DSN, string2);
        } else if (string.equalsIgnoreCase("FileDSN") || string.equalsIgnoreCase("FileDataSourceName")) {
            this._props.setProperty(PID_FILEDSN, string2);
        } else {
            this._props.setProperty(string, string2);
        }
    }

    public void merge(GenericConnectionInfo genericConnectionInfo) {
        for (int i = 0; i < SupportedParameters.length; ++i) {
            String string = genericConnectionInfo.getParameter(SupportedParameters[i]);
            if (string == null || string.length() <= 0) continue;
            this._props.setProperty(SupportedParameters[i], string);
        }
    }

    protected boolean shouldEncrypt(String string) {
        return string.equals(PID_PASSWORD);
    }

    @Override
    public String serialize() {
        int n = this._props.size();
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        Enumeration<Object> enumeration = this._props.keys();
        for (int i = 0; i < n; ++i) {
            String string;
            stringArray[i] = string = enumeration.nextElement().toString();
            String string2 = this._props.getProperty(string);
            stringArray2[i] = this.shouldEncrypt(string) ? this.encryptPassword(string2) : string2;
        }
        return this.defaultSerializer(stringArray, stringArray2);
    }

    @Override
    public void deserialize(String string) {
        String[] stringArray = this.defaultDeserializer(string);
        if (stringArray != null) {
            this.resetFields();
            for (int i = 0; i < stringArray.length; i += 2) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                if (this.shouldEncrypt(string2)) {
                    this._props.put(string2, this.decryptPassword(string3));
                    continue;
                }
                this._props.put(string2, string3);
            }
        }
    }

    private void resetFields() {
        this._props = new Properties();
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

