/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.BrowseDSNDialog;
import com.sybase.asa.logon.GenericConnectionInfo;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.LogonSourceHost;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.asa.logon.Preferences;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.MRUComboBox;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import com.sybase.util.SybTextArea;
import com.sybase.util.win32.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class GenericDatabaseSource
implements LogonSource,
ActionListener,
ItemListener {
    private static final String SAVE_PREFIX = "GenericDatabaseSource";
    private static final String SAVE_DSN = "DSN";
    private static final String SAVE_FDSN = "FDSN";
    private static final String SAVE_LAST_DBF_FOLDER = "lastDBFFolder";
    private static final String SAVE_LAST_FDSN_FOLDER = "lastFDSNFolder";
    private static final String DELETE_KEY_COMMAND = "deleteKey";
    private static final String INSERT_KEY_COMMAND = "insertKey";
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private JTabbedPane _tabbedPane = null;
    private JPanel _identificationPanel = null;
    private JPanel _advancedPanel = null;
    private JTextField _userid = null;
    private JTextField _password = null;
    private SybRadioButton _dsnProfile = null;
    private SybRadioButton _fdsnProfile = null;
    private MRUComboBox _dsn = null;
    private MRUComboBox _fdsn = null;
    private SybButton _browseDSN = null;
    private SybButton _openODBCAdmin = null;
    private SybButton _browseFDSN = null;
    private static final int NO_PROFILE = 0;
    private static final int DSN_PROFILE = 1;
    private static final int FDSN_PROFILE = 2;
    private SybTextArea _advanced = null;
    private ClassLoader _classLoader = null;
    private boolean _simplified = false;
    private String _helpJARLocation = null;
    private String _helpPrefix;
    private String _helpSuffix;
    private HelpViewer _helpViewer = null;
    private LogonResourcesBase _res = null;
    private JPanel _panel = null;
    private GenericConnectionInfo _initialConnectionInfo = null;
    private Exception _initialException = null;
    private LogonSourceHost _host = null;
    private static final int TEST_CONNECTION_TOOL_ID = 1;

    public GenericDatabaseSource(int n) {
        this._simplified = (n & 1) != 0;
        this._res = LogonResourcesBase.getBundle();
    }

    @Override
    public void setLogonSourceHost(LogonSourceHost logonSourceHost) {
        this._host = logonSourceHost;
    }

    @Override
    public void notifyLogonSourceSelected(boolean bl) {
        this._host.enableOKButton(true);
    }

    @Override
    public void notifyConnectOK() {
        Preferences.save(SAVE_PREFIX, SAVE_DSN, this._dsn.getMRUList());
        Preferences.save(SAVE_PREFIX, SAVE_FDSN, this._fdsn.getMRUList());
    }

    @Override
    public void setInitialConnectionInfo(AbstractConnectionInfo abstractConnectionInfo) {
        if (abstractConnectionInfo instanceof GenericConnectionInfo) {
            this._initialConnectionInfo = (GenericConnectionInfo)abstractConnectionInfo;
        }
    }

    @Override
    public void destroy() {
        this.destroyGUI();
        this._res = null;
        this._initialConnectionInfo = null;
        this._helpViewer = null;
        this._host = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel.getPreferredSize();
    }

    @Override
    public JPanel getPanel(int n) {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel;
    }

    @Override
    public String getHelpContextId() {
        String string;
        if (this._simplified) {
            string = "HELP_GENERIC_DB_SRC_PAGE_1";
        } else {
            switch (this._tabbedPane.getSelectedIndex()) {
                default: {
                    string = "HELP_GENERIC_DB_SRC_PAGE_1";
                    break;
                }
                case 1: {
                    string = "HELP_GENERIC_DB_SRC_PAGE_2";
                }
            }
        }
        return string;
    }

    private void buildConnectionString(ConnectionStringBuilder connectionStringBuilder) {
        String string;
        if (this._dsnProfile.isSelected()) {
            string = this._dsn.getStringValue();
            if (string != null && string.length() != 0) {
                connectionStringBuilder.addParm(SAVE_DSN, string);
            }
        } else if (this._fdsnProfile.isSelected() && (string = this._fdsn.getStringValue()) != null && string.length() != 0) {
            connectionStringBuilder.addParm("FileDSN", string);
        }
        if (this._advanced != null && (string = this._advanced.getText().trim()).length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf("=");
                if (n == -1 || (string2 = string3.substring(0, n).trim()).length() == 0) continue;
                String string4 = string3.substring(n + 1).trim();
                connectionStringBuilder.addParm(string2, string4);
            }
        }
    }

    @Override
    public void setInitialFocus() {
        if (this._initialException != null) {
            this.displayError(this._initialException);
            this._initialException = null;
        } else {
            this._userid.requestFocus();
        }
    }

    private void createGUI() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        if (this._simplified) {
            this._identificationPanel = this.createIdentificationPanel();
            this._panel.add(this._identificationPanel);
        } else {
            this._tabbedPane = new JTabbedPane();
            this._identificationPanel = this.createIdentificationPanel();
            this._tabbedPane.addTab(this._identificationPanel.getName(), this._identificationPanel);
            this._advancedPanel = this.createAdvancedPanel();
            this._tabbedPane.addTab(this._advancedPanel.getName(), this._advancedPanel);
            this._panel.add(this._tabbedPane);
        }
        this.setInitialValues();
        this.enableControls();
    }

    private JPanel createIdentificationPanel() {
        int n = 0;
        JPanel jPanel = new JPanel();
        jPanel.setName(this._res.get("Identification"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        ImageIcon imageIcon = new ImageIcon(LogonImages.getIdentification());
        SybLabel sybLabel = new SybLabel(this._res.get("The following values are used to identify yourself to the database"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("User:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._userid = new JTextField(10);
        new FontHelper((JTextComponent)this._userid);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._userid, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._userid);
        sybLabel = new SybLabel(this._res.get("Password:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 16, 0, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._password = new JPasswordField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel2.add((Component)this._password, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._password);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        n = 0;
        imageIcon = new ImageIcon(LogonImages.getProfile());
        sybLabel = new SybLabel(this._res.get("GENERIC_DATABASE_INSTRUCTIONS"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)sybLabel, gridBagConstraints);
        this._dsnProfile = new SybRadioButton(this._res.get("ODBC Data Source Name"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        jPanel3.add((Component)this._dsnProfile, gridBagConstraints);
        String string = Preferences.load(SAVE_PREFIX, SAVE_DSN);
        if (string != null && string.length() != 0) {
            string = this.removeBogusDataSources(string);
        }
        this._dsn = new MRUComboBox(string);
        new FontHelper((JComboBox)this._dsn);
        GenericDatabaseSource.setMRUComboBoxPreferredWidth(this._dsn, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        jPanel3.add((Component)this._dsn, gridBagConstraints);
        this._browseDSN = new SybButton(this._res.get("&Browse..."));
        this._browseDSN.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel3.add((Component)this._browseDSN, gridBagConstraints);
        if (System.getProperty("os.name").indexOf("Windows") >= 0) {
            this._openODBCAdmin = new SybButton((Icon)new ImageIcon(LogonImages.getOdbc()));
            this._openODBCAdmin.setMargin(new Insets(2, 2, 2, 2));
            this._openODBCAdmin.setToolTipText(this._res.get("ODBCAdminToolTip"));
            this._openODBCAdmin.addActionListener((ActionListener)this);
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 5, 0, 0);
            jPanel3.add((Component)this._openODBCAdmin, gridBagConstraints);
        }
        this._fdsnProfile = new SybRadioButton(this._res.get("FDSN_PROFILE"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 0, 0);
        gridBagConstraints.anchor = 17;
        jPanel3.add((Component)this._fdsnProfile, gridBagConstraints);
        string = Preferences.load(SAVE_PREFIX, SAVE_FDSN);
        if (string != null && string.length() != 0) {
            string = this.removeBogusDataSourceFiles(string);
        }
        this._fdsn = new MRUComboBox(string);
        new FontHelper((JComboBox)this._fdsn);
        GenericDatabaseSource.setMRUComboBoxPreferredWidth(this._fdsn, 40);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 30, 0, 0);
        jPanel3.add((Component)this._fdsn, gridBagConstraints);
        this._browseFDSN = new SybButton(this._res.get("&Browse..."));
        this._browseFDSN.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel3.add((Component)this._browseFDSN, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this._dsnProfile);
        buttonGroup.add((AbstractButton)this._fdsnProfile);
        if (this._initialConnectionInfo == null) {
            this._dsnProfile.setSelected(true);
        } else {
            String string2 = this._initialConnectionInfo.getParameter("FILEDSN");
            if (string2 != null && string2.length() > 0) {
                this._fdsnProfile.setSelected(true);
            } else {
                this._dsnProfile.setSelected(true);
            }
        }
        this._dsnProfile.addItemListener((ItemListener)this);
        this._fdsnProfile.addItemListener((ItemListener)this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets.top = 8;
        gridBagConstraints.insets.bottom = 8;
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        if (!Registry.isInstalled()) {
            this._browseDSN.setEnabled(false);
        }
        return jPanel;
    }

    private String removeBogusDataSourceFiles(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Registry.isInstalled()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                File file = new File(stringTokenizer.nextToken());
                if (!file.exists() && file.getParent() != null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(file);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String removeBogusDataSources(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Registry.isInstalled()) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (!ODBCUtils.isValidDSN(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(string2);
            }
        } else {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private static void setMRUComboBoxPreferredWidth(MRUComboBox mRUComboBox, int n) {
        Dimension dimension = mRUComboBox.getPreferredSize();
        FontMetrics fontMetrics = mRUComboBox.getFontMetrics(mRUComboBox.getFont());
        int n2 = fontMetrics.charWidth('m');
        int n3 = n2 * n;
        if (dimension.width > n3) {
            dimension.width = n3;
            mRUComboBox.setPreferredSize(dimension);
        }
    }

    private JPanel createAdvancedPanel() {
        int n = 0;
        JPanel jPanel = new JPanel();
        jPanel.setName(this._res.get("Advanced"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        SybLabel sybLabel = new SybLabel(this._res.get("Enter connection parameters, one per line, in the form \"name=value\""));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        this._advanced = new SybTextArea();
        this._advanced.setTabMovesFocus(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._advanced);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._advanced);
        return jPanel;
    }

    private void enableControls() {
        boolean bl = this._dsnProfile.isSelected();
        boolean bl2 = this._fdsnProfile.isSelected();
        this._dsn.setEnabled(bl);
        this._browseDSN.setEnabled(bl && Registry.isInstalled());
        if (this._openODBCAdmin != null) {
            this._openODBCAdmin.setEnabled(bl);
        }
        this._fdsn.setEnabled(bl2);
        this._browseFDSN.setEnabled(bl2);
    }

    private void setInitialValues() {
        this.resetControls();
        if (this._initialConnectionInfo != null) {
            this.setInitialValues(this._initialConnectionInfo);
        }
    }

    private void setInitialValues(GenericConnectionInfo genericConnectionInfo) {
        String string;
        Enumeration enumeration = genericConnectionInfo.getParameterNames();
        this._userid.setText(genericConnectionInfo.getUserName());
        this._password.setText(genericConnectionInfo.getPassword());
        String string2 = genericConnectionInfo.getParameter(SAVE_DSN);
        if (string2 != null) {
            this._dsnProfile.setSelected(true);
            this._dsn.setSelectedItem((Object)string2);
        }
        if ((string = genericConnectionInfo.getParameter("FILEDSN")) != null) {
            this._fdsnProfile.setSelected(true);
            this._fdsn.setSelectedItem((Object)string);
        }
        if (this._advanced != null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            enumeration = genericConnectionInfo.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = genericConnectionInfo.getParameter(string3);
                if (stringBuffer.length() <= 0) continue;
                stringBuffer.append('\n');
                stringBuffer.append(string3);
                stringBuffer.append('=');
                stringBuffer.append(string4);
            }
            this._advanced.setText(stringBuffer.toString());
        }
    }

    private void resetControls() {
        this._dsn.setSelectedItem(null);
        this._fdsn.setSelectedItem(null);
        if (this._advanced != null) {
            this._advanced.setText("");
        }
    }

    private void destroyGUI() {
        if (this._panel != null) {
            this._tabbedPane = null;
            this._identificationPanel = null;
            this._advancedPanel = null;
            this._dsn = null;
            this._fdsn = null;
            this._advanced = null;
            this._dsnProfile.removeItemListener((ItemListener)this);
            this._dsnProfile = null;
            this._fdsnProfile.removeItemListener((ItemListener)this);
            this._fdsnProfile = null;
            this._browseDSN.removeActionListener((ActionListener)this);
            this._browseDSN = null;
            if (this._openODBCAdmin != null) {
                this._openODBCAdmin.removeActionListener((ActionListener)this);
                this._openODBCAdmin = null;
            }
            this._browseFDSN.removeActionListener((ActionListener)this);
            this._browseFDSN = null;
            DialogUtils.removeComponents((Container)this._panel);
            this._panel = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._browseDSN) {
            this.handleBrowseDSN();
        } else if (object == this._browseFDSN) {
            this.handleBrowseFDSN();
        } else if (object == this._openODBCAdmin) {
            this.handleOpenODBCAdmin();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this._dsnProfile || object == this._fdsnProfile) {
            this.enableControls();
        }
    }

    private void handleOpenODBCAdmin() {
        ODBCUtils.openODBCAdministrator(this.getParentWindow());
    }

    private void handleBrowseDSN() {
        String string = this._dsn.getStringValue();
        Window window = this.getParentWindow();
        BrowseDSNDialog browseDSNDialog = window instanceof Frame ? new BrowseDSNDialog((Frame)window) : new BrowseDSNDialog((Dialog)window);
        if (browseDSNDialog.create(string)) {
            this._dsn.setSelectedItem((Object)browseDSNDialog.getDSN());
        }
    }

    private void handleBrowseFDSN() {
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        String string = Preferences.load(SAVE_PREFIX, SAVE_LAST_FDSN_FOLDER);
        if (string == null && (string = ODBCUtils.getDefaultFileDSNFolder()) == null) {
            string = System.getProperty("user.dir");
        }
        File file = new File(string);
        String string2 = this._fdsn.getStringValue();
        File file2 = string2 != null ? new File(string2) : null;
        sybFileChooser.setTitle(this._res.get("ODBC Data Source File"));
        if (sybFileChooser.showDialog(this.getParentWindow(), file, file2)) {
            File file3 = sybFileChooser.getSelectedFile();
            this._fdsn.setSelectedItem((Object)file3.toString());
            Preferences.save(SAVE_PREFIX, SAVE_LAST_FDSN_FOLDER, file3.getParent());
        }
    }

    private Window getParentWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._panel);
        return window;
    }

    @Override
    public AbstractConnectionInfo getConnectionInfo() {
        if (this._panel == null) {
            GenericConnectionInfo genericConnectionInfo = new GenericConnectionInfo(this._initialConnectionInfo);
            return genericConnectionInfo;
        }
        GenericConnectionInfo genericConnectionInfo = new GenericConnectionInfo();
        String string = this._userid.getText();
        genericConnectionInfo.setUserName(string);
        string = this._password.getText();
        genericConnectionInfo.setPassword(string);
        if (this._dsnProfile.isSelected()) {
            string = this._dsn.getStringValue();
            if (string != null && string.length() != 0) {
                genericConnectionInfo.setParameter(SAVE_DSN, string);
            }
        } else if (this._fdsnProfile.isSelected() && (string = this._fdsn.getStringValue()) != null && string.length() != 0) {
            genericConnectionInfo.setParameter("FILEDSN", string);
        }
        if (this._advanced != null && (string = this._advanced.getText().trim()).length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                int n;
                String string2 = stringTokenizer.nextToken();
                if (string2.length() == 0 || (n = string2.indexOf(61)) < 1) continue;
                String string3 = string2.substring(0, n).trim();
                string = string2.substring(n + 1).trim();
                genericConnectionInfo.setParameter(string3, string);
            }
        }
        return genericConnectionInfo;
    }

    @Override
    public Connection connect(ArrayList<SQLWarning> arrayList, AbstractConnectionInfo abstractConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        GenericConnectionInfo genericConnectionInfo = abstractConnectionInfo instanceof GenericConnectionInfo ? (GenericConnectionInfo)abstractConnectionInfo : null;
        if (this._panel == null) {
            GenericConnectionInfo genericConnectionInfo2 = new GenericConnectionInfo(this._initialConnectionInfo);
            if (genericConnectionInfo != null) {
                genericConnectionInfo2.merge(genericConnectionInfo);
            }
            if (classLoader != null) {
                genericConnectionInfo2.setClassLoader(classLoader);
            }
            try {
                connection = genericConnectionInfo2.getConnection();
            }
            catch (Exception exception) {
                this._initialException = exception;
            }
        } else {
            connection = this.connectFromUI(arrayList, genericConnectionInfo, classLoader);
        }
        return connection;
    }

    private Connection connectFromUI(ArrayList<SQLWarning> arrayList, GenericConnectionInfo genericConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        GenericConnectionInfo genericConnectionInfo2 = (GenericConnectionInfo)this.getConnectionInfo();
        if (classLoader != null) {
            genericConnectionInfo2.setClassLoader(classLoader);
        }
        if (genericConnectionInfo != null) {
            genericConnectionInfo2.merge(genericConnectionInfo);
        }
        try {
            connection = genericConnectionInfo2.getConnection();
            if (connection != null && arrayList != null) {
                for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    arrayList.add(sQLWarning);
                }
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            this.displayError(sQLException);
        }
        return connection;
    }

    @Override
    public void reportConnectionFailure(Exception exception) {
        this.displayError(exception);
    }

    private void displayError(Exception exception) {
        if (exception instanceof ClassNotFoundException) {
            this.handleDriverNotFound(exception);
        } else if (exception instanceof SQLException) {
            this.handleSQLException((SQLException)exception);
        } else {
            this.handleGenericException(exception);
        }
    }

    private void handleGenericException(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayConnectionError(exception.getLocalizedMessage(), null, stringBuffer.toString());
    }

    private void handleSQLException(SQLException sQLException) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        SQLException sQLException2 = sQLException.getNextException();
        String string4 = sQLException.getSQLState();
        if (sQLException.getMessage().indexOf("[Microsoft][ODBC Driver Manager]") != -1 && string4.equals("IM002")) {
            if (this._tabbedPane != null) {
                this._tabbedPane.setSelectedComponent(this._identificationPanel);
            }
            if (this._fdsnProfile.isSelected()) {
                this._fdsn.requestFocus();
            } else {
                this._dsn.requestFocus();
            }
            string2 = this._res.get("UnknownODBCDataSource");
            string = this._res.get("UnknownODBCDataSourceRemedy");
        } else {
            string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
            string = null;
            sQLException2 = sQLException.getNextException();
            if (sQLException2 != null) {
                stringBuffer.append(ODBCUtils.stripODBCHeader(sQLException2.getLocalizedMessage()));
                stringBuffer.append(string3);
            }
        }
        this.displayConnectionError(sQLException, string2, string, stringBuffer.toString());
    }

    private void handleDriverNotFound(Exception exception) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this._res.get("Missing JDBC driver"));
        stringBuffer.append(string);
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append(this._res.get("Classpath"));
        stringBuffer.append(string);
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        this.displayConnectionError(this._res.get("The JDBC driver could not be loaded."), null, stringBuffer.toString());
    }

    private void displayConnectionError(Exception exception, String string, String string2, String string3) {
        String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string4);
        if (exception instanceof SQLException) {
            stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(((SQLException)exception).getErrorCode())));
            stringBuffer.append(string4);
            stringBuffer.append(this._res.getFormatted("\tSQL state={0}", ((SQLException)exception).getSQLState()));
            stringBuffer.append(string4);
            SQLException sQLException = ((SQLException)exception).getNextException();
            if (sQLException != null) {
                stringBuffer.append(sQLException.getLocalizedMessage());
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(sQLException.getErrorCode())));
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tSQL state={0}", sQLException.getSQLState()));
                stringBuffer.append(string4);
            }
        }
        this.displayConnectionError(string, string2, stringBuffer.toString());
    }

    private void displayConnectionError(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        final String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this._res.get("Could not connect to the database"));
        stringBuffer2.append(string4);
        stringBuffer2.append(string4);
        stringBuffer2.append(string);
        if (string2 != null) {
            stringBuffer2.append(string4);
            stringBuffer2.append(string4);
            stringBuffer2.append(string2);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this._res.get("Connection parameters:"));
        stringBuffer.append(string4);
        this.buildConnectionString(new ConnectionStringBuilder(){

            @Override
            public void addParm(String string, String string2) {
                LogonResourcesBase logonResourcesBase = GenericDatabaseSource.this._res;
                GenericDatabaseSource.this._res;
                stringBuffer.append(logonResourcesBase.getFormatted("\t{0}={1}", string, string2));
                stringBuffer.append(string4);
            }
        });
        Window window = this.getParentWindow();
        String string5 = window instanceof Frame ? ((Frame)window).getTitle() : ((Dialog)window).getTitle();
        DetailsErrorDialog.showDialog((Component)window, (String)string5, (String)stringBuffer2.toString(), (String)stringBuffer.toString(), null);
    }

    @Override
    public String getDisplayName() {
        return this._res.get("GENERIC_ODBC_DATABASE");
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(LogonImages.getDatabase16());
    }

    @Override
    public boolean hasHelp() {
        return this._helpJARLocation != null;
    }

    @Override
    public void showHelp() {
        if (this._helpViewer == null) {
            try {
                this._helpViewer = FactoryHelp.getHelpViewer((String)this._helpJARLocation, (String)this._helpPrefix, (String)this._helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                Window window = this.getParentWindow();
                if (window instanceof Frame) {
                    String string = ((Frame)window).getTitle();
                    DetailsErrorDialog.showDetailsErrorDialog((Frame)((Frame)window), (String)string, (String)this._res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
                }
                String string = ((Dialog)window).getTitle();
                DetailsErrorDialog.showDetailsErrorDialog((Dialog)((Dialog)window), (String)string, (String)this._res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
            }
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage(this.getHelpContextId(), this.getParentWindow());
        }
    }

    @Override
    public void setHelpFolder(String string, String string2, String string3) {
        this._helpJARLocation = string;
        this._helpPrefix = string2;
        this._helpSuffix = string3;
    }

    @Override
    public Object[] getTools() {
        return null;
    }

    @Override
    public void notifyToolClicked(int n) {
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void notifyCancelClicked() {
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    static interface ConnectionStringBuilder {
        public void addParm(String var1, String var2);
    }
}

