/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ASAConnect;
import com.sybase.asa.logon.ASAConnectionInfo;
import com.sybase.asa.logon.CharLangWarning;
import com.sybase.asa.logon.CmdSeqException;
import com.sybase.asa.logon.CommException;
import com.sybase.asa.logon.Dbg;
import com.sybase.asa.logon.EngineStartException;
import com.sybase.asa.logon.GenericConnectionInfo;
import com.sybase.asa.logon.LogonException;
import com.sybase.asa.logon.NoServerAddressException;
import com.sybase.asa.logon.UltraLiteConnectionInfo;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.DSSettingsProxy;
import com.sybase.ase.logon.ServiceProxy;
import com.sybase.jdbcspy.JSBase;
import com.sybase.jdbcspy.JSDriver;
import com.sybase.logon.AbstractConnectionInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class JDBCDrivers {
    public static final String JCONNECT6 = "com.sybase.jdbc3.jdbc.SybDriver";
    public static final String JCONNECT7 = "com.sybase.jdbc4.jdbc.SybDriver";
    public static final String JDBC_ODBC = "ianywhere.ml.jdbcodbc.IDriver";
    public static final String JDBC_PROP_USER = "USER";
    public static final String JDBC_PROP_PASSWORD = "PASSWORD";
    public static final String JDBC_PROP_CHARSET = "CHARSET";
    public static final String JDBC_PROP_LANGUAGE = "LANGUAGE";
    public static final String JDBC_PROP_SQLINITSTRING = "SQLINITSTRING";
    public static final String JDBC_PROP_APPLICATIONNAME = "APPLICATIONNAME";
    public static final String JDBC_PROP_HOSTNAME = "HOSTNAME";
    public static final String JDBC_PROP_JCONNECT_VERSION = "JCONNECT_VERSION";
    public static final String JDBC_PROP_DYNAMIC_PREPARE = "DYNAMIC_PREPARE";
    public static final String JDBC_PROP_SYBSOCKET_FACTORY = "SYBSOCKET_FACTORY";
    public static final String JDBC_PROP_ENCRYPT_PASSWORD = "ENCRYPT_PASSWORD";
    public static final String JDBC_PROP_JCE_PROVIDER_CLASS = "JCE_PROVIDER_CLASS";
    public static final String JDBC_PROP_CONNECTION_FAILOVER = "CONNECTION_FAILOVER";
    public static final String JDBC_PROP_DELETE_WARNINGS_FROM_EXCEPTION_CHAIN = "DELETE_WARNINGS_FROM_EXCEPTION_CHAIN";
    public static final String SQL_STATE_PASSWORD_EXPIRED = "01ZZZ";
    public static final String SQL_STATE_LOGIN_FAILED = "JZ00L";
    public static final String SQL_STATE_NO_USER_NAME = "JZ004";
    public static final String SQL_STATE_CONNECTION_REFUSED = "JZ006";
    public static final String SQL_STATE_CHARSET_UNMATCH = "JZ0IB";
    private static CharLangWarning _activeWarning;

    public static boolean isJConnectDriver(String string) {
        return string.startsWith("com.sybase.");
    }

    public static String getConnectWarning() {
        if (_activeWarning != null && _activeWarning.getMessage().length() != 0) {
            return _activeWarning.getMessage();
        }
        return null;
    }

    public static void clearConnectWarning() {
        _activeWarning = null;
    }

    private static void setConnectWarning(CharLangWarning charLangWarning) {
        _activeWarning = charLangWarning;
    }

    public static Connection connect(AbstractConnectionInfo abstractConnectionInfo) throws SQLException, ClassNotFoundException, LogonException {
        Connection connection = abstractConnectionInfo instanceof ASAConnectionInfo ? JDBCDrivers.connect((ASAConnectionInfo)abstractConnectionInfo) : (abstractConnectionInfo instanceof ASEConnectionInfo ? JDBCDrivers.connect((ASEConnectionInfo)abstractConnectionInfo) : (abstractConnectionInfo instanceof UltraLiteConnectionInfo ? ((UltraLiteConnectionInfo)abstractConnectionInfo).getConnection() : (abstractConnectionInfo instanceof GenericConnectionInfo ? ((GenericConnectionInfo)abstractConnectionInfo).getConnection() : null)));
        return connection;
    }

    static Driver loadIAnywhereJDBCODBCDriver(ClassLoader classLoader) throws ClassNotFoundException {
        ReflectiveOperationException reflectiveOperationException = null;
        Driver driver = null;
        if (classLoader == null) {
            classLoader = JDBCDrivers.class.getClassLoader();
        }
        try {
            driver = (Driver)Class.forName(JDBC_ODBC, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            if (!(reflectiveOperationException instanceof ClassNotFoundException)) {
                reflectiveOperationException = new ClassNotFoundException("Could not load the iAnywhere JDBC driver", reflectiveOperationException);
            }
            throw reflectiveOperationException;
        }
        return driver;
    }

    public static Connection connect(ASAConnectionInfo aSAConnectionInfo) throws SQLException, ClassNotFoundException {
        int n;
        Connection connection = null;
        Driver driver = null;
        Statement statement = null;
        JDBCDrivers.clearConnectWarning();
        driver = JDBCDrivers.loadIAnywhereJDBCODBCDriver(aSAConnectionInfo.getClassLoader());
        String string = aSAConnectionInfo.getURL();
        Properties properties = aSAConnectionInfo.getConnectionPropertiesForDriver();
        String string2 = "\u00e3\u00fc\u00dd\u00db\u0084\u00e6\u00e3\u00e9";
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < string2.length(); ++n) {
            stringBuilder.append((char)(string2.charAt(n) ^ 0xAA));
        }
        properties.setProperty("licfile", stringBuilder.toString());
        String string3 = "\u00ee\u00cb\u00c6\u00cf\u00ef\u00cb\u00d8\u00c4\u00c2\u00cb\u00d8\u00ce\u00de\u00e6\u00c3\u00dc\u00cf\u00d9\u00ec\u00c5\u00d8\u00cf\u00dc\u00cf";
        stringBuilder = new StringBuilder();
        for (n = 0; n < string3.length(); ++n) {
            stringBuilder.append((char)(string3.charAt(n) ^ 0xAA));
        }
        properties.setProperty("licpwd", stringBuilder.toString());
        try {
            if (JSBase.isActive()) {
                driver = new JSDriver(driver);
            }
            connection = driver.connect(string, properties);
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            statement = connection.createStatement();
            if (Dbg.shouldSendAuthenticationString()) {
                String string4 = ASAConnectionInfo.getSelfAuthenticationSQL();
                try {
                    statement.execute(string4);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append("set temporary option sql_flagger_error_level='W';");
            stringBuilder.append("set temporary option sql_flagger_warning_level='W';");
            stringBuilder.append("if( connection_property('Suppress_TDS_debugging') is not null ) then set temporary option Suppress_TDS_debugging='on'; end if;");
            stringBuilder.append("if( connection_property('Return_date_time_as_string') is not null ) then set temporary option Return_date_time_as_String='on'; end if;");
            stringBuilder.append("set textsize 2147483647");
            try {
                statement.execute(stringBuilder.toString());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
                statement = null;
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection connect(ASEConnectionInfo aSEConnectionInfo) throws SQLException, ClassNotFoundException, LogonException {
        Connection connection = null;
        JDBCDrivers.clearConnectWarning();
        if (aSEConnectionInfo.host == null || aSEConnectionInfo.port == -1) {
            throw new NoServerAddressException();
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        arrayList.add(new String[]{aSEConnectionInfo.host, String.valueOf(aSEConnectionInfo.port), aSEConnectionInfo.getServiceFilter()});
        String string = aSEConnectionInfo.getProperty(JDBC_PROP_CONNECTION_FAILOVER);
        if (string == null || Boolean.valueOf(string).booleanValue()) {
            List<ServiceProxy> list = aSEConnectionInfo.getOtherServices();
            for (int i = 0; i < list.size(); ++i) {
                ServiceProxy serviceProxy = list.get(i);
                arrayList.add(new String[]{serviceProxy.getHost(), serviceProxy.getPort(), serviceProxy.getFilter()});
            }
        }
        int n = 0;
        SQLException sQLException = new SQLException();
        boolean bl = false;
        do {
            Driver driver;
            String string2 = ((String[])arrayList.get(n))[0];
            String string3 = ((String[])arrayList.get(n))[1];
            String string4 = ((String[])arrayList.get(n))[2];
            String string5 = aSEConnectionInfo.getURL(string2, string3, aSEConnectionInfo.getDatabaseName());
            if (string5 == null) {
                throw new NoServerAddressException();
            }
            Properties properties = aSEConnectionInfo.getProperties();
            if (n > 0) {
                boolean bl2;
                boolean bl3 = bl2 = string4 != null && string4.equalsIgnoreCase("ssl");
                if (bl2) {
                    properties.setProperty(JDBC_PROP_SYBSOCKET_FACTORY, "com.sybase.util.ds.ssl.SSLSocketFactoryASE");
                }
            }
            properties.setProperty(JDBC_PROP_DYNAMIC_PREPARE, "false");
            try {
                driver = JDBCDrivers.loadJConnectDriver(JCONNECT7, aSEConnectionInfo.getClassLoader());
                properties.setProperty(JDBC_PROP_DELETE_WARNINGS_FROM_EXCEPTION_CHAIN, "false");
            }
            catch (ClassNotFoundException classNotFoundException) {
                driver = JDBCDrivers.loadJConnectDriver(JCONNECT6, aSEConnectionInfo.getClassLoader());
            }
            if (JSBase.isActive()) {
                driver = new JSDriver(driver);
            }
            try {
                if (DSSettingsProxy.getEnableLoginTimeout()) {
                    DriverManager.setLoginTimeout(DSSettingsProxy.getLoginTimeout());
                }
                connection = driver.connect(string5, properties);
                sQLException = null;
                bl = true;
                if (n <= 0) continue;
                aSEConnectionInfo.host = string2;
                aSEConnectionInfo.port = Integer.valueOf(string3);
                aSEConnectionInfo.setServiceFilter(string4);
            }
            catch (SQLException sQLException2) {
                String string6 = sQLException2.getSQLState();
                SQLException sQLException3 = sQLException2.getNextException();
                if (string6 != null && string6.equals(SQL_STATE_CHARSET_UNMATCH) || sQLException3 != null && sQLException3.getSQLState() != null && sQLException3.getSQLState().equals(SQL_STATE_CHARSET_UNMATCH)) {
                    aSEConnectionInfo.setCharSet("iso_1");
                    Connection connection2 = JDBCDrivers.connect(aSEConnectionInfo);
                    return connection2;
                }
                sQLException.setNextException(sQLException2);
                sQLException = sQLException2;
            }
            finally {
                if (connection != null) {
                    try {
                        Statement statement = connection.createStatement();
                        statement.execute("set textsize 2147483647");
                        statement.close();
                        statement = null;
                    }
                    catch (SQLException sQLException4) {}
                }
            }
        } while (++n < arrayList.size() && !bl);
        if (sQLException != null) {
            throw sQLException;
        }
        return connection;
    }

    public static Driver loadJConnectDriver(String string, ClassLoader classLoader) throws ClassNotFoundException {
        ReflectiveOperationException reflectiveOperationException = null;
        Driver driver = null;
        if (classLoader == null) {
            classLoader = JDBCDrivers.class.getClassLoader();
        }
        try {
            driver = (Driver)Class.forName(string, true, classLoader).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            if (!(reflectiveOperationException instanceof ClassNotFoundException)) {
                reflectiveOperationException = new ClassNotFoundException("Could not load the JConnect driver", reflectiveOperationException);
            }
            throw reflectiveOperationException;
        }
        return driver;
    }

    public static boolean startASAServer(String string, String string2) throws EngineStartException, CommException, CmdSeqException {
        boolean[] blArray = new boolean[1];
        if (string2 == null) {
            string2 = "";
        }
        boolean bl = ASAConnect.isInstalled() && ASAConnect.startEngine(string, string2, blArray);
        return bl;
    }
}

