/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.DBTypeComboBox;
import com.sybase.asa.logon.LogonDialogClient;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.LogonSourceHost;
import com.sybase.asa.logon.LogonTool;
import com.sybase.asa.logon.Preferences;
import com.sybase.util.DialogUtils;
import com.sybase.util.DropDownButtonEvent;
import com.sybase.util.DropDownButtonListener;
import com.sybase.util.SybButton;
import com.sybase.util.SybDropDownButton;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;

class LogonDialog
extends JDialog
implements LogonSourceHost,
ActionListener,
DropDownButtonListener,
ItemListener,
MouseListener {
    private static final String ESCAPE_KEY_COMMAND = "escape";
    private static final String F1_KEY_RELEASE = "F1_KEY_RELEASE";
    private SybButton _ok;
    private SybButton _cancel;
    private SybButton _help;
    private DBTypeComboBox _dbType = null;
    private LogonDialogClient _client;
    private LogonResourcesBase _res;
    private LogonSource _currentSource = null;
    private int _currentSourceIndex = -1;
    private LogonSource[] _sources = null;
    private int _disabledCount = 0;
    private Image _icon = null;
    private JFrame _parentingFrame = null;
    private int _options = 0;
    private JPanel _sourcePanelContainer = null;
    private SybDropDownButton _tools = null;
    private LogonTool[][] _clientTools = null;

    LogonDialog(JFrame jFrame, String string, Image image, LogonSource[] logonSourceArray, int n, LogonTool[][] logonToolArray, int n2, LogonDialogClient logonDialogClient) {
        super((Window)jFrame, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jFrame, string, image, logonSourceArray, n, logonToolArray, n2, logonDialogClient);
    }

    LogonDialog(JDialog jDialog, String string, Image image, LogonSource[] logonSourceArray, int n, LogonTool[][] logonToolArray, int n2, LogonDialogClient logonDialogClient) {
        super((Window)jDialog, Dialog.ModalityType.DOCUMENT_MODAL);
        this.constructor(jDialog, string, image, logonSourceArray, n, logonToolArray, n2, logonDialogClient);
    }

    private void constructor(Window window, String string, Image image, LogonSource[] logonSourceArray, int n, LogonTool[][] logonToolArray, int n2, LogonDialogClient logonDialogClient) {
        int n3;
        this._client = logonDialogClient;
        this._icon = image;
        this._res = LogonResourcesBase.getBundle();
        this._options = n2;
        this._sources = logonSourceArray;
        this._clientTools = logonToolArray;
        this._ok = new SybButton(this._res.get("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(this._res.get("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._help = new SybButton(this._res.get("Help"));
        this._help.addActionListener((ActionListener)this);
        for (n3 = 0; n3 < logonSourceArray.length; ++n3) {
            logonSourceArray[n3].setLogonSourceHost(this);
        }
        this._sourcePanelContainer = new JPanel(new CardLayout());
        this._sourcePanelContainer.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        for (n3 = 0; n3 < logonSourceArray.length; ++n3) {
            this._sourcePanelContainer.add((Component)logonSourceArray[n3].getPanel(n2), Integer.toString(n3));
        }
        if (logonSourceArray.length > 1) {
            this._dbType = new DBTypeComboBox(logonSourceArray);
            this._dbType.setSelectedIndex(n);
            this._dbType.addItemListener(this);
        }
        this._tools = new SybDropDownButton(this._res.get("Tools"), null);
        this._tools.addActionListener((ActionListener)this);
        this._tools.addDropDownButtonListener((DropDownButtonListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 2);
        this.getRootPane().registerKeyboardAction(this, F1_KEY_RELEASE, KeyStroke.getKeyStroke(112, 0, true), 2);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel, this._help});
        if (this._dbType != null) {
            Dimension dimension = this._dbType.getPreferredSize();
            this._dbType.setMinimumSize(dimension);
            this._dbType.setMaximumSize(dimension);
            jPanel.add((Component)((Object)this._dbType));
        }
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add((Component)this._tools);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add((Component)this._ok);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add((Component)this._cancel);
        jPanel.add(Box.createHorizontalStrut(5));
        jPanel.add((Component)this._help);
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this._sourcePanelContainer, "Center");
        jPanel2.add((Component)jPanel, "South");
        this.setLogonSource(n, true);
        if (string == null) {
            this.setTitle(this._res.get("Connect"));
        } else {
            this.setTitle(string);
        }
        this.pack();
        this.setResizable(false);
        logonSourceArray[n].setInitialFocus();
        UIUtils.ensureWindowIsVisible((Window)this);
        this.setLocationRelativeTo(window);
    }

    void destroy() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, true));
        this.getGlassPane().removeMouseListener(this);
        this._currentSource = null;
        this._currentSourceIndex = -1;
        if (this._sources != null) {
            for (int i = 0; i < this._sources.length; ++i) {
                this._sources[i].destroy();
                this._sources[i] = null;
            }
            this._sources = null;
        }
        this._sourcePanelContainer = null;
        if (this._dbType != null) {
            this._dbType.removeItemListener(this);
            this._dbType.destroy();
            this._dbType = null;
        }
        this.getRootPane().setDefaultButton(null);
        if (this._ok != null) {
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
        }
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        if (this._tools != null) {
            this._tools.removeActionListener((ActionListener)this);
            this._tools.removeDropDownButtonListener((DropDownButtonListener)this);
            this._tools = null;
        }
        if (this._help != null) {
            this._help.removeActionListener((ActionListener)this);
            this._help = null;
        }
        this._res = null;
        this._client = null;
        this._parentingFrame = null;
        this._icon = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel) {
            this.handleCancel();
        } else if (object == this._tools) {
            this._tools.showDropDown();
        } else if (object == this._help) {
            this.handleHelp();
        } else if (actionEvent.getActionCommand().equals(ESCAPE_KEY_COMMAND)) {
            this.handleCancel();
        } else if (actionEvent.getActionCommand().equals(F1_KEY_RELEASE)) {
            this.handleHelp();
        }
    }

    private void handleOK() {
        if (this._client == null) {
            return;
        }
        this.setEnabled(false);
        this._ok.setEnabled(false);
        this._cancel.setEnabled(false);
        if (!this._currentSource.validate()) {
            this._ok.setEnabled(true);
            this._cancel.setEnabled(true);
            this.setEnabled(true);
            return;
        }
        boolean bl = this._client.handleOK(this, this._currentSource);
        if (bl) {
            this._currentSource.notifyConnectOK();
            this.setVisible(false);
            Preferences.makePermanent();
        } else {
            this._ok.setEnabled(true);
            this._cancel.setEnabled(true);
            this.setEnabled(true);
        }
    }

    private void handleCancel() {
        this._currentSource.notifyCancelClicked();
        this.setVisible(false);
    }

    void handleHelp() {
        if (this._currentSource != null) {
            this._currentSource.showHelp();
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl && this._disabledCount != 0) {
            --this._disabledCount;
            if (this._disabledCount == 0) {
                Component component = this.getGlassPane();
                component.setCursor(Cursor.getPredefinedCursor(0));
                component.setVisible(false);
                component.removeMouseListener(this);
            }
        } else if (!bl) {
            if (this._disabledCount == 0) {
                Component component = this.getGlassPane();
                component.setCursor(Cursor.getPredefinedCursor(3));
                component.setVisible(true);
                component.addMouseListener(this);
            }
            ++this._disabledCount;
        }
    }

    @Override
    public JFrame getParentingFrame() {
        if (this._parentingFrame == null) {
            this._parentingFrame = new JFrame();
            if (this._icon != null) {
                this._parentingFrame.setIconImage(this._icon);
            }
            this._parentingFrame.setTitle(this.getTitle());
        }
        this._parentingFrame.setBounds(this.getBounds());
        return this._parentingFrame;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            int n = this._dbType.getSelectedIndex();
            this.setLogonSource(n, false);
        }
    }

    private void setLogonSource(int n, boolean bl) {
        Object[] objectArray = null;
        ((CardLayout)this._sourcePanelContainer.getLayout()).show(this._sourcePanelContainer, Integer.toString(n));
        this._currentSource = this._sources[n];
        this._currentSourceIndex = n;
        this._currentSource.notifyLogonSourceSelected(bl);
        int n2 = 0;
        Object[] objectArray2 = this._currentSource.getTools();
        if (objectArray2 != null) {
            n2 = objectArray2.length;
        }
        if (this._clientTools != null && this._clientTools[n] != null) {
            if (n2 != 0) {
                ++n2;
            }
            n2 += this._clientTools[n].length;
        }
        if (n2 > 0) {
            objectArray = new Object[n2];
            int n3 = 0;
            if (objectArray2 != null) {
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
                n3 = objectArray2.length;
            }
            if (this._clientTools != null && this._clientTools[n] != null) {
                if (objectArray2 != null && objectArray2.length != 0) {
                    objectArray[n3++] = null;
                }
                for (int i = 0; i < this._clientTools[n].length; ++i) {
                    objectArray[i + n3] = this._clientTools[n][i].getName();
                    ++n3;
                }
            }
        }
        this._tools.setListData(objectArray);
        this._tools.setEnabled(objectArray != null && objectArray.length != 0);
    }

    @Override
    public void enableOKButton(boolean bl) {
        this._ok.setEnabled(bl);
    }

    @Override
    public void simulateOKButtonClick() {
        if (this._ok.isEnabled()) {
            this.handleOK();
        }
    }

    @Override
    public void simulateCancelButtonClick() {
        this.handleCancel();
    }

    public void dropDownOpening(DropDownButtonEvent dropDownButtonEvent) {
    }

    public void dropDownItemClicked(DropDownButtonEvent dropDownButtonEvent) {
        Object[] objectArray = null;
        int n = dropDownButtonEvent.getIndex();
        objectArray = this._currentSource.getTools();
        if (objectArray != null && n < objectArray.length) {
            this._currentSource.notifyToolClicked(n);
        } else {
            int n2 = n;
            if (objectArray != null) {
                n2 -= objectArray.length;
                --n2;
            }
            this._clientTools[this._currentSourceIndex][n2].toolSelected();
        }
    }

    @Override
    public void setDefaultButton(JButton jButton) {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(jButton);
        jRootPane.putClientProperty("initialDefaultButton", jButton);
    }

    @Override
    public void resetDefaultButton() {
        this.setDefaultButton((JButton)this._ok);
    }

    @Override
    public void enableSourceComboBox(boolean bl) {
        if (this._dbType != null) {
            this._dbType.setEnabled(bl);
        }
    }

    @Override
    public void repositionRelativeToParent() {
        this.setLocationRelativeTo(this.getParent());
    }
}

