/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.common.IntegerTextField;
import com.sybase.asa.logon.ConnectionPropertyTableCellEditor;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.PropertyMetaData;
import com.sybase.asa.logon.PropertyTable;
import com.sybase.asa.logon.PropertyTableModel;
import com.sybase.util.CommandLineOption;
import com.sybase.util.CommandLineOptionMetaData;
import com.sybase.util.CommandLineParser;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.KeySelectionHelper;
import com.sybase.util.ProtocolOption;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybComboBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import javax.swing.text.JTextComponent;

public abstract class NetworkPageBase
extends JPanel
implements ActionListener,
ComponentListener {
    public static final String NET_LINKS = "LINKS";
    public static final String NET_LINKS_LONG = "CommLinks";
    private static final int VERT_SPACING = 8;
    private static final int HORIZ_INDENT = 16;
    private static final int HORIZ_SPACING = 5;
    static final String CONN_TYPE_SHMEM = "ShMem";
    static final String CONN_TYPE_SHMEM_LONG = "SharedMemory";
    static final String CONN_TYPE_ALL = "ALL";
    static final String CONN_TYPE_TCP = "TCPIP";
    static final String CONN_TYPE_TCP_SHORT = "TCP";
    static final String NOVERIFY_PARMS = "VERIFY=no;DOBROAD=none";
    private SybCheckBox _shMemCheck;
    private SybCheckBox _tcpCheck;
    private PropertyTable _tcpTable;
    private KeySelectionHelper _tcpTableKeySelectionHelper;
    private SybLabel _titleLabel;
    private ImageIcon _titleIcon;
    private SybLabel _hostLabel;
    private JTextField _hostField;
    private SybLabel _portLabel;
    private IntegerTextField _portField;
    private SybLabel _otherLabel;
    private JTextField _otherField;
    private SybButton _tcpEditButton;
    private SybButton _pingButton;
    private SybLabel _encTitleLabel;
    private SybComboBox _encTypeCombo;
    private PropertyTable _encTable;
    private KeySelectionHelper _encTableKeySelectionHelper;
    private String _tlsName;
    private String _noneName;
    private String _simpleName;
    private String _tcpDialogTitle;

    public NetworkPageBase(String string) {
        this.setName(string);
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        this._tlsName = logonResourcesBase.get("NETWORK_SECURITY_TLS");
        this._noneName = logonResourcesBase.get("NETWORK_SECURITY_NONE");
        this._simpleName = logonResourcesBase.get("NETWORK_SECURITY_SIMPLE");
        this._tcpDialogTitle = logonResourcesBase.get("TCP_TITLE");
        this.createTables(logonResourcesBase);
        this.createUI(logonResourcesBase);
    }

    public abstract PropertyMetaData[] getTCPMetaData();

    public abstract PropertyMetaData[] getEncMetaData();

    public void destroyUI() {
        this._tcpCheck.removeActionListener((ActionListener)this);
        this._tcpTableKeySelectionHelper.destroy();
        this._tcpTableKeySelectionHelper = null;
        this._encTableKeySelectionHelper.destroy();
        this._encTableKeySelectionHelper = null;
        this.removeComponentListener(this);
        this._shMemCheck = null;
        this._tcpCheck = null;
        this._titleLabel = null;
        this._titleIcon = null;
        this._hostLabel = null;
        this._hostField = null;
        this._portLabel = null;
        this._portField = null;
        this._otherLabel = null;
        this._otherField = null;
        this._tcpEditButton = null;
        this._encTitleLabel = null;
        this._encTypeCombo = null;
        this._pingButton = null;
        this._tcpTable = null;
        this._encTable = null;
    }

    private void createUI(LogonResourcesBase logonResourcesBase) {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(0, 0, 8, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        Insets insets3 = new Insets(0, 16, 8, 5);
        Insets insets4 = new Insets(0, 0, 8, 5);
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.createComponents(logonResourcesBase);
        JScrollPane jScrollPane = new JScrollPane(this._encTable);
        gridBagConstraints.gridy = n++;
        this.add((Component)this._titleLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets2;
        this.add((Component)this._shMemCheck, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        this.add((Component)this._tcpCheck, gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this._hostLabel, gridBagConstraints);
        gridBagConstraints.insets = insets4;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._hostField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets;
        this.add((Component)this._pingButton, gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this._portLabel, gridBagConstraints);
        gridBagConstraints.insets = insets4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._portField, gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = insets3;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this._otherLabel, gridBagConstraints);
        gridBagConstraints.insets = insets4;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this._otherField, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.insets = insets;
        this.add((Component)this._tcpEditButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.add((Component)this._encTitleLabel, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this._encTypeCombo, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        this._tcpCheck.addActionListener((ActionListener)this);
        this._pingButton.addActionListener((ActionListener)this);
        this._tcpEditButton.addActionListener((ActionListener)this);
        this._encTypeCombo.addActionListener((ActionListener)this);
        this.addComponentListener(this);
    }

    private void createComponents(LogonResourcesBase logonResourcesBase) {
        this._titleIcon = new ImageIcon(LogonImages.getHost32x32());
        this._titleLabel = new SybLabel(logonResourcesBase.get("ABOUT_NETWORK"));
        this._titleLabel.setIconTextGap(10);
        this._titleLabel.setIcon((Icon)this._titleIcon);
        this._titleLabel.setAlignmentX(0.0f);
        this._shMemCheck = new SybCheckBox(logonResourcesBase.get("NETWORK_SHMEM"), true);
        this._tcpCheck = new SybCheckBox(logonResourcesBase.get("NETWORK_TCP"), false);
        this._hostLabel = new SybLabel(logonResourcesBase.get("NETWORK_HOST"));
        this._hostField = new JTextField();
        new FontHelper((JTextComponent)this._hostField);
        this._hostField.setHorizontalAlignment(2);
        this._hostLabel.setLabelFor((Component)this._hostField);
        this._portLabel = new SybLabel(logonResourcesBase.get("NETWORK_PORT"));
        this._portField = new IntegerTextField();
        this._portField.setHorizontalAlignment(2);
        this._portLabel.setLabelFor((Component)this._portField);
        this._otherLabel = new SybLabel(logonResourcesBase.get("NETWORK_OTHER"));
        this._otherField = new JTextField();
        new FontHelper((JTextComponent)this._otherField);
        this._otherField.setHorizontalAlignment(2);
        this._otherLabel.setLabelFor((Component)this._otherField);
        this._tcpEditButton = new SybButton(logonResourcesBase.get("NETWORK_TCP_EDIT"));
        this._encTitleLabel = new SybLabel(logonResourcesBase.get("NETWORK_SECURITY"));
        this._encTypeCombo = new SybComboBox();
        this._encTypeCombo.setEditable(false);
        this._encTypeCombo.setPreferredSize(new Dimension(170, this._encTypeCombo.getPreferredSize().height));
        this._encTypeCombo.addItem((Object)"");
        this._encTypeCombo.addItem((Object)logonResourcesBase.get("NETWORK_SECURITY_NONE"));
        this._encTypeCombo.addItem((Object)logonResourcesBase.get("NETWORK_SECURITY_SIMPLE"));
        this._encTypeCombo.addItem((Object)logonResourcesBase.get("NETWORK_SECURITY_TLS"));
        this._encTitleLabel.setLabelFor((Component)this._encTypeCombo);
        Dimension dimension = new Dimension(265, this._hostField.getPreferredSize().height);
        this._hostField.setPreferredSize(dimension);
        this._portField.setPreferredSize(dimension);
        this._otherField.setPreferredSize(dimension);
        this._pingButton = new SybButton(logonResourcesBase.get("NETWORK_PING_BUTTON"));
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._tcpEditButton, this._pingButton});
    }

    private void createTables(LogonResourcesBase logonResourcesBase) {
        PropertyMetaData[] propertyMetaDataArray = this.getTCPMetaData();
        PropertyMetaData[] propertyMetaDataArray2 = this.getEncMetaData();
        String[] stringArray = new String[2];
        stringArray[0] = logonResourcesBase.get("NAME");
        stringArray[1] = logonResourcesBase.get("VALUE");
        String[] stringArray2 = stringArray;
        PropertyTableModel propertyTableModel = new PropertyTableModel(propertyMetaDataArray, stringArray2);
        this._tcpTable = new PropertyTable(propertyTableModel);
        this._tcpTable.setInitialColumnWidths();
        this._tcpTable.setRowSorter(new TableRowSorter<PropertyTableModel>(propertyTableModel));
        this._tcpTableKeySelectionHelper = new KeySelectionHelper((JComponent)this._tcpTable);
        this._tcpTable.setRowHeight(this._tcpTable.getRowHeight() + 2);
        PropertyTableModel propertyTableModel2 = new PropertyTableModel(propertyMetaDataArray2, stringArray2);
        this._encTable = new PropertyTable(propertyTableModel2);
        this._encTable.setInitialColumnWidths();
        this._encTable.setRowSorter(new TableRowSorter<PropertyTableModel>(propertyTableModel2));
        this._encTableKeySelectionHelper = new KeySelectionHelper((JComponent)this._encTable);
        this._encTable.setRowHeight(this._encTable.getRowHeight() + 2);
        this._tcpTable.setDefaultEditor(Object.class, new ConnectionPropertyTableCellEditor(this._tcpTable));
        this._encTable.setDefaultEditor(Object.class, new ConnectionPropertyTableCellEditor(this._encTable));
        TableCellRenderer tableCellRenderer = FontHelper.getTableCellRenderer();
        this._tcpTable.setDefaultRenderer(Object.class, tableCellRenderer);
        this._encTable.setDefaultRenderer(Object.class, tableCellRenderer);
        this._encTable.setEnabled(false);
        this._encTable.getTableHeader().setEnabled(false);
        this._tcpTable.setPreferredScrollableViewportSize(new Dimension(350, 70));
        this._tcpTable.getColumnModel().getColumn(0).setPreferredWidth(110);
        this._tcpTable.getColumnModel().getColumn(1).setPreferredWidth(240);
        this._encTable.setPreferredScrollableViewportSize(new Dimension(350, 70));
        this._encTable.getColumnModel().getColumn(0).setPreferredWidth(110);
        this._encTable.getColumnModel().getColumn(1).setPreferredWidth(240);
    }

    void toggleAllCheckboxes(boolean bl) {
        this._shMemCheck.setSelected(bl);
        this.toggleTCPCheckBox(bl);
    }

    void toggleTCPCheckBox(boolean bl) {
        this._tcpCheck.setSelected(bl);
        this._hostLabel.setEnabled(bl);
        this._hostField.setEnabled(bl);
        this._portLabel.setEnabled(bl);
        this._portField.setEnabled(bl);
        this._otherLabel.setEnabled(bl);
        this._otherField.setEnabled(bl);
        this._tcpEditButton.setEnabled(bl);
        this._pingButton.setEnabled(bl);
    }

    void toggleEncTable(boolean bl) {
        this._encTable.setEnabled(bl);
        this._encTable.getTableHeader().setEnabled(bl);
    }

    public String getConnectionString() {
        if (!this._tcpCheck.isSelected()) {
            if (!this._shMemCheck.isSelected()) {
                return null;
            }
            return "";
        }
        String string = this.getTCPPropString();
        if (this._shMemCheck.isSelected() && this._tcpCheck.isSelected() && string.isEmpty()) {
            return CONN_TYPE_ALL;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        if (this._shMemCheck.isSelected()) {
            stringBuilder.append(CONN_TYPE_SHMEM);
        }
        if (this._tcpCheck.isSelected()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(CONN_TYPE_TCP);
            if (!string.isEmpty()) {
                stringBuilder.append('(');
                stringBuilder.append(string);
                stringBuilder.append(')');
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public String getLinksString() {
        String string = this.getConnectionString();
        if (string == null || string.length() < 1) {
            return string;
        }
        return "LINKS=" + string;
    }

    private String getTCPPropString() {
        if (!this._tcpCheck.isSelected()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        String string = this._hostField.getText();
        if (string != null && string.length() > 0) {
            stringBuilder.append("IP");
            stringBuilder.append("=");
            stringBuilder.append(string);
        }
        if ((string = this._portField.getText(false)) != null && string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append("PORT");
            stringBuilder.append("=");
            stringBuilder.append(string);
        }
        if ((string = this._otherField.getText()) != null && string.length() > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return "";
    }

    private void setTCPFieldFromTable() {
        PropertyMetaData[] propertyMetaDataArray = this.getTCPMetaData();
        StringBuilder stringBuilder = new StringBuilder(128);
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray) {
            String string = propertyMetaData.getValue();
            if (string == null || string.length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            if ("(other)".equals(propertyMetaData.getName())) {
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(propertyMetaData.getName() + "=" + string);
        }
        if (stringBuilder.length() > 0) {
            this._otherField.setText(stringBuilder.toString());
        } else {
            this._otherField.setText("");
        }
    }

    public void setInitialValues(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.startsWith(CONN_TYPE_ALL)) {
            this.toggleAllCheckboxes(true);
            return;
        }
        this.toggleAllCheckboxes(false);
        CommandLineOptionMetaData[] commandLineOptionMetaDataArray = new CommandLineOptionMetaData[]{new CommandLineOptionMetaData("foo", 5, 0)};
        String[] stringArray = new String[]{"-foo", string};
        CommandLineOption[] commandLineOptionArray = CommandLineParser.parse((String)"jLogon", (String[])stringArray, (CommandLineOptionMetaData[])commandLineOptionMetaDataArray);
        if (commandLineOptionArray.length > 0) {
            for (ProtocolOption protocolOption = (ProtocolOption)commandLineOptionArray[0]; protocolOption != null; protocolOption = protocolOption.getNextProtocol()) {
                String string2 = protocolOption.getProtocolName();
                if (CONN_TYPE_SHMEM.equalsIgnoreCase(string2) || CONN_TYPE_SHMEM_LONG.equalsIgnoreCase(string2)) {
                    this._shMemCheck.setSelected(true);
                    continue;
                }
                if (!CONN_TYPE_TCP.equalsIgnoreCase(string2) && !CONN_TYPE_TCP_SHORT.equalsIgnoreCase(string2)) continue;
                this.toggleTCPCheckBox(true);
                StringBuilder stringBuilder = new StringBuilder(128);
                for (int i = 0; i < protocolOption.getParameterCount(); ++i) {
                    String string3 = protocolOption.getParameterName(i);
                    String string4 = protocolOption.getParameterValue(i);
                    if (string3.equalsIgnoreCase("IP") || string3.equalsIgnoreCase("Host")) {
                        this._hostField.setText(string4);
                        continue;
                    }
                    if (string3.equalsIgnoreCase("PORT") || string3.equalsIgnoreCase("ServerPort")) {
                        this._portField.setText(string4);
                        continue;
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(';');
                    }
                    stringBuilder.append(string3 + "=" + string4);
                }
                if (stringBuilder.length() > 0) {
                    this._otherField.setText(stringBuilder.toString());
                    continue;
                }
                this._otherField.setText("");
            }
        }
    }

    private void populateTCPTableData() {
        String string = this._otherField.getText();
        if (string == null || string.length() < 1) {
            return;
        }
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String[] stringArray = connectionStringTokenizer.nextToken().split("=");
            if (stringArray.length <= 1) continue;
            this.setTCPPropValue(stringArray[0], stringArray[1]);
        }
    }

    private void setTCPPropValue(String string, String string2) {
        if (string == null || string.isEmpty() || string2 == null) {
            return;
        }
        PropertyMetaData[] propertyMetaDataArray = this.getTCPMetaData();
        PropertyMetaData propertyMetaData = null;
        for (PropertyMetaData propertyMetaData2 : propertyMetaDataArray) {
            if (string.equalsIgnoreCase(propertyMetaData2.getName()) || string.equalsIgnoreCase(propertyMetaData2.getLongName())) {
                try {
                    propertyMetaData2.setValue(string2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
            if (!"(other)".equalsIgnoreCase(propertyMetaData2.getName())) continue;
            propertyMetaData = propertyMetaData2;
        }
        if (propertyMetaData != null) {
            Object object = propertyMetaData.getValue();
            object = object == null || ((String)object).isEmpty() ? string + "=" + string2 : (String)object + ";" + string + "=" + string2;
            try {
                propertyMetaData.setValue((String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public String getEncryptionString(boolean bl) {
        String string;
        Object object = this._encTypeCombo.getSelectedItem();
        if (object == null || object.toString().isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = object.toString();
        if (bl) {
            stringBuilder.append("ENC=");
        }
        stringBuilder.append(string2);
        if (this._tlsName.equalsIgnoreCase(string2) && (string = this.getTLSProps()) != null && string.length() > 0) {
            stringBuilder.append("(");
            stringBuilder.append(string);
            stringBuilder.append(")");
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return "";
    }

    private String getTLSProps() {
        PropertyMetaData[] propertyMetaDataArray = this.getEncMetaData();
        StringBuilder stringBuilder = new StringBuilder(128);
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray) {
            String string = propertyMetaData.getValue();
            if (string == null || string.length() == 0) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(';');
            }
            stringBuilder.append(propertyMetaData.getName() + "=" + string);
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return "";
    }

    public void setEncryptionValues(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        if (string.equalsIgnoreCase(this._noneName) || string.equalsIgnoreCase(this._simpleName)) {
            this._encTypeCombo.setSelectedItem((Object)string);
            return;
        }
        if (string.equalsIgnoreCase(this._tlsName)) {
            this._encTypeCombo.setSelectedItem((Object)string);
            this.toggleEncTable(true);
            return;
        }
        int n = string.indexOf(40);
        if (n != -1) {
            String string2 = string.substring(0, n);
            if (string2.equalsIgnoreCase(this._noneName) || string2.equalsIgnoreCase(this._simpleName)) {
                this._encTypeCombo.setSelectedItem((Object)string2);
                return;
            }
            if (string2.equalsIgnoreCase(this._tlsName)) {
                this._encTypeCombo.setSelectedItem((Object)string2);
                String string3 = string.substring(n + 1, string.length() - 1);
                this.populateEncTableData(string3);
            }
        }
    }

    private void populateEncTableData(String string) {
        if (string == null || string.length() < 1) {
            return;
        }
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String[] stringArray = connectionStringTokenizer.nextToken().split("=");
            if (stringArray.length <= 1) continue;
            this.setEncPropValue(stringArray[0], stringArray[1]);
        }
    }

    private void setEncPropValue(String string, String string2) {
        PropertyMetaData[] propertyMetaDataArray;
        if (string == null || string.isEmpty() || string2 == null) {
            return;
        }
        for (PropertyMetaData propertyMetaData : propertyMetaDataArray = this.getEncMetaData()) {
            if (!string.equalsIgnoreCase(propertyMetaData.getName())) continue;
            try {
                propertyMetaData.setValue(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return;
        }
    }

    void resetProps() {
        this.commitPartialEdits();
        this.clearTCPTable();
        for (int i = 0; i < this._encTable.getRowCount(); ++i) {
            this._encTable.setValueAt("", i, 1);
        }
        this._hostField.setText("");
        this._portField.setText("");
        this._otherField.setText("");
        this._encTypeCombo.setSelectedItem((Object)"");
        this._shMemCheck.setSelected(true);
        this.toggleTCPCheckBox(false);
        this.toggleEncTable(false);
    }

    private void clearTCPTable() {
        for (int i = 0; i < this._tcpTable.getRowCount(); ++i) {
            this._tcpTable.setValueAt("", i, 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._tcpCheck) {
            boolean bl = this._tcpCheck.isSelected();
            this._hostLabel.setEnabled(bl);
            this._hostField.setEnabled(bl);
            this._portLabel.setEnabled(bl);
            this._portField.setEnabled(bl);
            this._otherLabel.setEnabled(bl);
            this._otherField.setEnabled(bl);
            this._tcpEditButton.setEnabled(bl);
            this._pingButton.setEnabled(bl);
        } else if (object == this._encTypeCombo) {
            String string = this._encTypeCombo.getSelectedItem().toString();
            this.toggleEncTable(this._tlsName.equalsIgnoreCase(string));
        } else if (object == this._tcpEditButton) {
            this.handleShowTCPTable();
        } else if (object == this._pingButton) {
            this.handlePing();
        }
    }

    private void handlePing() {
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        Dialog dialog = this.getParentDialog();
        String string = this._hostField.getText();
        String string2 = logonResourcesBase.get("NETWORK_PING_TITLE");
        if (string == null || string.length() == 0) {
            SybOptionPane.showMessageDialog((Component)dialog, (Object)logonResourcesBase.get("NETWORK_NOTHING_TO_PING"), (String)string2, (int)2);
            return;
        }
        PingDialog pingDialog = new PingDialog(dialog, string2, logonResourcesBase, string);
        pingDialog.create();
    }

    private void handleShowTCPTable() {
        this.clearTCPTable();
        this.populateTCPTableData();
        PropTableDialog propTableDialog = new PropTableDialog(this.getParentDialog(), this._tcpDialogTitle);
        propTableDialog.create();
    }

    private Dialog getParentDialog() {
        Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        return dialog;
    }

    void commitPartialEdits() {
        if (this._tcpTable.isEditing()) {
            ((AbstractCellEditor)((Object)this._tcpTable.getCellEditor())).stopCellEditing();
        }
        if (this._encTable.isEditing()) {
            ((AbstractCellEditor)((Object)this._encTable.getCellEditor())).stopCellEditing();
        }
    }

    boolean hostEntered() {
        String string = this._hostField.getText();
        return this._tcpCheck.isSelected() && string != null && string.length() > 0;
    }

    boolean portEntered() {
        String string = this._portField.getText(false);
        return this._tcpCheck.isSelected() && string != null && string.length() > 0;
    }

    void addNoVerifyParms() {
        String string = this._otherField.getText();
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null && string.length() > 0) {
            ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
            while (connectionStringTokenizer.hasMoreTokens()) {
                String string2 = connectionStringTokenizer.nextToken();
                String[] stringArray = string2.split("=");
                if (stringArray.length >= 1 && ("DOBROAD".equalsIgnoreCase(stringArray[0]) || "DoBroadcast".equalsIgnoreCase(stringArray[0]) || "VERIFY".equalsIgnoreCase(stringArray[0]) || "VerifyServerName".equalsIgnoreCase(stringArray[0]))) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(string2);
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append(";");
        }
        stringBuilder.append(NOVERIFY_PARMS);
        this._otherField.setText(stringBuilder.toString());
    }

    void selectDefaultOptions() {
        if (!this._shMemCheck.isSelected() && !this._tcpCheck.isSelected()) {
            this._shMemCheck.setSelected(true);
            this.toggleTCPCheckBox(false);
            this.toggleEncTable(false);
        }
    }

    JTextField getHostField() {
        return this._hostField;
    }

    IntegerTextField getPortField() {
        return this._portField;
    }

    JTextField getOtherPropField() {
        return this._otherField;
    }

    SybComboBox getEncTypeCombo() {
        return this._encTypeCombo;
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.commitPartialEdits();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    static class PingDialog
    extends JDialog
    implements ActionListener {
        private static final int PING_TIMEOUT = 10000;
        private LogonResourcesBase _res;
        private String _host;
        private SybLabel _label;
        private SybLabel _reasonLabel;
        private SybButton _dismiss;
        private SwingWorker _worker = null;

        PingDialog(Dialog dialog, String string, LogonResourcesBase logonResourcesBase, String string2) {
            super((Window)dialog, string, Dialog.ModalityType.DOCUMENT_MODAL);
            this._res = logonResourcesBase;
            this._host = string2;
        }

        void create() {
            this.createUI();
            new PingWorker().execute();
            this.setVisible(true);
            this.destroyUI();
        }

        private void createUI() {
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            ImageIcon imageIcon = new ImageIcon(LogonImages.getFindServer());
            this._label = new SybLabel(this._res.getFormatted("NETWORK_PING_ADDRESS_MSG", this._host));
            this._label.setIcon((Icon)imageIcon);
            this._label.setIconTextGap(10);
            this._label.setAlignmentX(0.0f);
            imageIcon.setImageObserver((ImageObserver)this._label);
            jPanel.add((Component)this._label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
            this._reasonLabel = new SybLabel(" ");
            this._reasonLabel.setAlignmentX(0.0f);
            jPanel.add((Component)this._reasonLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 42, 0, 0), 0, 0));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            this._dismiss = new SybButton(this._res.get("Cancel"));
            jPanel2.add(Box.createHorizontalGlue());
            jPanel2.add((Component)this._dismiss);
            jPanel2.add(Box.createHorizontalGlue());
            jPanel.add((Component)jPanel2, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 21, 2, new Insets(10, 0, 0, 0), 0, 0));
            this._dismiss.addActionListener((ActionListener)this);
            this.getContentPane().add(jPanel);
            this.pack();
            this.setResizable(false);
            this.setLocationRelativeTo(this.getParent());
        }

        private void destroyUI() {
            this._dismiss.removeActionListener((ActionListener)this);
            this._dismiss = null;
            DialogUtils.removeComponents((Container)this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this._dismiss) {
                if (this._worker != null && !this._worker.isDone()) {
                    this._worker.cancel(true);
                }
                this.setVisible(false);
            }
        }

        class PingWorker
        extends SwingWorker<Void, Void> {
            private String _result;
            private String _reason;
            private boolean _ok;

            PingWorker() {
            }

            @Override
            public Void doInBackground() {
                this._reason = null;
                this._result = null;
                this._ok = false;
                try {
                    InetAddress inetAddress = InetAddress.getByName(PingDialog.this._host);
                    this._ok = inetAddress.isReachable(10000);
                    if (this._ok) {
                        this._result = PingDialog.this._res.getFormatted("NETWORK_PING_SUCCESS_MSG", PingDialog.this._host);
                    } else {
                        this._result = PingDialog.this._res.getFormatted("NETWORK_PING_FAILURE_MSG", PingDialog.this._host);
                        this._reason = PingDialog.this._res.get("NETWORK_PING_HOST_DID_NOT_RESPOND");
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    this._result = PingDialog.this._res.getFormatted("NETWORK_PING_FAILURE_MSG", PingDialog.this._host);
                    this._reason = PingDialog.this._res.get("NETWORK_PING_UNKNOWN_HOST");
                }
                catch (IOException iOException) {
                    this._result = PingDialog.this._res.getFormatted("NETWORK_PING_FAILURE_MSG", PingDialog.this._host);
                    this._reason = iOException.getLocalizedMessage();
                }
                return null;
            }

            @Override
            protected void done() {
                if (!PingDialog.this.isVisible()) {
                    return;
                }
                if (this._ok) {
                    PingDialog.this._label.setIcon((Icon)new ImageIcon(LogonImages.getConnect32()));
                } else {
                    PingDialog.this._label.setIcon((Icon)new ImageIcon(LogonImages.getDisconnect32()));
                }
                PingDialog.this._label.setText(this._result);
                if (this._reason != null) {
                    PingDialog.this._reasonLabel.setText(this._reason);
                }
                SybButton sybButton = PingDialog.this._dismiss;
                LogonResourcesBase logonResourcesBase = PingDialog.this._res;
                PingDialog.this._res;
                sybButton.setText(logonResourcesBase.get("OK"));
                PingDialog.this.pack();
            }
        }
    }

    class PropTableDialog
    extends JDialog
    implements ActionListener {
        private static final String ESCAPE_ACTION = "Escape";
        private JTable _table;
        private SybButton _ok;
        private SybButton _cancel;

        PropTableDialog(Dialog dialog, String string) {
            super((Window)dialog, string, Dialog.ModalityType.DOCUMENT_MODAL);
        }

        void create() {
            this.createUI();
            this.setVisible(true);
            this.destroyUI();
        }

        private void createUI() {
            LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
            this._table = NetworkPageBase.this._tcpTable;
            JScrollPane jScrollPane = new JScrollPane(this._table);
            int n = this._table.getRowHeight();
            Cloneable cloneable = this._table.getPreferredScrollableViewportSize();
            cloneable.height = Math.max(cloneable.height, n * 8);
            this._table.setPreferredScrollableViewportSize((Dimension)cloneable);
            this._table.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropTableDialog.this.handleOK();
                }
            }, KeyStroke.getKeyStroke(10, 0), 0);
            this._table.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropTableDialog.this.handleCancel();
                }
            }, KeyStroke.getKeyStroke(27, 0), 0);
            this._ok = new SybButton(logonResourcesBase.get("OK"));
            this._ok.addActionListener((ActionListener)this);
            this.getRootPane().setDefaultButton((JButton)this._ok);
            this._cancel = new SybButton(logonResourcesBase.get("Cancel"));
            this._cancel.addActionListener((ActionListener)this);
            this.getRootPane().registerKeyboardAction(this, ESCAPE_ACTION, KeyStroke.getKeyStroke(27, 0, false), 2);
            DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            cloneable = new GridBagConstraints();
            ((GridBagConstraints)cloneable).anchor = 17;
            ((GridBagConstraints)cloneable).gridx = 0;
            ((GridBagConstraints)cloneable).gridy = 0;
            ((GridBagConstraints)cloneable).gridwidth = 3;
            ((GridBagConstraints)cloneable).gridheight = 1;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            ((GridBagConstraints)cloneable).weighty = 1.0;
            ((GridBagConstraints)cloneable).fill = 1;
            jPanel.add((Component)jScrollPane, cloneable);
            Component component = Box.createHorizontalGlue();
            ((GridBagConstraints)cloneable).gridx = 0;
            ((GridBagConstraints)cloneable).gridy = 1;
            ((GridBagConstraints)cloneable).weightx = 1.0;
            ((GridBagConstraints)cloneable).weighty = 0.0;
            ((GridBagConstraints)cloneable).gridwidth = 1;
            ((GridBagConstraints)cloneable).gridheight = 1;
            ((GridBagConstraints)cloneable).fill = 2;
            jPanel.add(component, cloneable);
            ((GridBagConstraints)cloneable).gridx = 1;
            ((GridBagConstraints)cloneable).gridy = 1;
            ((GridBagConstraints)cloneable).gridwidth = 1;
            ((GridBagConstraints)cloneable).gridheight = 1;
            ((GridBagConstraints)cloneable).weightx = 0.0;
            ((GridBagConstraints)cloneable).weighty = 0.0;
            ((GridBagConstraints)cloneable).insets = new Insets(8, 0, 0, 5);
            jPanel.add((Component)this._ok, cloneable);
            ((GridBagConstraints)cloneable).gridx = 2;
            ((GridBagConstraints)cloneable).gridy = 1;
            ((GridBagConstraints)cloneable).gridwidth = 1;
            ((GridBagConstraints)cloneable).gridheight = 1;
            ((GridBagConstraints)cloneable).weightx = 0.0;
            ((GridBagConstraints)cloneable).weighty = 0.0;
            ((GridBagConstraints)cloneable).insets = new Insets(8, 0, 0, 0);
            jPanel.add((Component)this._cancel, cloneable);
            this.getContentPane().add(jPanel);
            this.pack();
            this.setLocationRelativeTo(this.getParent());
        }

        private void destroyUI() {
            this.getRootPane().setDefaultButton(null);
            this._ok.removeActionListener((ActionListener)this);
            this._ok = null;
            this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
            this.dispose();
        }

        private void handleOK() {
            NetworkPageBase.this.commitPartialEdits();
            this.setVisible(false);
            NetworkPageBase.this.setTCPFieldFromTable();
        }

        private void handleCancel() {
            NetworkPageBase.this.commitPartialEdits();
            this.setVisible(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this._ok) {
                this.handleOK();
            } else if (object == this._cancel) {
                this.handleCancel();
            }
        }
    }
}

