/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.util.win32.Registry;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;

public class ODBCDataSource {
    private Type _type;
    private String _name;
    private String _driverName;
    private String _description;
    private Properties _properties;
    private boolean _isRead;

    public String toString() {
        return "ODBCDataSource[Name=" + this._name + ",Description=" + this._description + ",Type=" + (Object)((Object)this._type) + ",Driver=" + this._driverName + ",Properties=" + this._properties + ",isRead=" + this._isRead + "]";
    }

    public static ODBCDataSource getDataSource(Type type, String string) {
        ODBCDataSource oDBCDataSource = null;
        if (Registry.isInstalled()) {
            int n = type == Type.USER_DSN ? 1 : 0;
            String string2 = Registry.getValue((int)n, (String)("SOFTWARE\\ODBC\\ODBC.INI\\" + string), (String)"Driver");
            String string3 = ODBCDataSource.getDriverNameFromFileName(string2);
            oDBCDataSource = new ODBCDataSource(type, string, string3);
        }
        return oDBCDataSource;
    }

    private static String getDriverNameFromFileName(String string) {
        String string2 = null;
        Vector vector = Registry.enumerateKeys((int)0, (String)"SOFTWARE\\ODBC\\ODBCINST.INI");
        for (int i = 0; i < vector.size(); ++i) {
            string2 = (String)vector.get(i);
            String string3 = Registry.getValue((int)0, (String)("SOFTWARE\\ODBC\\ODBCINST.INI\\" + string2), (String)"Driver");
            if (string3 != null && string3.equalsIgnoreCase(string)) break;
            string2 = null;
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static ODBCDataSource[] getDataSources(Type type, String string) {
        ODBCDataSource[] oDBCDataSourceArray;
        if (Registry.isInstalled()) {
            int n = type == Type.USER_DSN ? 1 : 0;
            String string2 = "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources";
            Vector vector = Registry.enumerateValues((int)n, (String)string2);
            ArrayList<ODBCDataSource> arrayList = new ArrayList<ODBCDataSource>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                String string3 = (String)vector.elementAt(i);
                String string4 = Registry.getValue((int)n, (String)string2, (String)string3);
                if (string != null && !string.equalsIgnoreCase(string4)) continue;
                arrayList.add(new ODBCDataSource(type, string3, string4));
            }
            oDBCDataSourceArray = new ODBCDataSource[arrayList.size()];
            arrayList.toArray(oDBCDataSourceArray);
        } else {
            oDBCDataSourceArray = new ODBCDataSource[]{};
        }
        return oDBCDataSourceArray;
    }

    public Type getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getDriverName() {
        return this._driverName;
    }

    public String getDescription() {
        if (!this._isRead) {
            this.read();
        }
        return this._description;
    }

    public Properties getProperties() {
        if (!this._isRead) {
            this.read();
        }
        return this._properties;
    }

    private ODBCDataSource(Type type, String string, String string2) {
        this._type = type;
        this._name = string;
        this._driverName = string2;
        this._isRead = false;
    }

    private void read() {
        int n = this._type == Type.USER_DSN ? 1 : 0;
        this._properties = new Properties();
        String string = "Software\\ODBC\\ODBC.INI\\" + this._name;
        Vector vector = Registry.enumerateValues((int)n, (String)string);
        for (int i = 0; i < vector.size(); ++i) {
            String string2;
            String string3 = (String)vector.elementAt(i);
            if (string3 == null || string3.length() <= 0 || string3.equalsIgnoreCase("Driver") || (string2 = Registry.getValue((int)n, (String)string, (String)string3)) == null || string2.length() <= 0) continue;
            if (string3.equalsIgnoreCase("Description")) {
                this._description = string2;
                continue;
            }
            this._properties.setProperty(string3, string2);
        }
        this._isRead = true;
    }

    public static enum Type {
        USER_DSN,
        SYSTEM_DSN;

    }
}

