/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.common.CommonUtils;
import com.sybase.asa.common.ProcessException;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.util.Platform;
import com.sybase.util.SybOptionPane;
import com.sybase.util.win32.Registry;
import com.sybase.util.win32.Win32Util;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class ODBCUtils {
    public static final int USER_DSN = 0;
    public static final int SYSTEM_DSN = 1;

    public static boolean isValidDSN(String string) {
        boolean bl = ODBCUtils.isValidDSN(0, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", string);
        if (!bl) {
            bl = ODBCUtils.isValidDSN(1, "SOFTWARE\\ODBC\\ODBC.INI\\ODBC Data Sources", string);
        }
        return bl;
    }

    private static boolean isValidDSN(int n, String string, String string2) {
        String string3;
        boolean bl = Registry.isInstalled() ? (string3 = Registry.getValue((int)n, (String)string, (String)string2)) != null : true;
        return bl;
    }

    static void createDSN(int n, String string, String string2, File file, Properties properties) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid value for type: " + n);
        }
        if (!Platform.isWindows()) {
            return;
        }
        if (Platform.isVista() && n == 1) {
            ODBCUtils.createVistaSystemDSN(string, properties);
        }
        int n2 = n == 0 ? 1 : 0;
        if (!Registry.isInstalled()) {
            return;
        }
        ODBCUtils.deleteDSN(string, n2);
        Registry.createKey((int)n2, (String)"Software\\ODBC\\ODBC.INI\\ODBC Data Sources");
        Registry.setValue((int)n2, (String)"Software\\ODBC\\ODBC.INI\\ODBC Data Sources", (String)string, (String)string2);
        String string3 = "Software\\ODBC\\ODBC.INI\\" + string;
        Registry.createKey((int)n2, (String)string3);
        Registry.setValue((int)n2, (String)string3, (String)"Driver", (String)file.getAbsolutePath());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            String string5 = properties.getProperty(string4);
            Registry.setValue((int)n2, (String)string3, (String)string4, (String)string5);
        }
    }

    private static void createVistaSystemDSN(String string, Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("dbdsn -y -ws \"");
        stringBuilder.append(string);
        stringBuilder.append("\" -c \"");
        boolean bl = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (bl) {
                stringBuilder.append(';');
            }
            stringBuilder.append(string2);
            stringBuilder.append('=');
            stringBuilder.append(string3);
            bl = true;
        }
        stringBuilder.append('\"');
        try {
            CommonUtils.runProcess(null, null, (String)stringBuilder.toString(), null, null, (String)"");
        }
        catch (ProcessException processException) {
            // empty catch block
        }
    }

    static void deleteDSN(String string, int n) {
        String string2 = Registry.getValue((int)n, (String)"Software\\ODBC\\ODBC.INI\\ODBC Data Sources", (String)string);
        if (string2 != null && string2.length() > 0) {
            Registry.deleteValue((int)n, (String)"Software\\ODBC\\ODBC.INI\\ODBC Data Sources", (String)string);
            Registry.deleteKey((int)n, (String)("Software\\ODBC\\ODBC.INI\\" + string));
        }
    }

    public static void openODBCAdministrator(Window window) {
        int n = 0;
        boolean bl = false;
        String string = "";
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        if (!Platform.isWindows()) {
            return;
        }
        if (Platform.isVista()) {
            n = Win32Util.shellExecute((String)"odbcad32.exe");
            if (n <= 32) {
                bl = true;
                string = logonResourcesBase.getFormatted("\tError code={0}", String.valueOf(n));
            }
        } else {
            try {
                Runtime.getRuntime().exec("odbcad32.exe");
            }
            catch (IOException iOException) {
                bl = true;
                string = logonResourcesBase.getFormatted("CouldNotOpenODBCAdmin", iOException.getLocalizedMessage());
            }
        }
        if (bl) {
            String string2;
            if (window instanceof Frame) {
                string2 = ((Frame)window).getTitle();
            } else if (window instanceof Dialog) {
                string2 = ((Dialog)window).getTitle();
            } else {
                throw new IllegalArgumentException("parent window must be a Frame or Dialog");
            }
            SybOptionPane.showMessageDialog((Component)window, (Object)string, (String)string2, (int)0);
        }
    }

    public static String getDefaultFileDSNFolder() {
        String string = null;
        if (Platform.isWindows() && Registry.isInstalled()) {
            string = Registry.getValue((int)0, (String)"SOFTWARE\\ODBC\\ODBC.INI\\ODBC File DSN", (String)"DefaultDSNDir");
        }
        return string;
    }

    public static void openODBCAdministrator(Frame frame) {
        boolean bl = false;
        int n = 0;
        String string = "";
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        if (!Platform.isWindows()) {
            return;
        }
        if (Platform.isVista()) {
            n = Win32Util.shellExecute((String)"odbcad32.exe");
            if (n <= 32) {
                bl = true;
                string = logonResourcesBase.getFormatted("\tError code={0}", String.valueOf(n));
            }
        } else {
            try {
                Runtime.getRuntime().exec("odbcad32.exe");
            }
            catch (IOException iOException) {
                bl = true;
                string = logonResourcesBase.getFormatted("CouldNotOpenODBCAdmin", iOException.getLocalizedMessage());
            }
        }
        if (bl) {
            SybOptionPane.showMessageDialog((Component)frame, (Object)string, (String)frame.getTitle(), (int)0);
        }
    }

    static String stripODBCHeader(String string) {
        boolean bl = false;
        String string2 = string;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            if (bl) {
                if (c != ']') continue;
                bl = false;
                continue;
            }
            if (c == '[') {
                bl = true;
                continue;
            }
            string2 = string.substring(i);
            break;
        }
        return string2;
    }

    public static boolean isTracingEnabled() {
        boolean bl = false;
        if (Registry.isInstalled()) {
            String string = Registry.getValue((int)1, (String)"SOFTWARE\\ODBC\\ODBC.INI\\ODBC", (String)"Trace");
            bl = string != null && string.equals("1");
        }
        return bl;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

