/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.util.NumericTextField;

public class PropertyMetaData {
    public static final String BOOLEAN_YES = "YES";
    public static final String BOOLEAN_NO = "NO";
    public static final String BLANK_VALUE = "";
    public static final String INT_K = "k";
    public static final String INT_M = "m";
    public static final String INT_G = "g";
    public static final long KB_CONVERT = 1024L;
    public static final long MB_CONVERT = 0x100000L;
    public static final long GB_CONVERT = 0x40000000L;
    private String _name;
    private String _longName;
    private String _value;
    private String _descr;
    private PropType _type;
    private boolean _hasUnits;
    private long _minVal;
    private long _maxVal;
    private String[] _enumValues;
    private boolean _enumAllowsEdits;

    public PropertyMetaData(String string, String string2, PropType propType) {
        this(string, string2, BLANK_VALUE, BLANK_VALUE, propType);
    }

    public PropertyMetaData(String string, String string2, String string3, PropType propType) {
        this(string, string2, string3, BLANK_VALUE, propType);
    }

    public PropertyMetaData(String string, String string2, String string3, String string4, PropType propType) {
        this._name = string;
        this._longName = string2;
        this._descr = string3;
        this._value = string4;
        this._type = propType;
        this._hasUnits = false;
        this._minVal = Long.MIN_VALUE;
        this._maxVal = Long.MAX_VALUE;
        this._enumValues = null;
        this._enumAllowsEdits = false;
    }

    public String getName() {
        return this._name;
    }

    public String getLongName() {
        return this._longName;
    }

    public String getValue() {
        return this._value;
    }

    public String getDescription() {
        return this._descr;
    }

    public PropType getType() {
        return this._type;
    }

    public void setValue(String string) throws IllegalArgumentException {
        assert (string != null);
        if (BLANK_VALUE.equals(string = string.trim())) {
            this._value = string;
            return;
        }
        switch (this._type) {
            case STRING: 
            case PASSWORD: {
                break;
            }
            case FILE: {
                break;
            }
            case BOOLEAN: {
                if ("Y".equalsIgnoreCase(string) || BOOLEAN_YES.equalsIgnoreCase(string) || "ON".equalsIgnoreCase(string) || "TRUE".equalsIgnoreCase(string) || "T".equalsIgnoreCase(string) || "1".equalsIgnoreCase(string)) {
                    string = BOOLEAN_YES;
                    break;
                }
                if ("N".equalsIgnoreCase(string) || BOOLEAN_NO.equalsIgnoreCase(string) || "OFF".equalsIgnoreCase(string) || "FALSE".equalsIgnoreCase(string) || "F".equalsIgnoreCase(string) || "0".equalsIgnoreCase(string)) {
                    string = BOOLEAN_NO;
                    break;
                }
                string = BLANK_VALUE;
                break;
            }
            case INTEGER: {
                if (this._hasUnits) {
                    long l;
                    try {
                        l = NumericTextField.decodeWithUnit((String)string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException(LogonResourcesBase.getBundle().getFormatted("ERR_PROPERTY_VALUE_OUT_OF_RANGE", Long.toString(this._minVal), Long.toString(this._maxVal)));
                    }
                    if (l >= this._minVal && l <= this._maxVal) break;
                    throw new IllegalArgumentException(LogonResourcesBase.getBundle().getFormatted("ERR_PROPERTY_VALUE_OUT_OF_RANGE", Long.toString(this._minVal), Long.toString(this._maxVal)));
                }
                long l = -1L;
                try {
                    l = Long.parseLong(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(LogonResourcesBase.getBundle().getFormatted("ERR_PROPERTY_VALUE_OUT_OF_RANGE", Long.toString(this._minVal), Long.toString(this._maxVal)));
                }
                if (l >= this._minVal && l <= this._maxVal) break;
                throw new IllegalArgumentException(LogonResourcesBase.getBundle().getFormatted("ERR_PROPERTY_VALUE_OUT_OF_RANGE", Long.toString(this._minVal), Long.toString(this._maxVal)));
            }
            case ENUM: {
                if (this._enumAllowsEdits) break;
                if (this._enumValues == null) {
                    throw new IllegalStateException("Enum datatype specified with no associated values.");
                }
                boolean bl = false;
                for (int i = 0; !bl && i < this._enumValues.length; ++i) {
                    if (!this._enumValues[i].equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) break;
                throw new IllegalStateException("Value supplied to property does not match any allowable value.");
            }
        }
        this._value = string;
    }

    public void setHasUnits(boolean bl) {
        if (this._type == PropType.INTEGER) {
            this._hasUnits = bl;
        }
    }

    public boolean getHasUnits() {
        return this._hasUnits;
    }

    public void setValidRange(long l, long l2) {
        if (this._type == PropType.INTEGER) {
            this._minVal = l;
            this._maxVal = l2;
        }
    }

    public void setEnumValues(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this._type == PropType.ENUM) {
            this._enumValues = stringArray;
        }
    }

    public String[] getEnumValues() {
        return this._enumValues;
    }

    public void setEnumAllowsEdits(boolean bl) {
        if (this._type == PropType.ENUM) {
            this._enumAllowsEdits = bl;
        }
    }

    public boolean isEnumAllowsEdits() {
        return this._enumAllowsEdits;
    }

    public static enum PropType {
        STRING,
        BOOLEAN,
        INTEGER,
        ENUM,
        FILE,
        PASSWORD;

    }
}

