/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.PropertyMetaData;
import com.sybase.asa.logon.PropertyTableModel;
import com.sybase.asa.logon.PropertyTablePasswordRenderer;
import com.sybase.util.JREUtils;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

class PropertyTable
extends JTable {
    private PropertyTablePasswordRenderer _passwordRenderer = null;

    PropertyTable(TableModel tableModel) {
        super(tableModel);
        this.init();
    }

    PropertyTable() {
        this.init();
    }

    private void init() {
        this.setColumnSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setAutoResizeMode(0);
        this.setSelectionMode(0);
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        PropertyTableModel propertyTableModel;
        PropertyMetaData propertyMetaData;
        TableModel tableModel;
        TableCellRenderer tableCellRenderer = null;
        if (n2 == 1 && (tableModel = this.getModel()) instanceof PropertyTableModel && (propertyMetaData = (propertyTableModel = (PropertyTableModel)tableModel).getMetaDataForRow(n)).getType() == PropertyMetaData.PropType.PASSWORD) {
            if (this._passwordRenderer == null) {
                this._passwordRenderer = new PropertyTablePasswordRenderer();
            }
            tableCellRenderer = this._passwordRenderer;
        }
        if (tableCellRenderer == null) {
            tableCellRenderer = super.getCellRenderer(n, n2);
        }
        return tableCellRenderer;
    }

    @Override
    public void setValueAt(final Object object, final int n, final int n2) {
        try {
            this.getModel().setValueAt(object, this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Window window = SwingUtilities.getWindowAncestor(this);
            SybOptionPane.showMessageDialog((Component)window, (Object)illegalArgumentException.getLocalizedMessage(), (String)LogonResourcesBase.getBundle().get("Error"), (int)0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PropertyTable.this.requestFocusInWindow();
                    PropertyTable.this.changeSelection(n, n2, false, false);
                    PropertyTable.this.editCellAt(n, 1);
                    Component component = PropertyTable.this.getEditorComponent();
                    if (component != null) {
                        component.requestFocusInWindow();
                        if (component instanceof JTextComponent) {
                            ((JTextComponent)component).setText(object.toString());
                        }
                    }
                }
            });
        }
    }

    void setInitialColumnWidths() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            int n3;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            if (this.getTableHeader() != null) {
                tableCellRenderer = JREUtils.getTableCellRenderer((JTable)this, (int)i);
                n3 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)0).getPreferredSize().width;
            } else {
                n3 = 0;
            }
            Class<?> clazz = this.getColumnClass(i);
            tableCellRenderer = this.getDefaultRenderer(clazz);
            for (int j = 0; j < n2; ++j) {
                int n4 = tableCellRenderer.getTableCellRendererComponent((JTable)this, (Object)this.getValueAt((int)j, (int)i), (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n3 = Math.max(n3, n4);
            }
            tableColumn.setMinWidth(n3 + 6);
            tableColumn.setPreferredWidth(n3 + 6);
        }
        this.sizeColumnsToFit(-1);
    }
}

