/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.logon.AbstractConnectionInfo;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public final class UltraLiteConnectionInfo
extends AbstractConnectionInfo {
    public static final String USER_PROPERTY = "UID";
    public static final String PASSWORD_PROPERTY = "PWD";
    public static final String ODBC_DSN_PROPERTY = "DSN";
    public static final String ODBC_DSF_PROPERTY = "DSF";
    public static final String DATABASE_FILENAME_PROPERTY = "DBF";
    public static final String ENCRYPTION_KEY_PROPERTY = "DBKEY";
    public static final String CONNECTION_NAME_PROPERTY = "CON";
    public static final String DATABASE_NAME_PROPERTY = "DBN";
    static final char DELIMITER = ';';
    private static final String USERID_PREFIX = "UID=";
    private static final String PASSWORD_PREFIX = "PWD=";
    private static final String DATABASE_FILE_PREFIX = "DBF=";
    private static final String DSN_PREFIX = "DSN=";
    private static final String DSF_PREFIX = "DSF=";
    private static final String DBKEY_PREFIX = "DBKEY=";
    private static final String CONNECTION_NAME_PREFIX = "CON=";
    private static final String ADVANCED_PREFIX = "ADVANCED=";
    private Properties _props = new Properties();

    public UltraLiteConnectionInfo() {
    }

    public UltraLiteConnectionInfo(UltraLiteConnectionInfo ultraLiteConnectionInfo) {
        if (ultraLiteConnectionInfo != null) {
            this.merge(ultraLiteConnectionInfo);
        }
    }

    public UltraLiteConnectionInfo(String string) {
        this.deserialize(string);
    }

    @Override
    public String serialize() {
        String string = this.getConnectionString(true);
        return string;
    }

    @Override
    public void deserialize(String string) {
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String string2 = connectionStringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (string3.compareTo(USER_PROPERTY) == 0) {
                this._props.setProperty(USER_PROPERTY, string4);
                continue;
            }
            if (string3.compareTo(PASSWORD_PROPERTY) == 0) {
                this._props.setProperty(PASSWORD_PROPERTY, this.decryptPassword(string4));
                continue;
            }
            if (string3.compareTo(ODBC_DSN_PROPERTY) == 0) {
                this._props.setProperty(ODBC_DSN_PROPERTY, string4);
                continue;
            }
            if (string3.compareTo(ODBC_DSF_PROPERTY) == 0) {
                this._props.setProperty(ODBC_DSF_PROPERTY, string4);
                continue;
            }
            if (string3.compareTo(DATABASE_FILENAME_PROPERTY) == 0) {
                this._props.setProperty(DATABASE_FILENAME_PROPERTY, string4);
                continue;
            }
            if (string3.compareTo(ENCRYPTION_KEY_PROPERTY) == 0) {
                this._props.setProperty(ENCRYPTION_KEY_PROPERTY, this.decryptPassword(string4));
                continue;
            }
            if (string3.compareTo(CONNECTION_NAME_PROPERTY) == 0) {
                this._props.setProperty(CONNECTION_NAME_PROPERTY, string4);
                continue;
            }
            this._props.setProperty(string3, string4);
        }
    }

    public void merge(UltraLiteConnectionInfo ultraLiteConnectionInfo) {
        if (ultraLiteConnectionInfo != null) {
            Enumeration<?> enumeration = ultraLiteConnectionInfo._props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = ultraLiteConnectionInfo.getParameter(string);
                this._props.setProperty(string, string2);
            }
        }
    }

    Enumeration getParameterNames() {
        return this._props.propertyNames();
    }

    public String getParameter(String string) {
        return this._props.getProperty(string);
    }

    public void setParameter(String string, String string2) {
        if (string2 != null) {
            if (DATABASE_FILENAME_PROPERTY.equals(string) || USER_PROPERTY.equals(string) || PASSWORD_PROPERTY.equals(string)) {
                string2 = string2.trim();
            }
            this._props.setProperty(string, string2);
        } else {
            this._props.remove(string);
        }
    }

    private String getConnectionString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(128);
        Enumeration<Object> enumeration = this._props.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this._props.getProperty(string);
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(string);
            stringBuffer.append('=');
            if (bl && (string.equals(PASSWORD_PROPERTY) || string.equals(ENCRYPTION_KEY_PROPERTY))) {
                stringBuffer.append(this.encryptPassword(string2));
                continue;
            }
            stringBuffer.append(UltraLiteConnectionInfo.quoteIfNeeded(string2));
        }
        return stringBuffer.toString();
    }

    public static String quoteIfNeeded(String string) {
        return string;
    }

    public static boolean validParameter(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            char c = string.charAt(0);
            if (string.indexOf(59) >= 0 || Character.isWhitespace(c) || Character.isWhitespace(string.charAt(n - 1))) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.getConnectionString(false);
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(false);
    }

    @Override
    public int getDatabaseType() {
        return 2;
    }

    public void setDatabaseName(String string) {
        this.setParameter(DATABASE_NAME_PROPERTY, string);
    }

    public String getDatabaseName() {
        return this.getParameter(DATABASE_NAME_PROPERTY);
    }

    public void setConnectionName(String string) {
        this.setParameter(CONNECTION_NAME_PROPERTY, string);
    }

    public String getConnectionName() {
        return this.getParameter(CONNECTION_NAME_PROPERTY);
    }

    public void setDatabaseFileName(String string) {
        this.setParameter(DATABASE_FILENAME_PROPERTY, string);
    }

    public String getDatabaseFileName() {
        return this.getParameter(DATABASE_FILENAME_PROPERTY);
    }

    public void setDBKey(String string) {
        this.setParameter(ENCRYPTION_KEY_PROPERTY, string);
    }

    public String getDBKey() {
        return this.getParameter(ENCRYPTION_KEY_PROPERTY);
    }

    @Override
    public String getPassword() {
        return this.getParameter(PASSWORD_PROPERTY);
    }

    @Override
    public void setPassword(String string) {
        this.setParameter(PASSWORD_PROPERTY, string);
    }

    @Override
    public void setUserName(String string) {
        this.setParameter(USER_PROPERTY, string);
    }

    @Override
    public String getUserName() {
        return this.getParameter(USER_PROPERTY);
    }

    public String getDSN() {
        return this.getParameter(ODBC_DSN_PROPERTY);
    }

    public String getDSF() {
        return this.getParameter(ODBC_DSF_PROPERTY);
    }

    @Override
    public String getURL() {
        return this._getURL(true, null);
    }

    public String getNativeURL(String string) {
        return this._getURL(false, string);
    }

    public String getNativeURL() {
        return this._getURL(false, null);
    }

    private String _getURL(boolean bl, String string) {
        String string2 = this.getParameter(ODBC_DSN_PROPERTY);
        StringBuffer stringBuffer = new StringBuffer(128);
        if (bl) {
            stringBuffer.append("jdbc:odbc:");
            stringBuffer.append("driver=UltraLite ");
            stringBuffer.append(Integer.toString(11));
        }
        if (string != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(DATABASE_NAME_PROPERTY);
            stringBuffer.append('=');
            stringBuffer.append(UltraLiteConnectionInfo.quoteIfNeeded(string));
        } else {
            String string3 = this.getParameter(DATABASE_NAME_PROPERTY);
            if (string3 != null) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(';');
                }
                stringBuffer.append(DATABASE_NAME_PROPERTY);
                stringBuffer.append('=');
                stringBuffer.append(UltraLiteConnectionInfo.quoteIfNeeded(string3));
            }
        }
        Enumeration<Object> enumeration = this._props.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = enumeration.nextElement().toString();
            String string5 = this._props.getProperty(string4);
            if (string4.equals(ODBC_DSN_PROPERTY) || string4.equals(ODBC_DSF_PROPERTY) || string4.equals(DATABASE_NAME_PROPERTY)) continue;
            if (!bl && string4.equals(CONNECTION_NAME_PROPERTY)) {
                string5 = "N_" + string5;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(string4);
            stringBuffer.append('=');
            stringBuffer.append(UltraLiteConnectionInfo.quoteIfNeeded(string5));
        }
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        UltraLiteConnectionInfo ultraLiteConnectionInfo = new UltraLiteConnectionInfo();
        Enumeration<Object> enumeration = this._props.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this._props.getProperty(string);
            ultraLiteConnectionInfo._props.setProperty(string, string2);
        }
        ultraLiteConnectionInfo._classLoader = this._classLoader;
        return ultraLiteConnectionInfo;
    }

    @Override
    public void mergeConnectionString(String string) {
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String string2 = connectionStringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n == -1) continue;
            this.setConnectionInfoDataFromNameValue(string2.substring(0, n), string2.substring(n + 1));
        }
    }

    private void setConnectionInfoDataFromToken(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n) + '=' + string.substring(n + 1);
            } else {
                return;
            }
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        this.setConnectionInfoDataFromNameValue(string2, string3);
    }

    private void setConnectionInfoDataFromNameValue(String string, String string2) {
        if (string.equalsIgnoreCase(ODBC_DSN_PROPERTY) || string.equalsIgnoreCase("DataSourceName")) {
            this._props.setProperty(ODBC_DSN_PROPERTY, string2);
        } else if (string.equalsIgnoreCase("FileDSN") || string.equalsIgnoreCase("FileDataSourceName")) {
            this._props.setProperty(ODBC_DSF_PROPERTY, string2);
        } else if (string.equalsIgnoreCase(DATABASE_FILENAME_PROPERTY) || string.equalsIgnoreCase("DatabaseFile")) {
            this._props.setProperty(DATABASE_FILENAME_PROPERTY, string2);
        } else if (string.equalsIgnoreCase(ENCRYPTION_KEY_PROPERTY) || string.equalsIgnoreCase("key")) {
            this._props.setProperty(ENCRYPTION_KEY_PROPERTY, string2);
        } else if (string.equalsIgnoreCase(CONNECTION_NAME_PROPERTY) || string.equalsIgnoreCase("ConnectionName")) {
            this._props.setProperty(CONNECTION_NAME_PROPERTY, string2);
        } else if (string.equalsIgnoreCase(USER_PROPERTY) || string.equalsIgnoreCase("UserID") || string.equalsIgnoreCase("User")) {
            this._props.setProperty(USER_PROPERTY, string2);
        } else if (string.equalsIgnoreCase(PASSWORD_PROPERTY) || string.equalsIgnoreCase("Password")) {
            this._props.setProperty(PASSWORD_PROPERTY, string2);
        } else {
            this._props.setProperty(string, string2);
        }
    }

    @Override
    public boolean canAttemptConnection() {
        String string = this.getParameter(DATABASE_FILENAME_PROPERTY);
        boolean bl = string != null && string.length() > 0;
        return bl;
    }

    public Connection getConnection() throws SQLException {
        Connection connection = null;
        try {
            String string = this.getURL();
            Properties properties = new Properties();
            Driver driver = JDBCDrivers.loadIAnywhereJDBCODBCDriver(this._classLoader);
            connection = driver.connect(string, properties);
            try {
                connection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            SQLException sQLException = new SQLException("The iAnywhere JDBC Driver could not be loaded.");
            sQLException.initCause(classNotFoundException);
            throw sQLException;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        return connection;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

