/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.logon;

import com.sybase.asa.logon.CEProxyPortDialog;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonResourcesBase;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.LogonSourceHost;
import com.sybase.asa.logon.ODBCUtils;
import com.sybase.asa.logon.Preferences;
import com.sybase.asa.logon.Tool;
import com.sybase.asa.logon.UltraLiteConnectionInfo;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.FontHelper;
import com.sybase.util.MRUComboBox;
import com.sybase.util.Platform;
import com.sybase.util.SybButton;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybTextArea;
import com.sybase.util.win32.Registry;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class UltraLiteDatabaseSource
implements LogonSource,
ActionListener {
    private static final String SAVE_PREFIX = "ULDatabaseSource";
    private static final String SAVE_DATABASE_FILE = "databaseFile";
    private static final String SAVE_LAST_DBF_FOLDER = "lastDBFFolder";
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private JTabbedPane _tabbedPane = null;
    private JPanel _identificationPanel = null;
    private JPanel _advancedPanel = null;
    private SybLabel _useridLabel = null;
    private JTextField _userid = null;
    private SybLabel _passwordLabel = null;
    private JTextField _password = null;
    private MRUComboBox _databaseFile = null;
    private SybButton _browseDatabaseFile = null;
    private SybLabel _databaseKeyLabel = null;
    private JPasswordField _databaseKey = null;
    private DocumentListener _databaseFileDocumentListener = null;
    private SybTextArea _advanced = null;
    private ClassLoader _classLoader = null;
    private boolean _simplified = false;
    private String _helpJARLocation = null;
    private String _helpPrefix;
    private String _helpSuffix;
    private HelpViewer _helpViewer = null;
    private LogonResourcesBase _res = null;
    private JPanel _panel = null;
    private UltraLiteConnectionInfo _initialConnectionInfo = null;
    private Exception _initialException = null;
    private LogonSourceHost _host = null;
    private Object[] _tools = null;
    private static final int TEST_CONNECTION_TOOL_ID = 1;
    private static final int CE_PROXY_PORT_TOOL_ID = 2;

    public UltraLiteDatabaseSource(int n) {
        this._simplified = (n & 1) != 0;
        this._res = LogonResourcesBase.getBundle();
    }

    @Override
    public void setLogonSourceHost(LogonSourceHost logonSourceHost) {
        this._host = logonSourceHost;
    }

    @Override
    public void notifyLogonSourceSelected(boolean bl) {
        this._host.enableOKButton(true);
    }

    @Override
    public void notifyConnectOK() {
        Preferences.save(SAVE_PREFIX, SAVE_DATABASE_FILE, this._databaseFile.getMRUList());
    }

    @Override
    public void setInitialConnectionInfo(AbstractConnectionInfo abstractConnectionInfo) {
        if (abstractConnectionInfo instanceof UltraLiteConnectionInfo) {
            this._initialConnectionInfo = (UltraLiteConnectionInfo)abstractConnectionInfo;
        }
    }

    @Override
    public void destroy() {
        this.destroyGUI();
        this._res = null;
        this._initialConnectionInfo = null;
        this._helpViewer = null;
        this._host = null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getPanel(0).getPreferredSize();
    }

    @Override
    public JPanel getPanel(int n) {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel;
    }

    @Override
    public String getHelpContextId() {
        String string;
        if (this._tabbedPane == null) {
            string = "HELP_UL_DB_SRC_PAGE_1";
        } else {
            switch (this._tabbedPane.getSelectedIndex()) {
                default: {
                    string = "HELP_UL_DB_SRC_PAGE_1";
                    break;
                }
                case 1: {
                    string = "HELP_UL_DB_SRC_PAGE_2";
                }
            }
        }
        return string;
    }

    private void buildConnectionString(ConnectionStringBuilder connectionStringBuilder) {
        String string;
        if (this._userid.getText().trim().length() != 0) {
            connectionStringBuilder.addParm("UID", this._userid.getText().trim());
        }
        if (this._password.getText().trim().length() != 0) {
            connectionStringBuilder.addParm("PWD", this._password.getText().trim());
        }
        if ((string = this._databaseFile.getStringValue()) != null && string.length() != 0) {
            connectionStringBuilder.addParm("DBF", string);
        }
        char[] cArray = this._databaseKey.getPassword();
        int n = this._databaseKey.echoCharIsSet() ? (int)this._databaseKey.getEchoChar() : 42;
        if (cArray != null && cArray.length != 0) {
            int n2 = cArray.length;
            for (int i = 0; i < n2; ++i) {
                cArray[i] = n;
            }
            string = new String(cArray);
            connectionStringBuilder.addParm("DBKEY", string);
        }
        if (this._advanced != null && (string = this._advanced.getText().trim()).length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                int n3 = string3.indexOf("=");
                if (n3 == -1 || (string2 = string3.substring(0, n3).trim()).length() == 0) continue;
                String string4 = string3.substring(n3 + 1).trim();
                connectionStringBuilder.addParm(string2, string4);
            }
        }
    }

    @Override
    public void setInitialFocus() {
        if (this._initialException != null) {
            this.displayError(this._initialException);
            this._initialException = null;
        } else {
            this._userid.requestFocus();
        }
    }

    private void createGUI() {
        this._panel = new JPanel();
        this._panel.setLayout(new BoxLayout(this._panel, 1));
        if (this._simplified) {
            this._identificationPanel = this.createIdentificationPanel();
            this._panel.add(this._identificationPanel);
        } else {
            this._tabbedPane = new JTabbedPane();
            this._identificationPanel = this.createIdentificationPanel();
            this._tabbedPane.addTab(this._identificationPanel.getName(), this._identificationPanel);
            this._advancedPanel = this.createAdvancedPanel();
            this._tabbedPane.addTab(this._advancedPanel.getName(), this._advancedPanel);
            this._panel.add(this._tabbedPane);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this._userid.getKeymap().removeKeyStrokeBinding(keyStroke);
        this._password.getKeymap().removeKeyStrokeBinding(keyStroke);
        this.setInitialValues();
        this.enableControls();
    }

    private JPanel createIdentificationPanel() {
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        ImageIcon imageIcon = new ImageIcon(LogonImages.getIdentification());
        SybLabel sybLabel = new SybLabel(this._res.get("The following values are used to identify yourself to the database"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        this._useridLabel = new SybLabel(this._res.get("User:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        jPanel.add((Component)this._useridLabel, gridBagConstraints);
        this._userid = new JTextField(10);
        new FontHelper((JTextComponent)this._userid);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this._userid, gridBagConstraints);
        this._useridLabel.setLabelFor((Component)this._userid);
        this._passwordLabel = new SybLabel(this._res.get("Password:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 16, 0, 5);
        jPanel.add((Component)this._passwordLabel, gridBagConstraints);
        this._password = new JPasswordField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel.add((Component)this._password, gridBagConstraints);
        this._passwordLabel.setLabelFor((Component)this._password);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        imageIcon = new ImageIcon(LogonImages.getDatabase32x32());
        sybLabel = new SybLabel(this._res.get("The following information identifies the database"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Database file:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._databaseFile = new MRUComboBox(Preferences.load(SAVE_PREFIX, SAVE_DATABASE_FILE));
        new FontHelper((JComboBox)this._databaseFile);
        UltraLiteDatabaseSource.setComboBoxPreferredWidth((JComboBox)this._databaseFile, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel2.add((Component)this._databaseFile, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._databaseFile);
        this._browseDatabaseFile = new SybButton(this._res.get("&Browse..."));
        this._browseDatabaseFile.addActionListener((ActionListener)this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)this._browseDatabaseFile, gridBagConstraints);
        sybLabel = new SybLabel(this._res.get("Database key:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 32, 8, 5);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._databaseKey = new JPasswordField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel2.add((Component)this._databaseKey, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._databaseKey);
        this._databaseKeyLabel = sybLabel;
        JTextField jTextField = (JTextField)this._databaseFile.getEditor().getEditorComponent();
        this._databaseFileDocumentListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                UltraLiteDatabaseSource.this.enableDatabaseKeyField();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                UltraLiteDatabaseSource.this.enableDatabaseKeyField();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                UltraLiteDatabaseSource.this.enableDatabaseKeyField();
            }
        };
        jTextField.getDocument().addDocumentListener(this._databaseFileDocumentListener);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setName(this._res.get("Identification"));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        jPanel3.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add(Box.createVerticalGlue(), gridBagConstraints);
        return jPanel3;
    }

    private static void setComboBoxPreferredWidth(JComboBox jComboBox, int n) {
        Dimension dimension = jComboBox.getPreferredSize();
        FontMetrics fontMetrics = jComboBox.getFontMetrics(jComboBox.getFont());
        int n2 = fontMetrics.charWidth('m');
        int n3 = n2 * n;
        if (dimension.width > n3) {
            dimension.width = n3;
            jComboBox.setPreferredSize(dimension);
        }
    }

    private JPanel createAdvancedPanel() {
        boolean bl = false;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        SybLabel sybLabel = new SybLabel(this._res.get("Enter connection parameters, one per line, in the form \"name=value\""));
        sybLabel.setAlignmentX(0.0f);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        this._advanced = new SybTextArea();
        this._advanced.setTabMovesFocus(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._advanced);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._advanced);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setName(this._res.get("Advanced"));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        return jPanel2;
    }

    private void enableControls() {
        this.enableDatabaseKeyField();
    }

    private void enableDatabaseKeyField() {
        String string;
        Object object;
        boolean bl = false;
        if (this._databaseFile != null && (object = this._databaseFile.getEditor().getItem()) != null && (string = object.toString()) != null && string.length() > 0) {
            bl = true;
        }
        this._databaseKeyLabel.setEnabled(bl);
        this._databaseKey.setEnabled(bl);
    }

    private void setInitialValues() {
        this.resetControls();
        if (this._initialConnectionInfo != null) {
            this.setInitialValues(this._initialConnectionInfo);
        }
    }

    private void setInitialValues(UltraLiteConnectionInfo ultraLiteConnectionInfo) {
        StringBuffer stringBuffer = null;
        Enumeration enumeration = ultraLiteConnectionInfo.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = ultraLiteConnectionInfo.getParameter(string);
            if (string.equals("UID")) {
                this._userid.setText(string2);
                continue;
            }
            if (string.equals("PWD")) {
                this._password.setText(string2);
                continue;
            }
            if (string.equals("DBF")) {
                this._databaseFile.setSelectedItem((Object)string2);
                continue;
            }
            if (string.equals("DBKEY")) {
                this._databaseKey.setText(string2);
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(64);
            } else {
                stringBuffer.append('\n');
            }
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(UltraLiteConnectionInfo.quoteIfNeeded(string2));
        }
        if (stringBuffer != null && this._advanced != null) {
            this._advanced.setText(stringBuffer.toString());
        }
    }

    private void resetControls() {
        this._userid.setText("");
        this._password.setText("");
        this._databaseFile.setSelectedItem(null);
        this._databaseKey.setText("");
        if (this._advanced != null) {
            this._advanced.setText("");
        }
    }

    private void destroyGUI() {
        if (this._panel != null) {
            this._tabbedPane = null;
            this._identificationPanel = null;
            this._advancedPanel = null;
            this._userid = null;
            this._useridLabel = null;
            this._password = null;
            this._passwordLabel = null;
            if (this._databaseFileDocumentListener != null) {
                JTextField jTextField = (JTextField)this._databaseFile.getEditor().getEditorComponent();
                jTextField.getDocument().removeDocumentListener(this._databaseFileDocumentListener);
                this._databaseFileDocumentListener = null;
            }
            this._databaseFile = null;
            this._databaseKeyLabel = null;
            this._databaseKey = null;
            this._advanced = null;
            this._browseDatabaseFile.removeActionListener((ActionListener)this);
            this._browseDatabaseFile = null;
            DialogUtils.removeComponents((Container)this._panel);
            this._panel = null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._browseDatabaseFile) {
            this.handleBrowseDBF();
        }
    }

    private void handleBrowseDBF() {
        SybFileChooser sybFileChooser = new SybFileChooser(17);
        String string = Preferences.load(SAVE_PREFIX, SAVE_LAST_DBF_FOLDER);
        if (string == null) {
            string = System.getProperty("user.dir");
        }
        File file = new File(string);
        sybFileChooser.setTitle(this._res.get("Database File"));
        String string2 = this._databaseFile.getStringValue();
        File file2 = string2 != null && string2.length() != 0 ? new File(string2) : null;
        SybFileFilter[] sybFileFilterArray = new SybFileFilter[3];
        sybFileFilterArray[0] = new SybFileFilter(new String[]{"udb", "pdb"}, this._res.get("ULTRALITE_ALL_DATABASE_FILE_DESCRIPTION"));
        sybFileFilterArray[1] = new SybFileFilter("udb", this._res.get("ULTRALITE_DATABASE_FILE_DESCRIPTION"));
        sybFileFilterArray[2] = new SybFileFilter("pdb", this._res.get("ULTRALITE_PALM_DATABASE_FILE_DESCRIPTION"));
        sybFileChooser.setFilters(sybFileFilterArray, 0);
        if (sybFileChooser.showDialog(this.getParentWindow(), file, file2)) {
            File file3 = sybFileChooser.getSelectedFile();
            this._databaseFile.setSelectedItem((Object)file3.toString());
            Preferences.save(SAVE_PREFIX, SAVE_LAST_DBF_FOLDER, file3.getParent());
        }
    }

    private Window getParentWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._panel);
        return window;
    }

    @Override
    public AbstractConnectionInfo getConnectionInfo() {
        if (this._panel == null) {
            UltraLiteConnectionInfo ultraLiteConnectionInfo = (UltraLiteConnectionInfo)this._initialConnectionInfo.clone();
            return ultraLiteConnectionInfo;
        }
        UltraLiteConnectionInfo ultraLiteConnectionInfo = new UltraLiteConnectionInfo();
        String string = this._userid.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        ultraLiteConnectionInfo.setUserName(string);
        string = this._password.getText().trim();
        if (string.length() == 0) {
            string = null;
        }
        ultraLiteConnectionInfo.setPassword(string);
        string = this._databaseFile.getStringValue().trim();
        if (string != null && string.length() == 0) {
            string = null;
        }
        ultraLiteConnectionInfo.setDatabaseFileName(string);
        string = new String(this._databaseKey.getPassword());
        ultraLiteConnectionInfo.setDBKey(string.length() != 0 ? string : null);
        if (this._advanced != null && (string = this._advanced.getText().trim()).length() != 0) {
            ultraLiteConnectionInfo.mergeConnectionString(string.replaceAll("[\n\r]+", ";"));
        }
        return ultraLiteConnectionInfo;
    }

    @Override
    public Connection connect(ArrayList<SQLWarning> arrayList, AbstractConnectionInfo abstractConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        UltraLiteConnectionInfo ultraLiteConnectionInfo = abstractConnectionInfo instanceof UltraLiteConnectionInfo ? (UltraLiteConnectionInfo)abstractConnectionInfo : null;
        if (this._panel == null) {
            UltraLiteConnectionInfo ultraLiteConnectionInfo2 = (UltraLiteConnectionInfo)this._initialConnectionInfo.clone();
            if (ultraLiteConnectionInfo != null) {
                ultraLiteConnectionInfo2.merge(ultraLiteConnectionInfo);
            }
            if (classLoader != null) {
                ultraLiteConnectionInfo2.setClassLoader(classLoader);
            }
            try {
                connection = ultraLiteConnectionInfo2.getConnection();
            }
            catch (Exception exception) {
                this._initialException = exception;
            }
        } else {
            connection = this.connectFromUI(arrayList, ultraLiteConnectionInfo, classLoader);
        }
        return connection;
    }

    private Connection connectFromUI(ArrayList<SQLWarning> arrayList, UltraLiteConnectionInfo ultraLiteConnectionInfo, ClassLoader classLoader) {
        Connection connection = null;
        UltraLiteConnectionInfo ultraLiteConnectionInfo2 = (UltraLiteConnectionInfo)this.getConnectionInfo();
        if (classLoader != null) {
            ultraLiteConnectionInfo2.setClassLoader(classLoader);
        }
        if (ultraLiteConnectionInfo != null) {
            ultraLiteConnectionInfo2.merge(ultraLiteConnectionInfo);
        }
        try {
            connection = ultraLiteConnectionInfo2.getConnection();
            if (arrayList != null) {
                for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                    arrayList.add(sQLWarning);
                }
                connection.clearWarnings();
            }
        }
        catch (SQLException sQLException) {
            this.displayError(sQLException);
        }
        return connection;
    }

    @Override
    public void reportConnectionFailure(Exception exception) {
        this.displayError(exception);
    }

    private void displayError(Exception exception) {
        if (exception instanceof ClassNotFoundException) {
            this.handleDriverNotFound(exception);
        } else if (exception instanceof SQLException) {
            this.handleSQLException((SQLException)exception);
        } else {
            this.handleGenericException(exception);
        }
    }

    private void handleGenericException(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayConnectionError(exception.getLocalizedMessage(), null, stringBuffer.toString());
    }

    private void handleSQLException(SQLException sQLException) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        SQLException sQLException2 = sQLException.getNextException();
        if (sQLException2 != null) {
            int n = sQLException2.getErrorCode();
        } else {
            boolean bl = false;
        }
        String string4 = sQLException.getSQLState();
        if (sQLException.getMessage().indexOf("[UltraLite Database]") != -1) {
            switch (sQLException.getErrorCode()) {
                case -103: {
                    string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                    string = null;
                    this._tabbedPane.setSelectedComponent(this._identificationPanel);
                    this._userid.requestFocus();
                    break;
                }
                default: {
                    string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
                    string = null;
                    break;
                }
            }
        } else {
            if (sQLException.getMessage().indexOf("[Microsoft][ODBC Driver Manager]") != -1) {
                // empty if block
            }
            string2 = ODBCUtils.stripODBCHeader(sQLException.getLocalizedMessage());
            string = null;
            sQLException2 = sQLException.getNextException();
            if (sQLException2 != null) {
                stringBuffer.append(ODBCUtils.stripODBCHeader(sQLException2.getLocalizedMessage()));
                stringBuffer.append(string3);
            }
        }
        this.displayConnectionError(sQLException, string2, string, stringBuffer.toString());
    }

    private void handleDriverNotFound(Exception exception) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this._res.get("Missing JDBC driver"));
        stringBuffer.append(string);
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append(this._res.get("Classpath"));
        stringBuffer.append(string);
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        this.displayConnectionError(this._res.get("The JDBC driver could not be loaded."), null, stringBuffer.toString());
    }

    private void displayConnectionError(Exception exception, String string, String string2, String string3) {
        String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string4);
        if (exception instanceof SQLException) {
            stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(((SQLException)exception).getErrorCode())));
            stringBuffer.append(string4);
            stringBuffer.append(this._res.getFormatted("\tSQL state={0}", ((SQLException)exception).getSQLState()));
            stringBuffer.append(string4);
            SQLException sQLException = ((SQLException)exception).getNextException();
            if (sQLException != null) {
                stringBuffer.append(sQLException.getLocalizedMessage());
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tError code={0}", Integer.toString(sQLException.getErrorCode())));
                stringBuffer.append(string4);
                stringBuffer.append(this._res.getFormatted("\tSQL state={0}", sQLException.getSQLState()));
                stringBuffer.append(string4);
            }
        }
        this.displayConnectionError(string, string2, stringBuffer.toString());
    }

    private void displayConnectionError(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        final String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this._res.get("Could not connect to the database"));
        stringBuffer2.append(string4);
        stringBuffer2.append(string4);
        stringBuffer2.append(string);
        if (string2 != null) {
            stringBuffer2.append(string4);
            stringBuffer2.append(string4);
            stringBuffer2.append(string2);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(this._res.get("Connection parameters:"));
        stringBuffer.append(string4);
        stringBuffer.append(this._res.getFormatted("\tUser={0}", this._userid.getText()));
        stringBuffer.append(string4);
        stringBuffer.append(this._res.getFormatted("\tPassword={0}", "***"));
        stringBuffer.append(string4);
        this.buildConnectionString(new ConnectionStringBuilder(){

            @Override
            public void addParm(String string, String string2) {
                if (string.equalsIgnoreCase("UID") || string.equalsIgnoreCase("PWD")) {
                    return;
                }
                LogonResourcesBase logonResourcesBase = UltraLiteDatabaseSource.this._res;
                UltraLiteDatabaseSource.this._res;
                stringBuffer.append(logonResourcesBase.getFormatted("\t{0}={1}", string, string2));
                stringBuffer.append(string4);
            }
        });
        Window window = this.getParentWindow();
        String string5 = window instanceof Dialog ? ((Dialog)window).getTitle() : ((Frame)window).getTitle();
        DetailsErrorDialog.showDialog((Component)window, (String)string5, (String)stringBuffer2.toString(), (String)stringBuffer.toString(), null);
    }

    @Override
    public String getDisplayName() {
        return this._res.get("ULTRALITE_DISPLAY_NAME");
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(LogonImages.getUltralite());
    }

    @Override
    public boolean hasHelp() {
        return this._helpJARLocation != null;
    }

    @Override
    public void showHelp() {
        if (this._helpViewer == null) {
            try {
                this._helpViewer = FactoryHelp.getHelpViewer((String)this._helpJARLocation, (String)this._helpPrefix, (String)this._helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                Window window = this.getParentWindow();
                if (window instanceof Dialog) {
                    String string = ((Dialog)window).getTitle();
                    DetailsErrorDialog.showDetailsErrorDialog((Dialog)((Dialog)window), (String)string, (String)this._res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
                }
                String string = ((Frame)window).getTitle();
                DetailsErrorDialog.showDetailsErrorDialog((Frame)((Frame)window), (String)string, (String)this._res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
            }
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage(this.getHelpContextId(), this.getParentWindow());
        }
    }

    @Override
    public void setHelpFolder(String string, String string2, String string3) {
        this._helpJARLocation = string;
        this._helpPrefix = string2;
        this._helpSuffix = string3;
    }

    @Override
    public Object[] getTools() {
        if (this._tools == null) {
            if (Platform.isWindows() && Registry.isInstalled() && CEProxyPortDialog.areProxyPortsSupported()) {
                Object[] objectArray = new Object[1];
                objectArray[0] = new Tool(2, this._res.get("CreateCEProxyPort"));
                this._tools = objectArray;
            } else {
                this._tools = null;
            }
        }
        return this._tools;
    }

    @Override
    public void notifyToolClicked(int n) {
        int n2 = ((Tool)this._tools[n]).getID();
        if (n2 != 1 && n2 == 2) {
            CEProxyPortDialog.create(this.getParentWindow());
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void notifyCancelClicked() {
    }

    public static void testConnection(Window window, UltraLiteConnectionInfo ultraLiteConnectionInfo) {
        Object var3_2 = null;
        Connection connection = null;
        LogonResourcesBase logonResourcesBase = LogonResourcesBase.getBundle();
        try {
            connection = JDBCDrivers.connect(ultraLiteConnectionInfo);
            if (connection != null) {
                SybOptionPane.showMessageDialog((Component)window, (Object)logonResourcesBase.get("ConnectionSucceeded"), (String)logonResourcesBase.get("TestConnectionWindowTitle"), (int)1);
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            SybOptionPane.showMessageDialog((Component)window, (Object)(logonResourcesBase.get("ConnectionFailed") + "\n" + exception.getLocalizedMessage()), (String)logonResourcesBase.get("TestConnectionWindowTitle"), (int)0);
        }
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    static interface ConnectionStringBuilder {
        public void addParm(String var1, String var2);
    }
}

