/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.logon;

import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.ase.logon.ServiceProxy;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.ReflectionProxyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public final class ASEConnectionInfo
extends AbstractConnectionInfo {
    public static final int UNKNOWN_PORT = -1;
    public static final String SSL_FILTER = "ssl";
    public static final String USER_PROPERTY = "USER";
    public static final String PASSWORD_PROPERTY = "PASSWORD";
    public static final String LANGUAGE_PROPERTY = "LANGUAGE";
    public static final String CHARSET_PROPERTY = "CHARSET";
    public static final String APPLICATIONNAME_PROPERTY = "APPLICATIONNAME";
    public static final String SERVERNAME_PROPERTY = "SERVERNAME";
    public static final String DATABASENAME_PROPERTY = "DATABASENAME";
    public static final String RMI_PORT_PROPERTY = "RMIPORT";
    public static final String SERVICEFILTER_PROPERTY = "SERVICEFILTER";
    public static final String OTHER_PARMS_PROPERTY = "OTHERPARMS";
    public static final String CONNECTIONNAME_PROPERTY = "CONNECTIONNAME";
    public static final String OTHER_SERVICES_PROPERTY = "OTHERSERVICES";
    private static final String HOST_PROPERTY = "<HOST>";
    private static final String PORT_PROPERTY = "<PORT>";
    public String host;
    public int port;
    private Properties _properties;

    private void resetFields() {
        this.host = null;
        this.port = -1;
        this._properties = new Properties();
        this.setProperty("JCONNECT_VERSION", String.valueOf(0));
        this.setProperty(APPLICATIONNAME_PROPERTY, "DBISQL");
    }

    public ASEConnectionInfo() {
        this.resetFields();
    }

    public ASEConnectionInfo(ASEConnectionInfo aSEConnectionInfo) {
        this.resetFields();
        if (aSEConnectionInfo != null) {
            this.merge(aSEConnectionInfo);
        }
    }

    public ASEConnectionInfo(String string) {
        this.deserialize(string);
    }

    @Override
    public String getUserName() {
        return this._properties.getProperty(USER_PROPERTY);
    }

    @Override
    public void setUserName(String string) {
        this.setProperty(USER_PROPERTY, string);
    }

    @Override
    public String getPassword() {
        return this._properties.getProperty(PASSWORD_PROPERTY);
    }

    @Override
    public void setPassword(String string) {
        this.setProperty(PASSWORD_PROPERTY, string);
    }

    public String getServerName() {
        return this._properties.getProperty(SERVERNAME_PROPERTY);
    }

    public String getDisplayServerName() {
        String string;
        String string2 = this.getServerName();
        if (string2 == null) {
            string2 = this.host + ":" + this.port;
        }
        if ((string = this.getRMIPort()) != null) {
            string2 = string2 + ";" + string;
        }
        return string2;
    }

    public void setServerName(String string) {
        this.setProperty(SERVERNAME_PROPERTY, string);
    }

    public String getDatabaseName() {
        return this._properties.getProperty(DATABASENAME_PROPERTY);
    }

    public void setDatabaseName(String string) {
        this.setProperty(DATABASENAME_PROPERTY, string);
    }

    public String getConnectionName() {
        return this._properties.getProperty(CONNECTIONNAME_PROPERTY);
    }

    public void setConnectionName(String string) {
        this.setProperty(CONNECTIONNAME_PROPERTY, string);
    }

    public String getServiceFilter() {
        return this._properties.getProperty(SERVICEFILTER_PROPERTY);
    }

    public void setServiceFilter(String string) {
        this.setProperty(SERVICEFILTER_PROPERTY, string);
        if (string != null && string.equals(SSL_FILTER)) {
            this.setProperty("SYBSOCKET_FACTORY", "com.sybase.util.ds.ssl.SSLSocketFactoryASE");
        } else {
            this.setProperty("SYBSOCKET_FACTORY", null);
        }
    }

    public boolean getEncryptPassword() {
        String string = this._properties.getProperty("ENCRYPT_PASSWORD");
        return Boolean.parseBoolean(string);
    }

    public void setEncryptPassword(boolean bl) {
        if (bl) {
            this.setProperty("ENCRYPT_PASSWORD", "true");
            this.setProperty("JCE_PROVIDER_CLASS", "com.certicom.ecc.jcae.Certicom");
        } else {
            this.setProperty("ENCRYPT_PASSWORD", null);
            this.setProperty("JCE_PROVIDER_CLASS", null);
        }
    }

    public void setOtherServices(List<ServiceProxy> list) {
        String string = "";
        String string2 = "";
        for (int i = 0; i < list.size(); ++i) {
            ServiceProxy serviceProxy = list.get(i);
            string2 = string2 + string + serviceProxy.getHost() + "," + serviceProxy.getPort();
            if (serviceProxy.isSSL()) {
                string2 = string2 + ",ssl";
            }
            string = "/";
        }
        this.setProperty(OTHER_SERVICES_PROPERTY, string2);
    }

    public List<ServiceProxy> getOtherServices() {
        String string = this._properties.getProperty(OTHER_SERVICES_PROPERTY);
        ArrayList<ServiceProxy> arrayList = new ArrayList<ServiceProxy>();
        if (string != null) {
            String[] stringArray = string.split("/");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                int n = string2.indexOf(",");
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                try {
                    ServiceProxy serviceProxy = new ServiceProxy(string3, string4);
                    arrayList.add(serviceProxy);
                    continue;
                }
                catch (ReflectionProxyException reflectionProxyException) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public String getOtherParms() {
        return this._properties.getProperty(OTHER_PARMS_PROPERTY);
    }

    public void setOtherParms(String string) {
        this.setProperty(OTHER_PARMS_PROPERTY, string);
    }

    public String getLanguage() {
        return this._properties.getProperty(LANGUAGE_PROPERTY);
    }

    public void setLanguage(String string) {
        this.setProperty(LANGUAGE_PROPERTY, string);
    }

    public String getCharSet() {
        return this._properties.getProperty(CHARSET_PROPERTY);
    }

    public void setCharSet(String string) {
        this.setProperty(CHARSET_PROPERTY, string);
    }

    public String getApplicationName() {
        return this._properties.getProperty(APPLICATIONNAME_PROPERTY);
    }

    public void setApplicationName(String string) {
        this.setProperty(APPLICATIONNAME_PROPERTY, string);
    }

    public String getRMIPort() {
        return this._properties.getProperty(RMI_PORT_PROPERTY);
    }

    public void setRMIPort(String string) {
        this.setProperty(RMI_PORT_PROPERTY, string);
    }

    @Override
    public int getDatabaseType() {
        return 1;
    }

    @Override
    public Object clone() {
        ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo();
        aSEConnectionInfo.host = this.host;
        aSEConnectionInfo.port = this.port;
        aSEConnectionInfo._properties = new Properties();
        Enumeration<Object> enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this._properties.getProperty(string);
            aSEConnectionInfo._properties.setProperty(string, string2);
        }
        return aSEConnectionInfo;
    }

    public void merge(ASEConnectionInfo aSEConnectionInfo) {
        this.merge(aSEConnectionInfo, true);
    }

    public void merge(ASEConnectionInfo aSEConnectionInfo, boolean bl) {
        if (aSEConnectionInfo.host != null && (bl || this.host == null || this.host.isEmpty())) {
            this.host = aSEConnectionInfo.host;
        }
        if (aSEConnectionInfo.port != -1 && (bl || this.port == -1)) {
            this.port = aSEConnectionInfo.port;
        }
        Properties properties = aSEConnectionInfo.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string);
            if (string2 == null || !bl && this.getProperty(string) != null) continue;
            this._properties.setProperty(string, string2);
        }
    }

    @Override
    public String getConnectionString() {
        return this.getConnectionString(false);
    }

    public String getConnectionString(boolean bl) {
        String string = this.serialize(bl);
        return string;
    }

    @Override
    public void mergeConnectionString(String string) {
        ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(string);
        while (connectionStringTokenizer.hasMoreTokens()) {
            String string2 = connectionStringTokenizer.nextToken();
            this.setConnectionInfoDataFromToken(string2);
        }
    }

    private void setConnectionInfoDataFromToken(String string) {
        int n = string.indexOf("=");
        if (n == -1) {
            n = string.indexOf(35);
            if (n != -1) {
                string = string.substring(0, n) + '=' + string.substring(n + 1);
            } else {
                return;
            }
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        if (string2.equalsIgnoreCase("UID") || string2.equalsIgnoreCase("User")) {
            this._properties.setProperty(USER_PROPERTY, string3);
        } else if (string2.equalsIgnoreCase("PWD") || string2.equalsIgnoreCase("Password")) {
            this._properties.setProperty(PASSWORD_PROPERTY, string3);
        } else if (string2.equalsIgnoreCase(HOST_PROPERTY)) {
            this.host = string3;
        } else if (string2.equalsIgnoreCase(PORT_PROPERTY)) {
            try {
                this.port = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.setProperty(string2, string3);
        }
    }

    @Override
    public boolean canAttemptConnection() {
        String string = this._properties.getProperty(USER_PROPERTY);
        boolean bl = string != null && string.length() != 0;
        String string2 = this.getServerName();
        boolean bl2 = string2 != null && string2.length() > 0;
        boolean bl3 = this.host != null && this.host.length() > 0;
        boolean bl4 = this.port != -1;
        boolean bl5 = bl && (bl2 || bl3 && bl4);
        return bl5;
    }

    public String getURL(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("jdbc:sybase:Tds:");
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        if (string3 != null && string3.length() > 0) {
            stringBuffer.append('/');
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getURL() {
        return this.getURL(this.host, String.valueOf(this.port), this.getDatabaseName());
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        Enumeration<Object> enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = this._properties.getProperty(string);
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public void setProperty(String string, String string2) {
        if (string2 == null) {
            this._properties.remove(string);
        } else {
            this._properties.setProperty(string, string2);
        }
    }

    public String getProperty(String string) {
        return this._properties.getProperty(string);
    }

    @Override
    public String serialize() {
        return this.serialize(false);
    }

    private String serialize(boolean bl) {
        int n = this._properties.size();
        if (this.host != null) {
            ++n;
        }
        if (this.port != -1) {
            ++n;
        }
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = 0;
        Enumeration<Object> enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String string;
            stringArray[n2] = string = enumeration.nextElement().toString();
            String string2 = this._properties.getProperty(string);
            stringArray2[n2] = string.equals(PASSWORD_PROPERTY) ? (bl ? "***" : this.encryptPassword(string2)) : string2;
            ++n2;
        }
        if (this.host != null) {
            stringArray[n2] = HOST_PROPERTY;
            stringArray2[n2] = this.host;
            ++n2;
        }
        if (this.port != -1) {
            stringArray[n2] = PORT_PROPERTY;
            stringArray2[n2] = Integer.toString(this.port);
            ++n2;
        }
        return this.defaultSerializer(stringArray, stringArray2);
    }

    @Override
    public void deserialize(String string) {
        String[] stringArray = this.defaultDeserializer(string);
        if (stringArray != null) {
            this.resetFields();
            for (int i = 0; i < stringArray.length; i += 2) {
                String string2 = stringArray[i];
                String string3 = stringArray[i + 1];
                if (string2.equals(PASSWORD_PROPERTY)) {
                    this._properties.setProperty(string2, this.decryptPassword(string3));
                    continue;
                }
                if (string2.equals(HOST_PROPERTY)) {
                    this.host = string3;
                    continue;
                }
                if (string2.equals(PORT_PROPERTY)) {
                    try {
                        this.port = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.port = -1;
                    }
                    continue;
                }
                this._properties.setProperty(string2, string3);
            }
        }
    }
}

