/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.logon;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.logon.ConnectionStringTokenizer;
import com.sybase.asa.logon.Dbg;
import com.sybase.asa.logon.JDBCDrivers;
import com.sybase.asa.logon.LogonException;
import com.sybase.asa.logon.LogonImages;
import com.sybase.asa.logon.LogonSource;
import com.sybase.asa.logon.LogonSourceHost;
import com.sybase.asa.logon.Preferences;
import com.sybase.ase.logon.ASEConnectionInfo;
import com.sybase.ase.logon.ASEHostInformation;
import com.sybase.ase.logon.ASEResourcesBase;
import com.sybase.ase.logon.DSSettingsProxy;
import com.sybase.ase.logon.DiscoverySettingProxy;
import com.sybase.ase.logon.FindASEsDialog;
import com.sybase.ase.logon.FindingASEsDialog;
import com.sybase.ase.logon.LanguageItem;
import com.sybase.ase.logon.MyReflectionProxy;
import com.sybase.ase.logon.NewPasswordDialogProxy;
import com.sybase.ase.logon.OldDiscoverySetting;
import com.sybase.ase.logon.ServiceProxy;
import com.sybase.ase.logon.SyASEServerProxy;
import com.sybase.ase.logon.SyInterfacesEntryProxy;
import com.sybase.ase.logon.SyUAFASEEntryProxy;
import com.sybase.ase.logon.Tool;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.logon.AbstractConnectionInfo;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.ReflectionProxyException;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybTextArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.PlainDocument;

public class ASEDatabaseSource
implements LogonSource,
KeyListener,
DocumentListener,
ActionListener,
ItemListener,
ChangeListener {
    public static final String SAVE_PREFIX = "ASEDatabaseSource";
    public static final String SAVE_CONNECTION_INFO = "ConnectionInfo";
    public static final String SAVE_UAF_PORT_NUMBER = "UAFPortNumber";
    public static final String SAVE_SHOW_DETAILS = "showDetails";
    public static final String SAVE_SERVER_DISCOVERY = "serverDiscovery";
    public static final String SAVE_LDAP_INCLUDE = "ldapInclude";
    public static final String SAVE_LDAP_TIMEOUT = "ldapTimeout";
    public static final int DEFAULT_LDAP_TIMEOUT = 180;
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private static final String PORT_SEP = ":";
    private static final String RMI_PORT_SEP = ";";
    private static String DEFAULT_RMI_PORT = "9999";
    private static Vector<ASEConnectionInfo> _connectedServers;
    private Object[] _tools = null;
    private static final int TEST_CONNECTION_TOOL_ID = 1;
    private JTabbedPane _tabbedPane = null;
    private JPanel _identificationPanel = null;
    private JPanel _advancedPanel = null;
    private SybLabel _useridLabel = null;
    private JTextField _userid = null;
    private SybLabel _passwordLabel = null;
    private JTextField _password = null;
    private SybCheckBox _encryptPasswordCheckBox;
    private SybButton _settings = null;
    private JComboBox _serverComboBox = null;
    private SybButton _findServer = null;
    private SybLabel _infoLabel;
    private SybLabel _serverInfoLabel = null;
    private JToggleButton _detailsButton = null;
    private SybLabel _hostLabel;
    private JComboBox _hostComboBox = null;
    private SybLabel _portLabel;
    private JComboBox _portComboBox = null;
    private JCheckBox _sslCheckBox = null;
    private JSeparator _charSeparator = null;
    private SybMultiLineLabel _charMLabel = null;
    private SybLabel _charLabel = null;
    private JComboBox _characterSet = null;
    private SybLabel _langLabel = null;
    private JComboBox _language = null;
    private JTextField _serverNameTextField = null;
    private JTextField _hostTextField = null;
    private JTextField _portTextField = null;
    private SybTextArea _advanced = null;
    private ClassLoader _classLoader = null;
    static ASEResourcesBase _res;
    private static UtilsProxy _dsUtils;
    private JPanel _panel = null;
    private ASEConnectionInfo _initialConnectionInfo = null;
    private String _clientHostName = "";
    private LogonSourceHost _host = null;
    private String _helpJARLocation = null;
    private String _helpPrefix;
    private String _helpSuffix;
    private HelpViewer _helpViewer = null;
    private static String SEPARATOR;
    private int _numSavedServers = 1;

    public ASEDatabaseSource() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            this._clientHostName = inetAddress.getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            this._clientHostName = "";
        }
    }

    @Override
    public void setLogonSourceHost(LogonSourceHost logonSourceHost) {
        this._host = logonSourceHost;
    }

    private String getServerName() {
        if (this._serverComboBox != null) {
            return this._serverNameTextField.getText();
        }
        return "";
    }

    private String getHostName() {
        return this._hostTextField.getText();
    }

    private String getPortNumber() {
        return this._portTextField.getText();
    }

    private int getPort() {
        String string = this.getPortNumber();
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    private String getAdvanced() {
        return this._advanced.getText().trim();
    }

    public void selectServerName() {
        this._tabbedPane.setSelectedIndex(0);
        this._serverNameTextField.requestFocus();
        this._serverNameTextField.selectAll();
    }

    @Override
    public void notifyLogonSourceSelected(boolean bl) {
        this.enableOKButton();
    }

    @Override
    public Object[] getTools() {
        if (this._tools == null) {
            this._tools = new Object[]{new Tool(1, _res.get("TEST_CONNECTION"))};
        }
        return this._tools;
    }

    @Override
    public void notifyToolClicked(int n) {
        int n2 = ((Tool)this._tools[n]).getID();
        if (n2 == 1) {
            this.handleTestConnectionTool();
        }
    }

    private void handleTestConnectionTool() {
        if (!this.validate()) {
            return;
        }
        ASEConnectionInfo aSEConnectionInfo = (ASEConnectionInfo)this.getConnectionInfo();
        aSEConnectionInfo.setApplicationName(null);
        Window window = this.getParentWindow();
        ASEDatabaseSource.testConnection(window, aSEConnectionInfo);
    }

    public static void testConnection(Window window, ASEConnectionInfo aSEConnectionInfo) {
        try {
            Connection connection = JDBCDrivers.connect(aSEConnectionInfo);
            if (connection != null) {
                ASEDatabaseSource.reportTestConnection(window, UIManager.getIcon("OptionPane.informationIcon"), _res.get("TEST_CONNECTION_SUCCEEDED"), aSEConnectionInfo, "");
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sQLException) {
            ASEDatabaseSource.reportFailedConnection(window, aSEConnectionInfo, sQLException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ASEDatabaseSource.reportFailedConnection(window, aSEConnectionInfo, classNotFoundException);
        }
        catch (LogonException logonException) {
            ASEDatabaseSource.reportFailedConnection(window, aSEConnectionInfo, logonException);
        }
    }

    private static void reportFailedConnection(Window window, ASEConnectionInfo aSEConnectionInfo, Exception exception) {
        ASEDatabaseSource.reportTestConnection(window, UIManager.getIcon("OptionPane.errorIcon"), _res.get("TEST_CONNECTION_FAILED"), aSEConnectionInfo, exception.getLocalizedMessage());
    }

    private static void reportTestConnection(Window window, Icon icon, String string, ASEConnectionInfo aSEConnectionInfo, String string2) {
        DetailsErrorDialog.showDialog((Component)window, (String)_res.get("TEST_CONNECTION_WINDOW_TITLE"), (Icon)icon, (String)string, (String)(_res.getFormatted("TEST_CONNECTION_USING", aSEConnectionInfo.getConnectionString(true)) + "\n" + string2), null);
    }

    @Override
    public void notifyConnectOK() {
        ASEConnectionInfo aSEConnectionInfo = (ASEConnectionInfo)this.getConnectionInfo();
        aSEConnectionInfo.setPassword(null);
        this.addConnectedServer(aSEConnectionInfo);
        this.saveConnectedServers();
    }

    private void addConnectedServer(ASEConnectionInfo aSEConnectionInfo) {
        if (aSEConnectionInfo == null || !aSEConnectionInfo.canAttemptConnection()) {
            return;
        }
        Vector<ASEConnectionInfo> vector = new Vector<ASEConnectionInfo>();
        for (int i = 0; i < _connectedServers.size(); ++i) {
            ASEConnectionInfo aSEConnectionInfo2 = _connectedServers.elementAt(i);
            if ((aSEConnectionInfo.getServerName() == null || !aSEConnectionInfo.getServerName().equals(aSEConnectionInfo2.getServerName())) && (aSEConnectionInfo2.port != aSEConnectionInfo.port || !aSEConnectionInfo2.host.equals(aSEConnectionInfo.host))) continue;
            _connectedServers.removeElementAt(i);
        }
        vector.add(aSEConnectionInfo);
        vector.addAll(_connectedServers);
        if (vector.size() > this._numSavedServers) {
            vector.setSize(this._numSavedServers);
        }
        _connectedServers.removeAllElements();
        _connectedServers = vector;
    }

    private void clearConnectedServers() {
        for (int i = 0; i < 20; ++i) {
            Preferences.remove(SAVE_PREFIX, SAVE_CONNECTION_INFO + i);
        }
    }

    private void saveConnectedServers() {
        this.clearConnectedServers();
        for (int i = 0; i < _connectedServers.size(); ++i) {
            ASEConnectionInfo aSEConnectionInfo = _connectedServers.elementAt(i);
            Preferences.save(SAVE_PREFIX, SAVE_CONNECTION_INFO + i, aSEConnectionInfo.getConnectionString());
        }
    }

    private ASEConnectionInfo getLastConnectedServerInfo() {
        return _connectedServers.size() == 0 ? null : _connectedServers.elementAt(0);
    }

    private void loadConnectedServers() {
        _connectedServers.removeAllElements();
        for (int i = 0; i < this._numSavedServers; ++i) {
            String string = Preferences.load(SAVE_PREFIX, SAVE_CONNECTION_INFO + i);
            if (string == null) continue;
            _connectedServers.add(new ASEConnectionInfo(string));
        }
    }

    @Override
    public void setInitialConnectionInfo(AbstractConnectionInfo abstractConnectionInfo) {
        if (abstractConnectionInfo == null) {
            this._initialConnectionInfo = new ASEConnectionInfo();
        } else if (abstractConnectionInfo instanceof ASEConnectionInfo) {
            this._initialConnectionInfo = (ASEConnectionInfo)abstractConnectionInfo;
        }
    }

    @Override
    public void destroy() {
        Preferences.save(SAVE_PREFIX, SAVE_SHOW_DETAILS, String.valueOf(this._detailsButton.isSelected()));
        Preferences.makePermanent();
        this.destroyGUI();
        _res = null;
        this._initialConnectionInfo = null;
        this._host = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel.getPreferredSize();
    }

    @Override
    public JPanel getPanel(int n) {
        if (this._panel == null) {
            this.createGUI();
        }
        return this._panel;
    }

    @Override
    public String getHelpContextId() {
        String string;
        switch (this._tabbedPane.getSelectedIndex()) {
            default: {
                string = "HELP_ASE_DB_SRC_CONNECT_PAGE";
                break;
            }
            case 1: {
                string = "HELP_ASE_DB_SRC_ADVANCED_PAGE";
            }
        }
        return string;
    }

    private String getUser() {
        String string = this._userid != null ? this._userid.getText().trim() : null;
        return string;
    }

    private String getPassword() {
        String string = this._password != null ? this._password.getText().trim() : null;
        return string;
    }

    private void buildConnectionString(ConnectionStringBuilder connectionStringBuilder) {
        String string;
        if (this._userid.getText().trim().length() != 0) {
            connectionStringBuilder.addParm("UID", this._userid.getText().trim());
        }
        if (this._password.getText().trim().length() != 0) {
            connectionStringBuilder.addParm("PWD", this._password.getText().trim());
        }
        if ((string = this.getServerName()).length() != 0 && string.indexOf(PORT_SEP) == -1) {
            connectionStringBuilder.addParm("ENG", string);
        }
        if ((string = this.getAdvanced()).length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                int n = string3.indexOf("=");
                if (n == -1 || (string2 = string3.substring(0, n).trim()).length() == 0) continue;
                String string4 = string3.substring(n + 1).trim();
                connectionStringBuilder.addParm(string2, string4);
            }
        }
    }

    @Override
    public void setInitialFocus() {
        this._userid.requestFocus();
    }

    private void createGUI() {
        _res = ASEResourcesBase.getBundle();
        this._panel = new JPanel();
        this._panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this._panel.setLayout(new BorderLayout());
        this._tabbedPane = new JTabbedPane();
        this._identificationPanel = this.createIdentificationPanel();
        this._tabbedPane.addTab(this._identificationPanel.getName(), this._identificationPanel);
        this._advancedPanel = this.createAdvancedPanel();
        this._tabbedPane.addTab(this._advancedPanel.getName(), this._advancedPanel);
        this._panel.add(this._tabbedPane);
        this._tabbedPane.addChangeListener(this);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this._userid.getKeymap().removeKeyStrokeBinding(keyStroke);
        this._password.getKeymap().removeKeyStrokeBinding(keyStroke);
        String string = Preferences.load(SAVE_PREFIX, SAVE_SHOW_DETAILS);
        if (string == null) {
            this.showDetails(false);
        } else {
            boolean bl = Boolean.valueOf(string);
            this._detailsButton.setSelected(bl);
            this.showDetails(bl);
        }
        this.setInitialValues();
    }

    private JPanel createIdentificationPanel() {
        Object object;
        int n;
        int n2 = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName(_res.get("Identification"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        ImageIcon imageIcon = new ImageIcon(LogonImages.getIdentification());
        SybLabel sybLabel = new SybLabel(_res.get("AboutUserid"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel2.add((Component)sybLabel, gridBagConstraints);
        this._useridLabel = new SybLabel(_res.get("User"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 16, 0, 5);
        jPanel2.add((Component)this._useridLabel, gridBagConstraints);
        this._userid = new JTextField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this._userid, gridBagConstraints);
        this._useridLabel.setLabelFor((Component)this._userid);
        this._passwordLabel = new SybLabel(_res.get("Password"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 16, 0, 5);
        jPanel2.add((Component)this._passwordLabel, gridBagConstraints);
        this._password = new JPasswordField(10);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        jPanel2.add((Component)this._password, gridBagConstraints);
        this._passwordLabel.setLabelFor((Component)this._password);
        this._encryptPasswordCheckBox = new SybCheckBox(_res.get("EncryptPassword"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(8, 0, 0, 5);
        jPanel2.add((Component)this._encryptPasswordCheckBox, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        imageIcon = new ImageIcon(LogonImages.getHost32x32());
        sybLabel = new SybLabel(_res.get("AboutServerInfo"));
        sybLabel.setIconTextGap(10);
        sybLabel.setIcon((Icon)imageIcon);
        sybLabel.setAlignmentX(0.0f);
        n2 = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)sybLabel, gridBagConstraints);
        this._settings = new SybButton(_res.get("SETTINGS"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)this._settings, gridBagConstraints);
        String string = "localhost";
        if (this._clientHostName.length() > 0 && (n = (string = this._clientHostName).indexOf(".")) > 0) {
            string = string.substring(0, n);
        }
        SybMultiLineLabel sybMultiLineLabel = new SybMultiLineLabel(_res.getFormatted("AboutServerName", string));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)sybMultiLineLabel, gridBagConstraints);
        sybLabel = new SybLabel(_res.get("ServerName"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)sybLabel, gridBagConstraints);
        this._serverComboBox = new JComboBox();
        this._serverComboBox.setEditable(true);
        this._serverComboBox.setRenderer(new ComboBoxRenderer());
        this._serverComboBox.addActionListener(new ComboBoxListener(this._serverComboBox));
        ASEDatabaseSource.setComboBoxPreferredWidth(this._serverComboBox, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._serverComboBox, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._serverComboBox);
        this._findServer = new SybButton(_res.get("FIND"));
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)this._findServer, gridBagConstraints);
        this.updateFindServerButton();
        this._hostLabel = new SybLabel(_res.get("HOST"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._hostLabel, gridBagConstraints);
        this._infoLabel = new SybLabel(_res.get("SERVER_INFO"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._infoLabel, gridBagConstraints);
        this._hostComboBox = new JComboBox();
        this._hostComboBox.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._hostComboBox, gridBagConstraints);
        this._hostLabel.setLabelFor((Component)this._hostComboBox);
        this._serverInfoLabel = new SybLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._serverInfoLabel, gridBagConstraints);
        this._detailsButton = new JToggleButton(_res.get("DETAILS"));
        this._detailsButton.setMnemonic('D');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)this._detailsButton, gridBagConstraints);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._findServer, this._settings, this._detailsButton});
        this._portLabel = new SybLabel(_res.get("PORT"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._portLabel, gridBagConstraints);
        this._portComboBox = new JComboBox();
        this._portComboBox.setEditable(true);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._portComboBox, gridBagConstraints);
        this._portLabel.setLabelFor((Component)this._portComboBox);
        this._sslCheckBox = new JCheckBox(_res.get("SSL"));
        this._sslCheckBox.setMnemonic('L');
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel3.add((Component)this._sslCheckBox, gridBagConstraints);
        this._charSeparator = new JSeparator();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._charSeparator, gridBagConstraints);
        this._charMLabel = new SybMultiLineLabel(_res.get("AboutCharLang"));
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        jPanel3.add((Component)this._charMLabel, gridBagConstraints);
        this._charLabel = new SybLabel(_res.get("CharacterSet"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._charLabel, gridBagConstraints);
        this._characterSet = new JComboBox<String>(this.getCharacterSetList());
        this._characterSet.setEditable(true);
        ASEDatabaseSource.setComboBoxPreferredWidth(this._characterSet, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._characterSet, gridBagConstraints);
        this._charLabel.setLabelFor((Component)this._characterSet);
        this._langLabel = new SybLabel(_res.get("Language"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 16, 8, 5);
        jPanel3.add((Component)this._langLabel, gridBagConstraints);
        this._language = new JComboBox<LanguageItem>(this.getLanguageList());
        this._language.setEditable(true);
        ASEDatabaseSource.setComboBoxPreferredWidth(this._language, 40);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 5);
        jPanel3.add((Component)this._language, gridBagConstraints);
        this._langLabel.setLabelFor((Component)this._language);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(8, 0, 8, 0);
        jPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 0;
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        this._settings.addActionListener((ActionListener)this);
        this._findServer.addActionListener((ActionListener)this);
        this._sslCheckBox.addActionListener(this);
        this._userid.getDocument().addDocumentListener(this);
        this._serverComboBox.addItemListener(this);
        this._serverNameTextField = (JTextField)this._serverComboBox.getEditor().getEditorComponent();
        this._serverNameTextField.getDocument().addDocumentListener(this);
        this._serverNameTextField.addKeyListener(this);
        this._hostComboBox.addItemListener(this);
        this._hostTextField = (JTextField)this._hostComboBox.getEditor().getEditorComponent();
        this._hostTextField.getDocument().addDocumentListener(this);
        this._hostTextField.addKeyListener(this);
        try {
            object = new ConstraintDocumentProxy().getObject();
            this._hostTextField.setDocument((PlainDocument)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._portComboBox.addItemListener(this);
        this._portTextField = (JTextField)this._portComboBox.getEditor().getEditorComponent();
        try {
            object = new NumericsOnlyDocumentProxy().getObject();
            this._portTextField.setDocument((PlainDocument)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._portTextField.getDocument().addDocumentListener(this);
        this._portTextField.addKeyListener(this);
        this._detailsButton.addActionListener(this);
        return jPanel;
    }

    private void refreshServerComboList() {
        int n;
        this._serverComboBox.removeAllItems();
        int n2 = 0;
        int n3 = 0;
        Vector<SyASEServerProxy> vector = ASEDatabaseSource.getServersFromInterfaces();
        for (n = 0; n < vector.size(); ++n) {
            this._serverComboBox.addItem(vector.get(n));
            ++n2;
        }
        vector = ASEDatabaseSource.getServersFromLDAP();
        if (vector.size() > 0) {
            this._serverComboBox.addItem(SEPARATOR);
        }
        for (n = 0; n < vector.size(); ++n) {
            this._serverComboBox.addItem(vector.get(n));
            ++n2;
        }
        for (n = _connectedServers.size() - 1; n >= 0; --n) {
            SyASEServerProxy syASEServerProxy = null;
            ASEConnectionInfo aSEConnectionInfo = _connectedServers.elementAt(n);
            String string = String.valueOf(aSEConnectionInfo.port);
            String string2 = aSEConnectionInfo.getServerName();
            if (string2 != null && !string2.isEmpty()) {
                syASEServerProxy = this.getServerItem(string2, null, null);
            }
            if (syASEServerProxy == null) {
                syASEServerProxy = this.getServerItem(aSEConnectionInfo.getServerName(), aSEConnectionInfo.host, string);
            }
            try {
                SyInterfacesEntryProxy syInterfacesEntryProxy;
                if (syASEServerProxy != null) {
                    syInterfacesEntryProxy = syASEServerProxy.getEntry();
                    syASEServerProxy = new SyASEServerProxy(syInterfacesEntryProxy);
                    this._serverComboBox.insertItemAt(syASEServerProxy, 0);
                    ++n3;
                    continue;
                }
                String string3 = aSEConnectionInfo.getServiceFilter();
                if (string3 != null) {
                    string = string + "," + string3;
                }
                ServiceProxy serviceProxy = new ServiceProxy(aSEConnectionInfo.host, string);
                syInterfacesEntryProxy = new SyInterfacesEntryProxy(aSEConnectionInfo.getDisplayServerName());
                syInterfacesEntryProxy.addService(serviceProxy);
                List<ServiceProxy> list = aSEConnectionInfo.getOtherServices();
                if (!list.isEmpty()) {
                    for (int i = 0; i < list.size(); ++i) {
                        ServiceProxy serviceProxy2 = list.get(i);
                        syInterfacesEntryProxy.addService(serviceProxy2);
                    }
                }
                syASEServerProxy = new SyASEServerProxy(syInterfacesEntryProxy);
                this._serverComboBox.insertItemAt(syASEServerProxy, 0);
                ++n3;
                continue;
            }
            catch (ReflectionProxyException reflectionProxyException) {
                // empty catch block
            }
        }
        if (n3 > 0 && n2 > 0) {
            this._serverComboBox.insertItemAt(SEPARATOR, n3);
        }
    }

    private void updateFindServerButton() {
        boolean bl = false;
        try {
            UtilsProxy utilsProxy = new UtilsProxy();
            bl = utilsProxy.getEnableServerDiscovery();
        }
        catch (ReflectionProxyException reflectionProxyException) {
            // empty catch block
        }
        this._findServer.setVisible(bl);
    }

    public static Vector<SyASEServerProxy> getServersFromInterfaces() {
        Vector<SyASEServerProxy> vector;
        block3: {
            vector = new Vector<SyASEServerProxy>();
            try {
                DirectoryServiceHelperProxy directoryServiceHelperProxy = new DirectoryServiceHelperProxy();
                directoryServiceHelperProxy.initInterfacesDriver();
                Enumeration enumeration = directoryServiceHelperProxy.entriesFromInterfaces();
                while (enumeration.hasMoreElements()) {
                    ASEDatabaseSource.checkAndAddServer(enumeration.nextElement(), vector);
                }
            }
            catch (ReflectionProxyException reflectionProxyException) {
                if (!ASEDatabaseSource.dbgEnabled()) break block3;
                Dbg.printlnEx((Throwable)reflectionProxyException.getCause(), (String)"Error calling interfaces reader");
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public static Vector<SyASEServerProxy> getServersFromLDAP() {
        Vector<SyASEServerProxy> vector;
        block4: {
            vector = new Vector<SyASEServerProxy>();
            try {
                LDAPSettingProxy lDAPSettingProxy = new LDAPSettingProxy();
                LDAPSettingProxy lDAPSettingProxy2 = lDAPSettingProxy.getLDAPSetting();
                boolean bl = lDAPSettingProxy2.getInclude();
                if (bl) {
                    DirectoryServiceHelperProxy directoryServiceHelperProxy = new DirectoryServiceHelperProxy();
                    directoryServiceHelperProxy.initLibtclDriver();
                    Enumeration enumeration = directoryServiceHelperProxy.entriesFromLDAP(lDAPSettingProxy2.getTimeout());
                    while (enumeration.hasMoreElements()) {
                        ASEDatabaseSource.checkAndAddServer(enumeration.nextElement(), vector);
                    }
                }
            }
            catch (ReflectionProxyException reflectionProxyException) {
                if (!ASEDatabaseSource.dbgEnabled()) break block4;
                Dbg.printlnEx((Throwable)reflectionProxyException.getCause(), (String)"Error calling ldap reader");
            }
        }
        Collections.sort(vector);
        return vector;
    }

    public static Vector<SyASEServerProxy> getServerList() {
        Vector<SyASEServerProxy> vector = ASEDatabaseSource.getServersFromInterfaces();
        vector.addAll(ASEDatabaseSource.getServersFromLDAP());
        return vector;
    }

    public static String getClientSideServerName(String string, String string2) {
        Vector<SyASEServerProxy> vector = ASEDatabaseSource.getServerList();
        for (SyASEServerProxy syASEServerProxy : vector) {
            String string3;
            String string4 = syASEServerProxy.getName();
            String string5 = syASEServerProxy.getHost();
            String string6 = ASEDatabaseSource.getIPAndPort(string5, string3 = syASEServerProxy.getPort());
            if (string6 == null || !string6.equals(ASEDatabaseSource.getIPAndPort(string, string2))) continue;
            return string4;
        }
        return null;
    }

    public static SyASEServerProxy getServer(String string) {
        Vector<SyASEServerProxy> vector = ASEDatabaseSource.getServerList();
        for (SyASEServerProxy syASEServerProxy : vector) {
            String string2 = syASEServerProxy.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            return syASEServerProxy;
        }
        return null;
    }

    private static void checkAndAddServer(Object object, Vector<SyASEServerProxy> vector) {
        SyASEServerProxy syASEServerProxy = new SyASEServerProxy(object);
        String string = syASEServerProxy.getHost();
        String string2 = syASEServerProxy.getPort();
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            vector.add(syASEServerProxy);
        }
    }

    private String getCharacterSet() {
        Object object = this._characterSet.getSelectedItem();
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    private Vector<String> getCharacterSetList() {
        Vector<String> vector = new Vector<String>();
        vector.add(_res.get("DEFAULT"));
        String string = "";
        try {
            _dsUtils = new UtilsProxy();
            string = _dsUtils.getSybasePath();
        }
        catch (ReflectionProxyException reflectionProxyException) {
            // empty catch block
        }
        try {
            String string2 = string + File.separator + "charsets";
            File file = new File(string2);
            if (file.exists()) {
                String[] stringArray = file.list();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (string3.toUpperCase().equals("META-INF")) continue;
                    vector.add(string3);
                }
                return vector;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        vector.add("cp437");
        vector.add("cp850");
        vector.add("cp852");
        vector.add("cp1250");
        vector.add("deckanji");
        vector.add("eucgb");
        vector.add("eucjis");
        vector.add("eucksc");
        vector.add("iso_1");
        vector.add("iso88592");
        vector.add("mac");
        vector.add("roman8");
        vector.add("sjis");
        vector.add("utf8");
        return vector;
    }

    private String getLanguage() {
        int n = this._language.getSelectedIndex();
        Object object = this._language.getSelectedItem();
        if (n > -1) {
            return ((LanguageItem)object).language;
        }
        return object.toString();
    }

    private Vector<LanguageItem> getLanguageList() {
        Vector<LanguageItem> vector = new Vector<LanguageItem>();
        vector.add(new LanguageItem(_res.get("DEFAULT"), "default"));
        vector.add(new LanguageItem(_res.get("CHINESE"), "chinese"));
        vector.add(new LanguageItem(_res.get("ENGLISH"), "us_english"));
        vector.add(new LanguageItem(_res.get("FRENCH"), "french"));
        vector.add(new LanguageItem(_res.get("GERMAN"), "german"));
        vector.add(new LanguageItem(_res.get("JAPANESE"), "japanese"));
        vector.add(new LanguageItem(_res.get("KOREAN"), "korean"));
        vector.add(new LanguageItem(_res.get("POLISH"), "polish"));
        vector.add(new LanguageItem(_res.get("PORTUGESE"), "portuguese"));
        vector.add(new LanguageItem(_res.get("SPANISH"), "spanish"));
        vector.add(new LanguageItem(_res.get("THAI"), "thai"));
        return vector;
    }

    private static void setComboBoxPreferredWidth(JComboBox jComboBox, int n) {
        Dimension dimension = jComboBox.getPreferredSize();
        FontMetrics fontMetrics = jComboBox.getFontMetrics(jComboBox.getFont());
        int n2 = fontMetrics.charWidth('m');
        int n3 = n2 * n;
        if (dimension.width > n3) {
            dimension.width = n3;
            jComboBox.setPreferredSize(dimension);
        }
    }

    private JPanel createAdvancedPanel() {
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName(_res.get("Advanced"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        SybLabel sybLabel = new SybLabel(_res.get("AdvancedText"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        jPanel.add((Component)sybLabel, gridBagConstraints);
        this._advanced = new SybTextArea();
        this._advanced.setTabMovesFocus(true);
        JScrollPane jScrollPane = new JScrollPane((Component)this._advanced);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        sybLabel.setLabelFor((Component)this._advanced);
        return jPanel;
    }

    private void setInitialValues() {
        try {
            SettingsProxy settingsProxy = new SettingsProxy();
            this._numSavedServers = settingsProxy.getEnableSaveServers() ? settingsProxy.getNumberOfSavedServers() : 0;
        }
        catch (ReflectionProxyException reflectionProxyException) {
            // empty catch block
        }
        this.resetControls();
        this.loadConnectedServers();
        this.refreshServerComboList();
        if (this._initialConnectionInfo != null && _connectedServers.size() > 0) {
            if (!this._initialConnectionInfo.canAttemptConnection()) {
                this._initialConnectionInfo.merge(this.getLastConnectedServerInfo());
            } else {
                for (int i = 0; i < _connectedServers.size(); ++i) {
                    ASEConnectionInfo aSEConnectionInfo = _connectedServers.get(i);
                    if (aSEConnectionInfo.host == null || !aSEConnectionInfo.host.equals(this._initialConnectionInfo.host) || aSEConnectionInfo.port != this._initialConnectionInfo.port) continue;
                    this._initialConnectionInfo.merge(aSEConnectionInfo, false);
                    break;
                }
            }
        }
        if (this._initialConnectionInfo != null) {
            this.setInitialValues(this._initialConnectionInfo);
        }
    }

    private void setInitialValues(ASEConnectionInfo aSEConnectionInfo) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = aSEConnectionInfo.getUserName();
        if (string5 == null) {
            this._userid.setText(System.getProperty("user.name"));
        } else {
            this._userid.setText(string5);
        }
        String string6 = aSEConnectionInfo.getPassword();
        if (string6 != null) {
            this._password.setText(string6);
        }
        this._encryptPasswordCheckBox.setSelected(aSEConnectionInfo.getEncryptPassword());
        String string7 = aSEConnectionInfo.getServerName();
        String string8 = String.valueOf(aSEConnectionInfo.port);
        SyASEServerProxy syASEServerProxy = this.getServerItem(string7, aSEConnectionInfo.host, string8);
        boolean bl = false;
        if (string7 != null && syASEServerProxy != null) {
            this._serverComboBox.setSelectedItem(string7);
            if (aSEConnectionInfo.port != -1) {
                this.updateFilter(aSEConnectionInfo.host, string8);
            }
        } else if (aSEConnectionInfo.host != null && aSEConnectionInfo.port != -1) {
            this._serverComboBox.setSelectedItem(ASEDatabaseSource.getHostAndPort(aSEConnectionInfo.host, aSEConnectionInfo.port));
            if (aSEConnectionInfo.getServiceFilter() != null) {
                this._sslCheckBox.setSelected(true);
            }
        } else {
            bl = true;
        }
        if (!((string4 = aSEConnectionInfo.getRMIPort()) == null || bl || string4.equals(String.valueOf(-1)) || string4.equals(DEFAULT_RMI_PORT) || this._serverNameTextField.getText().endsWith(RMI_PORT_SEP + string4))) {
            this._serverNameTextField.setText(this._serverNameTextField.getText() + RMI_PORT_SEP + string4);
        }
        if ((string3 = aSEConnectionInfo.getCharSet()) != null) {
            this._characterSet.setSelectedItem(string3);
        }
        if ((string2 = aSEConnectionInfo.getLanguage()) != null) {
            this._language.setSelectedItem(string2);
        }
        if ((string = aSEConnectionInfo.getOtherParms()) != null && string.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(128);
            ConnectionStringTokenizer connectionStringTokenizer = new ConnectionStringTokenizer(aSEConnectionInfo.getOtherParms());
            while (connectionStringTokenizer.hasMoreTokens()) {
                String string9 = connectionStringTokenizer.nextToken();
                if (stringBuffer.length() > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append(string9);
            }
            this._advanced.setText(stringBuffer.toString());
        }
        this._serverNameTextField.setCaretPosition(0);
    }

    private void resetControls() {
        this._userid.setText("");
        this._password.setText("");
        this._serverComboBox.setSelectedItem("");
        this._language.setSelectedIndex(0);
        this._characterSet.setSelectedIndex(0);
        this._advanced.setText("");
    }

    private void destroyGUI() {
        if (this._panel != null) {
            this._tabbedPane = null;
            this._identificationPanel = null;
            this._advancedPanel = null;
            this._userid = null;
            this._useridLabel = null;
            this._password = null;
            this._passwordLabel = null;
            this._settings = null;
            this._serverNameTextField = null;
            this._serverComboBox = null;
            this._findServer = null;
            this._infoLabel = null;
            this._serverInfoLabel = null;
            this._detailsButton = null;
            this._hostLabel = null;
            this._hostTextField = null;
            this._hostComboBox = null;
            this._portLabel = null;
            this._portTextField = null;
            this._portComboBox = null;
            this._sslCheckBox = null;
            this._charSeparator = null;
            this._charMLabel = null;
            this._charLabel = null;
            this._characterSet = null;
            this._langLabel = null;
            this._language = null;
            this._advanced = null;
            DialogUtils.removeComponents((Container)this._panel);
            this._panel = null;
        }
    }

    protected Window getParentWindow() {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this._panel);
        return window;
    }

    protected JDialog getParentDialog() {
        JDialog jDialog = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this._panel);
        return jDialog;
    }

    @Override
    public AbstractConnectionInfo getConnectionInfo() {
        int n;
        int n2;
        if (this._panel == null) {
            ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo(this._initialConnectionInfo);
            return aSEConnectionInfo;
        }
        ASEConnectionInfo aSEConnectionInfo = new ASEConnectionInfo();
        aSEConnectionInfo.setUserName(this.getUser());
        aSEConnectionInfo.setPassword(this.getPassword());
        String string = this.getServerName();
        if (string.length() != 0) {
            int n3 = string.indexOf(RMI_PORT_SEP);
            if (n3 > 0) {
                aSEConnectionInfo.setRMIPort(string.substring(n3 + RMI_PORT_SEP.length()));
                string = string.substring(0, n3);
            }
            if ((n3 = string.indexOf(PORT_SEP)) == -1) {
                aSEConnectionInfo.setServerName(string);
            }
            aSEConnectionInfo.host = this.getHostName();
            aSEConnectionInfo.port = this.getPort();
            if (aSEConnectionInfo.getRMIPort() == null && FindingASEsDialog._entries.size() > 0) {
                String string2 = ASEDatabaseSource.getIPAndPort(aSEConnectionInfo.host, String.valueOf(aSEConnectionInfo.port));
                for (SyUAFASEEntryProxy myReflectionProxy2 : FindingASEsDialog._entries) {
                    String n4 = ASEDatabaseSource.getIPAndPort(myReflectionProxy2.getHostName(), String.valueOf(myReflectionProxy2.getPortNumber()));
                    if (!string2.equals(n4)) continue;
                    aSEConnectionInfo.setRMIPort(myReflectionProxy2.getRMIPort());
                    break;
                }
            }
        } else {
            aSEConnectionInfo.setServerName(null);
            aSEConnectionInfo.host = null;
            aSEConnectionInfo.port = -1;
        }
        if ((n2 = this._characterSet.getSelectedIndex()) > 0) {
            aSEConnectionInfo.setCharSet(this.getCharacterSet());
        } else if (System.getProperty("os.name").startsWith("HP")) {
            aSEConnectionInfo.setCharSet("iso_1");
        }
        int n4 = this._language.getSelectedIndex();
        if (n4 > 0) {
            aSEConnectionInfo.setLanguage(this.getLanguage());
        }
        if (this._sslCheckBox.isSelected()) {
            aSEConnectionInfo.setServiceFilter("ssl");
        }
        aSEConnectionInfo.setEncryptPassword(this._encryptPasswordCheckBox.isSelected());
        SyASEServerProxy syASEServerProxy = this.getServerItem(aSEConnectionInfo.getServerName(), aSEConnectionInfo.host, String.valueOf(aSEConnectionInfo.port));
        if (syASEServerProxy != null && (n = this._portComboBox.getItemCount()) > 1) {
            int n5;
            ArrayList<ServiceProxy> arrayList = new ArrayList<ServiceProxy>();
            int n6 = this._portComboBox.getSelectedIndex();
            for (n5 = 0; n5 < n; ++n5) {
                if (n5 == n6) continue;
                arrayList.add(((PortItem)this._portComboBox.getItemAt((int)n5))._service);
            }
            if (n6 > 0) {
                for (n5 = 0; n5 < n6; ++n5) {
                    arrayList.add(arrayList.remove(0));
                }
            }
            aSEConnectionInfo.setOtherServices(arrayList);
        }
        if ((string = this.getAdvanced()).length() != 0) {
            this.fillAdvancedInfo(aSEConnectionInfo, string);
            aSEConnectionInfo.setOtherParms(string);
        } else {
            aSEConnectionInfo.setOtherParms(null);
        }
        if (this._classLoader != null) {
            aSEConnectionInfo.setClassLoader(this._classLoader);
        }
        aSEConnectionInfo.setProperty("HOSTNAME", this._clientHostName);
        return aSEConnectionInfo;
    }

    private void fillAdvancedInfo(ASEConnectionInfo aSEConnectionInfo, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(61);
            if (n == -1) continue;
            String string3 = string2.substring(0, n);
            string = string2.substring(n + 1);
            aSEConnectionInfo.setProperty(string3, string);
        }
    }

    private SyASEServerProxy getServerItem(String string, String string2, String string3) {
        for (int i = 0; i < this._serverComboBox.getItemCount(); ++i) {
            Object e = this._serverComboBox.getItemAt(i);
            if (!(e instanceof SyASEServerProxy)) continue;
            SyASEServerProxy syASEServerProxy = (SyASEServerProxy)e;
            String string4 = syASEServerProxy.getName();
            int n = string4.indexOf(RMI_PORT_SEP);
            if (n > 0) {
                string4 = string4.substring(0, n);
            }
            if (string2 == null || string3 == null) {
                if (!string4.equals(string)) continue;
                return syASEServerProxy;
            }
            List list = syASEServerProxy.getEntry().getServices();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceProxy serviceProxy = new ServiceProxy(iterator.next());
                if (!serviceProxy.hasPort()) continue;
                String string5 = serviceProxy.getHost();
                String string6 = serviceProxy.getPort();
                if (!string6.equals(string3) || string5 == null || !string5.equals(string2) || string != null && string.lastIndexOf(PORT_SEP) <= 0 && !string4.equals(string)) continue;
                return syASEServerProxy;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connect(ArrayList<SQLWarning> arrayList, AbstractConnectionInfo abstractConnectionInfo, ClassLoader classLoader) {
        Connection connection;
        block46: {
            connection = null;
            Properties properties = new Properties();
            ASEConnectionInfo aSEConnectionInfo = (ASEConnectionInfo)this.getConnectionInfo();
            if (classLoader != null) {
                aSEConnectionInfo.setClassLoader(classLoader);
            }
            if (ASEDatabaseSource.dbgEnabled()) {
                Dbg.printlnEx((String)("ConnectionInfo=" + aSEConnectionInfo + "\n" + "Overrides=" + abstractConnectionInfo));
            }
            if (abstractConnectionInfo != null && abstractConnectionInfo instanceof ASEConnectionInfo) {
                aSEConnectionInfo.merge((ASEConnectionInfo)abstractConnectionInfo);
            }
            StringBuffer stringBuffer = new StringBuffer();
            try {
                Driver driver;
                try {
                    driver = JDBCDrivers.loadJConnectDriver("com.sybase.jdbc4.jdbc.SybDriver", classLoader);
                    properties.put("DELETE_WARNINGS_FROM_EXCEPTION_CHAIN", "false");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    driver = JDBCDrivers.loadJConnectDriver("com.sybase.jdbc3.jdbc.SybDriver", classLoader);
                }
                if (aSEConnectionInfo.host != null && aSEConnectionInfo.port != -1) {
                    stringBuffer.append("jdbc:sybase:Tds:");
                    stringBuffer.append(aSEConnectionInfo.host);
                    stringBuffer.append(PORT_SEP);
                    stringBuffer.append(aSEConnectionInfo.port);
                } else if (ASEDatabaseSource.dbgEnabled()) {
                    Dbg.printlnEx((String)"Either info.host or info.port is invalid");
                }
                properties.put("HOSTNAME", this._clientHostName);
                String string = aSEConnectionInfo.getUserName();
                properties.put("USER", string);
                string = aSEConnectionInfo.getPassword();
                if (string != null) {
                    properties.put("PASSWORD", string);
                }
                if ((string = aSEConnectionInfo.getCharSet()) != null) {
                    properties.put("CHARSET", string);
                }
                if ((string = aSEConnectionInfo.getLanguage()) != null) {
                    properties.put("LANGUAGE", string);
                }
                if ((string = aSEConnectionInfo.getApplicationName()) == null || string.length() == 0) {
                    string = "DBISQL";
                }
                properties.put("APPLICATIONNAME", string);
                string = aSEConnectionInfo.getServiceFilter();
                if (string != null && string.equals("ssl")) {
                    properties.put("SYBSOCKET_FACTORY", "com.sybase.util.ds.ssl.SSLSocketFactoryASE");
                }
                if ((string = this.getAdvanced()).length() > 0) {
                    String[] stringArray = string.split("\n");
                    for (int i = 0; i < stringArray.length; ++i) {
                        int n;
                        string = stringArray[i].trim();
                        if (string.length() == 0 || (n = string.indexOf("=")) == -1) continue;
                        properties.put(string.substring(0, n), string.substring(n + 1));
                    }
                }
                properties.put("JCONNECT_VERSION", Integer.toString(0));
                if (ASEDatabaseSource.dbgEnabled()) {
                    Dbg.printlnEx((String)("Connecting with URL=" + stringBuffer.toString() + ", parms=" + properties.toString()));
                }
                if (DSSettingsProxy.getEnableLoginTimeout()) {
                    DriverManager.setLoginTimeout(DSSettingsProxy.getLoginTimeout());
                }
                connection = driver.connect(stringBuffer.toString(), properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.displayError(classNotFoundException);
            }
            catch (SQLException sQLException) {
                String string = sQLException.getSQLState();
                SQLException sQLException2 = sQLException.getNextException();
                if (string != null && string.equals("JZ0IB") || sQLException2 != null && sQLException2.getSQLState() != null && sQLException2.getSQLState().equals("JZ0IB")) {
                    properties.put("CHARSET", "iso_1");
                    try {
                        connection = DriverManager.getConnection(stringBuffer.toString(), properties);
                    }
                    catch (SQLException sQLException3) {
                        this.displayError(sQLException3);
                    }
                    break block46;
                }
                if (string != null && string.equals("01ZZZ")) {
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (SQLException sQLException4) {
                        // empty catch block
                    }
                    try {
                        NewPasswordDialogProxy newPasswordDialogProxy = new NewPasswordDialogProxy(this.getParentDialog(), aSEConnectionInfo.getPassword());
                        String string2 = newPasswordDialogProxy.create();
                        if (string2 == null) break block46;
                        stringBuffer.append("?NEWPASSWORD=\"" + string2 + "\"");
                        try {
                            connection = DriverManager.getConnection(stringBuffer.toString(), properties);
                            break block46;
                        }
                        catch (SQLException sQLException5) {
                            this.displayError(sQLException5);
                        }
                    }
                    catch (ReflectionProxyException reflectionProxyException) {
                        this.displayInstallError(reflectionProxyException);
                    }
                    break block46;
                }
                this.displayError(sQLException);
            }
            finally {
                block47: {
                    if (connection != null) {
                        try {
                            Statement statement = connection.createStatement();
                            statement.execute("set textsize 2147483647");
                            statement.close();
                            statement = null;
                            if (arrayList != null) {
                                for (SQLWarning sQLWarning = connection.getWarnings(); sQLWarning != null; sQLWarning = sQLWarning.getNextWarning()) {
                                    arrayList.add(sQLWarning);
                                }
                                connection.clearWarnings();
                            }
                        }
                        catch (SQLException sQLException) {
                            if (!ASEDatabaseSource.dbgEnabled()) break block47;
                            Dbg.printlnEx((Throwable)sQLException, (String)"Warning! Could not set textsize option.");
                        }
                    }
                }
            }
        }
        return connection;
    }

    @Override
    public void reportConnectionFailure(Exception exception) {
        this.displayError(exception);
    }

    public void displayError(Exception exception) {
        if (ASEDatabaseSource.dbgEnabled()) {
            Dbg.printlnEx((Throwable)exception, (String)"Displaying error");
        }
        if (exception instanceof ClassNotFoundException) {
            this.handleDriverNotFound(exception);
        } else if (exception instanceof SQLException) {
            this.handleSQLException((SQLException)exception);
        } else {
            this.handleGenericException(exception);
        }
    }

    private void handleGenericException(Exception exception) {
        StringBuffer stringBuffer = new StringBuffer();
        this.displayConnectionError(exception.getLocalizedMessage(), null, stringBuffer.toString());
    }

    public void handleSQLException(SQLException sQLException) {
        String string;
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = System.getProperty("line.separator");
        SQLException sQLException2 = sQLException.getNextException();
        int n = sQLException2 != null ? sQLException2.getErrorCode() : 0;
        String string4 = sQLException.getSQLState();
        if (string4 != null && string4.equals("JZ00L") && sQLException2 != null) {
            switch (n) {
                case 4002: {
                    this._tabbedPane.setSelectedComponent(this._identificationPanel);
                    this._password.requestFocus();
                    this._password.selectAll();
                    string2 = sQLException2.getLocalizedMessage();
                    string = null;
                    break;
                }
                default: {
                    string2 = sQLException2.getLocalizedMessage();
                    string = null;
                    break;
                }
            }
        } else if (string4 != null && string4.equals("JZ004")) {
            string2 = _res.get("You must give a user name.");
            string = null;
            this._tabbedPane.setSelectedComponent(this._identificationPanel);
            this._userid.requestFocus();
        } else if (string4 != null && string4.equals("JZ006")) {
            string2 = _res.get("Connection refused.");
            this._tabbedPane.setSelectedComponent(this._identificationPanel);
            String string5 = sQLException.getMessage();
            JTextField jTextField = null;
            boolean bl = this._detailsButton.isSelected();
            if (string5.indexOf("UnknownHostException") != -1) {
                string = _res.get("ErrServerNotFoundRemedy");
                if (bl) {
                    jTextField = this._hostTextField;
                } else {
                    this._serverNameTextField.requestFocus();
                    this._serverNameTextField.select(0, this.getServerName().indexOf(PORT_SEP));
                }
            } else if (string5.indexOf("SSLHandshakeException") != -1) {
                string = _res.get("ERR_FAILED_SSL_CONNECT_REMEDY");
                jTextField = this._portTextField;
                if (!bl) {
                    this.showDetails(true);
                    this._detailsButton.setSelected(true);
                }
            } else {
                string = _res.get("ErrServerNotFoundRemedy");
                jTextField = this._serverNameTextField;
            }
            if (jTextField != null) {
                jTextField.requestFocus();
                jTextField.selectAll();
            }
        } else {
            string2 = sQLException.getLocalizedMessage();
            string = null;
            sQLException2 = sQLException.getNextException();
            if (sQLException2 != null) {
                stringBuffer.append(sQLException2.getLocalizedMessage());
                stringBuffer.append(string3);
            }
        }
        if (string4 != null && !string4.equals("01ZZZ")) {
            this.displayConnectionError(sQLException, string2, string, stringBuffer.toString());
        }
    }

    private void handleDriverNotFound(Exception exception) {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(_res.get("Missing JDBC driver"));
        stringBuffer.append(string);
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string);
        stringBuffer.append(string);
        stringBuffer.append(_res.get("Classpath"));
        stringBuffer.append(string);
        String[] stringArray = System.getProperty("java.class.path").split(File.pathSeparator);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append("    ");
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(string);
        }
        this.displayConnectionError(_res.get("The JDBC driver could not be loaded."), "", stringBuffer.toString());
    }

    private void displayConnectionError(Exception exception, String string, String string2, String string3) {
        String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(exception.getLocalizedMessage());
        stringBuffer.append(string4);
        if (exception instanceof SQLException) {
            stringBuffer.append(_res.getFormatted("\tError code={0}", Integer.toString(((SQLException)exception).getErrorCode())));
            stringBuffer.append(string4);
            stringBuffer.append(_res.getFormatted("\tSQL state={0}", ((SQLException)exception).getSQLState()));
            stringBuffer.append(string4);
            SQLException sQLException = ((SQLException)exception).getNextException();
            if (sQLException != null) {
                stringBuffer.append(sQLException.getLocalizedMessage());
                stringBuffer.append(string4);
                stringBuffer.append(_res.getFormatted("\tError code={0}", Integer.toString(sQLException.getErrorCode())));
                stringBuffer.append(string4);
                stringBuffer.append(_res.getFormatted("\tSQL state={0}", sQLException.getSQLState()));
                stringBuffer.append(string4);
            }
            if (ASEDatabaseSource.dbgEnabled()) {
                stringBuffer.append(ASEDatabaseSource.getDetails(exception));
                stringBuffer.append(string4);
            }
        }
        this.displayConnectionError(string, string2, stringBuffer.toString());
    }

    private void displayConnectionError(String string, String string2, String string3) {
        StringBuffer stringBuffer;
        final String string4 = System.getProperty("line.separator");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(_res.get("Could not connect to the database"));
        stringBuffer2.append(string4);
        stringBuffer2.append(string4);
        stringBuffer2.append(string);
        if (string2 != null) {
            stringBuffer2.append(string4);
            stringBuffer2.append(string4);
            stringBuffer2.append(string2);
        }
        if ((stringBuffer = new StringBuffer(string3)).length() > 0) {
            stringBuffer.append(string4);
        }
        stringBuffer.append(_res.get("Connection parameters:"));
        stringBuffer.append(string4);
        stringBuffer.append(_res.getFormatted("\tUser={0}", this.getUser()));
        stringBuffer.append(string4);
        int n = this.getPassword().length();
        StringBuffer stringBuffer3 = new StringBuffer(n);
        while (n-- > 0) {
            stringBuffer3.append('*');
        }
        stringBuffer.append(_res.getFormatted("\tPassword={0}", stringBuffer3.toString()));
        stringBuffer.append(string4);
        this.buildConnectionString(new ConnectionStringBuilder(){

            @Override
            public void addParm(String string, String string2) {
                if (string.equalsIgnoreCase("UID") || string.equalsIgnoreCase("PWD")) {
                    return;
                }
                stringBuffer.append(_res.getFormatted("\t{0}={1}", string, string2));
                stringBuffer.append(string4);
            }
        });
        Window window = this.getParentWindow();
        String string5 = window instanceof Dialog ? ((Dialog)window).getTitle() : ((Frame)window).getTitle();
        DetailsErrorDialog.showDialog((Component)window, (String)string5, (String)stringBuffer2.toString(), (String)stringBuffer.toString(), null);
    }

    @Override
    public String getDisplayName() {
        return _res.get("ADAPTIVE_SERVER_ENTERPRISE");
    }

    @Override
    public Icon getIcon() {
        return ASAComponentsImageLoader.getImageIcon((String)"ase", (int)1001);
    }

    @Override
    public void showHelp() {
        this.showHelp(this.getHelpContextId(), this.getParentWindow());
    }

    public void showHelp(String string, Window window) {
        if (this._helpViewer == null) {
            try {
                this._helpViewer = FactoryHelp.getViewer((String)this._helpJARLocation, (String)this._helpPrefix, (String)this._helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                if (window instanceof Dialog) {
                    String string2 = ((Dialog)window).getTitle();
                    DetailsErrorDialog.showDetailsErrorDialog((Dialog)((Dialog)window), (String)string2, (String)_res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
                }
                String string3 = ((Frame)window).getTitle();
                DetailsErrorDialog.showDetailsErrorDialog((Frame)((Frame)window), (String)string3, (String)_res.get("Help could not be displayed."), (Throwable)helpNotFoundException, null);
            }
        }
        if (this._helpViewer != null) {
            this._helpViewer.turnPage(string, window);
        }
    }

    @Override
    public boolean hasHelp() {
        return this._helpJARLocation != null;
    }

    @Override
    public void setHelpFolder(String string, String string2, String string3) {
        this._helpJARLocation = string;
        this._helpPrefix = string2;
        this._helpSuffix = string3;
    }

    private static boolean dbgEnabled() {
        return false;
    }

    private boolean verifyServerName() {
        SyASEServerProxy syASEServerProxy;
        boolean bl = false;
        String string = this._serverNameTextField.getText();
        String string2 = null;
        int n = string.indexOf(RMI_PORT_SEP);
        if (n > 0) {
            string2 = string.substring(n + RMI_PORT_SEP.length());
            string = string.substring(0, n);
            int n2 = -1;
            try {
                n2 = Integer.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (n2 < 0) {
                return false;
            }
        }
        if ((syASEServerProxy = this.getServerItem(string, null, null)) != null) {
            this._serverComboBox.setToolTipText(this.getToolTipText(syASEServerProxy, string2));
            bl = true;
        } else {
            n = string.lastIndexOf(PORT_SEP);
            if (n > 0) {
                String string3 = string.substring(0, n);
                String string4 = string.substring(n + PORT_SEP.length());
                int n3 = -1;
                try {
                    n3 = Integer.valueOf(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                if (string3.length() > 0 && n3 >= 0 && n3 < 65536) {
                    bl = true;
                    this._serverComboBox.setToolTipText(this.getToolTipText(string3, string4, string2));
                }
            }
        }
        return bl;
    }

    private void enableOKButton() {
        if (this._host == null) {
            return;
        }
        boolean bl = this.verifyServerName();
        if (!bl) {
            this._serverComboBox.setToolTipText(_res.get("INVALID_SERVER_NAME"));
        }
        boolean bl2 = this.getUser().length() > 0 && bl;
        this._host.enableOKButton(bl2);
    }

    private String getToolTipText(SyASEServerProxy syASEServerProxy, String string) {
        String string2 = "<HTML>";
        SyInterfacesEntryProxy syInterfacesEntryProxy = syASEServerProxy.getEntry();
        List list = syInterfacesEntryProxy.getServices();
        String string3 = "";
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ServiceProxy serviceProxy = new ServiceProxy(iterator.next());
            if (!serviceProxy.hasPort()) continue;
            String string4 = serviceProxy.getHost();
            String string5 = serviceProxy.getPort();
            String string6 = serviceProxy.getFilter();
            string2 = string2 + string3 + "<i>" + _res.get("HostName") + "</i>" + string4 + "<i>" + _res.get("PortNumber") + "</i>" + string5 + (string6 != null && string6.length() > 0 ? "<i>" + _res.get("FILTER") + "</i>" + string6 : "");
            string3 = "<BR>";
        }
        return this.getToolTipAgentPortText(string2, string);
    }

    private String getToolTipText(String string, String string2, String string3) {
        String string4 = "<HTML><i>" + _res.get("HostName") + "</i>" + string + "<BR>" + "<i>" + _res.get("PortNumber") + "</i>" + string2;
        return this.getToolTipAgentPortText(string4, string3);
    }

    private String getToolTipAgentPortText(String string, String string2) {
        String string3 = string;
        string3 = string2 == null ? string3 + "</HTML>" : string3 + "<BR>" + _res.get("AgentPortNumber") + string2 + "</HTML>";
        return string3;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged(documentEvent);
    }

    private void textValueChanged(DocumentEvent documentEvent) {
        this.enableOKButton();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && (keyEvent.getSource() == this._serverNameTextField || keyEvent.getSource() == this._hostTextField || keyEvent.getSource() == this._portTextField)) {
            if (this._host != null) {
                this._host.simulateOKButtonClick();
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (!keyEvent.isActionKey()) {
            int n = keyEvent.getKeyCode();
            if (n == 17 || n == 157 || keyEvent.getModifiers() > 0) {
                return;
            }
            if (object == this._hostTextField) {
                this.updateServer();
            } else if (object == this._portTextField) {
                this.updateServer();
            } else if (object == this._serverNameTextField) {
                this.updateHostPort();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object;
            Object object2 = itemEvent.getSource();
            if (object2 == this._serverComboBox) {
                this.updateHostPort();
            } else if (object2 == this._portComboBox) {
                Object object3 = this._portComboBox.getSelectedItem();
                if (object3 instanceof PortItem) {
                    this.updateServer((PortItem)object3, this._portComboBox.getSelectedIndex());
                }
            } else if (object2 == this._hostComboBox && (object = this._hostComboBox.getSelectedItem()) instanceof HostItem) {
                this.updateServer((HostItem)object, this._hostComboBox.getSelectedIndex());
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane != null && jTabbedPane.getTabCount() > 1) {
            jTabbedPane.setTitleAt(1, _res.get("Advanced"));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._findServer) {
            this.handleFindServer();
        } else if (object == this._settings) {
            this.handleSettings();
        } else if (object == this._detailsButton) {
            this.showDetails(this._detailsButton.isSelected());
        } else if (object == this._sslCheckBox) {
            this.updateServerInfo();
        }
    }

    private void showDetails(boolean bl) {
        this._serverInfoLabel.setVisible(!bl);
        this._infoLabel.setVisible(!bl);
        this._hostLabel.setVisible(bl);
        this._hostComboBox.setVisible(bl);
        this._portLabel.setVisible(bl);
        this._portComboBox.setVisible(bl);
        this._sslCheckBox.setVisible(bl);
        this._charSeparator.setVisible(bl);
        this._charMLabel.setVisible(bl);
        this._charLabel.setVisible(bl);
        this._characterSet.setVisible(bl);
        this._langLabel.setVisible(bl);
        this._language.setVisible(bl);
        JDialog jDialog = this.getParentDialog();
        if (jDialog != null) {
            jDialog.setSize(jDialog.getSize().width, jDialog.getPreferredSize().height);
            jDialog.setVisible(true);
        }
    }

    private void updateFilter(String string, String string2) {
        this.updateFilter(string, string2, -1);
    }

    private void updateFilter(String string, String string2, int n) {
        if (this._portComboBox.getItemCount() != this._hostComboBox.getItemCount()) {
            return;
        }
        this._sslCheckBox.setSelected(false);
        if (n == -1) {
            for (int i = 0; i < this._portComboBox.getItemCount(); ++i) {
                PortItem portItem = (PortItem)this._portComboBox.getItemAt(i);
                HostItem hostItem = (HostItem)this._hostComboBox.getItemAt(i);
                if (!hostItem._service.getHost().equals(string) || !portItem._service.getPort().equals(string2)) continue;
                String string3 = portItem._service.getFilter();
                this._sslCheckBox.setSelected(this.isSSL(string3));
                this._portComboBox.setSelectedItem(portItem);
                this._hostComboBox.setSelectedItem(hostItem);
                return;
            }
        } else {
            HostItem hostItem = (HostItem)this._hostComboBox.getItemAt(n);
            String string4 = hostItem._service.getFilter();
            this._sslCheckBox.setSelected(this.isSSL(string4));
        }
    }

    private boolean isSSL(String string) {
        return string != null && string.toLowerCase().equals("ssl");
    }

    private void populateHostsPorts(SyASEServerProxy syASEServerProxy, String string, String string2) {
        this._hostComboBox.removeItemListener(this);
        this._hostTextField.getDocument().removeDocumentListener(this);
        this._hostTextField.removeKeyListener(this);
        this._portComboBox.removeItemListener(this);
        this._portTextField.getDocument().removeDocumentListener(this);
        this._portTextField.removeKeyListener(this);
        this._portComboBox.removeAllItems();
        this._hostComboBox.removeAllItems();
        if (syASEServerProxy != null) {
            SyInterfacesEntryProxy syInterfacesEntryProxy = syASEServerProxy.getEntry();
            List list = syInterfacesEntryProxy.getServices();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ServiceProxy serviceProxy = new ServiceProxy(iterator.next());
                PortItem portItem = new PortItem(serviceProxy, syASEServerProxy);
                HostItem hostItem = new HostItem(serviceProxy, syASEServerProxy);
                if (!serviceProxy.hasPort()) continue;
                this._hostComboBox.addItem(hostItem);
                this._portComboBox.addItem(portItem);
            }
            this.updateFilter(string == null ? syASEServerProxy.getHost() : string, string2 == null ? syASEServerProxy.getPort() : string2);
        }
        this._hostComboBox.addItemListener(this);
        this._hostTextField.getDocument().addDocumentListener(this);
        this._hostTextField.addKeyListener(this);
        this._portComboBox.addItemListener(this);
        this._portTextField.getDocument().addDocumentListener(this);
        this._portTextField.addKeyListener(this);
    }

    private boolean isAdHocServerName(String string) {
        return string != null && string.indexOf(PORT_SEP) > 0;
    }

    private void updateHostPort() {
        String string;
        Object object;
        String string2;
        String string3 = this._hostTextField.getText();
        String string4 = this._portTextField.getText();
        String string5 = string2 = this._serverNameTextField.getText();
        int n = string2.indexOf(RMI_PORT_SEP);
        boolean bl = n > 0;
        String string6 = null;
        if (bl) {
            string6 = string2.substring(n + RMI_PORT_SEP.length());
            string5 = string2 = string2.substring(0, n);
            try {
                Integer.valueOf(string6).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                string6 = null;
            }
        }
        boolean bl2 = (n = string2.lastIndexOf(PORT_SEP)) > 0;
        SyASEServerProxy syASEServerProxy = null;
        String string7 = null;
        String string8 = null;
        if (bl2) {
            string7 = string2.substring(0, n);
            string8 = string2.substring(n + PORT_SEP.length());
            try {
                Integer.valueOf(string8).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                string8 = null;
            }
            syASEServerProxy = this.getServerItem(string2, string7, string8);
        } else {
            syASEServerProxy = this.getServerItem(string2, null, null);
        }
        int n2 = this._serverComboBox.getSelectedIndex();
        if (n2 >= 0 && n2 < _connectedServers.size()) {
            object = _connectedServers.get(n2);
            string3 = ((ASEConnectionInfo)object).host;
            string4 = String.valueOf(((ASEConnectionInfo)object).port);
            this._encryptPasswordCheckBox.setSelected(((ASEConnectionInfo)object).getEncryptPassword());
            string = ((ASEConnectionInfo)object).getLanguage();
            String string9 = ((ASEConnectionInfo)object).getCharSet();
            String string10 = ((ASEConnectionInfo)object).getOtherParms();
            if (string != null) {
                this._language.setSelectedItem(string);
            } else {
                this._language.setSelectedIndex(0);
            }
            if (string9 != null) {
                this._characterSet.setSelectedItem(string9);
            } else {
                this._characterSet.setSelectedIndex(0);
            }
            this.updateAdvanced(string10);
        } else {
            this._language.setSelectedIndex(0);
            this._characterSet.setSelectedIndex(0);
            this.updateAdvanced(null);
        }
        object = "";
        string = "";
        if (syASEServerProxy != null) {
            this._sslCheckBox.setEnabled(false);
            this.populateHostsPorts(syASEServerProxy, bl2 ? string7 : string3, bl2 ? string8 : string4);
            this._serverComboBox.removeItemListener(this);
            this._serverComboBox.setSelectedItem(syASEServerProxy);
            this.updateServer();
            this._serverComboBox.addItemListener(this);
            string = syASEServerProxy.getPort();
            object = syASEServerProxy.getHost();
        } else {
            this._serverNameTextField.setText(string2);
            this._hostTextField.setText(string2);
            this._sslCheckBox.setEnabled(true);
            if (string7 != null && string7.length() > 0) {
                this._hostTextField.setText(string7);
                object = string7;
                if (string8 != null) {
                    this._portTextField.setText(string8);
                    string = string8;
                }
            }
        }
        if (bl) {
            this._serverNameTextField.setText(string5 + RMI_PORT_SEP);
            if (string6 != null) {
                this._serverNameTextField.setText(this._serverNameTextField.getText() + string6);
            }
        }
        if (syASEServerProxy != null) {
            this._serverNameTextField.setCaretPosition(this._serverNameTextField.getText().length());
        }
        if (string.length() == 0) {
            this._portTextField.setText("");
            if (string4.length() > 0) {
                this.updateFilter(string3, string4);
            }
        }
        this.updateServerInfo();
    }

    private void updateAdvanced(String string) {
        String string2 = this._advanced.getText();
        String string3 = string == null ? "" : string;
        this._advanced.setText(string3);
        if (!string2.equals(string3)) {
            if (string3.length() > 0) {
                this._tabbedPane.setTitleAt(1, _res.get("Advanced") + "*");
            } else {
                this._tabbedPane.setTitleAt(1, _res.get("Advanced"));
            }
        }
    }

    private void updateServer() {
        this.updateServer(null, -1);
    }

    private void updateServer(HostItem hostItem, int n) {
        String string = this._hostTextField.getText();
        String string2 = this._portTextField.getText();
        String string3 = this._serverNameTextField.getText();
        SyASEServerProxy syASEServerProxy = null;
        syASEServerProxy = hostItem == null ? this.getServerItem(string3, string, string2) : hostItem._server;
        this._sslCheckBox.setEnabled(syASEServerProxy == null);
        this.updateFilter(string, string2, n);
        if (syASEServerProxy == null) {
            String string4 = string + PORT_SEP + string2;
            if (string4.equals(PORT_SEP)) {
                string4 = "";
            }
            this._serverNameTextField.setText(string4);
        } else {
            if (n == -1) {
                this.populateHostsPorts(syASEServerProxy, string, string2);
            } else if (hostItem.isHost()) {
                this._portComboBox.setSelectedIndex(n);
            } else {
                this._hostComboBox.setSelectedIndex(n);
            }
            this._serverComboBox.setSelectedItem(syASEServerProxy);
            this._serverNameTextField.setText(syASEServerProxy.toString());
        }
        this.updateServerInfo();
    }

    private void updateServerInfo() {
        String string = this._hostTextField.getText();
        string = string.length() > 0 ? "<i>" + _res.get("HostName") + "</i>" + string : "";
        String string2 = this._portTextField.getText();
        string2 = string2.length() > 0 ? "<i>" + _res.get("PortNumber") + "</i>" + string2 : "";
        String string3 = this._sslCheckBox.isSelected() ? "<i>" + _res.get("FILTER") + "</i>" + "SSL" : "";
        this._serverInfoLabel.setText("<html>" + string + string2 + string3 + "</html>");
    }

    private void handleFindServer() {
        Object object;
        Object object2;
        Object object3;
        DiscoveryFilterProxy discoveryFilterProxy;
        boolean bl;
        ArrayList<DiscoverySettingProxy> arrayList;
        block12: {
            arrayList = new ArrayList<DiscoverySettingProxy>();
            bl = false;
            discoveryFilterProxy = null;
            try {
                object3 = new DiscoverySettingProxy();
                object2 = ((DiscoverySettingProxy)((Object)object3)).getDiscoverySettings();
                object = object2.iterator();
                while (object.hasNext()) {
                    arrayList.add(new DiscoverySettingProxy(object.next()));
                }
                discoveryFilterProxy = new DiscoveryFilterProxy();
                bl = discoveryFilterProxy.hasFilters();
            }
            catch (ReflectionProxyException reflectionProxyException) {
                if (!ASEDatabaseSource.dbgEnabled()) break block12;
                Dbg.printlnEx((Throwable)reflectionProxyException, (String)("Error getting discovery settings: " + ASEDatabaseSource.getDetails((Exception)((Object)reflectionProxyException))));
            }
        }
        object3 = new FindASEsDialog(this, arrayList.toArray(new DiscoverySettingProxy[arrayList.size()]), bl);
        if (((FindASEsDialog)object3).create()) {
            object2 = ((FindASEsDialog)object3).getASEHostInfo();
            object = ((ASEHostInformation)object2).rmiPort;
            if (object == null || ((String)object).equals(DEFAULT_RMI_PORT)) {
                this._serverNameTextField.setText(((FindASEsDialog)object3).getServerName());
            } else {
                this._serverNameTextField.setText(((FindASEsDialog)object3).getServerName() + RMI_PORT_SEP + (String)object);
            }
            this.updateHostPort();
        }
        if (((FindASEsDialog)object3).foundNoServers()) {
            boolean bl2;
            Object object4;
            object2 = _res.get("DISCOVERY_SETTINGS") + "\n" + ((FindASEsDialog)object3).getDiscoveryURLs("\n");
            object = "";
            String string = "";
            if (discoveryFilterProxy != null) {
                try {
                    List list = discoveryFilterProxy.getDiscoveryFilters();
                    object4 = list.iterator();
                    while (object4.hasNext()) {
                        DiscoveryFilterProxy discoveryFilterProxy2 = new DiscoveryFilterProxy(object4.next());
                        if (!discoveryFilterProxy2.isEnabled()) continue;
                        object = (String)object + string + discoveryFilterProxy2.getDisplayString();
                        string = "\n";
                    }
                }
                catch (ReflectionProxyException reflectionProxyException) {
                    // empty catch block
                }
            }
            boolean bl3 = bl2 = ((String)object).length() > 0;
            if (bl2) {
                object2 = (String)object2 + "\n\n" + _res.get("FILTERS") + "\n" + (String)object;
            }
            object4 = bl2 ? _res.get("ERR_NO_SERVERS_FOUND_OR_MATCH") : _res.get("ERR_NO_SERVERS_FOUND");
            DetailsErrorDialog.showDialog((Component)this.getParentWindow(), (String)_res.get("SERVER_DISCOVERY"), (String)object4, (String)object2, null);
        }
    }

    public static String getDetails(Exception exception) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(8192);
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        exception.printStackTrace(printStream);
        printStream.flush();
        printStream.close();
        try {
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = byteArrayOutputStream.toString();
        return string;
    }

    public static void migrateDiscoverySettings() throws ReflectionProxyException {
        ArrayList<OldDiscoverySetting> arrayList = ASEDatabaseSource.getSavedDiscoverySettings();
        if (arrayList != null) {
            DiscoverySettingProxy discoverySettingProxy = new DiscoverySettingProxy();
            boolean bl = discoverySettingProxy.hasDiscoverySettings();
            if (!bl) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                for (OldDiscoverySetting oldDiscoverySetting : arrayList) {
                    DiscoverySettingProxy discoverySettingProxy2 = new DiscoverySettingProxy(oldDiscoverySetting.service, oldDiscoverySetting.host, oldDiscoverySetting.port);
                    arrayList2.add(discoverySettingProxy2.getObject());
                }
                discoverySettingProxy.saveDiscoverySettings(arrayList2);
            }
            Preferences.remove(SAVE_PREFIX, SAVE_SERVER_DISCOVERY);
            Preferences.makePermanent();
        }
    }

    public static void migrateLDAPSetting() throws ReflectionProxyException {
        String string = Preferences.load(SAVE_PREFIX, SAVE_LDAP_INCLUDE);
        String string2 = Preferences.load(SAVE_PREFIX, SAVE_LDAP_TIMEOUT);
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0) {
            boolean bl = Boolean.valueOf(string);
            int n = Integer.parseInt(string2);
            LDAPSettingProxy lDAPSettingProxy = new LDAPSettingProxy(bl, n);
            lDAPSettingProxy.save();
            Preferences.remove(SAVE_PREFIX, SAVE_LDAP_INCLUDE);
            Preferences.remove(SAVE_PREFIX, SAVE_LDAP_TIMEOUT);
            Preferences.makePermanent();
        }
    }

    private void handleSettings() {
        try {
            ASEDatabaseSource.migrateDiscoverySettings();
            ASEDatabaseSource.migrateLDAPSetting();
            SettingsDialogProxy settingsDialogProxy = new SettingsDialogProxy(this.getParentDialog());
            settingsDialogProxy.create();
            if (settingsDialogProxy.isLDAPChanged() || settingsDialogProxy.isNumSavedServersChanged() || settingsDialogProxy.isClearServersSelected()) {
                if (settingsDialogProxy.isClearServersSelected()) {
                    this.clearConnectedServers();
                }
                this.setInitialValues();
            }
            this.updateFindServerButton();
        }
        catch (ReflectionProxyException reflectionProxyException) {
            this.displayInstallError(reflectionProxyException);
        }
    }

    private void displayInstallError(ReflectionProxyException reflectionProxyException) {
        String string = reflectionProxyException.getMessage();
        DetailsErrorDialog.showDetailsErrorDialog((Dialog)this.getParentDialog(), (String)_res.get("Error"), (String)_res.get("DamagedInstall"), (String)string, null);
    }

    public static String getHostAndPort(String string, String string2) {
        int n = -1;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ASEDatabaseSource.getHostAndPort(string, n);
    }

    public static String getHostAndPort(String string, int n) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string2 + string;
            if (n >= 0) {
                string2 = string2 + PORT_SEP + n;
            }
        }
        return string2;
    }

    public static String getIPAndPort(String string, String string2) {
        if (_dsUtils != null) {
            try {
                return _dsUtils.getIPAndPort(string, string2);
            }
            catch (ReflectionProxyException reflectionProxyException) {
                return ASEDatabaseSource.getHostAndPort(string, string2);
            }
        }
        return ASEDatabaseSource.getHostAndPort(string, string2);
    }

    public static String getSavedAgentPortNumber() {
        String string = Preferences.load(SAVE_PREFIX, SAVE_UAF_PORT_NUMBER);
        return string;
    }

    private static ArrayList<OldDiscoverySetting> getSavedDiscoverySettings() {
        String string = Preferences.load(SAVE_PREFIX, SAVE_SERVER_DISCOVERY);
        ArrayList<OldDiscoverySetting> arrayList = null;
        if (string != null && string.length() > 0) {
            arrayList = new ArrayList<OldDiscoverySetting>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 0) {
                arrayList.add(new OldDiscoverySetting());
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(new OldDiscoverySetting(stringTokenizer.nextToken()));
                }
            }
        }
        return arrayList;
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void notifyCancelClicked() {
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
        MyReflectionProxy._classLoader = classLoader;
    }

    ClassLoader getClassLoader() {
        return this._classLoader;
    }

    static {
        String string = ASEDatabaseSource.getSavedAgentPortNumber();
        if (string != null && !string.equals("0")) {
            DEFAULT_RMI_PORT = string;
        }
        _connectedServers = new Vector();
        _dsUtils = null;
        SEPARATOR = "";
    }

    class PortItem
    extends HostItem {
        PortItem(ServiceProxy serviceProxy, SyASEServerProxy syASEServerProxy) {
            super(serviceProxy, syASEServerProxy);
        }

        @Override
        public String toString() {
            return this._service.getPort();
        }

        @Override
        boolean isHost() {
            return false;
        }
    }

    class HostItem {
        ServiceProxy _service;
        SyASEServerProxy _server;

        HostItem(ServiceProxy serviceProxy, SyASEServerProxy syASEServerProxy) {
            this._service = serviceProxy;
            this._server = syASEServerProxy;
        }

        public String toString() {
            return this._service.getHost();
        }

        boolean isHost() {
            return true;
        }
    }

    class ComboBoxListener
    implements ActionListener {
        JComboBox _comboBox;
        Object _item;

        ComboBoxListener(JComboBox jComboBox) {
            this._comboBox = jComboBox;
            this._item = this._comboBox.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this._comboBox.getSelectedItem();
            if (object instanceof SyASEServerProxy) {
                if (SEPARATOR.equals(object)) {
                    this._comboBox.setSelectedItem(this._item);
                } else {
                    this._item = object;
                }
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        JSeparator _sep;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this._sep = new JSeparator(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = string = object == null ? "" : object.toString();
            if (SEPARATOR.equals(string)) {
                return this._sep;
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setFont(jList.getFont());
            this.setText(string);
            return this;
        }
    }

    static class ConstraintDocumentProxy
    extends MyReflectionProxy {
        ConstraintDocumentProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.ui.ConstraintDocument", null, null);
        }
    }

    static class NumericsOnlyDocumentProxy
    extends MyReflectionProxy {
        NumericsOnlyDocumentProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.ui.NumericsOnlyDocument", null, null);
        }
    }

    static class DiscoveryFilterProxy
    extends MyReflectionProxy {
        DiscoveryFilterProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.uaf.DiscoveryFilter", null, null);
        }

        DiscoveryFilterProxy(Object object) {
            super(object);
        }

        boolean isEnabled() {
            return this.callBooleanMethod("enabled", false);
        }

        String getDisplayString() {
            try {
                String string = this.invokeStringMethod("getDisplayString", null, null);
                return string;
            }
            catch (ReflectionProxyException reflectionProxyException) {
                return null;
            }
        }

        List getDiscoveryFilters() throws ReflectionProxyException {
            return (List)this.invokeMethod("getDiscoveryFilters", null, null);
        }

        boolean hasFilters() {
            return this.callBooleanMethod("hasDiscoveryFilters", false);
        }
    }

    static class SettingsProxy
    extends MyReflectionProxy {
        SettingsProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.Settings");
        }

        boolean getEnableSaveServers() {
            return this.callBooleanMethod("getEnableSaveServers", true);
        }

        int getNumberOfSavedServers() {
            try {
                Integer n = (Integer)this.invokeMethod("getNumberOfSavedServers", null, null);
                return n;
            }
            catch (ReflectionProxyException reflectionProxyException) {
                return 1;
            }
        }
    }

    static class SettingsDialogProxy
    extends MyReflectionProxy {
        SettingsDialogProxy(JDialog jDialog) throws ReflectionProxyException {
            super("com.sybase.util.ds.ui.SettingsDialog", new Class[]{JDialog.class}, new Object[]{jDialog});
        }

        void create() {
            try {
                this.invokeMethod("create", null, null);
            }
            catch (ReflectionProxyException reflectionProxyException) {
                // empty catch block
            }
        }

        boolean isLDAPChanged() {
            return this.callBooleanMethod("isLDAPChanged", false);
        }

        boolean isNumSavedServersChanged() {
            return this.callBooleanMethod("isNumSavedServersChanged", false);
        }

        boolean isClearServersSelected() {
            return this.callBooleanMethod("isClearServersSelected", false);
        }
    }

    static class LDAPSettingProxy
    extends MyReflectionProxy {
        LDAPSettingProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.ldap.LDAPSetting");
        }

        LDAPSettingProxy(boolean bl, int n) throws ReflectionProxyException {
            super("com.sybase.util.ds.ldap.LDAPSetting", new Class[]{Boolean.class, Integer.class}, new Object[]{bl, n});
        }

        LDAPSettingProxy(Object object) {
            super(object);
        }

        LDAPSettingProxy getLDAPSetting() throws ReflectionProxyException {
            return new LDAPSettingProxy(this.invokeMethod("getLDAPSetting", null, null));
        }

        boolean getInclude() {
            return this.callBooleanMethod("includeLDAP", true);
        }

        int getTimeout() {
            try {
                Integer n = (Integer)this.getFieldValue("timeout");
                return n;
            }
            catch (ReflectionProxyException reflectionProxyException) {
                return 180;
            }
        }

        void save() throws ReflectionProxyException {
            this.invokeMethod("save", null, null);
        }
    }

    static class UtilsProxy
    extends MyReflectionProxy {
        UtilsProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.Utils");
        }

        String getSybasePath() throws ReflectionProxyException {
            return (String)this.invokeMethod("getSybasePath", null, null);
        }

        String getIPAndPort(String string, String string2) throws ReflectionProxyException {
            return (String)this.invokeMethod("getIPAndPort", new Class[]{String.class, String.class}, new Object[]{string, string2});
        }

        boolean getEnableServerDiscovery() {
            return this.callBooleanMethod("getEnableServerDiscovery", false);
        }
    }

    static class LibtclDriverProxy
    extends MyReflectionProxy {
        LibtclDriverProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.ldap.LibtclDriver");
        }

        Vector getLDAPServers() throws ReflectionProxyException {
            return (Vector)this.invokeMethod("getLDAPServers", null, null);
        }
    }

    static class DirectoryServiceHelperProxy
    extends MyReflectionProxy {
        DirectoryServiceHelperProxy() throws ReflectionProxyException {
            super("com.sybase.util.ds.DirectoryServiceHelper");
        }

        void initInterfacesDriver() throws ReflectionProxyException {
            this.invokeMethod("initInterfacesDriver", null, null);
        }

        void initLibtclDriver() throws ReflectionProxyException {
            this.invokeMethod("initLibtclDriver", null, null);
        }

        Enumeration entriesFromInterfaces() throws ReflectionProxyException {
            return (Enumeration)this.invokeMethod("getEntriesFromInterfacesFile", null, null);
        }

        Enumeration entriesFromLDAP(int n) throws ReflectionProxyException {
            return (Enumeration)this.invokeMethod("getEntriesFromLDAP", new Class[]{Integer.class}, new Object[]{n});
        }
    }

    static interface ConnectionStringBuilder {
        public void addParm(String var1, String var2);
    }
}

