/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.logon;

import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.ase.logon.SyUAFASEEntryProxy;
import java.text.Collator;

public class ASEHostInformation
implements Comparable {
    public SyUAFASEEntryProxy entry;
    public String name;
    public String host;
    public int port;
    public String platform;
    public String os;
    public String status;
    public String version;
    public String versionString;
    public boolean isClientName;
    public String rmiPort;
    private Collator _collator = Collator.getInstance();

    public ASEHostInformation(SyUAFASEEntryProxy syUAFASEEntryProxy) {
        this.host = syUAFASEEntryProxy.getHostName();
        this.port = syUAFASEEntryProxy.getPortNumber();
        String string = String.valueOf(this.port);
        String string2 = ASEDatabaseSource.getClientSideServerName(this.host, string);
        this.isClientName = string2 != null;
        this.name = !this.isClientName ? syUAFASEEntryProxy.getName() : string2;
        this.platform = syUAFASEEntryProxy.getPlatform();
        this.os = syUAFASEEntryProxy.getOperatingSystem();
        this.status = syUAFASEEntryProxy.getStatus();
        this.version = syUAFASEEntryProxy.getVersion();
        this.versionString = syUAFASEEntryProxy.getVersionString();
        this.rmiPort = syUAFASEEntryProxy.getRMIPort();
    }

    public String toString() {
        return this.name;
    }

    public int compareTo(Object object) {
        ASEHostInformation aSEHostInformation = (ASEHostInformation)object;
        int n = this._collator.compare(this.name, aSEHostInformation.name);
        if (n == 0 && (n = this._collator.compare(this.host, aSEHostInformation.host)) == 0) {
            n = this.port < aSEHostInformation.port ? -1 : (this.port == aSEHostInformation.port ? 0 : 1);
        }
        return n;
    }
}

