/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.logon;

import com.sybase.asa.logon.BrowseDSNDialog;
import com.sybase.asa.logon.LogonImages;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.ase.logon.ASEHostInformation;
import com.sybase.ase.logon.ASEResourcesBase;
import com.sybase.ase.logon.BasePanel;
import com.sybase.ase.logon.DiscoverySettingProxy;
import com.sybase.ase.logon.FindingASEsDialog;
import com.sybase.ase.logon.SyUAFASEEntryProxy;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

class FindASEsDialog
extends JDialog
implements ActionListener {
    private static final String ESCAPE_ACTION = "Escape";
    private static final String TAB_ACTION = "Tab";
    private static final String BACKTAB_ACTION = "BackTab";
    private DiscoverySettingProxy[] _settings;
    private boolean _hasFilters;
    private boolean _retcode;
    private boolean _foundNoServers = false;
    private String _serverName;
    private ASEHostInformation _ASEHostInfo = null;
    private JTable _serverList = null;
    private SybButton _ok = null;
    private SybButton _cancel = null;
    private SybButton _help = null;

    FindASEsDialog(ASEDatabaseSource aSEDatabaseSource, DiscoverySettingProxy[] discoverySettingProxyArray, boolean bl) {
        super((Window)aSEDatabaseSource.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL);
        this._settings = discoverySettingProxyArray;
        this._hasFilters = bl;
    }

    boolean create() {
        this._retcode = false;
        this.setVisible(this.createUI());
        this.destroyUI();
        return this._retcode;
    }

    boolean foundNoServers() {
        return this._foundNoServers;
    }

    String getServerName() {
        return this._serverName;
    }

    ASEHostInformation getASEHostInfo() {
        return this._ASEHostInfo;
    }

    private boolean createUI() {
        ASEResourcesBase aSEResourcesBase = ASEDatabaseSource._res;
        this._serverList = new JTable(new MyTableModel()){

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (component instanceof JComponent) {
                    JComponent jComponent = (JComponent)component;
                    if (n2 == 1) {
                        MyTableModel myTableModel = (MyTableModel)this.getModel();
                        ASEHostInformation aSEHostInformation = myTableModel.getRowObject(n);
                        jComponent.setToolTipText(aSEHostInformation.versionString);
                    } else {
                        jComponent.setToolTipText((String)this.getValueAt(n, n2));
                    }
                }
                return component;
            }
        };
        this._serverList.getTableHeader().setReorderingAllowed(false);
        this._serverList.setShowVerticalLines(false);
        this._serverList.setShowHorizontalLines(false);
        this._serverList.setPreferredScrollableViewportSize(new Dimension(600, (this._serverList.getRowHeight() + this._serverList.getRowMargin()) * 8));
        CellRenderer cellRenderer = new CellRenderer();
        this._serverList.setDefaultRenderer(Object.class, cellRenderer);
        this._serverList.setSelectionMode(0);
        boolean bl = this.fillServerList();
        if (!bl) {
            return false;
        }
        BrowseDSNDialog.setInitialColumnWidths(this._serverList);
        JScrollPane jScrollPane = new JScrollPane(this._serverList);
        jScrollPane.getViewport().setBackground(this._serverList.getBackground());
        this._serverList.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindASEsDialog.this.handleOK();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this._serverList.registerKeyboardAction(this, TAB_ACTION, KeyStroke.getKeyStroke(9, 0), 1);
        this._serverList.registerKeyboardAction(this, BACKTAB_ACTION, KeyStroke.getKeyStroke(9, 1), 1);
        this._serverList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    FindASEsDialog.this.handleOK();
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(true);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBackground(SystemColor.window);
        jPanel.add(jScrollPane);
        this._ok = new SybButton(aSEResourcesBase.get("OK"));
        this._ok.addActionListener((ActionListener)this);
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this._cancel = new SybButton(aSEResourcesBase.get("Cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._help = new SybButton(aSEResourcesBase.get("Help"));
        this._help.addActionListener((ActionListener)this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_ACTION, KeyStroke.getKeyStroke(27, 0, false), 2);
        DialogUtils.makeComponentsSameWidth((JComponent[])new JComponent[]{this._ok, this._cancel});
        BasePanel basePanel = new BasePanel("");
        basePanel.add(jPanel, 0, 0, 4, 1, 1.0, 1.0, 17, 1, BasePanel.INSETS_NONE, 0, 0);
        basePanel.add(Box.createHorizontalGlue(), 0, 1, 1, 1, 1.0, 0.0, 17, 2, BasePanel.INSETS_NONE, 0, 0);
        basePanel.add((Component)this._ok, 1, 1, 1, 1, 0.0, 0.0, 12, 0, BasePanel.INSETS, 0, 0);
        basePanel.add((Component)this._cancel, 2, 1, 1, 1, 0.0, 0.0, 12, 0, BasePanel.INSETS, 0, 0);
        this.getContentPane().add(basePanel);
        String string = aSEResourcesBase.getFormatted("FIND_SERVERS", this.getDiscoveryURLs(", "));
        if (this._hasFilters) {
            string = string + " " + aSEResourcesBase.get("FILTERS_APPLIED");
        }
        this.setTitle(string);
        this.pack();
        this.setResizable(true);
        this.setLocationRelativeTo(this.getParent());
        return true;
    }

    String getDiscoveryURLs(String string) {
        String string2 = "";
        String string3 = "";
        for (int i = 0; i < this._settings.length; ++i) {
            string3 = string3 + string2 + this._settings[i].getURL();
            string2 = string;
        }
        return string3;
    }

    private void destroyUI() {
        this.getRootPane().setDefaultButton(null);
        if (this._ok != null) {
            this._ok.removeActionListener((ActionListener)this);
            this._ok.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0, false));
            this._ok = null;
        }
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        if (this._cancel != null) {
            this._cancel.removeActionListener((ActionListener)this);
            this._cancel = null;
        }
        DialogUtils.removeComponents((Container)this);
    }

    private boolean fillServerList() {
        FindingASEsDialog findingASEsDialog = new FindingASEsDialog((Dialog)((JDialog)this.getParent()), this._settings, true);
        if (!findingASEsDialog.hasEntries()) {
            this._foundNoServers = findingASEsDialog.getDiscovered();
            return false;
        }
        TreeSet<SyUAFASEEntryProxy> treeSet = FindingASEsDialog._entries;
        Object[] objectArray = new ASEHostInformation[treeSet.size()];
        int n = 0;
        for (SyUAFASEEntryProxy syUAFASEEntryProxy : treeSet) {
            objectArray[n] = new ASEHostInformation(syUAFASEEntryProxy);
            ++n;
        }
        Arrays.sort(objectArray);
        ((MyTableModel)this._serverList.getModel()).setDataArray(objectArray);
        this._serverList.requestFocus();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (actionEvent.getActionCommand().equals(TAB_ACTION)) {
            this._ok.requestFocus();
        } else if (actionEvent.getActionCommand().equals(BACKTAB_ACTION)) {
            this._cancel.requestFocus();
        } else if (object == this._ok) {
            this.handleOK();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_ACTION)) {
            this.handleCancel();
        }
    }

    private void handleOK() {
        this.setVisible(false);
        int n = this._serverList.getSelectedRow();
        if (n != -1) {
            MyTableModel myTableModel = (MyTableModel)this._serverList.getModel();
            ASEHostInformation aSEHostInformation = myTableModel.getRowObject(n);
            this._serverName = aSEHostInformation.isClientName ? aSEHostInformation.name : ASEDatabaseSource.getHostAndPort(aSEHostInformation.host, aSEHostInformation.port);
            this._ASEHostInfo = aSEHostInformation;
            this._retcode = true;
        } else {
            this._retcode = false;
        }
    }

    private void handleCancel() {
        this._retcode = false;
        this.setVisible(false);
    }

    static class MyTableModel
    extends AbstractTableModel {
        private String[] _columnNames;
        private Object[] _data;

        MyTableModel() {
            ASEResourcesBase aSEResourcesBase = ASEDatabaseSource._res;
            this._data = new ASEHostInformation[0];
            this._columnNames = new String[]{aSEResourcesBase.get("getName"), aSEResourcesBase.get("getVersionNumber"), aSEResourcesBase.get("TABLE_HOST_PORT_LABEL"), aSEResourcesBase.get("TABLE_PLATFORM_OS_LABEL")};
        }

        void setDataArray(Object[] objectArray) {
            this._data = objectArray;
            this.fireTableChanged(new TableModelEvent(this));
        }

        ASEHostInformation getRowObject(int n) {
            return (ASEHostInformation)this._data[n];
        }

        void add(ASEHostInformation aSEHostInformation) {
            int n = this._data.length;
            Object[] objectArray = new Object[n + 1];
            System.arraycopy(this._data, 0, objectArray, 0, n);
            objectArray[n] = aSEHostInformation;
            Arrays.sort(objectArray);
            this._data = objectArray;
            this.fireTableChanged(new TableModelEvent(this));
        }

        int find(ASEHostInformation aSEHostInformation) {
            int n = -1;
            for (int i = 0; i < this._data.length; ++i) {
                ASEHostInformation aSEHostInformation2 = (ASEHostInformation)this._data[i];
                if (aSEHostInformation2 != aSEHostInformation && (!aSEHostInformation2.host.equalsIgnoreCase(aSEHostInformation.host) || aSEHostInformation2.port != aSEHostInformation.port)) continue;
                n = i;
                break;
            }
            return n;
        }

        void remove(int n) {
            int n2 = this._data.length;
            Object[] objectArray = new Object[n2 - 1];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (i == n) continue;
                objectArray[n3++] = this._data[i];
            }
            this._data = objectArray;
            this.fireTableRowsDeleted(n, n);
        }

        @Override
        public String getColumnName(int n) {
            return this._columnNames[n];
        }

        @Override
        public int getRowCount() {
            return this._data.length;
        }

        @Override
        public int getColumnCount() {
            return this._columnNames.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            String string;
            ASEHostInformation aSEHostInformation = (ASEHostInformation)this._data[n];
            switch (n2) {
                case 0: {
                    string = aSEHostInformation.name;
                    break;
                }
                case 1: {
                    string = aSEHostInformation.version;
                    break;
                }
                case 2: {
                    string = aSEHostInformation.host + ":" + Integer.toString(aSEHostInformation.port);
                    break;
                }
                case 3: {
                    string = aSEHostInformation.platform != null && aSEHostInformation.platform.length() > 0 ? aSEHostInformation.platform + "/" + aSEHostInformation.os : "";
                    break;
                }
                case 4: {
                    string = aSEHostInformation.status;
                    break;
                }
                default: {
                    string = null;
                }
            }
            return string;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    static class CellRenderer
    extends DefaultTableCellRenderer {
        private static final ImageIcon ASE_ICON = new ImageIcon(LogonImages.getAse());

        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setIcon(ASE_ICON);
            } else {
                this.setIcon(null);
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

