/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.ase.logon;

import com.ianywhere.errorreporting.ExceptionHandler;
import com.sybase.asa.logon.LogonImages;
import com.sybase.ase.logon.ASEDatabaseSource;
import com.sybase.ase.logon.ASEResourcesBase;
import com.sybase.ase.logon.DiscoverySettingProxy;
import com.sybase.ase.logon.SyUAFASEEntryProxy;
import com.sybase.ase.logon.SyUAFProxy;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.ReflectionProxyException;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ImageObserver;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class FindingASEsDialog
extends JDialog
implements Runnable,
ActionListener {
    public static TreeSet<SyUAFASEEntryProxy> _entries = new TreeSet();
    private boolean _hasEntries;
    private boolean _discovered;
    private SybButton _cancelFinding;
    private SybLabel _label;
    private DiscoverySettingProxy[] _settings;
    private boolean _filterServers;

    public FindingASEsDialog(Dialog dialog, DiscoverySettingProxy[] discoverySettingProxyArray, boolean bl) {
        super(dialog, true);
        this._settings = discoverySettingProxyArray;
        this._filterServers = bl;
        _entries.clear();
        this.createGUI();
        this.setLocationRelativeTo(dialog);
        this._hasEntries = false;
        this._discovered = false;
        Thread thread = new Thread(this);
        thread.start();
        if (!this._hasEntries) {
            this.setVisible(true);
        }
        this.destroyGUI();
    }

    public boolean hasEntries() {
        return this._hasEntries;
    }

    public boolean getDiscovered() {
        return this._discovered;
    }

    private void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ImageIcon imageIcon = new ImageIcon(LogonImages.getFindServer());
        ASEResourcesBase aSEResourcesBase = ASEResourcesBase.getBundle();
        this._label = new SybLabel(aSEResourcesBase.get("FINDING_SERVERS"));
        this._label.setIcon((Icon)imageIcon);
        this._label.setIconTextGap(10);
        imageIcon.setImageObserver((ImageObserver)this._label);
        jPanel.add((Component)this._label);
        jPanel.add(Box.createVerticalStrut(5));
        JPanel jPanel2 = new JPanel();
        this._cancelFinding = new SybButton(aSEResourcesBase.get("Cancel"));
        jPanel2.add((Component)this._cancelFinding);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        this._cancelFinding.addActionListener((ActionListener)this);
        this.setTitle(aSEResourcesBase.get("Connect"));
        this.getContentPane().add(jPanel);
        this.pack();
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this._cancelFinding) {
            this._discovered = false;
            this.setVisible(false);
        }
    }

    private void destroyGUI() {
        this._cancelFinding.removeActionListener((ActionListener)this);
        this._cancelFinding = null;
        DialogUtils.removeComponents((Container)this);
    }

    @Override
    public void run() {
        for (int i = 0; i < this._settings.length; ++i) {
            Object object;
            Object object2;
            DiscoverySettingProxy discoverySettingProxy = null;
            try {
                discoverySettingProxy = this._settings[i];
                SyUAFProxy syUAFProxy = new SyUAFProxy();
                syUAFProxy.init(discoverySettingProxy.getService(), discoverySettingProxy.getHost(), discoverySettingProxy.getPort());
                syUAFProxy.initAgent();
                object2 = syUAFProxy.discover(this._filterServers);
                this._discovered = true;
                object = object2.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    SyUAFASEEntryProxy syUAFASEEntryProxy = new SyUAFASEEntryProxy(e);
                    if (!syUAFASEEntryProxy.getStatus().equalsIgnoreCase("running") && !syUAFASEEntryProxy.isRunning()) continue;
                    _entries.add(syUAFASEEntryProxy);
                }
                continue;
            }
            catch (ReflectionProxyException reflectionProxyException) {
                object2 = ASEResourcesBase.getBundle();
                object = ASEDatabaseSource.getDetails((Exception)((Object)reflectionProxyException));
                DetailsErrorDialog.showDetailsErrorDialog((Dialog)((JDialog)this.getParent()), (String)(((ASEResourcesBase)object2).get("SERVER_DISCOVERY") + " - " + discoverySettingProxy.getURL()), (String)((ASEResourcesBase)object2).getFormatted("ERR_DISCOVERY_FAILED", discoverySettingProxy.getURL()), (String)object, null);
                continue;
            }
            catch (Exception exception) {
                ExceptionHandler.handleException((Throwable)exception);
            }
        }
        this._hasEntries = _entries.size() > 0;
        this.setVisible(false);
    }
}

