/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbcspy;

import com.sybase.jdbcspy.JSBlob;
import com.sybase.jdbcspy.JSCallableStatement;
import com.sybase.jdbcspy.JSClob;
import com.sybase.jdbcspy.JSConnection;
import com.sybase.jdbcspy.JSDatabaseMetaData;
import com.sybase.jdbcspy.JSPreparedStatement;
import com.sybase.jdbcspy.JSResultSet;
import com.sybase.jdbcspy.JSResultSetMetaData;
import com.sybase.jdbcspy.JSStatement;
import com.sybase.util.Dbg;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class JSBase {
    private static Writer _log = null;
    private static boolean _echoToConsole = false;
    private static int _delay = 0;
    private static boolean _showStackTrace = false;
    private static boolean _showThread = false;
    private static boolean _hideZeroTimeCalls = false;
    private static SimpleDateFormat _formatter = new SimpleDateFormat("HH:mm:ss");
    protected Object _passthru = null;
    static final ArgumentValueLookup[] _argLookupTable = new ArgumentValueLookup[]{new ArgumentValueLookup(1003, "TYPE_FORWARD_ONLY"), new ArgumentValueLookup(1004, "TYPE_SCROLL_INSENSITIVE"), new ArgumentValueLookup(1005, "TYPE_SCROLL_SENSITIVE"), new ArgumentValueLookup(1007, "CONCUR_READ_ONLY"), new ArgumentValueLookup(1008, "CONCUR_UPDATABLE")};

    public static boolean isActive() {
        return _log != null || _echoToConsole || _delay != 0;
    }

    protected JSBase(Object object) {
        this._passthru = object;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        InvocationInfo invocationInfo = new InvocationInfo(method, objectArray);
        try {
            object2 = method.invoke(this._passthru, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            invocationInfo.print(object2);
            if (_delay == 0) return this.wrapObject(object2);
            try {
                Thread.sleep(_delay);
                return this.wrapObject(object2);
            }
            catch (InterruptedException interruptedException) {}
            return this.wrapObject(object2);
            catch (IllegalArgumentException illegalArgumentException) {
                invocationInfo.print(object2);
                if (_delay == 0) return this.wrapObject(object2);
                try {
                    Thread.sleep(_delay);
                    return this.wrapObject(object2);
                }
                catch (InterruptedException interruptedException) {}
                return this.wrapObject(object2);
                catch (InvocationTargetException invocationTargetException) {
                    try {
                        invocationInfo.setThrowable(invocationTargetException.getCause());
                        throw invocationTargetException.getCause();
                        catch (Throwable throwable) {
                            invocationInfo.setThrowable(throwable);
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        invocationInfo.print(object2);
                        if (_delay == 0) throw throwable;
                        try {
                            Thread.sleep(_delay);
                            throw throwable;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
        }
        invocationInfo.print(object2);
        if (_delay == 0) return this.wrapObject(object2);
        try {
            Thread.sleep(_delay);
            return this.wrapObject(object2);
        }
        catch (InterruptedException interruptedException) {}
        return this.wrapObject(object2);
    }

    protected Object wrapObject(Object object) {
        if (object != null) {
            if (object instanceof DatabaseMetaData) {
                object = JSDatabaseMetaData.newInstance((DatabaseMetaData)object);
            } else if (object instanceof ResultSetMetaData) {
                object = JSResultSetMetaData.newInstance((ResultSetMetaData)object);
            } else if (object instanceof PreparedStatement) {
                object = JSPreparedStatement.newInstance((PreparedStatement)object);
            } else if (object instanceof Statement) {
                object = JSStatement.newInstance((Statement)object);
            } else if (object instanceof ResultSet) {
                object = JSResultSet.newInstance((ResultSet)object);
            } else if (object instanceof Connection) {
                object = JSConnection.newInstance((Connection)object);
            } else if (object instanceof CallableStatement) {
                object = JSCallableStatement.newInstance((CallableStatement)object);
            } else if (object instanceof Blob) {
                object = JSBlob.newInstance((Blob)object);
            } else if (object instanceof Clob) {
                object = JSClob.newInstance((Clob)object);
            }
        }
        return object;
    }

    class InvocationInfo {
        private String _className;
        private String _methodName;
        private String _signature;
        private Class _returnType;
        private Throwable _throwable = null;
        private Object[] _args;
        private long _startTime;
        private StackTraceElement[] _stackTrace;

        InvocationInfo(Method method, Object ... objectArray) {
            this._args = objectArray;
            this._startTime = System.currentTimeMillis();
            this._className = method.getDeclaringClass().getName();
            this._methodName = method.getName();
            this._returnType = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < classArray.length; ++i) {
                String string;
                int n;
                if (i > 0) {
                    stringBuilder.append(',');
                }
                if ((n = (string = classArray[i].getName()).lastIndexOf(".")) == -1) {
                    stringBuilder.append(string);
                    continue;
                }
                stringBuilder.append(string.substring(n + 1));
            }
            this._signature = stringBuilder.toString();
            if (_showStackTrace) {
                this._stackTrace = Thread.currentThread().getStackTrace();
            }
        }

        InvocationInfo(Object ... objectArray) {
            this._args = objectArray;
            this._startTime = System.currentTimeMillis();
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[3];
            this._className = stackTraceElement.getClassName();
            this._methodName = stackTraceElement.getMethodName();
            this._returnType = null;
            if (_showStackTrace) {
                this._stackTrace = stackTraceElementArray;
            }
        }

        void setThrowable(Throwable throwable) {
            this._throwable = throwable;
        }

        synchronized void print(Object object) {
            int n;
            String string = "  ";
            if (this._className.equals("java.lang.Object")) {
                return;
            }
            if (_log == null && !_echoToConsole) {
                return;
            }
            long l = System.currentTimeMillis();
            if (l - this._startTime == 0L && _hideZeroTimeCalls) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            stringBuilder.append(_formatter.format(new Date(l)));
            stringBuilder.append(' ');
            stringBuilder.append(this._className);
            stringBuilder.append('.');
            stringBuilder.append(this._methodName);
            stringBuilder.append('(');
            if (this._signature != null) {
                stringBuilder.append(this._signature);
            } else if (this._args != null && this._args.length > 0) {
                stringBuilder.append("...");
            }
            stringBuilder.append(')');
            if (_showThread) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                stringBuilder.append("Thread: ");
                stringBuilder.append(Thread.currentThread().getName());
            }
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append("This: ");
            stringBuilder.append(Dbg.getSignature((Object)JSBase.this._passthru));
            if (this._args != null && this._args.length > 0) {
                for (n = 0; n < this._args.length; ++n) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string);
                    stringBuilder.append("[");
                    stringBuilder.append(Integer.toString(n));
                    stringBuilder.append("]=");
                    this.printArg(stringBuilder, this._args[n], n);
                }
            }
            stringBuilder.append(string2);
            stringBuilder.append(string);
            stringBuilder.append("Execution time: " + (l - this._startTime) + " ms");
            if (this._throwable != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                if (this._throwable instanceof RuntimeException) {
                    stringBuilder.append("Threw unchecked exception: ");
                } else {
                    stringBuilder.append("Threw exception: ");
                }
                this.printException(stringBuilder, this._throwable);
                for (Throwable throwable = this._throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
                    stringBuilder.append(string2);
                    stringBuilder.append(string);
                    stringBuilder.append("Caused by: ");
                    this.printException(stringBuilder, throwable);
                }
            } else if (this._returnType != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                stringBuilder.append("Returned: ");
                if (object == null) {
                    stringBuilder.append("null");
                } else if (object instanceof Boolean || object instanceof Number) {
                    stringBuilder.append(object);
                } else if (object instanceof String) {
                    stringBuilder.append('\"');
                    stringBuilder.append(object);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append(Dbg.getSignature((Object)object));
                }
            }
            if (this._stackTrace != null) {
                stringBuilder.append(string2);
                stringBuilder.append(string);
                stringBuilder.append("Stack Trace:");
                stringBuilder.append(string2);
                for (n = 4; n < this._stackTrace.length; ++n) {
                    stringBuilder.append(string);
                    stringBuilder.append(string);
                    stringBuilder.append(this._stackTrace[n].getClassName());
                    stringBuilder.append('.');
                    stringBuilder.append(this._stackTrace[n].getMethodName());
                    if (this._stackTrace[n].getFileName() != null) {
                        stringBuilder.append('(');
                        stringBuilder.append(this._stackTrace[n].getFileName());
                        stringBuilder.append(':');
                        stringBuilder.append(this._stackTrace[n].getLineNumber());
                        stringBuilder.append(')');
                    }
                    stringBuilder.append(string2);
                }
            }
            stringBuilder.append(string2);
            stringBuilder.append(string2);
            if (_log != null) {
                try {
                    _log.write(stringBuilder.toString());
                    _log.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (_echoToConsole) {
                System.out.println(stringBuilder.toString());
            }
            this._args = null;
            this._throwable = null;
            this._stackTrace = null;
        }

        private void printException(StringBuilder stringBuilder, Throwable throwable) {
            String string = System.getProperty("line.separator");
            stringBuilder.append(throwable.getClass().getName());
            stringBuilder.append(string);
            stringBuilder.append("    Message=\"" + throwable.getLocalizedMessage() + "\"");
            if (throwable instanceof SQLException) {
                SQLException sQLException = (SQLException)throwable;
                stringBuilder.append(string);
                stringBuilder.append("    Error code=" + sQLException.getErrorCode());
                stringBuilder.append(string);
                stringBuilder.append("    SQLState=");
                String string2 = sQLException.getSQLState();
                if (string2 == null) {
                    stringBuilder.append("null");
                } else {
                    stringBuilder.append('\"');
                    stringBuilder.append(string2);
                    stringBuilder.append('\"');
                }
            }
        }

        private void printArg(StringBuilder stringBuilder, Object object, int n) {
            if (object == null) {
                stringBuilder.append("null");
                return;
            }
            if (object instanceof String) {
                stringBuilder.append('\"');
                stringBuilder.append((String)object);
                stringBuilder.append('\"');
                return;
            }
            if (object instanceof Object[]) {
                stringBuilder.append(Arrays.toString((Object[])object));
                return;
            }
            if (object instanceof Boolean) {
                stringBuilder.append(object.toString());
                return;
            }
            if (object instanceof Integer) {
                int n2 = (Integer)object;
                for (int i = 0; i < _argLookupTable.length; ++i) {
                    if (JSBase._argLookupTable[i].value != n2) continue;
                    stringBuilder.append(JSBase._argLookupTable[i].displayValue);
                    return;
                }
            }
            if (object instanceof Number) {
                stringBuilder.append(object.toString());
                return;
            }
            stringBuilder.append(Dbg.getSignature((Object)object));
        }
    }

    static class ArgumentValueLookup {
        int value;
        String displayValue;

        ArgumentValueLookup(int n, String string) {
            this.value = n;
            this.displayValue = string;
        }
    }
}

