/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.logon;

import java.util.ArrayList;

public abstract class AbstractConnectionInfo {
    private static char[] HexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static int[] EncryptionSeeds = new int[]{57242, 15751, 1931, 13749, 64049, 34175, 19472, 52229, 46581, 1841, 1279, 19456, 27523, 28593, 65460, 20895};
    protected ClassLoader _classLoader = null;
    private char EscapeChar = (char)94;

    public abstract String getUserName();

    public abstract void setUserName(String var1);

    public abstract String getPassword();

    public abstract void setPassword(String var1);

    public abstract String getURL();

    public abstract Object clone();

    public abstract String serialize();

    public abstract void deserialize(String var1);

    public abstract int getDatabaseType();

    public abstract String getConnectionString();

    public abstract void mergeConnectionString(String var1);

    public abstract boolean canAttemptConnection();

    protected String encryptPassword(String string) {
        int n = string.length();
        char[] cArray = new char[n * 4];
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            int n2 = ((i & 0xF) << 12) + ((i & 0xF) << 8) + ((i & 0xF) << 4) + (i & 0xF);
            n2 ^= EncryptionSeeds[n % EncryptionSeeds.length];
            cArray[i * 4 + 0] = HexDigits[(n2 ^= c) >>> 12 & 0xF];
            cArray[i * 4 + 1] = HexDigits[n2 >>> 8 & 0xF];
            cArray[i * 4 + 2] = HexDigits[n2 >>> 4 & 0xF];
            cArray[i * 4 + 3] = HexDigits[n2 & 0xF];
        }
        String string2 = new String(cArray);
        return string2;
    }

    protected String decryptPassword(String string) {
        if ((string.length() & 3) != 0) {
            return null;
        }
        int n = string.length() / 4;
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            for (int j = 0; j < 4; ++j) {
                int n3 = Character.digit(string.charAt(i * 4 + j), 16);
                n2 = (n2 << 4) + n3;
            }
            int n4 = ((i & 0xF) << 12) + ((i & 0xF) << 8) + ((i & 0xF) << 4) + (i & 0xF);
            cArray[i] = (char)(n2 ^ (n4 ^= EncryptionSeeds[n % EncryptionSeeds.length]));
        }
        String string2 = new String(cArray);
        return string2;
    }

    protected String defaultSerializer(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            throw new IllegalArgumentException("keys cannot be null");
        }
        if (stringArray2 == null) {
            throw new IllegalArgumentException("values cannot be null");
        }
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("must provide same number of keys and values");
        }
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i] == null) continue;
            if (stringArray[i] == null) {
                throw new IllegalArgumentException("null keys are not allowed");
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(this.escape(stringArray[i]));
            stringBuffer.append('=');
            stringBuffer.append(this.escape(stringArray2[i]));
        }
        return stringBuffer.toString();
    }

    protected String[] defaultDeserializer(String string) {
        String[] stringArray = string.split(";");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.unescape(stringArray[i]);
            int n = stringArray[i].indexOf("=");
            if (n == -1) continue;
            String string2 = stringArray[i].substring(0, n);
            String string3 = stringArray[i].substring(n + 1);
            arrayList.add(string2);
            arrayList.add(string3);
        }
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 8);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.EscapeChar) {
                stringBuffer.append(c);
                stringBuffer.append(c);
                continue;
            }
            if (c <= ' ' || c > '\u007f' || c == '=' || c == ';') {
                stringBuffer.append(this.EscapeChar);
                stringBuffer.append(HexDigits[c >>> 12 & 0xF]);
                stringBuffer.append(HexDigits[c >>> 8 & 0xF]);
                stringBuffer.append(HexDigits[c >>> 4 & 0xF]);
                stringBuffer.append(HexDigits[c & 0xF]);
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private String unescape(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == this.EscapeChar) {
                if (++i >= string.length()) continue;
                c = string.charAt(i);
                if (c == this.EscapeChar) {
                    stringBuffer.append(c);
                    continue;
                }
                if (i > string.length() - 4) continue;
                try {
                    c = (char)Integer.parseInt(string.substring(i, i + 4), 16);
                    stringBuffer.append(c);
                    i += 3;
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }
}

