/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.BlockCipherSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.security.spec.AESParameterSpec;
import javax.security.spec.CCMSTARParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AESCipherSpi
extends BlockCipherSpi {
    protected int m = -1;

    public AESCipherSpi() {
        this((CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"AES"), "AES", -1);
    }

    public AESCipherSpi(int n) {
        this((CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"AES"), "AES", n);
    }

    public AESCipherSpi(CryptoTransform cryptoTransform, String string, int n) {
        super(cryptoTransform, string);
        this.m = n;
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            this.if(key);
            return key.getEncoded().length * 8;
        }
        throw new InvalidKeyException("Invalid AES key.");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void if(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) throw new InvalidKeyException("wrong key");
        if (key == null) {
            throw new InvalidKeyException("wrong key");
        }
        this.if(key);
        byte[] byArray = key.getEncoded();
        if (this.h.equals("CCMSTAR")) {
            if (algorithmParameterSpec == null) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            if (!(algorithmParameterSpec instanceof CCMSTARParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
            CCMSTARParameterSpec cCMSTARParameterSpec = (CCMSTARParameterSpec)algorithmParameterSpec;
            this.f[0] = "AES";
            this.f[1] = cCMSTARParameterSpec.getNonce();
            this.f[2] = cCMSTARParameterSpec.getAssociatedData();
            this.f[3] = byArray;
            this.f[4] = cCMSTARParameterSpec.getMacLength();
            return;
        }
        this.f[0] = this.h;
        this.f[1] = new Integer(128);
        this.f[2] = byArray;
        if (algorithmParameterSpec == null) {
            if (this.h.equalsIgnoreCase("ECB")) return;
            if (this.k == 4) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            byte[] byArray2 = new byte[this.engineGetBlockSize()];
            if (this.e == null) {
                new SecureRandom().nextBytes(byArray2);
            } else {
                this.e.nextBytes(byArray2);
            }
            this.f[3] = byArray2;
            return;
        }
        if (algorithmParameterSpec instanceof AESParameterSpec) {
            AESParameterSpec aESParameterSpec = (AESParameterSpec)algorithmParameterSpec;
            Integer n = aESParameterSpec.getblockLen();
            this.f[1] = n;
            if (!this.h.equalsIgnoreCase("ECB")) {
                this.f[3] = aESParameterSpec.getIV();
                return;
            }
            if (aESParameterSpec.getIV() == null) return;
            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
        }
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
        if (this.h.equalsIgnoreCase("ECB")) {
            throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
        }
        if (this.h.equalsIgnoreCase("CTR")) {
            throw new InvalidAlgorithmParameterException("CTR mode cannot use IVParameterSpec");
        }
        this.f[3] = ((IvParameterSpec)algorithmParameterSpec).getIV();
    }

    protected final AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = this.h.indexOf("CCMSTAR") != -1 ? AlgorithmParameters.getInstance("CCMSTAR", "Certicom") : AlgorithmParameters.getInstance("AES", "Certicom");
            if (this.h.indexOf("ECB") != -1) {
                return null;
            }
            if (this.h.indexOf("CFB") != -1 || this.h.indexOf("CTR") != -1) {
                algorithmParameters.init(new AESParameterSpec((Integer)this.f[1], (byte[])this.f[3]));
            } else if (this.h.indexOf("CCMSTAR") != -1) {
                algorithmParameters.init(new CCMSTARParameterSpec((byte[])this.f[1], (byte[])this.f[2], (Integer)this.f[4]));
            } else {
                algorithmParameters.init(new AESParameterSpec((byte[])this.f[3]));
            }
        }
        catch (Exception exception) {
            return null;
        }
        return algorithmParameters;
    }

    protected void if(Key key) throws InvalidKeyException {
        int n;
        String string = key.getAlgorithm();
        String string2 = AESCipherSpi.commonKeyVerification(string, this.m, n = key.getEncoded().length * 8);
        if (string2 != null) {
            throw new InvalidKeyException(string2);
        }
    }

    protected final byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(byArray, n, n2);
    }

    public static String commonKeyVerification(String string, int n, int n2) {
        if (string.indexOf("AES") != 0) {
            return "Key must be AES";
        }
        String string2 = AESCipherSpi.commonKeyVerification(n, n2);
        if (string2 != null) {
            return string2;
        }
        if (string.length() > 3) {
            if ("AES-128".equals(string) && n2 != 128) {
                return "128 bit key required";
            }
            if ("AES-192".equals(string) && n2 != 192) {
                return "192 bit key required";
            }
            if ("AES-256".equals(string) && n2 != 256) {
                return "256 bit key required";
            }
        }
        return null;
    }

    public static String commonKeyVerification(int n, int n2) {
        if (n == -1) {
            if (n2 != 128 && n2 != 192 && n2 != 256) {
                return "key size must be 128,192 or 256";
            }
        } else if (n2 != n) {
            return "key size must be " + n;
        }
        return null;
    }
}

