/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.AESParameter;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import javax.security.spec.AESParameterSpec;

public class AESParamsSpi
extends AlgorithmParametersSpi
implements Zeroizeable {
    public static final int IV_ONLY = 0;
    public static final int EMPTY = 1;
    public static final int COMPLETE = 2;
    private byte[] cX;
    private int cV;
    private int cW = 0;
    private boolean cY = false;
    static /* synthetic */ Class class$javax$security$spec$AESParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public AESParamsSpi() {
    }

    public AESParamsSpi(int n, byte[] byArray) {
        this.cX = (byte[])byArray.clone();
        this.cV = n;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof AESParameterSpec) {
            AESParameterSpec aESParameterSpec = (AESParameterSpec)algorithmParameterSpec;
            this.cW = aESParameterSpec.getEncodingStyle();
            switch (this.cW) {
                case 2: {
                    this.cX = aESParameterSpec.getIV();
                    this.cV = aESParameterSpec.getblockLen();
                    break;
                }
                case 0: {
                    this.cX = aESParameterSpec.getIV();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new InvalidParameterSpecException("Unknown encoding style : " + this.cW);
                }
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.cX = ivParameterSpec.getIV();
            this.cW = 0;
        } else {
            throw new InvalidParameterSpecException("Invalid parameter spec");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            AESParameter aESParameter = new AESParameter();
            aESParameter.do(byArray);
            this.cW = aESParameter.getEncodingStyle();
            switch (this.cW) {
                case 2: {
                    this.cX = aESParameter.getIV();
                    this.cV = aESParameter.getNumBits();
                    break;
                }
                case 0: {
                    this.cX = aESParameter.getIV();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IOException("Decoded parameter contains unknown encoding style : " + this.cW);
                }
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException("ASN1ParsingException : " + aSN1ParsingException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz != null && (class$javax$security$spec$AESParameterSpec == null ? (class$javax$security$spec$AESParameterSpec = AESParamsSpi.class$("javax.security.spec.AESParameterSpec")) : class$javax$security$spec$AESParameterSpec).isAssignableFrom(clazz)) {
            switch (this.cW) {
                case 2: {
                    return new AESParameterSpec(this.cV, this.cX);
                }
                case 0: {
                    return new AESParameterSpec(this.cX);
                }
            }
            return new AESParameterSpec();
        }
        if (clazz != null && (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = AESParamsSpi.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec).isAssignableFrom(clazz)) {
            return new IvParameterSpec(this.cX);
        }
        throw new InvalidParameterSpecException("Invalid parameter spec class");
    }

    protected byte[] engineGetEncoded() throws IOException {
        AESParameter aESParameter = this.cW == 2 ? new AESParameter(this.cX, this.cV) : (this.cW == 0 ? new AESParameter(this.cX) : new AESParameter());
        return aESParameter.a();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "iv: " + Conversion.OS2Hex((byte[])this.cX, (int)2) + "\nblockLen: " + this.cV;
    }

    public String toString() {
        return this.engineToString();
    }

    public boolean isZeroized() {
        return this.cY;
    }

    public boolean testZeroizationState() {
        return this.cY;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.cX, (byte)0);
        this.cV = 0;
        this.cW = 1;
        this.cY = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

