/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.BlockCipherSpi;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ARC2CipherSpi
extends BlockCipherSpi {
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public ARC2CipherSpi() {
        super((CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"ARC2"), "ARC2");
    }

    protected final int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey && (key.getAlgorithm().equals("ARC2") || key.getAlgorithm().equals("RC2"))) {
            int n = key.getEncoded().length;
            if (n > 128) {
                throw new InvalidKeyException("Invalid ARC2 key length.");
            }
            return n * 8;
        }
        throw new InvalidKeyException("Invalid ARC2 key.");
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void if(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SecretKey)) throw new InvalidKeyException("wrong key");
        if (!key.getAlgorithm().equals("ARC2") && !key.getAlgorithm().equals("RC2")) {
            throw new InvalidKeyException("wrong key");
        }
        byte[] byArray = key.getEncoded();
        if (byArray.length > 128) throw new InvalidKeyException("wrong key");
        if (byArray.length < 1) {
            throw new InvalidKeyException("wrong key");
        }
        this.f[0] = this.h;
        this.f[1] = new Integer(byArray.length * 8);
        this.f[2] = byArray;
        if (algorithmParameterSpec == null) {
            if (this.h.equals("ECB")) return;
            if (this.k == 4) {
                throw new InvalidAlgorithmParameterException("wrong params");
            }
            byte[] byArray2 = new byte[this.engineGetBlockSize()];
            if (this.e == null) {
                new SecureRandom().nextBytes(byArray2);
            } else {
                this.e.nextBytes(byArray2);
            }
            this.f[3] = byArray2;
            return;
        }
        if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) {
            if (!(algorithmParameterSpec instanceof IvParameterSpec)) throw new InvalidAlgorithmParameterException("wrong params");
            if (this.h.equalsIgnoreCase("ECB")) throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
            this.f[3] = ((IvParameterSpec)algorithmParameterSpec).getIV();
            return;
        }
        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
        int n = rC2ParameterSpec.getEffectiveKeyBits();
        this.f[1] = new Integer(n);
        if (!this.h.equalsIgnoreCase("ECB")) {
            this.f[3] = rC2ParameterSpec.getIV();
            return;
        }
        if (rC2ParameterSpec.getIV() == null) return;
        throw new InvalidAlgorithmParameterException("ECB mode cannot use IV");
    }

    protected Class[] new() {
        return new Class[]{class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = ARC2CipherSpi.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec, class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = ARC2CipherSpi.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec};
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        try {
            algorithmParameters = AlgorithmParameters.getInstance("RC2");
            if (this.f[1] == null || this.f[3] == null) {
                return null;
            }
            algorithmParameters.init(new RC2ParameterSpec((Integer)this.f[1], (byte[])this.f[3]));
        }
        catch (Exception exception) {
            return null;
        }
        return algorithmParameters;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

