/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.asn1.ASN1EncodingException;
import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.asn1der.asn1.aa;
import com.certicom.ecc.asn1der.asn1.l;
import com.certicom.ecc.asn1der.asn1.w;
import com.certicom.ecc.asn1der.asn1.y;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.util.Conversion;
import java.math.BigInteger;
import java.security.spec.RSAPrivateCrtKeySpec;

public class ASNRSAPrivateKey
extends y
implements Zeroizeable {
    l cx = new l(l.ai);
    l cs;
    l cw;
    l cy;
    l cr;
    l cq;
    l cv;
    l cu;
    l cA;
    private boolean cz = false;

    public ASNRSAPrivateKey() {
        this.cs = new l();
        this.cw = new l();
        this.cy = new l();
        this.cr = new l();
        this.cq = new l();
        this.cv = new l();
        this.cu = new l();
        this.cA = new l();
    }

    public ASNRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        this.cs = new l(bigInteger);
        this.cw = new l(bigInteger2);
        this.cy = new l(bigInteger3);
        this.cr = new l(bigInteger4);
        this.cq = new l(bigInteger5);
        this.cv = new l(bigInteger6);
        this.cu = new l(bigInteger7);
        this.cA = new l(bigInteger8);
    }

    public void decodeContents(w w2) throws ASN1ParsingException {
        this.cx.a(w2);
        this.cs.a(w2);
        this.cw.a(w2);
        this.cy.a(w2);
        this.cr.a(w2);
        this.cq.a(w2);
        this.cv.a(w2);
        this.cu.a(w2);
        this.cA.a(w2);
        if (!this.cx.new().equals(l.ai)) {
            throw new ASN1ParsingException("Bad encoding for PKCS1 private key (version!=0)");
        }
    }

    public void encodeContents(aa aa2) throws ASN1EncodingException {
        this.cx.a(aa2);
        this.cs.a(aa2);
        this.cw.a(aa2);
        this.cy.a(aa2);
        this.cr.a(aa2);
        this.cq.a(aa2);
        this.cv.a(aa2);
        this.cu.a(aa2);
        this.cA.a(aa2);
    }

    public BigInteger getModulus() {
        return this.cs.new();
    }

    public BigInteger getPublicExponent() {
        return this.cw.new();
    }

    public BigInteger getPrivateExponent() {
        return this.cy.new();
    }

    public BigInteger getPrimeP() {
        return this.cr.new();
    }

    public BigInteger getPrimeQ() {
        return this.cq.new();
    }

    public BigInteger getPrimeExponentP() {
        return this.cv.new();
    }

    public BigInteger getPrimeExponentQ() {
        return this.cu.new();
    }

    public BigInteger getCrtCoefficient() {
        return this.cA.new();
    }

    public RSAPrivateCrtKeySpec getKeySpec() {
        return new RSAPrivateCrtKeySpec(this.getModulus(), this.getPublicExponent(), this.getPrivateExponent(), this.getPrimeP(), this.getPrimeQ(), this.getPrimeExponentP(), this.getPrimeExponentQ(), this.getCrtCoefficient());
    }

    public boolean isZeroized() {
        return this.cz;
    }

    public boolean testZeroizationState() {
        return this.cz;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.cs = new l(l.ai);
        this.cw = new l(l.ai);
        this.cy = new l(l.ai);
        this.cr = new l(l.ai);
        this.cq = new l(l.ai);
        this.cv = new l(l.ai);
        this.cu = new l(l.ai);
        this.cA = new l(l.ai);
        this.cz = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return Conversion.OS2Hex((byte[])this.a(), (int)2);
    }
}

