/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.CCMSTARParameter;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.security.spec.CCMSTARParameterSpec;

public class CCMSTARParamsSpi
extends AlgorithmParametersSpi
implements Zeroizeable {
    public static final int EMPTY = 0;
    public static final int NO_AUTH = 1;
    public static final int AUTH = 2;
    private byte[] cI;
    private byte[] cK;
    private int cJ;
    private int cH = 0;
    private boolean cL = false;
    static /* synthetic */ Class class$javax$security$spec$CCMSTARParameterSpec;

    public CCMSTARParamsSpi() {
    }

    public CCMSTARParamsSpi(byte[] byArray) {
        this.cI = (byte[])byArray.clone();
    }

    public CCMSTARParamsSpi(byte[] byArray, byte[] byArray2, int n) {
        this(byArray);
        this.cK = byArray2;
        this.cJ = n;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CCMSTARParameterSpec) {
            CCMSTARParameterSpec cCMSTARParameterSpec = (CCMSTARParameterSpec)algorithmParameterSpec;
            this.cH = cCMSTARParameterSpec.getEncodingStyle();
            switch (this.cH) {
                case 1: {
                    this.cI = cCMSTARParameterSpec.getNonce();
                    break;
                }
                case 2: {
                    this.cI = cCMSTARParameterSpec.getNonce();
                    this.cK = cCMSTARParameterSpec.getAssociatedData();
                    this.cJ = cCMSTARParameterSpec.getMacLength();
                    break;
                }
                case 0: {
                    throw new InvalidParameterSpecException("EMPTY parameter");
                }
                default: {
                    throw new InvalidParameterSpecException("Unknown encoding style : " + this.cH);
                }
            }
        } else {
            throw new InvalidParameterSpecException("Invalid parameter spec");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            CCMSTARParameter cCMSTARParameter = new CCMSTARParameter();
            cCMSTARParameter.do(byArray);
            this.cH = cCMSTARParameter.getEncodingStyle();
            switch (this.cH) {
                case 1: {
                    this.cI = cCMSTARParameter.getNonce();
                    break;
                }
                case 2: {
                    this.cI = cCMSTARParameter.getNonce();
                    this.cK = cCMSTARParameter.getAssociatedData();
                    this.cJ = cCMSTARParameter.getMacLength();
                    break;
                }
                case 0: {
                    throw new IOException("EMPTY parameter");
                }
                default: {
                    throw new IOException("Decoded parameter contains unknown encoding style : " + this.cH);
                }
            }
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException("ASN1ParsingException : " + aSN1ParsingException.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz != null && (class$javax$security$spec$CCMSTARParameterSpec == null ? (class$javax$security$spec$CCMSTARParameterSpec = CCMSTARParamsSpi.class$("javax.security.spec.CCMSTARParameterSpec")) : class$javax$security$spec$CCMSTARParameterSpec).isAssignableFrom(clazz)) {
            switch (this.cH) {
                case 1: {
                    return new CCMSTARParameterSpec(this.cI);
                }
                case 2: {
                    return new CCMSTARParameterSpec(this.cI, this.cK, this.cJ);
                }
            }
            return new CCMSTARParameterSpec(null);
        }
        throw new InvalidParameterSpecException("Invalid parameter spec class");
    }

    protected byte[] engineGetEncoded() throws IOException {
        CCMSTARParameter cCMSTARParameter = this.cH == 1 ? new CCMSTARParameter(this.cI) : (this.cH == 2 ? new CCMSTARParameter(this.cI, this.cK, this.cJ) : new CCMSTARParameter());
        return cCMSTARParameter.a();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        String string = new String();
        string = "nonce: " + Conversion.OS2Hex((byte[])this.cI, (int)2) + "\nMAC Length: " + this.cJ + "\nassociated data: " + Conversion.OS2Hex((byte[])this.cK, (int)2);
        return string;
    }

    public String toString() {
        return this.engineToString();
    }

    public boolean isZeroized() {
        return this.cL;
    }

    public boolean testZeroizationState() {
        return this.cL;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.cI, (byte)0);
        this.cK = null;
        this.cJ = 0;
        this.cH = 1;
        this.cL = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

