/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.a.a.d;
import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.asn1der.b.a;
import com.certicom.ecc.asn1der.b.c;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.spec.X942ParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class DHAlgParamsSpi
extends AlgorithmParametersSpi
implements Zeroizeable {
    private BigInteger c9;
    private BigInteger dd;
    private int da;
    private BigInteger c8;
    private BigInteger db;
    private BigInteger dc;
    private int de = -1;
    private boolean dg = false;
    private String df;
    static /* synthetic */ Class class$com$certicom$ecc$spec$X942ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$DHParameterSpec;

    public DHAlgParamsSpi() {
        this.df = "PKCS#3";
    }

    public DHAlgParamsSpi(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this.c9 = bigInteger;
        this.dd = bigInteger2;
        this.da = n;
        this.df = "PKCS#3";
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("Invalid parameter spec");
        }
        DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
        this.c9 = dHParameterSpec.getP();
        this.dd = dHParameterSpec.getG();
        this.da = dHParameterSpec.getL();
        if (algorithmParameterSpec instanceof X942ParameterSpec) {
            X942ParameterSpec x942ParameterSpec = (X942ParameterSpec)algorithmParameterSpec;
            this.c8 = x942ParameterSpec.getQ();
            this.db = x942ParameterSpec.getJ();
            this.dc = x942ParameterSpec.getSeed();
            this.de = x942ParameterSpec.getCounter();
            this.df = "X9.42";
        } else {
            this.df = "PKCS#3";
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        this.engineInit(byArray, this.df);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && string.equals("PKCS#3")) {
            this.df = "PKCS#3";
            try {
                d d2 = new d();
                d2.do(byArray);
                this.c9 = d2.x();
                this.dd = d2.y();
                this.da = d2.w();
                return;
            }
            catch (ASN1ParsingException aSN1ParsingException) {
                throw new IOException("ASN1ParsingException");
            }
        }
        if (string != null && !string.equals("X9.42")) throw new IOException("Security_InvalidEncoding");
        this.df = "X9.42";
        try {
            a a2 = new a();
            a2.do(byArray);
            this.c9 = a2.R();
            this.dd = a2.T();
            this.c8 = a2.P();
            this.db = a2.Q();
            c c2 = a2.S();
            if (c2 == null) return;
            this.dc = c2.W();
            this.de = c2.X();
            return;
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException("ASN1ParsingException");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz != null && (class$com$certicom$ecc$spec$X942ParameterSpec == null ? (class$com$certicom$ecc$spec$X942ParameterSpec = DHAlgParamsSpi.class$("com.certicom.ecc.spec.X942ParameterSpec")) : class$com$certicom$ecc$spec$X942ParameterSpec).isAssignableFrom(clazz)) {
            return new X942ParameterSpec(this.c9, this.dd, this.c8, this.db, this.dc, this.de, this.da);
        }
        if (clazz != null && (class$javax$crypto$spec$DHParameterSpec == null ? (class$javax$crypto$spec$DHParameterSpec = DHAlgParamsSpi.class$("javax.crypto.spec.DHParameterSpec")) : class$javax$crypto$spec$DHParameterSpec).isAssignableFrom(clazz)) {
            return new DHParameterSpec(this.c9, this.dd, this.da);
        }
        throw new InvalidParameterSpecException("Invalid parameter spec");
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded(this.df);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string != null && string.equals("X9.42")) {
            c c2 = this.dc != null && this.de >= 0 ? new c(this.dc, this.de) : null;
            return new a(this.c9, this.dd, this.c8, this.db, c2).a();
        }
        if (string != null && string.equals("PKCS#3")) {
            return new d(this.c9, this.dd, this.da).a();
        }
        throw new IOException("Security_InvalidEncoding");
    }

    protected String engineToString() {
        return "P: " + this.c9.toString(16) + "\nG: " + this.dd.toString(16) + "\nL: " + this.da;
    }

    public String toString() {
        return this.engineToString();
    }

    public boolean isZeroized() {
        return this.dg;
    }

    public boolean testZeroizationState() {
        return this.dg;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        this.c9 = BigInteger.ZERO;
        this.dd = BigInteger.ZERO;
        this.da = 0;
        this.dg = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

