/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.util.JDKVersion;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.util.Random;

public class ECDSASignatureSpi
extends SignatureSpi {
    private CryptoTransform a = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"ECDSA");

    protected ECDSASignatureSpi(int n) {
        this.a.setHashMode(n);
    }

    public ECDSASignatureSpi() {
        this(2);
    }

    protected Object engineGetParameter(String string) {
        return null;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        privateKey = (PrivateKey)JDKVersion.getTranslator().translateECKey_1_5_to_1_3(privateKey);
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("not ec private key.");
        }
        this.a.init(1, new Object[]{privateKey}, (Random)this.a());
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        publicKey = (PublicKey)JDKVersion.getTranslator().translateECKey_1_5_to_1_3(publicKey);
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("not ec public key.");
        }
        this.a.init(2, new Object[]{publicKey}, (Random)this.a());
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("this method is not supported.");
    }

    protected byte[] engineSign() throws SignatureException {
        return this.a.transform(null, 0, 0, true);
    }

    protected void engineUpdate(byte by) throws SignatureException {
        this.a.transform(new byte[]{by}, 0, 1, false);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        this.a.transform(byArray, n, n2, false);
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return this.a.verify(byArray, 0, byArray.length);
    }

    private SecureRandom a() {
        if (this.appRandom == null) {
            this.appRandom = new SecureRandom();
        }
        return this.appRandom;
    }
}

