/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.interfaces.ECKey;
import com.certicom.ecc.interfaces.ECParams;
import com.certicom.ecc.interfaces.PointParams;
import com.certicom.ecc.jcae.CurveList;
import com.certicom.ecc.jcae.ECPrivateKey;
import com.certicom.ecc.jcae.ECPublicKey;
import com.certicom.ecc.scheme.CryptoTransform;
import com.certicom.ecc.system.CryptoManager;
import com.certicom.ecc.system.SystemConfig;
import com.certicom.ecc.util.JDKVersion;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.security.spec.ECParameterSpec;
import javax.security.spec.ECPrivateKeySpec;
import javax.security.spec.ECPublicKeySpec;
import javax.security.spec.ECRawPublicKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ECKeyFactorySpi
extends KeyFactorySpi {
    private AlgorithmParameterSpec int;
    private CryptoTransform if;
    private int for;
    private int do;
    private static final Class try = class$com$certicom$ecc$interfaces$ECPrivateKey == null ? (class$com$certicom$ecc$interfaces$ECPrivateKey = ECKeyFactorySpi.class$("com.certicom.ecc.interfaces.ECPrivateKey")) : class$com$certicom$ecc$interfaces$ECPrivateKey;
    private static final Class case = class$com$certicom$ecc$interfaces$ECPublicKey == null ? (class$com$certicom$ecc$interfaces$ECPublicKey = ECKeyFactorySpi.class$("com.certicom.ecc.interfaces.ECPublicKey")) : class$com$certicom$ecc$interfaces$ECPublicKey;
    private static final Class a = class$java$security$spec$X509EncodedKeySpec == null ? (class$java$security$spec$X509EncodedKeySpec = ECKeyFactorySpi.class$("java.security.spec.X509EncodedKeySpec")) : class$java$security$spec$X509EncodedKeySpec;
    private static final Class new = class$java$security$spec$PKCS8EncodedKeySpec == null ? (class$java$security$spec$PKCS8EncodedKeySpec = ECKeyFactorySpi.class$("java.security.spec.PKCS8EncodedKeySpec")) : class$java$security$spec$PKCS8EncodedKeySpec;
    private static final Class byte = class$javax$security$spec$ECRawPublicKeySpec == null ? (class$javax$security$spec$ECRawPublicKeySpec = ECKeyFactorySpi.class$("javax.security.spec.ECRawPublicKeySpec")) : class$javax$security$spec$ECRawPublicKeySpec;
    static /* synthetic */ Class class$com$certicom$ecc$interfaces$ECPrivateKey;
    static /* synthetic */ Class class$com$certicom$ecc$interfaces$ECPublicKey;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$javax$security$spec$ECRawPublicKeySpec;

    public ECKeyFactorySpi() {
        SystemConfig systemConfig = SystemConfig.getConfig();
        this.int = CurveList.byName("ImplicitlyCA");
        this.for = systemConfig.getFormat();
        this.do = systemConfig.getPtCompression();
        this.if = (CryptoTransform)CryptoManager.getInstance((Class)CryptoTransform.TYPE, (String)"KEYFAC");
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        keySpec = JDKVersion.getTranslator().translateECKeySpec_1_5_to_1_3(keySpec);
        ECPrivateKey eCPrivateKey = null;
        if (keySpec instanceof ECPrivateKeySpec) {
            ECPrivateKeySpec eCPrivateKeySpec = (ECPrivateKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCPrivateKeySpec.getParams();
            ECParams eCParams = (ECParams)CurveList.convertParams(eCParameterSpec);
            eCPrivateKey = new ECPrivateKey(this.for, eCPrivateKeySpec.getExp(), eCParams);
        } else if (keySpec instanceof PKCS8EncodedKeySpec) {
            byte[] byArray = ((PKCS8EncodedKeySpec)keySpec).getEncoded();
            this.if.init(5, new Object[]{try, this.int}, null);
            eCPrivateKey = new ECPrivateKey(this.for, (com.certicom.ecc.interfaces.ECPrivateKey)this.if.transformToObject(byArray, 0, byArray.length, true));
        } else {
            throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
        }
        return (PrivateKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(eCPrivateKey);
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        keySpec = JDKVersion.getTranslator().translateECKeySpec_1_5_to_1_3(keySpec);
        ECPublicKey eCPublicKey = null;
        if (keySpec instanceof ECPublicKeySpec) {
            PointParams pointParams;
            ECPublicKeySpec eCPublicKeySpec = (ECPublicKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCPublicKeySpec.getParams();
            byte[] byArray = eCPublicKeySpec.getX();
            byte[] byArray2 = eCPublicKeySpec.getY();
            ECParams eCParams = (ECParams)CurveList.convertParams(eCParameterSpec);
            int n = eCParams.getSize();
            if (byArray.length != byArray2.length && byArray.length != n + 7 >>> 3) {
                throw new InvalidKeySpecException("invalid public key");
            }
            byte[] byArray3 = new byte[1 + byArray.length + byArray2.length];
            byArray3[0] = 4;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, 1 + byArray.length, byArray2.length);
            PointParams pointParams2 = eCParams.getPoint();
            try {
                pointParams = pointParams2.getDecoded(byArray3, 0, byArray3.length);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("invalid public key");
            }
            eCPublicKey = new ECPublicKey(this.for, this.do, pointParams.getX(), pointParams.getY(), eCParams);
        } else if (keySpec instanceof X509EncodedKeySpec) {
            byte[] byArray = ((X509EncodedKeySpec)keySpec).getEncoded();
            this.if.init(5, new Object[]{case, this.int}, null);
            eCPublicKey = new ECPublicKey(this.for, this.do, (com.certicom.ecc.interfaces.ECPublicKey)this.if.transformToObject(byArray, 0, byArray.length, true));
        } else if (keySpec instanceof ECRawPublicKeySpec) {
            PointParams pointParams;
            ECRawPublicKeySpec eCRawPublicKeySpec = (ECRawPublicKeySpec)keySpec;
            ECParameterSpec eCParameterSpec = eCRawPublicKeySpec.getParams();
            byte[] byArray = eCRawPublicKeySpec.getPt();
            ECParams eCParams = (ECParams)CurveList.convertParams(eCParameterSpec);
            PointParams pointParams3 = eCParams.getPoint();
            try {
                pointParams = pointParams3.getDecoded(byArray, 0, byArray.length);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("invalid public key");
            }
            eCPublicKey = new ECPublicKey(this.for, this.do, pointParams.getX(), pointParams.getY(), eCParams);
        } else {
            throw new InvalidKeySpecException("does not support " + keySpec.getClass().getName());
        }
        return (PublicKey)JDKVersion.getTranslator().translateECKey_1_3_to_1_5(eCPublicKey);
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        key = JDKVersion.getTranslator().translateECKey_1_5_to_1_3(key);
        if (key instanceof ECKey) {
            KeySpec keySpec = null;
            if (a.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)key;
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey && key.getFormat().equals("X.509")) {
                    keySpec = new X509EncodedKeySpec(eCKey.getEncoded());
                }
            } else if (new.isAssignableFrom(clazz)) {
                ECKey eCKey = (ECKey)key;
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey && key.getFormat().equals("PKCS#8")) {
                    keySpec = new PKCS8EncodedKeySpec(eCKey.getEncoded());
                }
            } else if (byte.isAssignableFrom(clazz)) {
                if (key instanceof com.certicom.ecc.interfaces.ECPublicKey) {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)key;
                    byte[] byArray = eCPublicKey.getPoint().getEncoded(this.do);
                    ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.convertParams(eCPublicKey.getECParams(), true);
                    keySpec = new ECRawPublicKeySpec(byArray, eCParameterSpec);
                }
            } else {
                ECParams eCParams = ((ECKey)key).getECParams();
                ECParameterSpec eCParameterSpec = (ECParameterSpec)CurveList.convertParams(eCParams, true);
                if (key instanceof com.certicom.ecc.interfaces.ECPrivateKey) {
                    byte[] byArray = ((com.certicom.ecc.interfaces.ECPrivateKey)key).getExp();
                    keySpec = new ECPrivateKeySpec(byArray, eCParameterSpec);
                } else {
                    com.certicom.ecc.interfaces.ECPublicKey eCPublicKey = (com.certicom.ecc.interfaces.ECPublicKey)key;
                    keySpec = new ECPublicKeySpec(eCPublicKey.getX(), eCPublicKey.getY(), eCParameterSpec);
                }
                keySpec = JDKVersion.getTranslator().translateECKeySpec_1_3_to_1_5(keySpec);
                if (!clazz.isInstance(keySpec)) {
                    keySpec = null;
                }
            }
            if (keySpec == null) {
                throw new InvalidKeySpecException("does not support " + clazz.getName());
            }
            return keySpec;
        }
        throw new InvalidKeySpecException("do not support " + key.getClass().getName());
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        try {
            if (Class.forName("java.security.interfaces.ECKey").isInstance(key)) {
                return key;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (key instanceof ECKey) {
            return key;
        }
        if (key instanceof javax.security.interfaces.ECKey) {
            javax.security.interfaces.ECParams eCParams = ((javax.security.interfaces.ECKey)key).getParams();
            ECParams eCParams2 = (ECParams)CurveList.convertParams(eCParams);
            if (key instanceof javax.security.interfaces.ECPrivateKey) {
                byte[] byArray = ((javax.security.interfaces.ECPrivateKey)key).getExp();
                return new ECPrivateKey(this.for, byArray, eCParams2);
            }
            javax.security.interfaces.ECPublicKey eCPublicKey = (javax.security.interfaces.ECPublicKey)key;
            return new ECPublicKey(this.for, this.do, eCPublicKey.getX(), eCPublicKey.getY(), eCParams2);
        }
        throw new InvalidKeyException("invalid key" + key.getClass().getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

