/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.jcae.PBECipherSpi;
import com.certicom.ecc.spec.PBES2ParameterSpec;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PBES2CipherSpi
extends PBECipherSpi {
    private String z;
    private Mac A;
    private int y;
    private byte[] x;
    private boolean w;
    private int v;
    public static final int DEFAULT_SALT_SIZE = 8;
    static /* synthetic */ Class class$com$certicom$ecc$spec$PBES2ParameterSpec;

    public PBES2CipherSpi() throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        this("AES", "HmacSHA1", "Certicom", 32, 16);
    }

    protected PBES2CipherSpi(String string, String string2, String string3, int n, int n2) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        this.t = string;
        this.z = string2;
        this.s = string3;
        this.v = n;
        this.y = n2;
        this.try();
    }

    protected AlgorithmParameters engineGetParameters() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBES2", this.s);
            PBES2ParameterSpec pBES2ParameterSpec = new PBES2ParameterSpec(this.o, this.p, this.x);
            pBES2ParameterSpec.setZeroBasedBugEnabled(this.w);
            algorithmParameters.init((AlgorithmParameterSpec)pBES2ParameterSpec);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
    }

    protected void try() throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException {
        this.n = Cipher.getInstance(this.t + "/CBC/PKCS5Padding", this.s);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(class$com$certicom$ecc$spec$PBES2ParameterSpec == null ? (class$com$certicom$ecc$spec$PBES2ParameterSpec = PBES2CipherSpi.class$("com.certicom.ecc.spec.PBES2ParameterSpec")) : class$com$certicom$ecc$spec$PBES2ParameterSpec), secureRandom);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (algorithmParameterSpec == null) {
            if (n == 2 || n == 4) {
                throw new InvalidKeyException("PBE parameter required");
            }
            if (secureRandom == null) {
                throw new InvalidParameterException("Random required when no explicit IV/salt given");
            }
            this.p = 1000;
            this.o = new byte[8];
            secureRandom.nextBytes(this.o);
            this.x = new byte[this.y];
            secureRandom.nextBytes(this.x);
            this.w = Boolean.getBoolean("com.certicom.ecc.spec.pbes2.zeroBasedBugEnabled");
        } else if (algorithmParameterSpec instanceof PBES2ParameterSpec) {
            this.p = ((PBES2ParameterSpec)algorithmParameterSpec).getIterationCount();
            if (this.p <= 0) {
                throw new InvalidParameterException("Iteration count <= 0");
            }
            this.o = ((PBES2ParameterSpec)algorithmParameterSpec).getSalt();
            this.x = ((PBES2ParameterSpec)algorithmParameterSpec).getIV();
            if (this.x == null) {
                if (n == 2 || n == 4) {
                    throw new InvalidParameterException("IV needs to be set for decrypt");
                }
                if (secureRandom == null) {
                    throw new InvalidParameterException("Random required when not specifiying an IV");
                }
                this.x = new byte[this.y];
                secureRandom.nextBytes(this.x);
            }
            this.w = ((PBES2ParameterSpec)algorithmParameterSpec).isZeroBasedBugEnabled();
        } else {
            throw new InvalidAlgorithmParameterException("Invalid Parameter Spec");
        }
        try {
            this.A = Mac.getInstance(this.z, this.s);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        int n2 = this.A.getMacLength();
        int n3 = this.v / n2 + 1;
        int n4 = this.v - (n3 - 1) * n2;
        int n5 = this.o.length + 4;
        byte[] byArray = new byte[this.v];
        for (int k = 0; k < n3; ++k) {
            int n6 = k + (this.w ? 0 : 1);
            byte[] byArray2 = new byte[n5];
            System.arraycopy(this.o, 0, byArray2, 0, this.o.length);
            int n7 = this.o.length;
            byArray2[n7++] = (byte)(n6 >>> 24);
            byArray2[n7++] = (byte)(n6 >>> 16);
            byArray2[n7++] = (byte)(n6 >>> 8);
            byArray2[n7] = (byte)n6;
            byte[] byArray3 = new byte[n2];
            for (int i2 = 0; i2 < this.p; ++i2) {
                byArray2 = this.if(key, byArray2);
                byArray3 = this.if(byArray3, byArray2);
            }
            if (k < n3 - 1) {
                System.arraycopy(byArray3, 0, byArray, n2 * k, n2);
                continue;
            }
            System.arraycopy(byArray3, 0, byArray, n2 * k, n4);
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.t);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(this.x);
        this.n.init(n, (Key)secretKeySpec, ivParameterSpec);
    }

    private byte[] if(Key key, byte[] byArray) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.A.init(key);
        byte[] byArray2 = this.A.doFinal(byArray);
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        return byArray3;
    }

    byte[] if(byte[] byArray, byte[] byArray2) throws InvalidAlgorithmParameterException {
        if (byArray.length != byArray2.length) {
            throw new InvalidAlgorithmParameterException("byte streams for xor have different length");
        }
        for (int k = byArray.length - 1; k >= 0; --k) {
            int n = k;
            byArray[n] = (byte)(byArray[n] ^ byArray2[k]);
        }
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

