/*
 * Decompiled with CFR 0.152.
 */
package com.certicom.ecc.jcae;

import com.certicom.ecc.asn1der.asn1.ASN1ParsingException;
import com.certicom.ecc.fips.FIPSException;
import com.certicom.ecc.fips.Zeroizeable;
import com.certicom.ecc.jcae.RC2CBCParameter;
import com.certicom.ecc.util.Conversion;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RC2ParamsSpi
extends AlgorithmParametersSpi
implements Zeroizeable {
    private byte[] dr;
    private int dt;
    private boolean ds = false;
    static /* synthetic */ Class class$javax$crypto$spec$RC2ParameterSpec;
    static /* synthetic */ Class class$javax$crypto$spec$IvParameterSpec;

    public RC2ParamsSpi() {
    }

    public RC2ParamsSpi(int n, byte[] byArray) {
        this.dt = n;
        this.case(byArray);
    }

    private final void case(byte[] byArray) {
        this.dr = byArray != null ? (byte[])byArray.clone() : new byte[8];
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RC2ParameterSpec) {
            RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
            this.case(rC2ParameterSpec.getIV());
            this.dt = rC2ParameterSpec.getEffectiveKeyBits();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.case(ivParameterSpec.getIV());
            this.dt = 128;
        } else {
            throw new InvalidParameterSpecException("Invalid parameter spec");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            RC2CBCParameter rC2CBCParameter = new RC2CBCParameter();
            rC2CBCParameter.do(byArray);
            this.case(rC2CBCParameter.getIV());
            this.dt = rC2CBCParameter.getSize();
        }
        catch (ASN1ParsingException aSN1ParsingException) {
            throw new IOException("ASN1ParsingException");
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz == null || (class$javax$crypto$spec$RC2ParameterSpec == null ? (class$javax$crypto$spec$RC2ParameterSpec = RC2ParamsSpi.class$("javax.crypto.spec.RC2ParameterSpec")) : class$javax$crypto$spec$RC2ParameterSpec).isAssignableFrom(clazz)) {
            return new RC2ParameterSpec(this.dt, this.dr);
        }
        if (clazz != null && (class$javax$crypto$spec$IvParameterSpec == null ? (class$javax$crypto$spec$IvParameterSpec = RC2ParamsSpi.class$("javax.crypto.spec.IvParameterSpec")) : class$javax$crypto$spec$IvParameterSpec).isAssignableFrom(clazz)) {
            return new IvParameterSpec(this.dr);
        }
        throw new InvalidParameterSpecException("Invalid parameter spec class");
    }

    protected byte[] engineGetEncoded() throws IOException {
        return new RC2CBCParameter(this.dt, this.dr).a();
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        return "iv: " + Conversion.OS2Hex((byte[])this.dr, (int)2) + "\neffectiveKeyBits: " + this.dt;
    }

    public boolean isZeroized() {
        return this.ds;
    }

    public boolean testZeroizationState() {
        return this.ds;
    }

    public boolean canReuse() {
        return false;
    }

    public void zeroize() throws FIPSException {
        Arrays.fill(this.dr, (byte)0);
        this.dt = 0;
        this.ds = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isZeroized()) {
            this.zeroize();
        }
    }

    public String toString() {
        return this.engineToString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

